/* static char sccsid[]="%Z% %M% %I% %E% %U%"; */
/************************************/
/* <cllocal.h>						*/
/*		coal struct					*/
/************************************/
#ifndef INC_CLLOCAL
#define INC_CLLOCAL

/**********************************
	R}hCompile and Execute
***********************************/
typedef struct {
	int cid;
	int *exobj;
	char **da;
	int  option;
	short nobj;
	short nda;
} CMDObject;

/******************************
	Tree
*******************************/
typedef struct _WHERE_TREE {
	short mcode;
	short t1;
	short t2;
	short t3;
	short lv;
	short rv;
	short resv1;
	short resv2;
/*
	struct _WHERE_TREE *t1;
	struct _WHERE_TREE *t2;
*/
} WHERE_TREE;

/******************************
	Compile and Execute
*******************************/
typedef struct {
	short maxda;
	short maxobj;
	short maxobj0;
	short nda;
	short nobj;
	short nobj0;
	short *obj;
	char **da;
	int  index0;	/* 0x10:exist OR,AND */
	tdtInfoParm **obj0;
	int  option;
	tdtInfoParm **obj0org;
#if 1	/* 2021.11.1 */
	WHERE_TREE *tree;
	int ntree;
#else
	char **stack;
#endif
} GXObject;

typedef struct {
	char  id[2];
	short nda;
	short nobj;
	short nobj0;
	MCAT *ms_obj;
	MCAT *ms_da;
	MCAT *ms_obj0;
	int  index0;
	int  option;
} GXObjectExpand;

/*******************************/
/*  */
/*******************************/
typedef struct {
	short alsz;
	short used;
	char  *resv;
	tdtInfoParm **Obj0;
} tdtObjHead;

/*******************************/
/* O[oGA (parmList) */
/*******************************/
typedef struct parmList {		/*** p[^Xg ***/
	int      prmlen;
	char     *prp;
	int      opt;
	GXObject *bxobj;
} parmList;

/*******************************/
/* O[oGA (condList) */
/*******************************/
typedef struct cmdInfo {		/*** R}h ***/
	int   rc;						/* sԍ					*/
	int   cid;						/* R}hID				*/
	int   sub_cid;					/* TuR}hID			*/
	uchar type;						/* ^Cv(̃x)	*/
	uchar pos;						/* p[^Jnʒu		*/
	short prmnum;					/* p[^			*/
	parmList **prmp;				/* p[^				*/
	ParList *parl;
	int   parnum;
	CMDObject *cmdobj;
} cmdInfo;

typedef struct Leaf {
	struct Leaf *preleaf;		/*  Õ[t        */
	struct Leaf *rightleaf;		/*  Ẽ[t        */
	struct Leaf *leftleaf;		/*  ̃[t        */
	char         pFlag;			/*  vZXtO    */
	char         cmdtag;		/* */
	char         pad[2];		/* */
	int          type;			/*  R}h̃x  */
	cmdInfo      cmd;			/*  R}h      */
} Leaf; 

/*****  CLNCB  *************************/
typedef struct CLNCB {
	Leaf    *TopStack;			/* X^bN̐擪       */
	int      StackCounter;		/* X^bNJE^     */
	Leaf    *nestLev1;			/* xP[t       */
	Leaf    *nestLev2;			/* xQ[t       */
	Leaf    *nestLev3;			/* xR[t       */
/*	VarTBL  *vary ;	*/
	Leaf    *TopTreeSave;		/* Tree̐擪̑ޔ		*/
	Leaf    *TopTree;			/* Tree̐擪       */
	Leaf    *DefTopStack;		/* Define X^bN̐擪 */
} CLNCB;

/********************************/
/* O[oGA (tableRoot) */
/********************************/
typedef struct tableRoot {	/*** e[ũ[g ***/
	int   cmds_len;				/* ̈̒               */
	char *cmds;					/* ̈̐擪               */
	int   cmds_offset;			/* Ɋi[̈̐擪 */
} tableRoot;

typedef struct condList {		/*** 񃊃Xg ***/
	char   *fname;					/* script name		*/
	FILE   *fp;						/* t@C|C^	*/
	char   *rbuf;
	int     line;					/* s			*/
	cmdInfo cmd;					/* 				*/
	ConstantCt	*ConstCt;			/* 萔e[u		*/
	char   *fullname;				/* Path+fname		*/
	int     option;
	MCAT    *mcat;
	int     max_prmnum;
	MCAT    *mcat_obj;
	MCAT    *mcat_da;
} condList;

/***************************************/
/* ubN̒`                  */
/***************************************/
typedef struct prmList {
	int      VarLen;
	void    *VarBD;
	char     VarType;
} prmList;

typedef struct  ListPacBody  {
	long          AllFieldlen;
	MCAT          mCat;
	tdtIndirectInfo indInfo;
	char          fname[16];
} ListPacBody;

/***********************************************/
/*                                             */
/***********************************************/
typedef struct {
	int   size;
	char *data;
	int   ntype;
	parmList  **vname;
	tdtInfoParm **pType;
} tdtDefType;

/***********************************************/
/*                                             */
/***********************************************/
typedef struct {
	char  uAttr[4];
	int   size;
	tdtInfoParm **pVarIndex;
	int   index[(4+MAX_ARRAY_DIM)*2];
			/*   0   : dim
			     1   : max_array	ővf
			     2   : max_set		off_setݒςݗvf̍őʒu(擪1)܂ł̌, <0 HASH 
			     3   : off_set
			     4   : m1			1ڂ̗vf
			     5   : m2			2ڂ̗vf
			     6   : m3			3ڂ̗vf
			   ...
			   dim+3 : m1_2			1ڂ̊JnIndexԍ
			   dim+4 : m2_2			2ڂ̊JnIndexԍ
			   dim+5 : m3_2			3ڂ̊JnIndexԍ
			   ... 			*/
	XHASHB *xhp;
	tdtInfoParm *pInfoType;
} tdtArrayIndex;

typedef struct FreamCB  {					/****t[ba **********/
	struct FreamCB *nextFRCB;
	int    len;
	char   *pBuff;
} FreamCB;

typedef struct PacketCB {					/**** pPbgba *********/
	int      AllBuffSize;
	FreamCB  *pFRCB;
} PacketCB ;

typedef struct BlockCB {				/**** ubNba ****/ 
	struct BlockCB *preBlockCB;
	struct BlockCB *nextBlockCB;
	void	*block;
	int		cid;						/* ubN */
	Leaf	*Blockleaf;
	int		TureFlag;
	int		ElseFlag;
	int		EndFlag;
	char	*pSwParm;
	uchar	ucExcept;
	uchar	try_level;
	uchar	pFlag;
	uchar	iUsed;
	int		iLoopCounter;			/* [vJEg  */
	int		iLoopMax;				/* [vől    */
	tdtInfoParm *pEachParm;
	int		iOpt;
	char	*BlockName;
} BlockCB;

typedef struct INPCB {
	char   *parmtop;
	char   *curaddr;
	int     curlen;
	int     maxlen;
	uchar   status;
	char    padding[3];
} INPCB;

typedef struct {
	int nparam;
	int maxlen;
	parmList  **parmLp;
	int iparam;
	char *line;
	int line_len;
} GWPRM_S;

typedef struct {
	char       *pId;
	ConstantCt *ConstCt;			/* 萔e[u			*/
	ConstantCt *LeafConstCt;		/* RpCʒ萔e[u	*/
	Leaf       *NodeLeaf;
} ScrConstCt;

typedef struct ProcCT {				/*** vV[We[u ***/
	struct ProcCT	*prePCT;		/* ÕvV[W       */
	struct ProcCT	*nextPCT;		/* ̃vV[W       */
	Leaf			*ProcTop;		/* vV[W擪[t */
	Leaf			*Curleaf;		/* ݎs[t       */
	char			*ProcPath;
	Leaf			*Nextleaf;		/* Next leaf           */
	BlockCB			*pTopBlockCB;	/* BlockCBgbv		*/ 
	BlockCB			*pcrBlockCB;		/* BlockCBJg		*/ 
	INPCB			INPCB;			/* Input function contorol */
	tdtRbCtl		*pRetStack;		/*         */
	int				varnam_pasento;
	XHASHB			*pha_vnam;
	tdtInfoParm		***pTBL_pasento;
	tdtInfoParm		***pTBL_vnam;
	uchar			ptype;			/* */
	char			pFlag;
	uchar			ucExcept;
	char			dummy;
	char			*ProcNM;		/* vV[W         */
	tdtInfoParm		*Retval;
	ConstantCt		*pTmpConstCt;
	int				ixobj0;
	tdtObjHead		*Obj;			/* obj0 */
	Leaf			*Nodeleaf;		/* Node leaf           */
	int				exception;
	int				ProcGid;
	tdtInfoParm		**ppExecParm;
	ScrConstCt		*pScrConstCt;
	int				try_level;
} ProcCT;

#ifdef NEW_VARTBL
typedef struct {
	short     max_ix
	short     max_iy
	int       used;
	tdtInfoParm ***pTBL;
	XHASHB    *pha;
} VarTBL_name;

typedef struct {				/*** ϐe[u ***/
	VarTBL_name *iget;
	VarTBL_name *doll;
	VarTBL_name *psnt;
	VarTBL_name *vnam;
} VarTBL;
#else
typedef struct VarTBL {			/*** ϐe[u ***/
	int       varnam_igeta;
	int       varnam_dolu;
	int       varnam_pasento;
	XHASHB    *pha_vnam;
	tdtInfoParm ***pTBL_dolu;
	tdtInfoParm ***pTBL_igeta;
	tdtInfoParm ***pTBL_pasento;
	tdtInfoParm ***pTBL_vnam;
} VarTBL;
#endif

typedef struct ONTBL  {			/*** nme[u ***/
		int   FldNum;
		uchar PrSel[4];
		char  *PrName[4];		/* 0:GR-1, 1:GR-2, 2:GR-3, 3:XML-TAG */
} ONTBL;

typedef struct SearchResult {			/*** ʍ\ ***/
	char                  szType[2];	/* i[^Cv             */
	char                 *sAreaId;		/* f[^i[GAhc   */ 
	int                   iTupleNum;	/* ^v               */
	int                   iCrTuple;		/* Jg^vԍ     */
	int                   iColmNum;		/* J               */
	char                 *pzFileName;	/* t@C             */
	int                  *iIndex;		/* CfbNX           */
	void                 *RslBody;		/* ʃf[^̐擪   */
	int                   iDataLen;		/* f[^               */
	int                   iIndexLen;	/* CfbNX         */
	struct SearchResult	*Next;			/* ̍\̂̃|C^[ */
} SearchResult;

typedef struct GlobalCt{			/*** VXeϐǗ ***/
	int		tuppl; 
	int		error;
	int		Return;
	tdtInfoParm *Retval;
	char	usrcod[16];
	char	Date[16];
	char	Hid[8];
	char	Trnshid[84];
	char	usrinf[D_USER_INF];
	int		column;
	char	errmsg[248];
	int		err_msg_len;
	char	*err_msg;
	int		exception;
	int		try_level;
	int		script_line;
	int		err_no;
	char	Quot[4];		/* [2]:pGlobTable->err_msg 擪ǉtO,[3]:term_code */
	int 	options[MAX_OPTIONS];
#if 1	/* 2020.12.26 */
	ParList err_hist[2];
#endif
} GlobalCt;

typedef struct ScrPrCT {				/*** XNvge[u ***/
	struct ScrPrCT	*preScCT;				/* ÕXNvge[u */
	struct ScrPrCT	*nextScCT;				/* ̃XNvge[u */
	ProcCT			*ProCT;					/* vV[We[u   */
	VarTBL			*Vary;					/* ϐe[u           */
	ONTBL			**ONCOND;				/* nme[u       */
	short			on_num_max;
	short			OnSelect;				/* ON condition selector  */
	Leaf			*TreeTop;				/* XNvg̐擪[t */
	ConstantCt		*ConstCt;				/* 萔e[u			*/
	uchar			ptype;
	char			pFlag;
	char			dummy1[2];
	char			*pId;
	ConstantCt		*LeafConstCt;			/* RpCʒ萔e[u */
	tdtRbCtl		*pListImport;			/* Importς݃t@C̃Xg */
	ProcCT			*CurProc;				/* JgvV[We[u */
	int				ScrGid;
	XHASHB			*ProcIndex;
	tdtObjHead		*Obj;					/* obj0 */
	FILE			*stdio[4];				/* stdin,stdout,strerr,HereDoc_fp */
	char			*HereDoc_nm;
	tdtRbCtl		*pListExport;			/* ExportΏەϐ̃Xg */
#if 1	/* 2021.18.25 */
	int				try_level_save;			/* save try_level when NOTRY */
#endif
} ScrPrCT;

typedef struct {
	long    mtime;
	long    ltime;
	int     refc;
	ScrPrCT scrct;
	char   *cpfullname;
	struct timeval rtime;	/* reg time */
} qLruScr;

typedef struct {
	int     LruOption;
	int     LruScrMax;
	int     LruCount;
	qLruScr *tpLruScr;
} tdtLruScrHead;

typedef struct CnCB {				/*** 萔ǗubN *****/
	struct CnCB *nextCnCB;				/* 萔ǗubN	  */
	char		*BD;					/* 萔̈̃AhX	@*/
} CnCB;

typedef struct {					/* Ǘe[u	93.5.20 Koba */
	int		ViewNum;
	char	*ViewLip;
	int		ViewLen;
	int		ItemNum;
	char	*ItemLip;
	int		ItemLen;
	int		ExtNum;
	char	*ExtLip;
	int		ExtLen;
	char	*rPrmLp;
	int		PrmLen;
} SlmanTBL;

typedef struct ViewLine {		/* r[̃e[uf[^@*/
	char	*ColSelCondition;		/* @*/
	char	ViewName[33];			/* r[́@*/
	char	ALIASNAME[2];			/* ȗ@*/
	char	ObjFlag;				/* ΏۃtO@*/
} ViewLine;

typedef struct ViewTBL {		/* r[̃e[u */
	int			iItemNum;
	ViewLine	Line[26];			/* r[̃e[uf[^ */
} ViewTBL;

typedef struct ItemLine {		/* ڃe[uf[^@*/
	int		ItemNumber;				/* ڔԍ@*/
	int		DisplaySequence;		/* \ */
	short	DisplayDigit;			/* \ */
	short	SummuryKind;			/*  */
	char	*ConditionData;			/* f[^ */
	int		OrderNumber;
	char	OrderType;				/* Asc or Desc */
	char	ALIASNAME[2];			/* ȗ@*/
	char	ItemName[65];			/* ږ́@*/
	char	AttrName[33];			/* Agr[g */
} ItemLine;

typedef struct ItemTBL {		/* ڃe[u */
	int			iItemNum;
	ItemLine	Line[200];			/* ڃe[uf[^ */
} ItemTBL;

typedef struct ExtTBL {			/* ڒoe[u */
	int			iItemNum;
	ItemLine	Line[200];			/* ڃe[uf[^ */
} ExtTBL;

typedef struct CatCondLine {	/* e[uf[^@*/
	int			CatRecNumber;		/* ʔԍ */
	char		ViewName[33];		/* r[́@*/
	char		AttrName[33]; 		/* Agr[g */
} CatCondLine;

typedef struct CatCondTBL {		/* e[u */
	int			iItemNum;
	CatCondLine	Line[50];			/* e[uf[^ */
} CatCondTBL;

typedef struct CLPRTBL {			/*** ubN ***/
	char             PrSt;				/* vV[W	*/
	char             ShtSt_unused;		/* terminate status	*/
	char             ScrSt;				/* XNvg	*/
	char             SearchSt;			/* status flag for select process */
	int              iStackDepth;		/*  */
	char            *CmdPacketp;		/* R}hpPbg	*/
	char            *PrPacketp;			/* spPbg	*/
	char            *WaitPacketp;		/* ҂pPbg		*/
	char            *WrPacketp;			/* opPbg */
	SearchResult	*SearchRsltF;		/* ʍ\̃`F[̐擪  */
	SearchResult	*SearchRsltC;		/* Jgʍ\ */
	char             CurCmdId [4];		/* JgR}hhc */
	int              MsgNum;			/* bZ[Wԍ	*/ 
	int              lInstanceHandle;	/* CX^gEnh */
	short			 iThread;			/* Xbhԍ	*/
	ushort			 usClassId;			/* NXԍ	*/
	int              PacketId;			/* pPbghc */
	ListPacBody     *ListPBody;			/* */
	GlobalCt        *GlobCt;			/* VXeϐǗ */
	ScrPrCT         *PrCTp;				/*XNvge[u */
	VarTBL          *Vary;				/* ϐe[u */
	ConstantCt		*ConstCt;			/* 萔e[u */
	int				 SlstatusSW;		/* ԃXCb`	93.5.20 Koba */
	SlmanTBL		*SlmanTblp;			/* Ǘe[u	93.5.20 Koba */
#ifdef NEW_VARTBL
	VarTBL_name		*gvnam;				/* Oϐp */
	char			*padding;
#else
	XHASHB			*pha_vnam;			/* Oϐp */
	tdtInfoParm		***pTBL_vnam;
#endif
	ushort			 usDbClassId;		/* DBNXhc   */
	ushort			 usDbProcId;		/* DBvZXhc */
	HASHB			*pha_fp;			/* Opened file pointer */
	struct timeval	 tScrTimeVal[4];	/* 0:Total 1: one thread */
	GXObject		**bxobj;
	ScrPrCT			*CurScr;			/* JgXNvge[u */
	ProcCT			*CurProc;			/* JgvV[We[u */
	XHASHB			*pha_env;			/* setenv name & value */
	int				 gid;
	tdtRbChain		*pha_gid;
	int				 myGid;
} CLPRTBL;

typedef struct {			/*** ʐubN (94.9.15)***/
	char	*dcHostId;		/* zXghc                  */
	char	*dbHostId;		/* cazXghc       93.9.21  */
	int		iOwnIPAddr;		/* IPAhX                  */
	INT4	dbHostAddr;		/* DBT[ohoAhX 93.9.21  */
	char	*ScrPathp;		/* Script File Search Path 94.1.4 Koba */
	char	*CmdScriptp;	/* Command to Script File */
	uchar	cDataCode;		/* {R[h 94.7.30 Koba */
	uchar	ShtSt;			/* terminate status             */
	uchar	MultShtSt;		/* terminate status for Multi   */
	uchar	ucByteOrder;	/* 0/1:RISC/Intel */
	char	dbgopt[4];
	int		ProcessId;		/* vZXhc */
	int		iDbProcNum;		/* DBvZX */
	ushort	usDbClassId;	/* DBNXhc */
	ushort	usDbProcId;		/* DBvZXhc */
	char	*pHomeDir;		/* User Home Directory */
	char	*pExtension;	/* Script File Name Extension  */
	char	Quot[4];
} CLCOMMON;

/*******************************/
/* O[oGA (cmdTable) */
/*******************************/
typedef struct cmdTable {	/*** R}he[u ***/
	int    cmdid;				/* R}h   */
	int    type;				/* R}h^Cv */
	int    osize;
	char   *cmds;				/* R}h */
} cmdTable;

/********************************/
/*                      */
/********************************/
typedef struct {		/*** ڏ ***/
	char *pData;			/* f[^ */
	char  attr;				/*    */
	int   len;				/* TCY */
} qDataElm;
typedef qDataElm  *pDataElm ;

typedef struct {		/*** t[ ***/
	char     szFrameID[2];	/* t[ ID */
	char     dummy[2];
	int      iTuple;		/* ^v */
	int      iNode;			/* m[h */
	int      field_1;		/* tB[h (GR only) */
	int      field_2;
	int      field_3;
	pDataElm pDataTbl;		/* ڏ */
} qFrameInfo;
typedef qFrameInfo *pFrameInfo ;

#define		STACKMAX	21		/* sR}hۑ̂l`wl */

typedef struct {
	char *name;
	int  osize;
	int  attr;
	int  id;
} tdtExtValName;

typedef struct {
	char *name;
	short osize;
	short selector;
	short scid;
	short size;
	int   attr;
} qSubCommand;

typedef struct {
	char *name;
	int  id;
} tdtException;

typedef struct {		/*** ֐e[u ***/
	char *name;
	short mpara;
	short ope;
	uchar kubun;
	uchar reta;
	uchar arg_kbn;
	uchar ret_kbn;
	int  (*func)();
} qOpeTable;

typedef struct {
	char *str_num;
	char *str1;
	char *str2;
	short rsv;
	uchar rad;
	uchar offset;
} tdtCharAdd;

typedef struct {
	char it_id;
	uchar it_attr;
	char it_rsv[2];
	int  it_nm;
	int  it_ix;
	int  it_interval;
	tdtInfoParm *it_pInfo;
	XHASHB *it_xhp;
	tdtInfoParm ***it_pTBL;
	tdtArrayIndex *it_pIndex;
	tdtRbCtl *it_pCt;
	tdtInfoParm *it_cur;
} tdtIterate;

typedef struct {
	tdtRbCtl *itc_stack;
	tdtIterate *itc_pIter;
#if 1
	MCAT2 *itc_circ_ref;
#else
	HASHB *itc_circ_ref;
#endif
	int itc_max_layer;
	int itc_layer;
} tdtIterate_ctl;

#endif /* INC_CLLOCAL */
