/*******************************************/
/*						*/
/*	hex dump	 			*/
/*						*/
/*		by A.Kobayashi 1992.2.15	*/
/*		by A.Kobayashi 1993.4.2	*/
/*						*/
/*******************************************/
#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#if defined(SUNOS) || defined(SUNOS5) || defined(AIX)
#include	<jctype.h>
#endif
#include	<string.h>
#include	<memory.h>

static FILE *fp;
static char dat[4096];
static char *fname;
#if defined(AIX) || defined(WIN) || defined(HPUX) || defined(CYGWIN)
static char mode='s';
#else
static char mode='e';
#endif

int issjis(c)
unsigned char c;
{
	if ((c>=0x81 && c<=0x9f) || (c>=0xe0  && c<=0xfc))
		return (1);
	else
		return (0);
}
 
int iskanji1(c1)
unsigned char c1;
{
 
	if (mode == 'e') {
		/**************************/
		/*    EUC                 */
		/**************************/
		if ( (c1==0x8e) || ( (c1>=0xa1) && (c1<=0xfe) ) ) return (1);
		return (0);
	}
	else {
		/**************************/
		/*    SJIS                */
		/**************************/
		return (issjis(c1));
	}
}

int iskanji(p)
unsigned char *p;
{
	unsigned char c1,c2;

	if (mode == 'e') {
		/**************************/
		/*    EUC                 */
		/**************************/
			c1 = *p++;
			c2 = *p;
			if ( (c1==0x8e) ||
				( (c1>=0xa1) && (c1<=0xfe) && (c2>=0xa1) && (c2<=0xfe) ) )
				return (1);
			return (0);
	}
	else {
		/**************************/
		/*    SJIS                */
		/**************************/
#if 0 /* 1994.3.18 CSK */
			return (issjis(*p));
#else
			c2 = *(p+1);
			if (issjis(*p) &&
			    ((c2>=0x40 && c2<=0x7e)||(c2>=0x80 && c2<=0xfc))) return 1;
			else return 0;
#endif
	}
}

int isank(c)
unsigned char c;
{
	if (mode == 'e') {
		/**************************/
		/*    EUC                 */
		/**************************/
			if ((c>=0x20 && c<=0x7e))
				return (1);
			else
				return (0);
	}
	else {
		/**************************/
		/*    SJIS                */
		/**************************/
			if ((c>=0x20 && c<=0x7e) ||
			    (c>=0xa1 && c<=0xdf) )
				return (1);
			else
				return (0);
	}
}

char toank(c)
unsigned char c;
{
	if (isank(c))
		return ((char)c);
	else
		return ('.');
}

int argcheck(argc,argv)
int  argc;
char *argv[];
{
	char c1,c2,*p;

	argc--;
	argv++;
	fp = NULL;
/*	mode = 'e';	*/
	fname = NULL;

	if (argc<1) return -1;

	while (argc>0) {
		p = *argv;
		c1 = *p++;
		if (c1 == '-') {
			if ((c2=*p) == 's') mode = 's';
			else if (c2 == 'e') mode = 'e';
			else if (c2 == '\0') {
				fp = stdin;
			}
			else return -3;
		}
		else if (!fname) {
			fname = *argv;
		}
		argc--;
		argv++;
	}
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{

	char *p,*pp,buf[128],pb[8];
	long i,j,jj,iend;
	int len,sjis,sflg,rc;

	rc = argcheck(argc,argv);
	if (rc || (!fp && !fname) || (fp && fname)) {
		fprintf(stderr,"usage : xdump [-s|-e] {file_name|-}\n");
		exit(1);
	}
	if (fname) {
		fp = fopen(fname,"rb");
		if (fp==0){
			fprintf(stderr,"file[%s] open error!!\n",fname);
			exit(2);
		}
	}
	else fname = "stdin";
	len=fread(dat,1,4096,fp);
/*
	len=getline(dat,4096,fp);
*/
	if (len>0)
		printf("*** %s ***\n       loc    0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15  ----+----+----+-",fname);

	sjis = sflg = 0;
	for (i=0;;) {
		p = dat;
		iend = i + (long)len;
		for (;i<iend;i+=16) {
			sprintf(buf,"\n%010d :",i);
			pp=p;
			if ((jj=i+16)>iend)
				jj=iend;
			for (j=i;j<i+16;j++)
				if (j<iend) {
					sprintf(pb," %02x",(int)*pp++ & 0xff);
					strcat(buf,pb);
				}
				else
					strcat(buf,"   ");
			strcat(buf,"  ");
			for (j=i;j<jj;j++,p++) {
				if (j==i && sflg) {
					strcpy(pb," ");
					sflg = 0;
				}
				else {
					if ((j<iend-1) && iskanji(p))
						sjis = 1;
					else
						sjis = 0;
					if (sjis) {
						sprintf(pb,"%c%c",*p,*(p+1));
						if (j<jj-1) {
							j++;
							p++;
						}
						else
							sflg = 1;
					}
					else
						sprintf(pb,"%c",toank(*p));
				}
				strcat(buf,pb);
			}
			printf("%s",buf);
		}
	/*
		printf("\n%010d   (DATA END)\n",j);
	*/
		if (len<4096) break;
		len=fread(dat,1,4096,fp);
	/*
		len=getline(dat,4096,fp);
	*/
		if (len<1) break;
	}
	printf("\n%010d   (DATA END)\n",j);
	fclose (fp);
}
