static	char	sccsid[]="%Z% %M% %I% %E% %U%";
#include "akbcommon.h"

static struct timeval gtTimeNow={-1,-1};
static int giTimeNow=-1;

/********************************************************/
/*                                                      */
/********************************************************/
tdtRWQ_TIME_OUT *akb_rwque_time_out_new(iQueMax,parm)
int iQueMax,parm[];
{
	tdtRWQ_TIME_OUT *p;

	if (p=(tdtRWQ_TIME_OUT *)Malloc(sizeof(tdtRWQ_TIME_OUT))) {
		memset(p,0,sizeof(tdtRWQ_TIME_OUT));
		akb_rwqtset_parm(p,parm);
	}
	return p;
 Err:
	akb_rwque_time_out_free(p);
	return NULL;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwque_time_out_free(p)
tdtRWQ_TIME_OUT *p;
{
	if (!p) return -1;
	Free(p);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int  akb_rwqtset_parm(p,parm)
tdtRWQ_TIME_OUT *p;
int parm[];
{
	int i,wt[6],wc[2],it[2],itmin;

	if (!p) return -1;
	if (parm) {
		wt[0] = parm[0];
		wt[1] = parm[1];
	}
	else {
		akb_get_time_out_set(wt,6);	/* read,write,connect,accept,RQue,WQue */
		wt[0] = wt[4];
		wt[1] = wt[5];
	}
	p->rwt_rqto.qto_wait = wt[0];
	p->rwt_wqto.qto_wait = wt[1];

DEBUGOUTL2(AKB_LOG_GROUP|250,
"akb_rwqtset_parm:read_wait=%d write_wait=%d",wt[0],wt[1]);

	itmin = wc[0] = wc[1] = -1;
	if (wt[0]>=0 || wt[1]>=0) {
		itmin = INT_MAX;
		for (i=0;i<2;i++) {
			if (wt[i] >= 0) {
				wc[i] = 1;	/* 5 */
				if ((it[i] = wt[i]/wc[i]) <= 0) it[i] = 1;
				if (it[i] < itmin) itmin = it[i];
			}
		}
	}
	p->rwt_qint = itmin;

DEBUGOUTL3(AKB_LOG_GROUP|250,
"akb_rwqtset_parm:RQueWaitCount=%d WQueWaitCount=%d RWQueInterval=%d",
wc[0],wc[1],itmin);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwqtupdate_qremain_flg(p)
tdtRWQ_TIME_OUT *p;
{
	if (!p) return 0;
	p->rwt_rflg[1] = p->rwt_rflg[0];
	p->rwt_rflg[0] = 0;
	if (p->rwt_rqto.qto_qrem) p->rwt_rflg[0]  = 0x01;
	if (p->rwt_wqto.qto_qrem) p->rwt_rflg[0] |= 0x02;

DEBUGOUTL4(AKB_LOG_GROUP|250,
"akb_rwqtupdate_qremain_flg:RRemain=%d WRemain=%d Flg[0]=%d Flg[1]=%d",
p->rwt_rqto.qto_qrem,p->rwt_wqto.qto_qrem,p->rwt_rflg[0],p->rwt_rflg[1]);

	return p->rwt_rflg[0] ^ p->rwt_rflg[1];
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _rwqtremain_sub(pQ,opt)
tdtQUE_TIME_OUT *pQ;
int opt;
{
	tdtGENERAL_DATA *pD;
	int iMax,iSta,count,n;

	count = 0;
	pQ->qto_qrem = 0;
	if (pD=pQ->qto_used) {
		iSta = pD->gd_scale;
		iMax = akx_get_gen_int_data(pD) + pD->gd_resv;
	}
	else {
		iSta = 0;
		iMax = pQ->qto_qmax;
	}
DEBUGOUTL4(AKB_LOG_GROUP|250,
"akb_rwqtremain: sQueMax=%d Sta=%d Max=%d opt=%02x",pQ->qto_qmax,iSta,iMax,opt);
	if ((n=akb_qscheck_paopt(iMax-iSta,&pQ->qto_ppqu[iSta],opt)) > 0) {
		pQ->qto_qrem = n;
		count += n;
DEBUGOUTL1(AKB_LOG_GROUP|250,"akb_rwqtremain: remain=%d",n);
	}
	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwqtremain(p,iRW)
tdtRWQ_TIME_OUT *p;
int iRW;
{
	tdtQUE_TIME_OUT *pQ;

	if (!p) return -1;
	if (iRW & 0x01) pQ = &p->rwt_rqto;
	if (iRW & 0x02) pQ = &p->rwt_wqto;
	return _rwqtremain_sub(pQ,iRW & 0x10);
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _qtclose_func(p,iRW,pQT,iTbl)
tdtRWQ_TIME_OUT *p;
tdtQUE_TIME_OUT *pQT;
int iRW,iTbl;
{
	tdtRW_QUE *pQ;

DEBUGOUTL2(AKB_LOG_GROUP|252,"_QTCloseFun:called RW=%d i=%d",iRW,iTbl);
	if (pQ = pQT->qto_ppqu[iTbl]) pQ->rwq_tcount = 255;
	return 1;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _qttimer_sub(p,pQT,iTimeNow,iMinOutTime,iRW)
tdtRWQ_TIME_OUT *p;
tdtQUE_TIME_OUT *pQT;
int          iTimeNow,iMinOutTime,iRW;
{
	int iRc,i,n,iWaitTime,iMax,iSta,iReSet;
	tdtRW_QUE *pQ;
	int (*pFunc)();
	tdtGENERAL_DATA *pD;

DEBUGOUTL3(AKB_LOG_GROUP|252,"_RWQTTimerSub: RW=%d iTimeNow=%d iMinOutTime=%d",
iRW,iTimeNow,iMinOutTime);

	iReSet = iRW & 0x0100;
	iRW &= ~0x00ff;
	if (pD=pQT->qto_used) {
		iSta = pD->gd_scale;
		iMax = akx_get_gen_int_data(pD) + pD->gd_resv;
	}
	else {
		iSta = 0;
		iMax = pQT->qto_qmax;
	}
DEBUGOUTL3(AKB_LOG_GROUP|250,
"_qttimer_sub:sQueMax=%d iSta=%d iMax=%d",pQT->qto_qmax,iSta,iMax);
	for (i=iSta;i<iMax;i++) {
		pQ = pQT->qto_ppqu[i];
		if (pQ && (pQ->rwq_sd > 0)) {
#if 1
			if (!(iWaitTime=pQ->rwq_wtime)) iWaitTime=pQT->qto_wait;
#else
			iWaitTime = pQ->rwq_wtime;
#endif
/*
DEBUGOUTL2(AKB_LOG_GROUP|254,"_RWQTTimerSub:RW=%d iWaitTime=%d",iRW,iWaitTime);
*/
			if (pQ->rwq_torwlen>0 && pQ->rwq_otime>=0 && iWaitTime>=0) {
DEBUGOUTL5(AKB_LOG_GROUP|254,"_RWQTTimerSub: i=%d sWaitTime=%d sQueWaitTime0=%d iWaitTime=%d iOutTime=%d",i,pQ->rwq_wtime,pQT->qto_wait,iWaitTime,pQ->rwq_otime);
				if (iReSet && (iTimeNow >= pQ->rwq_otime)) {
					pQ->rwq_otime = iTimeNow + iWaitTime;
/*
DEBUGOUTL1(AKB_LOG_GROUP|252,
*/
DEBUGOUTL1(0,
"_RWQTTimerSub: ReSet OutTime=%d",pQ->rwq_otime);

				}
				if (iTimeNow >= pQ->rwq_otime) {
DEBUGOUTL(AKB_LOG_GROUP|252,"_RWQTTimerSub: call CloseSdFunc()");
					if (!(pFunc=pQT->qto_clsf)) pFunc = p->rwt_clsf;
					if (!pFunc) pFunc = _qtclose_func;
/*
printf("%x %x pFunc=%x\n",pQT->qto_clsf,p->rwt_clsf,pFunc);
*/
					pFunc(p,iRW,pQT,i);
					if (akb_rwqtis_time_out(pQ)) iMinOutTime = iTimeNow;
				}
				else {
					if (iMinOutTime<0 ||
					    (iMinOutTime>0 && pQ->rwq_otime<iMinOutTime))
						iMinOutTime = pQ->rwq_otime;
				}
			}
		}
	}
	return iMinOutTime;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwqttimer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int iRc,i,n,iWaitTime,iMinOutTime,iTimeNow,iReSet;
	tdtRW_QUE *pWQ,*pRQ;
	tdtQUE_TIME_OUT *pQT;
	tdtRWQ_TIME_OUT *p;

	akxe_get_msec(NULL,&gtTimeNow);
	giTimeNow = gtTimeNow.tv_sec;
DEBUGOUTL4(AKB_LOG_GROUP|250,
"akb_rwqttimer:called TimerId=%d Name=[%s] Parm=%08x time=%d",
iTimerId,cpTimerName,cpParm,giTimeNow);

	p = (tdtRWQ_TIME_OUT *)cpParm;
/*
	if (!p->rwt_clsf && !p->rwt_rqto.qto_clsf && !p->rwt_wqto.qto_clsf)
		return 0;
*/
	if (akb_get_nwselect()) iReSet = 0x0100;
	else iReSet = 0;

	iMinOutTime = -1;
	iMinOutTime = _qttimer_sub(p,&p->rwt_rqto,giTimeNow,iMinOutTime,1);
	iMinOutTime = _qttimer_sub(p,&p->rwt_wqto,giTimeNow,iMinOutTime,2|iReSet);
	if (iMinOutTime > 0) {
		if ((iMinOutTime -= giTimeNow) <= 0) iWaitTime = 1;
		else iWaitTime = iMinOutTime*1000;
	}
	else iWaitTime = 0;
DEBUGOUTL1(AKB_LOG_GROUP|254,"akb_rwqttimer:ret=%d",iWaitTime);
	return iWaitTime;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwqtis_time_out(pQ)
tdtRW_QUE *pQ;
{
	if (pQ->rwq_tcount == 255) return 1;
	else return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwque_get_akb_time_out(cpProcName,parm)
char *cpProcName;
int   parm[];
{
	char *namv[3],*argv[3];
	int n;

	namv[0] = D_SECTION_AKB_SYSTEM;
	namv[1] = D_KEYNAME_RWQ_TIMEOUT;
	namv[2] = cpProcName;
	n = akb_gs_akb_stpl_func(namv,'.',"4 2 3 1 ",argv,3,NULL,NULL);
	if (n >= 2) {
		parm[0] = parm[1] = atoi(argv[1]);
		if (n >= 3) parm[1] = atoi(argv[2]);
	}

	return n;
}
