static	char	sccsid[]="%Z% %M% %I% %E% %U%";
#include "akbcommon.h"

static long giProperty[] = {
	 3
	,MAX_TOINDIRF_SIZE	/* 1 */
	,MAX_INDIRF_COUNT	/* 2 */
	,(long)INDIRF_SPOOL	/* 3 */
};

typedef struct PropertyNameId {
	char *name;
	int   id;
} qPropertyNameId;

static qPropertyNameId PropertyNameId[] = {
	 "CONFIG",				AKB_PRPTY_ID_CONFIG
	,"MAX_TOINDIRF_SIZE",	AKB_PRPTY_ID_INDIRF_SIZE
	,"MAX_INDIRF_COUNT",	AKB_PRPTY_ID_INDIRF_COUNT
	,"INDIRF_SPOOL",		AKB_PRPTY_ID_INDIRF_SPOOL
	,NULL,0
};

/****************************************/
/*										*/
/****************************************/
int akb_get_property_id_by_name(pName)
char *pName;
{
	qPropertyNameId *pn;
	char *p;
	int i;

	if (!pName) return -1;
	pn = PropertyNameId;
	while (p=pn->name) {
		if(!stricmp(pName,p)) {
			return pn->id;
		}
		pn++;
	}
	return -100;
}

/****************************************/
/*										*/
/****************************************/
static int _set_property_by_id(id,pVal)
int  id;
char *pVal;
{
	int val,ret;

	if (!pVal) return -1;
	switch (id) {
	case AKB_PRPTY_ID_INDIRF_SIZE:
		ret = giProperty[AKB_PRPTY_ID_INDIRF_SIZE];
		if ((val=*(long *)pVal) < MAX_TOINDIRF_SIZE) ret = -2;
		else giProperty[AKB_PRPTY_ID_INDIRF_SIZE] = val;
/*
printf("_set_com_propertyById: giMAX_TOINDIRF_SIZE=%d ret=%d\n",
giMAX_TOINDIRF_SIZE,ret);
*/
		break;
	case AKB_PRPTY_ID_INDIRF_COUNT:
		ret = giProperty[AKB_PRPTY_ID_INDIRF_COUNT];
		if ((val=*(long *)pVal) <= 0) ret = -3;
		else giProperty[AKB_PRPTY_ID_INDIRF_COUNT] = val;
/*
printf("_set_com_propertyById: giMAX_INDIRF_COUNT=%d ret=%d\n",
giMAX_INDIRF_COUNT,ret);
*/
		break;
	case AKB_PRPTY_ID_INDIRF_SPOOL:
		giProperty[AKB_PRPTY_ID_INDIRF_SPOOL] = (long)Strdup(pVal);
/*
printf("_set_com_propertyById: gcpSPOOL=[%s]\n",gcpSPOOL);
*/
		break;
	default:
		ret = -100;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int akb_set_property_by_id(id,pVal)
int  id;
char *pVal;
{
	int ret,v;
	char *argv[4];
	int n;

	ret = 0;
	if (!id) {
		n = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,"MAX_INDIRF",argv,4);
		if (n > 1) {
			v = atoi(argv[1]);
			ret = _set_property_by_id(AKB_PRPTY_ID_INDIRF_SIZE,&v);
		}
		if (n > 2) {
			v = atoi(argv[2]);
			ret = _set_property_by_id(AKB_PRPTY_ID_INDIRF_COUNT,&v);
		}
		if (n > 3)
			ret = _set_property_by_id(AKB_PRPTY_ID_INDIRF_SPOOL,argv[3]);
	}
	else {
		ret = _set_property_by_id(id,pVal);
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int akb_set_property_by_name(pKey,pVal)
char *pKey,*pVal;
{
	int ret;

	if ((ret = akb_get_property_id_by_name(pKey)) >= 0)
		ret = akb_set_property_by_id(ret,pVal);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int akb_get_property(iParm,is,nn)
long iParm[];
int  is,nn;
{
	int max;

	if (!iParm) return -1;
	if (is < 0) return -2;
	if (nn < 0) return -3;
	if ((max=giProperty[0]+1-is) < 0) return -4;
	else if (max > 0) {
		if (nn > 0) max = X_MIN(nn,max);
		memcpy(iParm,&giProperty[is],max*sizeof(long));
	}
	return max;
}

/****************************************/
/*										*/
/****************************************/
int akb_set_property(iParm,is,nn)
long iParm[];
int  is,nn;
{
	int max,i,ret;

	if (!iParm) return -1;
	if (is < 0) return -2;
	if (nn < 0) return -3;
	if ((max=giProperty[0]+1-is) < 0) return -4;
	else if (max > 0) {
		if (nn > 0) max = X_MIN(nn,max);
		for (i=0;i<max;i++) {
			if ((ret=_set_property_by_id(is+i,iParm+i)) < 0) return ret;
		}
	}
	return max;
}
/****************************************/
/*										*/
/****************************************/
int akb_set_property_all(i)
int  i;
{
	return akb_get_inf_max_indirf(0,0);
}
