static  char    sccsid[]="%Z% %M% %I% %D% %T%";
/*
 *	script test program
 *
 *		updated by A.Kobayashi 92/2/13
 *		updated by A.Kobayashi 92/4/15
 *		updated by A.Kobayashi 92/6/25
 *		updated by A.Kobayashi 92/7/2
 *		updated by A.Kobayashi 94/9/6
 *		updated by A.Kobayashi 97/5/27
 *		updated by A.Kobayashi 98/3/3
 *		updated by A.Kobayashi 98/8/11   V2.2
 */
#include	<stdio.h>
#include	<ctype.h>
#include	<string.h>
#include	<malloc.h>
#include	<memory.h>
#include	<errno.h>
#include	<signal.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<netdb.h>

#include	"mmi.h"

#define CD_TYPE_EUC 	0
#define CD_TYPE_SJIS	1


#ifdef EUC
static unsigned char  gucCodeType = CD_TYPE_EUC;
#else
static unsigned char  gucCodeType = CD_TYPE_SJIS;
#endif

#define		COMM_REG	1
#define		COMM_END	2
#define		COMM_SEND	5
#define		COMM_SHUT	254	
#define		COMM_FSHUT	255

#define		PSZ	char *

/*
typedef		unsigned char UCHAR	;
*/

/*	DEBUG	SWITCH	*/
#define		PRM_NTOH	1
#define		PRM_HTON	1
#define		LOGOUT		0
#define		DEBUG		0
#define		DBG		0
#define HOSTNAME    "ldhost"
#define SERVICE		"Term_Port"
#define PORTNO      1531
#define S_PID       0
#define D_PID       102
#define SAVEHISTORY	"mmisc.his"

int			task;
int	Log_flg;
FILE	*fp;

#define NSEP	11
#define NMTAB	24
char sep[NSEP]={' ','\t','\n',';',',','(','/','{','}','"','\''};
char name[128],w[128],ww[128];

struct SSP_S {
	int sp;
	char *w;
};

#define  PKHEAD_LEN	32
#define  UCODE_SIZE	68

struct PKHEAD_S {
	unsigned char pkh_verid;
	unsigned char pkh_mode;
	unsigned short pkh_cmd;
	long		pkh_dhost;
	long		pkh_dprid;
	long		pkh_dpkid;
	long		pkh_shost;
	long		pkh_sprid;
	long		pkh_spkid;
	long		pkh_pklen;
} pkhead;

struct CMHD_S {
	char ucode[UCODE_SIZE];
	long cmd;
	long nprm;
} cmhd,*cmhdp;

typedef struct DHEAD_S {
	UCHAR atr;
	UCHAR len;
	char llen[4];
} dhead_s;

typedef struct {
	UCHAR id;
	UCHAR um;
	UCHAR dum[2];
	long  len;
} pk_kan;

typedef struct {
	UCHAR id;
	UCHAR um;
	UCHAR dum[2];
	long  pos;
	long  len;
} dt_kan;

short wrks;
long  wrkl;
/* 94.7.18 Koba */
#ifdef MALC
char *buf;
#else
char buf[20480],rmsg[20480];
#endif
char dat[40960];
char line[16][256];
char crntline[256];
int  history;
/*
extern   int   errno;
*/

HEAD	Head_w = { 0 };
HEAD	Head_r = { 0 };

PARA	S_para = { sizeof(PARA), sizeof(PARA) - 4,
				"ABCDEFGIHJKLMNOPQRSTUVWXYZ123" };
PARA	R_para = { 0 };

long Hid,Pid,rcvPid;
char Uid[9];
int	Fd = 0;

/* insert tsuru 1993.11.08 */
dhead_s			dHead;
USERTBL			userctl;

int Repeat=0;
int Dumpflg=0;
int SaveHistoryFlg=0;

int sk_read( fd, buff, size )
int	fd;
char	*buff;
int	size;
{
int	len;
long	count;

	count = size;
	while( count )
	{
		errno = 0;
		len = recv( fd, buff, count, 0 );
/*
printf("[mmi read] len: %d, count: %ld\n",len,count);
*/
		if( len < -1 && count == size && errno == EWOULDBLOCK )
			return 0;
		if( len < 0 && errno != EWOULDBLOCK )
			return -1;
		if( len == 0 )
		{
			sleep( 1 );
			continue;
		}
		count -= len;
		buff += len;
	}
	return size;
}

int
Disp( )
{
	char     tmp[40960];
	unsigned char	*p;
	short		i;
	int		ret,len;
/***********
	printf("Head_r.ver     :   %c\n",Head_r.ver);
	printf("Head_r.info    : 0x%x\n",(int)Head_r.info       );
	printf("Head_r.command :   %d\n",(int)Head_r.command);
	printf("Head_r.host_s  : 0x%x\n",     Head_r.host_s     );
	printf("Head_r.prs_s   :   %d\n",     Head_r.prs_s      );
	printf("Head_r.pcid_s  :   %d\n",     Head_r.pcid_s     );
	printf("Head_r.host_d  : 0x%x\n",     Head_r.host_d     );
	printf("Head_r.prs_d   :   %d\n",     Head_r.prs_d      );
	printf("Head_r.pcid_d  :   %d\n",     Head_r.pcid_d     );
	printf("Head_r.len     :   %d\n",Head_r.len        );
**************/
	len = ntohl(Head_r.len);
	if( len )
	{
		ret = sk_read( Fd, tmp, len );
		if( ret != len )
		{
			printf( "[MMISC] Read Error\n" );
			return 1;
		}
		p = (unsigned char *)tmp;
/*
        axaxdump("[MMISC] Return Packet Dump", p , len );
*/
/*******************  ƃRg  Jan.31,1992
		printf("R_para.p_len : %d\n",R_para.p_len);
		printf("R_para.d_len : %d\n",R_para.d_len);
		printf("R_para.para\n");
		p = (unsigned char *)R_para.para;
		for( i = 0; i < R_para.d_len; i ++, p ++ )
		{
			if( i % 10 == 0 )
				printf("\n%03d :",i);
			printf("%02x ",*p);
		}
		printf("\n");
**************************************************/
	}
	return 0;
}

int
main( argc, argv )
int	 argc;
char *argv[];
{
	char				server[256],*pretcod,service[32],myhost[256];
	struct sockaddr_in	sin;
	struct hostent		*hosts;
    struct sockaddr 	addr;
    struct sockaddr_in  sa_in;
    struct hostent		*he;
    struct servent      *se;
	unsigned long       taddr_n, taddr_h;
	unsigned short     	tport_n, tport_h;
	long        lMyHost,lw;
	int			ret,i,j,cmd;
	int			aa;
	int			len;
	unsigned char          p1[11];
	unsigned char          p2[8];
/* insert tsuru 1993.11.08 */
	char		*p;
	short sCmd;

	printf("  MMISC V2.2\n  (c) Copyright CSK 1998\n");

	if( gethostname( myhost, sizeof(myhost) ) ) {
		perror( "[MMISC] gethostname" );
		exit( 0 );
	}
	if (!(hosts=gethostbyname(myhost))) {
		perror( "[MMISC] gethostbyname" );
		exit( 0 );
	}
	lMyHost = *(long *)hosts->h_addr;

	if (argc<=1) {
		strcpy(server,myhost);
	}
	else {
		if (!strcmp(argv[1],"-h") ||
		    !strcmp(argv[1],"/h")) {
			printf("usage: %s [host name|.] [port no|.] [sPid|.] [Uid|.] [rcvPid]\n",argv[0]);
			exit(0);
		}
		else if (*argv[1]=='.')
			strcpy(server,myhost);
		else
			strcpy(server,argv[1]);
	}
/*
	printf( "[MMISC] server[ %s ]\n",server );
*/
#ifndef AIX
	if (*server>='0' && *server<='9') {
		taddr_n = inet_addr(server);
		if ((long)taddr_n == -1) {
			perror( "[MMISC] inet_addr" );
			exit( 0 );
		}
	}
	else {
		if (!(hosts = gethostbyname( server ))) {
			perror( "[MMISC] gethostbyname" );
			exit( 0 );
		}
		memcpy((char *)&taddr_n,hosts->h_addr,hosts->h_length);
	}
#else
	hosts = gethostbyname( server );
	if( hosts == NULL )
	{
		perror( "[MMISC] gethostbyname" );
		exit( 0 );
	}
	memcpy((char *)&taddr_n,hosts->h_addr,hosts->h_length);
#endif
	if (argc<=2) {
		if (se = getservbyname(SERVICE,"tcp")) {
			tport_n = se->s_port;
			tport_h = ntohs(tport_n);
		}
		else {
			printf("[MMISC] gerservbyname failed. use default.\n");
			tport_h = PORTNO;
			tport_n = htons(tport_h);
		}
	}
	else {
		if((tport_h = atoi(argv[2]))<=0) {
			if (*argv[2] == '.') strcpy(service,SERVICE);
			else strcpy(service,argv[2]);
			if (se = getservbyname(service,"tcp")) {
				tport_n = se->s_port;
				tport_h = ntohs(tport_n);
			}
			else {
				printf("[MMISC] getservbyname failed. use default(%d).\n",PORT_NO);
				tport_h = PORT_NO;
				tport_n = htons(tport_h);
			}
		}
		else
			tport_n = htons(tport_h);
	}
/*
	printf("[MMISC] port no : %d\n",tport_h);
*/
	printf( "\nMMISC : server = [%s], port no = %d\n",server,tport_h);
 
	Pid = S_PID;
	if (argc>3 && *argv[3]!='.') {
		if((Pid = atoi(argv[3]))<0)
			Pid = S_PID;
	}
 
    if (argc<=4)
        strcpy(Uid,"legend");
    else
        strcpy(Uid,argv[4]);
 
    if (argc<=5)
        rcvPid = Pid;
    else {
        if((rcvPid = atoi(argv[5]))<=0)
            rcvPid = Pid;
    }

	Fd = socket( AF_INET, SOCK_STREAM, 0 );
	if( Fd < 0 )
	{
		perror( "[MMISC] socket" );
		exit( 1 );
	}
/*
	printf( "[MMISC] socket Fd : %d\n", Fd );
*/
	memset( &sin, 0, sizeof(sin) );
	sin.sin_family      = AF_INET;
	sin.sin_port        = tport_n;
/*
	sin.sin_addr.s_addr = *(long *)hosts->h_addr;
*/
	sin.sin_addr.s_addr = taddr_n;

	ret = connect( Fd, (struct sockaddr *)&sin, sizeof(sin) );
/*
	printf( "[MMISC] connect : %d\n", ret );
*/
	if( ret )
	{
		perror( "[MMISC] connect" );
		shutdown( Fd, 2 );
		exit( 0 );
	}
/*
	printf("[MMISC] Task Registment\n");
	printf("[MMISC] usrid is %d byte version.\n",UCODE_SIZE);
*/
/*
getchar( );
*/
/* add 94.7.18 Koba */
#ifdef MALC
	if (!(buf=malloc(40960))) {
		printf("*** malloc error!!! ***\n");
		shutdown( Fd, 2 );
		exit( 0 );
	}
#endif
	Head_w.ver     = 'B';
	Head_w.info    = 0;
	Head_w.command = htons(COMM_REG);

	Head_w.host_s  = *(long *)hosts->h_addr;
	Head_w.prs_s   = htonl(Pid);
	Head_w.pcid_s  = htonl(1);

	Head_w.host_d  = 0;
	Head_w.prs_d   = 0;
	Head_w.pcid_d  = 0;

	Head_w.len     = 0;

	ret = send( Fd, &Head_w, sizeof(HEAD), 0 );
/*
printf("[MMISC] (%d fd)regist packet write(%d size)\n",Fd,ret);
*/
    if ( ret < 0 )
        perror("write");

	ret = sk_read( Fd, (char *)&Head_r, sizeof(HEAD) );
	if( ret != sizeof(HEAD) )
	{
		perror( "[MMISC] 1st Read" );
		printf( "[MMISC] 1st Read ERROR ret : %d\n", ret );
		goto End;
	}

	Hid = Head_r.host_d;
	if (Head_r.pcid_s) {
		printf("\n*** receiv cpferror=%d EXIT.\n",Head_r.pcid_s);
		goto End;
	}
	rcvPid = Pid = ntohl(Head_r.prs_d);
	printf( "MMISC : sPid = %d, dPid = %d\n",Pid,D_PID);

	if( Disp( ) )
		goto End;
/*
	printf( "[MMISC] Data Send\n");
*/
/* insert tsuru 1993.11.08 */
	memcpy(&userctl.usr_code[8],"MMISC1",7);

#if LOGOUT
	Log_flg = 1;
#else
	Log_flg = 0;
#endif
	if (Log_flg) {
		fp = fopen("HSTLINE.DAT","w");
		if(fp == 0){
			printf("Log file open error!!\n");
		}
	}
/*
	printf( "[MMISC] START\n" );
*/
	fp = fopen(SAVEHISTORY,"r");
	if (fp) {
		for (i=0;i<16;i++) {
			if (!fgets(&line[i][0],255,fp)) break;
			for (j=0;j<256;j++) {
				if (line[i][j] == '\n') {
					line[i][j] = '\0';
					break;
				}
			}
		}
		history = i - 1;
		fclose(fp);
	}
	else history = 15;
	crntline[0] = '\0';
	for (;;) {
		ret = send_cmd(Fd);
		if (ret < 0)
			break;
		else if (ret==0)
			continue;

/* insert tsuru 1993.11.08 */
/*	del 94.11.8 Koba 
		if (*(int*)dat == 0x00010001)
		{
			p = dat + 8;
			p += ldc_getdhs(p,&dHead,sizeof(userctl.usr_id),userctl.usr_id);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.usr_pass),userctl.usr_pass);
		}
*/
/*
printf( "[MMISC] 2nd sk_read\n" );
*/
		ret = sk_read( Fd, (char *)&pkhead, sizeof(pkhead) );
		if( ret != sizeof(pkhead) )
		{
			perror( "[MMISC] 2nd Read" );
			printf( "[MMISC] 2nd Read ERROR ret : %d\n", ret );
			break;
		}
/*
printf( "[MMISC] 2nd sk_read ret[%d]\n",ret );
*/
		sCmd = ntohs(pkhead.pkh_cmd);
		if (sCmd == COMM_SHUT || sCmd == COMM_FSHUT ) {
			printf("\n*** SHUT/FSHUT command received.\n*** Exit.\n");
			goto End;
		}
		/* add A.Kobayashi 98/8/11 */
		if (pkhead.pkh_dpkid && pkhead.pkh_spkid) {
			printf("\n*** receiv cpferror=%d\n",pkhead.pkh_spkid);
		}
		dump_ret(Fd,pkhead.pkh_mode);
		if (pkhead.pkh_mode)
			pretcod = buf+8+UCODE_SIZE+4;
		else
			pretcod = buf+UCODE_SIZE+4;
		memcpy(&lw, pretcod, sizeof(long));
		ret = ntohl(lw);
		memcpy(&lw, pretcod-4, sizeof(long));
		cmd = ntohl(lw);
/*
		printf("Command Return Code = %d\n",ret);
*/
/* insert tsuru 1993.11.08 */
		if (ret == 0 && cmd == 0x00010001)
		{
			p = pretcod + 16;
			p += ldc_getdhs(p,&dHead,8,userctl.usr_code);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.men_nm),userctl.men_nm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.hnb_cd),userctl.hnb_cd);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.hnb_nm),userctl.hnb_nm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.hnb_rnm),userctl.hnb_rnm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.bsh_cd),userctl.bsh_cd);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.bsh_nm),userctl.bsh_nm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.bsh_rnm),userctl.bsh_rnm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.yku_cd),userctl.yku_cd);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.yku_nm),userctl.yku_nm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.yku_rnm),userctl.yku_rnm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.shk_cd),userctl.shk_cd);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.shk_nm),userctl.shk_nm);
			p += ldc_getdhs(p,&dHead,sizeof(userctl.shk_rnm),userctl.shk_rnm);

			memcpy(&userctl.usr_code[16],userctl.usr_id,sizeof(userctl.usr_id));
		    memcpy(&userctl.usr_code[32],userctl.usr_pass,sizeof(userctl.usr_pass));
		    memcpy(&userctl.usr_code[48],userctl.hnb_cd,sizeof(userctl.hnb_cd));
		    memcpy(&userctl.usr_code[52],userctl.bsh_cd,sizeof(userctl.bsh_cd));
		    memcpy(&userctl.usr_code[60],userctl.yku_cd,sizeof(userctl.yku_cd));
		    memcpy(&userctl.usr_code[64],userctl.shk_cd,sizeof(userctl.shk_cd));
		}
	}
	if (SaveHistoryFlg) {
		fp = fopen(SAVEHISTORY,"w");
		if (fp) {
			for (i=0;i<16;i++) {
				if (!strlen(&line[i][0])) break;
				if (fprintf(fp,"%s\n",&line[i][0])<0) break;
			}
			fclose(fp);
		}
	}
	if (Log_flg) 	fclose(fp);

	Head_w.command = htons(COMM_END);
	Head_w.pcid_s      = htonl(3);
	Head_w.host_d      = 0;
	Head_w.prs_d       = 0;
	Head_w.pcid_d      = 0;
	Head_w.len         = 0;
	Head_w.info        = 0;

	write( Fd, &Head_w, sizeof(HEAD) );

	ret = sk_read( Fd, (char *)&Head_r, sizeof(HEAD) );
	if( ret != sizeof(HEAD) )
	{
		perror( "[MMISC] 3rd Read" );
		printf( "[MMISC] 3rd Read ERROR ret : %d\n", ret );
		goto End;
    }

	Disp( );
End:
#ifdef MALC
	if (buf) free(buf);
#endif
/*
	printf( "[MMISC] END\n" );
*/
	shutdown( Fd, 0 );
	close( Fd );
}



int getline(line, prompt)
char   *line;
char         *prompt;
{
	char	ch,*sp=line;

	printf("%s", prompt);
	while ((ch = getchar()) != '\n' && ch != EOF)
		*line++ = ch;
	*line = '\0';
	if (ch == EOF)
		return(EOF);
	return (strlen(sp));
}

hit_return()
{
	char	tbuf[32];

	getline(tbuf, "hit return : ");
}


int send_cmd(s)
int s;
{
	int len;
	long i=1,ll,ld;
	char *p;

	while ((len = make_cmd())<0)
		printf(" data error \n");
	if (len==0)
		return (-1);
/*
	log_fxdmp("cmd data",dat,len);
*/

	pkhead.pkh_verid='B';
	pkhead.pkh_mode=0x00;
	pkhead.pkh_dhost=Hid;
	wrkl=D_PID;
	pkhead.pkh_dprid=ntohl(wrkl);
	pkhead.pkh_dpkid=0;
	pkhead.pkh_shost=Hid;
	wrkl=rcvPid;
	pkhead.pkh_sprid=ntohl(wrkl);
	pkhead.pkh_spkid=i;

	if (dat[0]=='/') {
		if (!strcmp(dat,"/shut")) {
			len = 0;
			wrks=COMM_SHUT;
		}
		else if (!strcmp(dat,"/fshut")) {
			len = 0;
			wrks=COMM_FSHUT;
		}
		else if (!strcmp(dat,"/shutterm")) {
			wrkl=rcvPid;
			pkhead.pkh_dprid=ntohl(wrkl);
			wrkl=Pid;
			pkhead.pkh_sprid=ntohl(wrkl);
			len = 0;
			wrks=COMM_SHUT;
		}
		else if (!strcmp(dat,"/recv")) {
			return 1;
		}
/**************
		else if (!strcmp(dat,"/dump")) {
			if (Dumpflg) {
				Dumpflg = 0;
				printf("[MMISC] dump mode off\n");
			}
			else {
				Dumpflg = 1;
				printf("[MMISC] dump mode on\n");
			}
			return 0;
		}
**************/
		else if (!strcmp(dat,"/history")) {
			if (SaveHistoryFlg) {
				SaveHistoryFlg = 0;
				printf("[MMISC] save history mode off\n");
			}
			else {
				SaveHistoryFlg = 1;
				printf("[MMISC] save history mode on\n");
			}
			return 0;
		}
		else return (0);
	}
	else {
		print_send(dat,len);
/* insert tsuru 1993.11.08 */
/*
		strcpy(buf+PKHEAD_LEN,Uid);
*/
		if (ntohl(*(int*)dat) == 0x00010001 && len>8)
		{
			p = dat + 8;
			ll=ldc_getdhs(p,&dHead,sizeof(userctl.usr_id),userctl.usr_id);
			if (len > 8+ll)
				ldc_getdhs(p+ll,&dHead,sizeof(userctl.usr_pass),
				           userctl.usr_pass);
		}
		memcpy(buf+PKHEAD_LEN,userctl.usr_code,sizeof(userctl.usr_code));
		memcpy(buf+PKHEAD_LEN+UCODE_SIZE,dat,len);
		len += UCODE_SIZE;
		wrks=COMM_SEND;
	}
	pkhead.pkh_cmd=htons(wrks);
	pkhead.pkh_pklen = htonl(len);
	memcpy(buf,(PSZ)&pkhead,PKHEAD_LEN);

#if DEBUG
	printf("packet len = %d\n",len);
#endif
	len += PKHEAD_LEN;
/*
	axaxdump("packet",buf,len);
*/
	if (send(s, buf, len, 0) != len) {
		printf("write error\n");
		return (-1);
	}


	return(len);

}

int dump_ret(s,mode)
int s,mode;
{
	int len,msglen,ml,rl;

	log_fxdmp("read packet header",(PSZ)&pkhead,32);

	msglen=ntohl(pkhead.pkh_pklen);

printf("[MMI] msglen: %d sizeof buf: %d\n",msglen,sizeof(buf));

#ifdef MALC /* add 94.7.18 Koba */
	if (!(buf=realloc(buf,msglen))) {
		printf("*** realloc error !!! ***\n");
		return -1;
	}
	len=sk_read(s,buf,msglen);
/*
printf("[MMI] 2nd msglen: %d sizeof buf: %d\n",msglen,sizeof(buf));
*/
	if (len != msglen) {
		printf("read error len=%d\n",len);
		return 0;
	}
	log_fxdmp("read packet data",buf,len);
/*
	axaxdump ("read packet data",buf,len);
*/
#else
	ml = msglen;
	if (ml>0) {
		if ((rl=sizeof(buf))>ml) rl = ml;
		len=sk_read(s,buf,rl);
		if (len != rl) {
			printf("read error len=%d\n",len);
			return 0;
		}
		log_fxdmp("read packet data",buf,len);
printf("[MMI] len=%d\n",len);
		print_ret(mode,buf,len,dat);
/*
		axaxdump ("read packet data",buf,len);
*/
		ml -= len;
		while (ml>0) {
			if ((rl=sizeof(rmsg))>ml) rl = ml;
			len=sk_read(s,rmsg,rl);
			if (len != rl) {
				printf("read error len=%d\n",len);
				return 0;
			}
			log_fxdmp("read packet data",rmsg,len);
			axaxdump ("read packet data",rmsg,len);
			ml -= len;
		}
	}
/*
	printf("######## msglen =  %d\n",msglen);
*/
#endif

	return(0);
}

/*******************************************/
/*						*/
/*	hex dump to file 			*/
/*						*/
/*		pointer : far model		*/
/*						*/
/*******************************************/
log_fxdmp(s,p,len)
char *s,*p;
long len;
{
	char *pp,buf[128],pb[8];
	int ret;
	long i,j,jj;

	if (!Log_flg)
		return;
	ret=fprintf(fp,"\n*** %s ***\n  addr    loc  0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15  ----+----+----+-",s);
	if (ret<1) return;
	for (i=0;i<len;i+=16) {
		sprintf(buf,"\n%08lx %04ld",p,i);
		pp=p;
		if ((jj=i+16)>len)
			jj=len;
		for (j=i;j<i+16;j++)
			if (j<len) {
				sprintf(pb," %02x",(int)*pp++ & 0xff);
				strcat(buf,pb);
			}
			else
				strcat(buf,"   ");
		strcat(buf,"  ");
		for (j=i;j<jj;j++,p++)
			if (isdispc(*p)) {
				sprintf(pb,"%c",*p);
				strcat(buf,pb);
			}
			else
				strcat(buf,".");
		ret = fprintf(fp,"%s",buf);
	}
	fprintf(fp,"\n%08lx %04ld  (DATA END)\n",p,j);
}

int isdispc(c)
unsigned char c;
{
	if (gucCodeType == CD_TYPE_EUC) {
		/**************************/
		/*    EUC                 */
		/**************************/
		if ((c>=0x20 && c<=0x7e))
			return (1);
		else
			return (0);
	}
	else if (gucCodeType == CD_TYPE_SJIS) {
		/**************************/
		/*    SJIS                */
		/**************************/
		if ((c>=0x20 && c<=0x7e) ||
		    (c>=0xa1 && c<=0xdf) )
			return (1);
		else
			return (0);
	}
}

int issjis(c)
unsigned char c;
{
	if ((c>=0x81 && c<=0x9f) || (c>=0xe0 && c<=0xfc))
		return (2);
	else
		return (0);
}

int getwssp(s,ssp) /* J -ƁJ */
char *s;
struct SSP_S *ssp;
{
	char c,*w;
	int i,l;

	s += ssp->sp;
	w=ssp->w;
	while ((c = *s) == ' ' || c=='\t') {
		s++;
		ssp->sp++;
	}
	if (!issjis(c)) {
		for (i=0;i<NSEP;i++)
			if (c==sep[i]) {
				*w++ = c;
				*w = NULL;
				ssp->sp++;
				return (-1);
			}
	}
	l=0;
	while (c = *s++) {
		if (issjis(c)) {
			l+=2;
			*w++ = c;
			*w++ = *s++;
			ssp->sp++;
		}
		else {
			for (i=0;i<NSEP;i++)
				if (c==sep[i])
					break;
			if (i<NSEP)
				break;
			else {
				l++;
				*w++ = c;
			}
		}
		ssp->sp++;
	}
	*w = NULL;
	return (l);
}

int q_skip(buf,ssp,quat)
char *buf,quat;
struct SSP_S *ssp;
{
	char c;
	int n=0,l;
#if DEBUG
printf("*** q_skip start.\n");
#endif

	for (;;) {
		if (c=buf[ssp->sp++]) {
			if (c=='\\' || issjis(c)==1) {
				n++;
				ssp->sp++;
			}
			else if (c==quat)
				break;
			n++;
		}
		else {
			if ((l=getline(buf," : "))==EOF)
				return (-1);
			else if (l==0)
				return (0);
			if (buf[0]=='/' && buf[1]=='/') return (-2);
			ssp->sp=0;
		}
	}
	return (n);
}

int c_skip(buf,ssp)
char *buf;
struct SSP_S *ssp;
{
	char c;
	int n=0,l;
#if DEBUG
printf("*** c_skip start.\n");
#endif
	n++;
	ssp->sp++;
	for (;;) {
		if (c=buf[ssp->sp++]) {
			if (issjis(c)) {
				n++;
				ssp->sp++;
			}
			else if (c=='*') {
				if (buf[ssp->sp]=='/') {
					ssp->sp++;
					n++;
					break;
				}
			}
		}
		else {
			if ((l=getline(buf," : "))==EOF)
				return (-1);
			else if (l==0)
				return (0);
			if (buf[0]=='/' && buf[1]=='/') return (-2);
			ssp->sp=0;
		}
	}
	return (n);
}

int make_cmd()
{
	int l,cflg,nparam,dl,i;
	char *p,c,*dp,c1;
	struct SSP_S ssp;
	long ll,lp;

	ssp.w=w;

	for (;;) {
		if (Repeat>0) {
printf("*** Repeat = %d\n",Repeat);
			strcpy(buf,"!!");
			l=2;
			Repeat--;
		}
		else l=getline(buf, "\nEnter command : ");
		if (l==EOF)
			return (0);
		if ((c=buf[0])=='#')
			continue;
        else if (c=='/') {
			if (buf[1]=='/')
				continue;
			else if (buf[1]!='*') {
				strcpy(dat,buf);
				return (l);
			}
		}
        else if (c=='!') {
            if ((c1=buf[1])=='h') {
                l = history;
                printf("\n");
                for (i=0;i<16;i++) {
                    printf("[%d] %s\n",l,&line[l][0]);
                    if (--l<0)
                        l=15;
                }
            }
            else if (c1=='!') {
                strcpy(buf,crntline);
                printf("\n%s\n",buf);
				if (strlen(buf)==0) continue;
                break;
            }
            else if ((c1>='0' && c1<='9') || c1=='.') {
				if (strlen(buf)>3) {
					Repeat=atoi(buf+3);
				}
				if (c1=='.') strcpy(buf,crntline);
				else {
					if ((l=atoi(buf+1))>15) continue;
                	strcpy(buf,&line[l][0]);
				}
                printf("\n%s\n",buf);
				if (getline(dat,"*** EDIT ***\n")>0) {
					if (dat[0]=='/' && dat[1]=='/') continue;
					edit_cmd(dat,buf);
                	printf("\n%s\n",buf);
					while (getline(dat,"*** EDIT ***\n")>0) {
						if (dat[0]=='/' && dat[1]=='/') break;
						edit_cmd(dat,buf);
                		printf("\n%s\n",buf);
					}
					if (dat[0]=='/' && dat[1]=='/') continue;
					for (i=0;i<15;i++) {
						if (!strcmp(&line[i][0],buf)) break;
					}
					if (i >= 15) {
						if (++history>15) history = 0;
						strcpy(&line[history][0],buf);
					}
				}
				break;
			}
		}
		else {
			for (i=0;i<15;i++) {
				if (!strcmp(&line[i][0],buf)) break;
			}
			if (i >= 15) {
				if (++history>15) history = 0;
				strcpy(&line[history][0],buf);
			}
			break;
		}
	}
	ssp.sp=0;
	cflg = 0;
	dp = dat;
	nparam =0;
	dl = 0;
	strcpy(crntline,buf);
	for (;;) {
		l=getwssp(buf,&ssp);
		if (l<0) {
			switch (*w) {
			case '\'':
			case '"':
				p=&buf[ssp.sp];
				ll=q_skip(buf,&ssp,*w);
				if (ll==EOF)
					return (0);
				else if (ll == -2)
					return (-1);
/*
printf("q_skip len=%ld\n",ll);
*/
				lp=ldc_setdhs(dp,1,1,ll,p);
				dp += lp;
				nparam++;
				dl += lp;
				break;
			case ';':
				ll=nparam;
				*(long *)(dat+4) = htonl(ll);
/*
				printf("nparam = %d  dlen = %d\n",nparam,dl);
*/
				return(dl);
				break;
			case '/':
				if (buf[ssp.sp]=='*') {
					l=c_skip(buf,&ssp);
					if (l==EOF)
						return (0);
					else if (ll == -2)
						return (-1);
/*
printf("c_skip len=%d\n",l);
*/
				}
				break;
			default:
				break;
			}
		}
		else if (l>0) {
			if (cflg) {
				ll = atoi(w);
				lp=ldc_setdhs(dp,2,3,4,&ll);
				dp += lp;
				nparam++;
				dl += lp;
			}
			else {
				cflg=1;
				axcctox(w,l,dp);
				dp += 8;
				dl = 8;
			}
		}
		else {
			l=getline(buf, " : ");
			if (l==EOF)
				return (0);
			if (buf[0]=='/' && buf[1]=='/') return (-1);
			ssp.sp=0;
		}
	}
	
}


long ldc_setdhs(p,atr,prs,len,data)
char *p,*data;
unsigned char atr,prs;
long len;
{
	dhead_s *dhdp;
	char  w[256];
	int l;
	short ns;
	long nl;

	dhdp = (dhead_s *)p;
	dhdp->atr = atr<<4 | prs;
	l = len;
	switch (atr) {
	    case  1:
			p += 6;
			memcpy(p,data,l);
			*(p+len)='\0';
			l=strlen(p);
			if (l<256) {
				memcpy(p-4,p,l);
				dhdp->len = l;
				len=(long)l+2;
			}
			else {
				dhdp->len  = 0;
				memcpy(dhdp->llen,&l,4);
				len=(long)l+6;
			}
			break;
	    case 2:
			p += 2;
			if (len==1) {
				dhdp->len = 1;
				*p = *data;
			}
			else if (len==2) {
				dhdp->len = 2;
				memcpy(p,data,2);
			}
			else {
				dhdp->len = 4;
				memcpy(p,data,4);
			}
			len += 2;
			break;
	    default:
			memcpy(p+6,data,len);
			dhdp->atr  = 0x50;
			dhdp->len  = 0;
			memcpy(dhdp->llen,&len,4);
			len += 6;
			break;
	}
	return (len);
}

long ldc_getdhs(p,dhp,len,data)
char *p,*data;
long len;
dhead_s *dhp;
{
	dhead_s *  hed;
	UCHAR atr,dlen;
	char dc;
	long ll,nl,dl;
	int l;
	short ns,ds;

	atr=((dhead_s *)p)->atr;
	dlen=((dhead_s *)p)->len;
	dhp->atr=atr;
	dhp->len=dlen;
	/*
	dhp->llen=0;
	*/
	switch (atr & 0x70) {
	    case 0x10:
			if (atr & 0x0f) {
				p +=2;
				if (len>dlen) {
					l = dlen;
					memcpy(data,p,l);
					*(data+dlen) = '\0';
				}
				else {
					l = len;
					memcpy(data,p,l);
				}
				ll = (long)(dlen+2);
			}
			break;
	    case 0x20:
			p += 2;
			switch (atr & 0x0f) {
			    case 0x01:
					dc = *data = *p;
					dl = (long)dc;
					break;
			    case 0x02:
					memcpy(&ns,p,2);
					ds = ntohs(ns);
					memcpy(data,(PSZ)&ds,2);
					dl = (long)ds;
					break;
			    default:
					memcpy(&nl,p,4);
					dl = ntohl(nl);
					memcpy(data,&dl,4);
					break;
			}
			if (len != (long)dlen) {
				switch (len) {
				    case 1:
						*data = (char)dl;
						break;
				    case 2:
						ns = dl;
						memcpy(data,(PSZ)&ns,2);
						break;
				    default:
						memcpy(data,&dl,4);
						break;
				}
			}
			ll = (long)(dlen+2);
			break;
	    case 0x50:
			hed = (dhead_s *)p;
			memcpy(&nl,hed->llen,4);
			p += 6;
			dhp->len=0;
			/*
			ll=dhp->llen=ntohl(nl);
			*/
			if (len>0) {
				if (ll<len) l = ll;
				else	     l = len;
			}
			else l = ll;
			memcpy(data,p,l);
			ll += 6;
			break;
	    default:
			memcpy(data,p,len);
			ll = (long)len;
			break;
	}
	return (ll);
}

long print_dat(p,slen,temp)
char *p,*temp;
int slen;
{
	UCHAR atr,dlen;
	char dc;
	long ll,nl,dl,lw;
	int l;
	short ns,ds;
	dt_kan kan;

	atr=((dhead_s *)p)->atr;
	dlen=((dhead_s *)p)->len;
	p +=2;
	slen -= 2;
	l = 2;
	switch (atr & 0x70) {
	    case 0x10:
			if (atr & 0x0f) {
				ll = dlen;
			}
			else {
				memcpy(&lw,p,4);
				ll = ntohl(lw);
				p += 4;
				l += 4;
			}
			if (ll>slen) ll=slen;
			memcpy(temp,p,ll);
			*(temp+ll) = '\0';
			printf("[%s]\n",temp);
			l += ll;
			break;
	    case 0x20:
			switch (atr & 0x0f) {
			    case 0x01:
					dc = *p;
					dl = (long)dc;
					break;
			    case 0x02:
					memcpy(&ns,p,2);
					dl = (long)ntohs(ns);
					break;
			    default:
					memcpy(&lw,p,4);
					dl = ntohl(lw);
					break;
			}
			printf("%d\n",dl);
			l += dlen;
			break;
	    case 0x50:
			if (atr & 0x80) {
				memcpy(&kan,p,sizeof(dt_kan));
				p += sizeof(dt_kan);
				memcpy(temp,p,kan.um-8);
				temp[kan.um-8]='\0';
				printf("'%c' %d %d [%s]\n",kan.id,ntohl(kan.pos),ntohl(kan.len),temp);
				l += dlen;
			}
			else {
				memcpy(&lw,p,4);
				ll = ntohl(lw);
				p += 4;
				l += ll + 4;
				if (ll>slen) ll=slen;
				axaxdump("BULK",p,ll);
			}
			break;
	    default:
			axaxdump("ERROR DATA",p,slen);
			l = slen;
			break;
	}
	return (l);
}

axcctox(pc,n,pb)
unsigned char *pc,*pb;
int n;
{
	int j;
	unsigned char d;

	j=0;
	while (n--) {
		d = *pc++;

		if	 ((d>='0') && (d<='9')) d = d - '0';
		else if ((d>='A') && (d<='F')) d = d - 'A' + 10;
		else if ((d>='a') && (d<='f')) d = d - 'a' + 10;
		else d = 0;

		if (j==0) {
			*pb = d<<4;
			j=1;
		}
		else {
			*pb |= d;
			j=0;
			pb++;
		}
	}
}
/**************
edit_cmd(eds,cmd)
char *eds,*cmd;
{
	char c;

	while (c=*eds++) {
		if (c==' ') {
			if (*cmd)
				cmd++;
			else {
				*cmd++ = c;
				*cmd   = '\0';
			}
		}
		else if (c=='\\') {
			if (c=*eds++) *cmd++ = c;
			else break;
		}
		else if (c==';') {
			*cmd++ = c;
			*cmd   = '\0';
			break;
		}
		else *cmd++ = c;
	}
}
************************/
edit_cmd(eds,cmdio)
char *eds,*cmdio;
{
	char c, tmp[4096], *cms, *cmd;

	cmd = tmp;
	cms = cmdio;
	while (c=*eds++) {
		if (c==' ') {
			if (*cms)
				*cmd++ = *cms++;
			else {
				*cmd++ = c;
				*cmd   = '\0';
			}
		}
		else if (c=='#') {
			if (*cms) cms++;
		}
		else if (c=='^') {
			if (c=*eds++) {
				*cmd++ = c;
			}
			else break;
		}
		else if (c=='%') {
			strcpy(cmd,eds);
			strcpy(cmdio,tmp);
			return 0;
		}
		else if (c=='\\') {
			if (c=*eds++) {
				*cmd++ = c;
				if (*cms) cms++;
			}
			else break;
		}
		else if (c==';') {
			*cmd++ = c;
			*cmd   = '\0';
			strcpy(cmdio,tmp);
			return 0;
		}
		else {
			*cmd++ = c;
			if (*cms) cms++;
		}
	}
	strcpy(cmd,cms);
	strcpy(cmdio,tmp);
	return 0;
}

print_send(dat,len)
char *dat;
int len;
{
	int ret,nparam,i;

	printf("\n*** send ***\n");
	memcpy(&nparam,dat,4);
	printf("command  = %08x\n",ntohl(nparam));
	dat += 4;
	memcpy(&nparam,dat,4);
	printf("nparam   = %d\n",ntohl(nparam));
	dat += 4;
	len -= 8;
	i = 1;
	while (len>0) {
		printf("parm(%2d) = ",i++);
		ret=print_dat(dat,len,buf);
		len -= ret;
		dat += ret;
	}
	return 0;
}

print_ret(mode,buf,len,temp)
char *buf,*temp;
int mode,len;
{
	int ret,nparam,i,kan_len;
	pk_kan kan;

	printf("\n*** receiv ***\n");
	if (!mode) {
		len -= UCODE_SIZE;
		buf += UCODE_SIZE;
		print_page(buf,len,temp);
		return 0;
	}
	while (len>0) {
		memcpy(&kan,buf,sizeof(pk_kan));
		kan_len = ntohl(kan.len);
		if (kan.id=='P' || kan.id=='F' || kan.id=='X') {
			printf("packet type = '%c'\n",kan.id);
			buf += sizeof(pk_kan);
			len -= sizeof(pk_kan);
			switch (kan.id) {
			case 'P':
				print_page(buf+UCODE_SIZE,kan_len-UCODE_SIZE,temp);
				len -= kan_len;
				buf += kan_len;
				break;
			case 'F':
			case 'X':
				memcpy(temp,buf,kan.um-4);
				temp[kan.um-4]='\0';
				printf("  file name = [%s]\n",temp);
				printf("  data len  = %d\n",kan_len);
				len -= kan.um;
				buf += kan.um;
				if (kan.id == 'X') {
					axaxdump("DATA",buf,kan_len);
					len -= kan_len;
					buf += kan_len;
				}
				break;
			}
		}
		else {
			axaxdump("ERROR DATA",buf,len);
			return 0;
		}
	}
	return 0;
}

print_page(buf,len,temp)
char *buf,*temp;
int len;
{
	char *p,w[32];
	long ret,l,nt,nd,cmnd;
	int i;
	FILE *fp;

	p = buf;
	memcpy(&ret,p,4);
	printf("command  = %08x\n",ntohl(ret));
	cmnd = ret;
	p += 4;
	memcpy(&ret,p,4);
	printf("retcode  = %d\n",ntohl(ret));
	p += 4;
	len -= 8;
	while (len>0) {
		if (!memcmp(p,"FM",2)) {
			p += 2;
			len -= 2;
			printf("FM\n");
			ret=print_dat(p,len,temp);
			len -= ret;
			p += ret;
		}
		else if (!memcmp(p,"GR",2)) {
			if (len>=17) {
				memcpy(w,p+12,5);
				w[5]='\0';
				l=atoi(w)*5+17;
				if (l>len) l=len;
			}
			else l=len;
			memcpy(temp,p,l);
			temp[l]='\0';
			printf("%s\n",temp);
			len -= l;
			p += l;
		}
		else if (!memcmp(p,"DT",2)) {
			strcpy(temp,"DT");
			p += 2;
			len -= 2;
			if (len>=5) {
				memcpy(temp+2,p,5);
				temp[7]='\0';
				p += 5;
				len -= 5;
			}
			if (len>=5) {
				memcpy(w,p,5);
				w[5]='\0';
				nd=atoi(w);
				memcpy(temp+7,p,5);
				temp[12]='\0';
				p += 5;
				len -= 5;
			}
			printf("%s\n",temp);
			for (i=0;i<nd && len>0;i++) {
				printf("parm(%2d) = ",i);
				ret=print_dat(p,len,temp);
				len -= ret;
				p += ret;
			}
		}
		else {
			*(p+len) = '\0';
			if (strstr(p,"<HTML>")) {
				printf("%s",p);
				sprintf(w,"cmnd%08x.htm",cmnd);
				if (fp=fopen(w,"wb")) {
					fwrite(p,1,len,fp);
					fclose(fp);
				}
			}
			else {
				axaxdump("ERROR DATA ",p,len);
			}
			break;
		}
	}
	return 0;
}

int axaxdump(msg, p , len )
char *msg,*p;
int len;
{
	return 0;
}
