static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  Z                                               *
*                                                                             *
*      ֐@@@F@int cl_gx_compute( pLeaf )                             *
*                      (I)Leaf     *pLeaf                                     *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern GlobalCt *pGlobTable;
extern CLCOMMON CLcommon;
extern int giOptions[];
extern tdtIterate_ctl gtIter_ctl[];

/****************************************/
/*										*/
/****************************************/
static int _gx_ppmm_val(atr,pInfoParm)
int atr;
tdtINFO_PARM *pInfoParm;
{
	static char *name="_gx_ppmm_val";
	char *p;
	int  *pi,rc,iValue,size;
	long lValue;
	double *pd,dValue;
	int  attr,iAttr[3],Val[2];
	MPA *mpa;
	char work[64];

	p = pInfoParm->pi_paux;
/*
printf("_gx_ppmm_val: atr=%d p=%08x\n",atr,p);
*/
	if ((attr=(int)(pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA)) == DEF_ZOK_BINA) {
#if defined(_LP64)	/* 2021.9.7 */
		size = pInfoParm->pi_len;
		if (size == sizeof(int)) lValue = *(int *)p;
		else lValue = *(long *)p;
		if (atr == 14) lValue++;
		else if (atr == 15) lValue--;
		else if (atr == 16) lValue = !lValue;
		else lValue = ~lValue;
		cl_set_parm_bin(pInfoParm,lValue);
		if (size == sizeof(int)) *(int *)p = lValue;
		else *(long *)p = lValue;
#else
		pi = (int *)p;
		if (atr == 14) (*pi)++;
		else if (atr == 15) (*pi)--;
		else if (atr == 16) *pi = !(*pi);
		else *pi = ~(*pi);
		cl_set_parm_bin(pInfoParm,*pi);
#endif
	}
	else if (attr == DEF_ZOK_FLOA) {
		pd = (double *)p;
		if (atr == 14) (*pd)++;
		else if (atr == 15) (*pd)--;
		else {
			/* %s: _f[^(%e)́ArbgZł܂B */
			ERROROUT2(FORMAT(141),name,*pd);
			return ECL_SCRIPT_ERROR;
		}
		cl_set_parm_double(pInfoParm,*pd);
	}
	else if (attr == DEF_ZOK_DECI) {
		mpa = (MPA *)p;
		if (atr == 14) m_add1(mpa,m_get_i(1));
		else if (atr == 15) m_sub1(mpa,m_get_i(1));
		else {
			m_mpa2an(mpa,work,sizeof(work),pGlobTable->options[10]);
			/* %s: POi_f[^(%s)́ArbgZł܂B */
			ERROROUT2(FORMAT(142),name,work);
			return ECL_SCRIPT_ERROR;
		}
		if (pInfoParm->pi_hlen) {
			if ((rc=cl_mpa_scale(p,pInfoParm->pi_hlen,pInfoParm->pi_pos))<0) return rc;
		}
		m_cpy((MPA *)pInfoParm->pi_data,mpa,0);
	}
	else if (attr == DEF_ZOK_CHAR) {
		/* %s: f[^(%s)́AZł܂B */
		ERROROUT2(FORMAT(143),name,p);
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _gx_ppmm(atr,pInfoParm)
int atr;
tdtINFO_PARM *pInfoParm;
{
	static char *name="_gx_ppmm";
	long   lValue;
	int  rc,iValue,mc,lenW,len,alen;
	int  attr0,attr,iAttr[3];
	long Valz[NMPA_LONG],*Val;
	double dValue;
	MPA *mpa;
	char work[64],*p,id;
	tdtINFO_PARM tInfoParmW,tInfoParm;

	if (!pInfoParm) return -1;
	if ((pGlobTable->options[1] & 0x02) &&
	     pInfoParm->pi_attr==DEF_ZOK_CHAR && !cl_is_none_parm(pInfoParm)) {
		if (atr==14 || atr==15) {
			mc = atr + 10;
			cl_set_parm_long(&tInfoParm,1);
			rc = cl_str_add(&tInfoParmW,mc,pInfoParm,&tInfoParm);
			if (!rc) {
				lenW = tInfoParmW.pi_dlen;
				len = pInfoParm->pi_dlen;
				alen = X_MAX(lenW,len);
				if (!(p=Strndup(tInfoParmW.pi_data,alen))) return ECL_MALLOC_ERROR;
				if (pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA) {
					if (len > lenW) memset(p+lenW,len-lenW,' ');
					memzcpy(pInfoParm->pi_paux,p,len);
					lenW = len;
				}
				cl_set_parm_char(pInfoParm,p,lenW);
			}
		}
		else {
			ERROROUT2(FORMAT(143),name,pInfoParm->pi_data);
			rc = ECL_SCRIPT_ERROR;
		}
		return rc;
	}
#if 1	/* 2021.3.29 */
	if ((id=pInfoParm->pi_id)=='A' || id=='R') {
		if (atr == 14) p = "+";
		else if (atr == 15) p = "-";
		else {
			return ECL_SCRIPT_ERROR;
		}
		cl_set_parm_long(&tInfoParm,1);
		if ((rc=cl_get_mapped_array(&tInfoParmW,pInfoParm,p,&tInfoParm)) < 0) return rc;
		cl_gx_copy_info(pInfoParm,&tInfoParmW);
		return 0;
	}
#endif
	if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;

	if (pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA) return _gx_ppmm_val(atr,pInfoParm);

	if ((attr0=pInfoParm->pi_attr)==DEF_ZOK_BINA && pInfoParm->pi_scale==0x40) {
		if (atr == 14) (pInfoParm->pi_pos)++;
		else if (atr == 15) (pInfoParm->pi_pos)--;
		else if (atr == 16) pInfoParm->pi_pos = !(pInfoParm->pi_pos);
		else pInfoParm->pi_pos = ~(pInfoParm->pi_pos);
/*
printf("_gx_ppmm: pInfoParm->pi_pos=%d\n",pInfoParm->pi_pos);
*/
	}
	else if (attr0 == DEF_ZOK_DECI) {
		mpa = (MPA *)pInfoParm->pi_data;
		if (atr == 14) m_add1(mpa,m_get_i(1));
		else if (atr == 15) m_sub1(mpa,m_get_i(1));
		else {
			m_mpa2an(mpa,work,sizeof(work),pGlobTable->options[10]);
			/* %s: POi_f[^(%s)́ArbgZł܂B */
			ERROROUT2(FORMAT(142),name,work);
			return ECL_SCRIPT_ERROR;
		}
		if (pInfoParm->pi_hlen) {
			if ((rc=cl_mpa_scale(mpa,pInfoParm->pi_hlen,pInfoParm->pi_pos))<0) return rc;
		}
	}
	else if (attr0 == DEF_ZOK_DATE) {
		mpa = (MPA *)pInfoParm->pi_data;
		if (atr == 14) lValue = 1;
		else if (atr == 15) lValue = -1;
		else {
			ERROROUT1(FORMAT(619),name);
			return ECL_SCRIPT_ERROR;
		}
		cl_date_add_term(mpa,lValue,3);
	}
	else {
		Val = cl_get_tmpMPA(Valz);
		if ((rc=cl_get_parm_mpa(pInfoParm,Val,"_gx_ppmm:",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		if (pInfoParm->pi_scale & D_DATA_MALLOC) Free(pInfoParm->pi_data);
		if ((attr=iAttr[0]) == DEF_ZOK_BINA) {
			lValue = Val[0];
			if (atr == 14) lValue++;
			else if (atr == 15) lValue--;
			else if (atr == 16) lValue = !lValue;
			else lValue = ~lValue;
/*
printf("_gx_ppmm: iValue=%d\n",lValue);
*/
			cl_set_parm_long(pInfoParm,lValue);
		}
		else if (attr == DEF_ZOK_FLOA) {
			memcpy(&dValue,Val,sizeof(double));
			if (atr == 14) dValue++;
			else if (atr == 15) dValue--;
			else {
				/* %s: _f[^(%e)́ArbgZł܂B */
				ERROROUT2(FORMAT(141),name,dValue);
				return ECL_SCRIPT_ERROR;
			}
/*
printf("_gx_ppmm: dValue=%f\n",dValue);
*/
			cl_set_parm_double(pInfoParm,dValue);
		}
		else if (attr == DEF_ZOK_DECI) {
			if (atr == 14) m_add1((MPA *)Val,m_get_i(1));
			else if (atr == 15) m_sub1((MPA *)Val,m_get_i(1));
			else {
				m_mpa2an((MPA *)Val,work,sizeof(work),pGlobTable->options[10]);
				/* %s: POi_f[^(%s)́ArbgZł܂B */
				ERROROUT2(FORMAT(142),name,work);
				return ECL_SCRIPT_ERROR;
			}
/*
printf("_gx_ppmm: dValue=%f\n",dValue);
*/
			cl_set_parm_mpa(pInfoParm,Val);
		}
		else {
			/* %s: lȊÓAZł܂B */
			ERROROUT1(FORMAT(144),name);
			return ECL_SCRIPT_ERROR;
		}
	}

	return 0;
}

/********1*********2*********3*********4*********5*********6*********7***/
/* @\ : R}h̃p[^ϊApParmɐݒ肷					*/
/*		  pParm̊evf̐擪AhXppParmɐݒ肷					*/
/*  ppParm[0]           <-- &pParm[0]			<-- 0NA				*/
/*  ppParm[1]           <-- &pParm[1]			<-- 0NA				*/
/*  ppParm[ipa]         <-- &pParm[ipa]         <-- prmp[0]̕ϊ	*/
/*  ppParm[ipa+1]       <-- &pParm[ipa+1]       <-- prmp[1]		V		*/
/*  EEE																*/
/*  ppParm[ipa+nparm-1] <-- &pParm[ipa+nparm-1] <-- prmp[nparm-1] V	*/
/*																		*/
/*  : ppParm	: InfoParm\̂ւ̃|C^z					*/
/*					  NULL̂Ƃ́Atmp_mallocpppParmɕԂB		*/
/*						pppParm=NULL̂Ƃ́AG[B					*/
/*					  pParḿAInfoParm\̔zBtmp_alloc()	*/
/*					  ppParmɂ́ApParm̊evf̐擪AhX		*/
/*		  ipa		: prmp̕ϊʂݒ肷ppParm̈ʒu(擪0)		*/
/*		  nparm		: prmp̐											*/
/*		  prmp		: R}h̃p[^̃|C^z				*/
/*					  =NULL̂Ƃ́AϊȂB			A			*/
/*		  Obj		: Obj												*/
/*		  opt		: cl_gx_exp_obj_opt()opt							*/
/*		  pppParm	: <>NULL̂ƂAtmp_mallocppParmԂ|C^B*/
/*						ppParm[0]ɂ́ApParmB					*/
/*					  prmp=NULL,nParm>0̂Ƃ́AppParm0=*pppParmŁA	*/
/*						a)pParm0=ppParm0[0]<>NULL̂Ƃ́A			*/
/*						  pParm+ipä̗pParm0̗̈				*/
/*						  cl_gx_copy_info()ŃRs[B				*/
/*						b)pParm0=NULL̂Ƃ́A0NAB			*/
/*		  pSetNum	: pParm[]ɐݒ肵								*/
/* ԋp : ^[R[h												*/
/*		  = 0 : 													*/
/*		  < 0 : G[													*/
/*				= ECL_MALLOC_ERROR : tmp_malloc()G[					*/
/*				= -1 : ppParm=NULL and pppParm=NULL						*/
/*				̑ : cl_gx_exp_obj_opt()<0 ̂Ƃ̒l				*/
/*======================================================================*/
/* 1  : ipa+nparmpParm̈mۂB							*/
/*		  ppParm̈́Amۍς݁B										*/
/*			cl_gx_parm_conv_arg(ppParm,ipa,nparm,NULL,0,NULL,NULL);		*/
/* 2  : ipa+nparmpParm̈ppParm̈mۂAppParm̈		*/
/*		  AhXppParmɕԂB										*/
/*		  ()nparm>0̂Ƃ́AppParm=NULLƂȂ΂ȂȂ			*/
/*			cl_gx_parm_conv_arg(NULL,ipa,nparm,NULL,0,&ppParm,NULL);	*/
/* 3  : ipa+nparmpParm̈ppParm̈mۂAppParm̈		*/
/*		  AhXppParmɕԂBݒς݂nparmpParm̈		*/
/*		  VɊmۂ̈pParm+ipɃRs[B						*/
/*			tdtInfoParm pParm[nparm],**ppParm,*ppParmW[1];				*/
/*			ppParmW[0] = pParm;											*/
/*			ppParm = ppParmW;											*/
/*			cl_gx_parm_conv_arg(NULL,ipa,nParm,NULL,0,&ppParm,NULL);	*/
/* 4  : ipa+nparmpParm̈ppParm̈mۂAppParm̈		*/
/*		  AhXppParmɕԂBnparm̃R}hp[^ϊ	*/
/*		  VɊmۂ̈pParm+ipɐݒ肷B						*/
/*			cl_gx_parm_conv_arg(NULL,ipa,nParm,prmp,opt,&ppParm,NULL);	*/
/************************************************************************/
int cl_gx_parm_conv_arg(ppParm,ipa,nparm,prmp,Obj,opt,pppParm,pSetNum)
tdtINFO_PARM *ppParm[],***pppParm;
int ipa,nparm,opt,*pSetNum;
parmList *prmp[];
tdtINFO_PARM **Obj;
{
	int i,ii,npa,rc,ret;
	tdtINFO_PARM **ppParm0,*pParm0,*pParm;

/*
printf("cl_gx_parm_conv_arg:Enter: ppParm=%08x\n",ppParm);
*/
	rc = 0;
	if (pSetNum) *pSetNum = 0;
	if ((npa=ipa+nparm) > 0) {
		pParm0 = NULL;
		if (!prmp && nparm && pppParm) {
			if (akxm_addrchk(ppParm0 = *pppParm)) pParm0 = ppParm0[0];
		}
		if (!ppParm) {
			if (!pppParm) return -1;
			if (!(ppParm=(tdtINFO_PARM **)cl_tmp_const_malloc(npa*sizeof(tdtINFO_PARM *)))) return ECL_MALLOC_ERROR;
			*pppParm = ppParm;
/*
printf("cl_gx_parm_conv_arg:malloc: ppParm=%08x\n",ppParm);
*/
		}
		if (pParm=(tdtINFO_PARM *)cl_tmp_const_malloc(npa*sizeof(tdtINFO_PARM))) {
			for (i=0;i<ipa;i++) {
				ppParm[i] = pParm++;
			}
			ii = i;
			opt &= ~D_GX_OPT_PARMINFO2;
			for (i=0;i<nparm;i++) {
				if (prmp) {
					if ((ret=cl_gx_exp_obj_opt(1,&prmp[i],Obj,pParm,opt)) < 0) {
						rc = ret;
						break;
					}
				}
				else if (pParm0) cl_gx_copy_info(pParm,pParm0++);
				ppParm[ii++] = pParm++;
			}
			if (pSetNum) *pSetNum = ii;
		}
		else rc = ECL_MALLOC_ERROR;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_bexp_func_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,nparm,prmp)
tdtINFO_PARM *pInfoParmW;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
char *pOperator;
int nparm;
parmList  *prmp[];
{
	tdtINFO_PARM **ppParm,*pParm,*ppParm0[2],pParm0[2];
	int rc;

	if (nparm > 0) {
		if ((rc=cl_gx_parm_conv_arg(NULL,2,nparm,prmp,NULL,0,&ppParm,NULL)) < 0) return rc;
		cl_gx_copy_info(ppParm[0],pInfoParm1);
		cl_gx_copy_info(ppParm[1],pInfoParm2);
		pParm = ppParm[0];
	}
	else {
		ppParm = ppParm0;
		pParm = pParm0;
		cl_gx_copy_info(&pParm[0],pInfoParm1);
		cl_gx_copy_info(&pParm[1],pInfoParm2);
		ppParm[0] =	&pParm[0];
		ppParm[1] =	&pParm[1];
	}
	if ((rc=cl_gx_func_bexp(pInfoParmW,pOperator,nparm+2,ppParm,0,pParm)) < 0) return rc;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_compute(pLeaf,proc)
Leaf *pLeaf;
ProcCT  *proc;
{
	static  char *fname="cl_gx_compute";
	int		rc, scale,len;
	char	*pOperator, *pWork, wk[33],c,*name,cPM;
	parmList  *pparmList1;
	parmList  *pparmList2;
	parmList  *pparmList3;
	tdtINFO_PARM InfoParm1,*pInfoParm1;
	tdtINFO_PARM InfoParm2,*pInfoParm2;
	tdtINFO_PARM InfoParm0,*pInfoParm0;
	tdtINFO_PARM InfoParmW,*pInfoParmW;
	tdtINFO_PARM *pInfoParm;
	ScrPrCT	  *pScCT;
	parmList  **parmp;
	char cM_QUOTE1 = pGlobTable->Quot[0];

	parmp = pLeaf->cmd.prmp;
	pInfoParm = NULL;
	pInfoParm0 = &InfoParm0;
	cPM = '\0';
	name = parmp[0]->prp;
	if ((len=parmp[0]->prmlen) > 2) {
		if (akxnrskipin(name,len,"+-") == (len-2)) {
			cPM = name[len-2];
			len -=2;
		}
	}
	if (rc=cl_gx_expsn_obj_opt(name,len,parmp[0]->bxobj,proc->Obj,pInfoParm0,
	                   D_GX_OPT_STORE|D_GX_OPT_GET_ADDR|D_GX_OPT_NOEROUT_NDEF)) return rc;
	if (pInfoParm0->pi_id == D_DATA_ID_STOREVAR) {
		if (pInfoParm = (tdtINFO_PARM *)pInfoParm0->pi_pos) {
			if (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED) rc = ECL_CAN_NOT_STORE;
			else if (((c=pInfoParm->pi_id)=='A' || c=='R') &&
			    (pInfoParm->pi_scale & D_DATA_INDEX_FREE)) {
				rc = ECL_CAN_NOT_STORE;
			}
		}
		else rc = ECL_CAN_NOT_STORE;
	}
	else rc = ECL_CAN_NOT_STORE;
	if (rc == ECL_CAN_NOT_STORE) {
		/* %s: %sւ͑͂ł܂B */
		ERROROUT2(FORMAT(126),fname,parmp[0]->prp);
		return rc;
	}
	pparmList2 = parmp[2]; 	/* EӂP	*/
	if (pparmList2->prp[0] == cM_QUOTE1) {
		if (rc=cl_conv_const_c(pparmList2,&InfoParm1)) return rc;
	}
	else {
		if (rc=cl_gx_exp_obj_opt(1,&parmp[2],proc->Obj,&InfoParm1,0)) return rc;
	}
	if (pLeaf->cmd.prmnum >= 5)	{	/* 񍀉Zq̏ꍇ		*/
		pparmList3 = parmp[4]; 	/* EӂQ	*/
		if (pparmList3->prp[0] == cM_QUOTE1) {
			if (rc=cl_conv_const_c(pparmList3,&InfoParm2)) return rc;
		}
		else {
			if (rc=cl_gx_exp_obj_opt(1,&parmp[4],proc->Obj,&InfoParm2,0)) return rc;
		}
	}
	pInfoParmW = &InfoParmW;
	if (pLeaf->cmd.prmnum >= 5)	{	/* 񍀉Zq̏ꍇ		*/
		pOperator = parmp[3]->prp;
		rc = cl_gx_bexp(pInfoParmW,&InfoParm1,pOperator,&InfoParm2,
		            pLeaf->cmd.prmnum-5, &parmp[5]);
		if (rc) {
			/* %s: 񍀉ZɌ肪܂B */
			ERROROUT1(FORMAT(145),fname);
			return rc;
		}
	}
	else {
		cl_gx_copy_info(pInfoParmW,&InfoParm1);
	}
	len = parmp[1]->prmlen;
	if (len > 1) {
		if (pInfoParm0->pi_id=='\0') {
			/* %s: %s̃f[^ݒłB */
			ERROROUT2(FORMAT(127),fname,parmp[0]->prp);
			return ECL_NDEFVAR_ERROR;
		}
		if (len > sizeof(wk)-1) {
			/* %s: Zq(%)܂B */
			ERROROUT2(FORMAT(146),fname,parmp[1]->prp);
			return ECL_SCRIPT_ERROR;
		}
		memzcpy(wk,parmp[1]->prp,len-1);
		if (!(pInfoParm1 = pInfoParm)) pInfoParm1 = pInfoParm0;
		pInfoParm2 = pInfoParmW;
		pInfoParmW = &InfoParm1;
		if (rc=cl_gx_bexp(pInfoParmW,pInfoParm1,wk,pInfoParm2,0,NULL))
			return rc;
	}
#if 1	/* 2021.10.27 */
	if (rc=cl_gx_rep_info_als(pInfoParm,pInfoParmW,1)) return rc;
#else
	if (rc=cl_gx_rep_info_set(pInfoParm,pInfoParmW,1)) return rc;
#endif
	if (cPM) rc = _gx_ppmm(cPM=='+'?14:15,pInfoParm);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int let_compute_sub_opt(nparm,prmp,Obj,opt,ppInfoParm)
int nparm;
parmList *prmp[];
tdtINFO_PARM **Obj;
int opt;
tdtINFO_PARM **ppInfoParm;
{
	int rc;
	tdtINFO_PARM tInfoParm;
/*
printf("let_compute_sub_opt:Enter: nparm=%d opt=%08x ppInfoParm=%08x\n",nparm,opt,ppInfoParm);
*/
	if (ppInfoParm) opt |= D_GX_OPT_GET_ADDR;
	if ((rc=cl_gx_exp_obj_opt(nparm,prmp,Obj,&tInfoParm,opt)) < 0)	{
		/* %s: Ă܂(rc=%d)B */
		ERROROUT2(FORMAT(48),"let_compute_sub_opt",rc);
		rc = ECL_EX_LET;
/*
printf("let_compute_sub_opt: rc=%d opt=%08x exception=%08x\n",rc,opt,pGlobTable->exception);
*/
	}
	else {
		rc = 0;
		if (ppInfoParm) {
			if (tInfoParm.pi_id == D_DATA_ID_STOREVAR)
				*ppInfoParm = (tdtINFO_PARM *)tInfoParm.pi_pos;
			else {
				ERROROUT2(FORMAT(126),"let_compute_sub_opt","ppInfoParm");	/* "%s: %sɂ͑ł܂B*/
				rc = ECL_CAN_NOT_STORE;
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int let_compute_sub(nparm,prmp,Obj)
int nparm;
parmList *prmp[];
tdtINFO_PARM **Obj;
{
	return let_compute_sub_opt(nparm,prmp,Obj,0,NULL);
}

/****************************************/
/*										*/
/****************************************/
int let_compute_info(pLeaf, proc, opt, ppInfoParm)
Leaf *pLeaf;
ProcCT  *proc;
int opt;
tdtINFO_PARM **ppInfoParm;
{
	tdtObjHead *pObj;

	if (proc) pObj = proc->Obj;
	else pObj = cl_gx_get_scr_obj();
	return let_compute_sub_opt(pLeaf->cmd.prmnum,pLeaf->cmd.prmp,pObj,opt,ppInfoParm);
}

/****************************************/
/*										*/
/****************************************/
int let_compute_opt(pLeaf, proc, opt)
Leaf *pLeaf;
ProcCT  *proc;
int opt;
{
	return let_compute_info(pLeaf, proc, opt, NULL);
}

/****************************************/
/*										*/
/****************************************/
int let_compute(pLeaf,proc)
Leaf *pLeaf;
ProcCT  *proc;
{
	return let_compute_info(pLeaf, proc, 0, NULL);
}

/********************************************/
/*	BEXPR}hĂ΂ꂽƂ			*/
/*		nparm : 3ȍ~̃p[^		*/
/*		prmp  : p[^zւ̃|C^*/
/*	2ZĂ΂ꂽƂ			*/
/*		nparm : 0							*/
/*		prmp  : NULL						*/
/********************************************/
int cl_gx_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,nparm,prmp)
char *pOperator;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
tdtINFO_PARM *pInfoParmW;
int nparm;
parmList  *prmp[];
{
	static char *name="cl_gx_bexp";
#if 1	/* 2021.3.10 */
	static char J[5][5]={0,0,0,0,0, 0,1,0,1,0, 0,0,1,1,0, 0,1,1,0,2, 0,0,0,2,0};
#else
	static char J[5][5]={0,0,0,0,0, 0,1,1,1,0, 0,1,1,1,0, 0,1,1,0,2, 0,0,0,2,0};
#endif
	int rc,rc2,ope;
	int dtlen,dtatr,scale,i1,i2,iParm[5];
	long Valz[NMPA_LONG*2+1],lVal,*Val;
	char *pWork,msg[7],id1,id2,c;
	uchar pi_aux1,pi_aux2;
	tdtINFO_PARM *ppParm[2],pParm[2];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_bexp: Enter pInfoParm1=",pInfoParm1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"            pOperator=[%s] pInfoParm2=",pInfoParm2,pOperator,0);

	memset(pInfoParmW,0,sizeof(tdtINFO_PARM));
	mem_set_int(iParm,0,5);

	Val = cl_get_tmpMPA2(Valz,2);
	pWork = (char *)Val;
	dtatr = DEF_ZOK_BINA;
	dtlen = 0;
	scale = 0x40;
	ope = cl_gx_chk_opt(pOperator,0);			/*Zq`FbN			*/

DEBUGOUTL2(120,"cl_gx_bexp: ope=%d pOperator=[%s]",ope,pOperator);

	id1 = pInfoParm1->pi_id;
	id2 = pInfoParm2->pi_id;
	if (id1=='S' || id2=='S') {
		if (ope==IS && id1=='S' && id2==' ') ;
		else {
					/* %s: %śAZł܂B*/
			ERROROUT2(FORMAT(187),name,FORMAT(339));
			return ECL_SCRIPT_ERROR;
		}
	}

	if (ope == MATH) {
		if (pInfoParm1->pi_attr==DEF_ZOK_DATE || pInfoParm2->pi_attr==DEF_ZOK_DATE) {
			return cl_cmpt_date(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
		}
		else if (((c=*pOperator)=='&' || c=='|') &&
		    (pInfoParm1->pi_attr==DEF_ZOK_CHAR && pInfoParm2->pi_attr==DEF_ZOK_CHAR)) {
			if (rc=concat(&pWork,pInfoParm1,pInfoParm2,nparm,prmp,NULL)) return rc;
			cl_set_parm_char(pInfoParmW,pWork,strlen(nval(pWork,"")));
			return 0;
		}
		else if ((pGlobTable->options[1] & 0x02) && ((c=*pOperator)=='*' || c=='+' || c=='-') &&
			     ((pInfoParm1->pi_attr==DEF_ZOK_CHAR && !cl_is_none_parm(pInfoParm1)) ||
				  (pInfoParm2->pi_attr==DEF_ZOK_CHAR && !cl_is_none_parm(pInfoParm2)))) {
			return cl_str_exp(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
		}
	/*
		id1 = pInfoParm1->pi_id;
		id2 = pInfoParm2->pi_id;
	*/
		pi_aux1 = (id1=='A'||id1=='R')&&(pInfoParm1->pi_aux[0] & DEF_ZOK_DATA);
		pi_aux2 = (id2=='A'||id2=='R')&&(pInfoParm2->pi_aux[0] & DEF_ZOK_DATA);
		i1 = i2 = 0;
		if (pi_aux1) i1 = 1;
		else if (id1=='L' || id1=='N') i1 = 2;
		else if (id1 == ' ') i1 = 3;
		else if (id1=='A'||id1=='R') i1 = 4;
		if (pi_aux2) i2 = 1;
		else if (id2=='L' || id2=='N') i2 = 2;
		else if (id2 == ' ') i2 = 3;
		else if (id2=='A'||id2=='R') i2 = 4;
/*
printf("cl_gx_bexp: pi_aux1=%02x pi_aux2=%02x id1=%c id2=%c i1=%d i2=%d j=%d\n",pi_aux1,pi_aux2,id1,id2,i1,i2,J[i1][i2]);
*/
		if ((c=J[i1][i2]) == 1) {
			ope = AGGREGATE;
			if (cl_is_undef_parm(pInfoParm1) || cl_is_none_parm(pInfoParm1)) {
					/* %s: Zq=%sȀWZ͂ł܂B */
				ERROROUT2(FORMAT(165),name,pOperator);
				return ECL_SCRIPT_ERROR;
			}
		}
		else if (c == 2) {	/* z̐擪ʒuړ */
			return cl_get_mapped_array(pInfoParmW,pInfoParm1,pOperator,pInfoParm2);
		}
		else {
			*msg = '\0';
			if (rc=cl_check_data_id(pInfoParm1,0)) {
				strcpy(msg,"1");
			}
			if (rc2=cl_check_data_id(pInfoParm2,0)) {
				rc = rc2;
				if (*msg) strcat(msg,",");
				strcat(msg,"2");
			}
			if (rc) {
				/* %s: ZpZ̑%sɌ肪܂B */
				ERROROUT2(FORMAT(147),name,msg);
				return rc+ECL_CHK_VAR_ERROR;
			}
		}
	}
#if 1	/* 2021.4.23 */
	if (id1 == ' ') {
		if (ope == COMP) {
			if (!stricmp(pOperator,"MAX") || !stricmp(pOperator,"MIN") ||
			    !stricmp(pOperator,"SUM") || !stricmp(pOperator,"AVG")) ope = FUNCTION;
		/*	if (_get_comp_no(pOperator,0) < 0) ope = FUNCTION;	*/
		}
		else if (ope == TO) {
			if (stricmp(pOperator,"TO")) ope = FUNCTION;
		}
		else if (!stricmp(pOperator,"ABS")) pInfoParm2 = pInfoParm1;
	}
#endif
	switch (ope) {
		case MATH:							/* ZpZ		*/
			if ((dtatr=cl_cmpt_math(pWork,pOperator,pInfoParm1,pInfoParm2,iParm)) < 0)
				return ERROR;
			break;
		case COMP:							/* rZ		*/
			gtIter_ctl[0].itc_circ_ref = NULL;
			gtIter_ctl[1].itc_circ_ref = NULL;
			if ((dtatr=cl_cmpt_comp(&pWork,pOperator,pInfoParm1,pInfoParm2,nparm,prmp)) < 0)
				return ERROR;
			break;
		case LOGICAL:						/* _Z		*/
			if ((rc=cl_cmpt_logic(pWork,pOperator,pInfoParm1,pInfoParm2)) != NORMAL)
				return ERROR;
			break;
		case IS:							/* is  Z		*/
			ppParm[0] = pInfoParm1;
			ppParm[1] = pInfoParm2;
			if (rc=cl_cmpt_is(pWork,pOperator,2,ppParm,0,0)) return ERROR;
			break;
		case STRING:						/* mojiZ		*/
			if ((rc=cl_cmpt_string(&pWork,pOperator,pInfoParm1,pInfoParm2,nparm,prmp)) != NORMAL)
				return ERROR;
			if (memicmp(pOperator,"ASC",3)) dtatr = DEF_ZOK_CHAR;
			else dtatr = DEF_ZOK_BINA;
			break;
		case TO:							/* to Z		*/
			ppParm[0] = pInfoParm1;
			ppParm[1] = pInfoParm2;
			if ((dtatr=cl_cmpt_to(&pWork,pOperator,2,ppParm,0,0)) < 0)
				return dtatr;
			if (!dtatr) dtatr = DEF_ZOK_CHAR;
			break;
		case AGGREGATE:						/* WZ		*/
			if ((rc=cl_cmpt_agg(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)) < 0)
				return rc;
			return 0;
		case FUNCTION:						/* ֐			*/
		case FUNCFILE:						/* t@C֐	*/
		case FUNCMATH:						/* lZ֐	*/
		case FUNCLOG:						/* O֐		*/
		case FUNCCAST:						/* CAST֐		*/
#if 0
			if (nparm && nparm!=2) {
				/* %s: ̐(%d)QȊOłBZq=%s ope=%d */
				ERROROUT4(FORMAT(157),name,nparm,pOperator,ope);
				return ECL_SCRIPT_ERROR;
			}
#endif
			return cl_gx_bexp_func_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,nparm,prmp);
		default:
			/* %s: Zq(%s)Ɍ肪܂Bope=%d */
			ERROROUT3(FORMAT(148),name,pOperator,ope);
			return ECL_SCRIPT_ERROR;
	}

	if (dtatr == DEF_ZOK_CHAR) {
		if (pWork) {
			dtlen = strlen(pWork);
			scale = 0;
		}
	}
	else if (dtatr == DEF_ZOK_BINA) {
		memcpy(&lVal,pWork,sizeof(long));
		dtlen = sizeof(long);
		pInfoParmW->pi_pos  = lVal;
		pWork = (char *)&(pInfoParmW->pi_pos);
		if (iParm[3] == DEF_ZOK_USMASK) scale |= D_DATA_UNSIGNED;
	}
	else if (dtatr == DEF_ZOK_FLOA) {
		dtlen = sizeof(double);
		memcpy(&pInfoParmW->pi_pos,pWork,dtlen);
		pWork = (char *)&(pInfoParmW->pi_pos);
	}
	else if (dtatr == DEF_ZOK_DECI) {
		return cl_set_parm_mpa(pInfoParmW,pWork);
	}
	else if (dtatr == DEF_ZOK_DATE) {
		return cl_set_parm_date(pInfoParmW,pWork);
	}

	pInfoParmW->pi_id    = ' ';
	pInfoParmW->pi_attr  = dtatr;
	pInfoParmW->pi_scale = scale;
	pInfoParmW->pi_code  = CLcommon.cDataCode;
	pInfoParmW->pi_dlen  = dtlen;
	pInfoParmW->pi_data  = pWork;
/*
printf("cl_gx_bexp: iParm=%d %d %d %d %d\n",iParm[0],iParm[1],iParm[2],iParm[3],iParm[4]);
*/
	pInfoParmW->pi_alen  = iParm[D_IPARM_OVER];

	return 0;
}

/****************************************/
/*										*/
/****************************************/
int let_compute_return(leaf,proc)
Leaf *leaf;
ProcCT  *proc;
{
	return -1;
}

/****************************************/
/*										*/
/****************************************/
static struct {
	short ckid_opt;
	short ckid_no;
	short ckid_rc;
	char  ckid_id;
	char  ckid_np;
} *p,_chk_id[] = {
	 {0x01,115,-1,'F',0x01}
	,{0x02,149,-2,'A',0x02}
	,{0x02,150,-2,'R',0x02}
	,{0x04,151,-3,'U',0x11}
	,{0x04,152,-3,'\0',0x10}
	,{0x08,153,-4,D_DATA_ID_LIST,0}
	,{0x10,154,-5,'T',0}
	,{0x20,466,-6,'P',0x23}
	,{0x40,134,-7,'X',0}
	,{0x80,120,-8,'C',0x01}
	,{0x100,159,-9,'I',0x01}
	,{0x200,162,-10,'M',0x01}
	,{0x400,114,-11,'O',0x01}
	,{0x800,169,-12,D_DATA_ID_PNAME,0}
	,{0x1000,170,-13,D_DATA_ID_NARABI,0}
	,{0xa000,597,-14,' ',0}
	,{0x4000,339,-15,'S',0}
	,{0,0,0,0,0}
};

int cl_check_data_id(pInfoParm,opt)
tdtINFO_PARM *pInfoParm;
int opt;
{
	return cl_check_data_id2(pInfoParm,opt,0);
}

int cl_check_data_id2(pInfoParm,opt,opt2)
tdtINFO_PARM *pInfoParm;
int opt,opt2;
{
	char c,*pn,*type,*fmt,cn;
	int ch_opt,i,j,iCKECK_NORMAL,attr;

	if (!pInfoParm) return 0;
	iCKECK_NORMAL = opt2 & 0x01;	/* OFF : 0x8000 ̂̓`FbNȂ */
	if (!opt) opt = -1;
	c = pInfoParm->pi_id;
	p = &_chk_id[0];
	while (ch_opt=p->ckid_opt) {
		if (!iCKECK_NORMAL && (p->ckid_opt & 0x8000)) ;
		else if ((opt & p->ckid_opt) && c==p->ckid_id) {
			type = FORMAT(p->ckid_no);
			i = p->ckid_np;
			j = i & 0xf0;
			i &= 0x0f;
			if (i == 1) {
				pn = pInfoParm->pi_data;
				if ((cn=*pn)>='0' && cn<='9') pn = cl_get_func_name(atoi(pn),NULL);
			}
			else if (i == 2) pn = (char *)pInfoParm->pi_pos;
			else if (i == 3) {
				pn = (char *)pInfoParm->pi_pos;
				attr = pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA;
				if (attr == D_AUX0_TYPE_STRUCT) type = FORMAT(154);
				else if (attr == D_AUX0_TYPE_ARRAY) type = FORMAT(150);
				else if (attr == D_AUX0_TYPE_MAPPED) type = FORMAT(149);
			}
			if (!j) {
				if (i) ERROROUT2(FORMAT(155),type,pn);
				else ERROROUT1(FORMAT(158),type);
			}
			else if (j == 0x10) {
				fmt = FORMAT(p->ckid_no);
				if (i) ERROROUT1(fmt,pn);
				else ERROROUT(fmt);
			}
			else if (j == 0x20) {
				ERROROUT2(FORMAT(155),FORMAT(p->ckid_no),pn);
			}
			return p->ckid_rc;
		}
		p++;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_let_ppmm(atr,pInfoParm)
int atr;
tdtINFO_PARM *pInfoParm;
{
#if 0
	if (pInfoParm->pi_id == 'S') {
				/* %s: %śAZł܂B*/
		ERROROUT2(FORMAT(187),"cl_gx_let_ppmm",FORMAT(339));
		return ECL_SCRIPT_ERROR;
	}
#endif
	if (atr < 0) atr = -atr;
	return _gx_ppmm(atr,pInfoParm);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_cast(pInfoParmW,pInfoParm1,pInfoParm2)
tdtINFO_PARM *pInfoParmW,*pInfoParm1,*pInfoParm2;
{
	int rc,iParm[5],len,attr;
	char *p,c,*p0;
	tdtINFO_PARM InfoParm1,*ppParm[2];

	rc = 0;
	p0 = p = pInfoParm1->pi_data;
	if (!stricmp(p,"FUNC")) {
		rc = cl_func_f(pInfoParmW,1,&pInfoParm2);
	}
	else {
		if ((attr=(pInfoParm1->pi_aux[0] & ~DEF_ZOK_DATA)) == FUNCCAST) {
			len = pInfoParm1->pi_dlen;
#if 1	/* 2021.3.19 */
			if ((c=*p)=='$' || c=='%' || c=='#') {
				pInfoParm1 = &InfoParm1;
				if (rc=_conv_arg_opt(p,pInfoParm1,0)) return rc;
				if (pInfoParm1->pi_id==' ' && pInfoParm1->pi_attr==DEF_ZOK_CHAR) {
					p0 = p = pInfoParm1->pi_data;
					len = pInfoParm1->pi_dlen;
				}
				else {
							/* %s: [%s]Ă܂B*/
					ERROROUT2(FORMAT(125),"cl_gx_cast",p);
					return ECL_SCRIPT_ERROR;
				}
			}
#endif
			if ((c=*p)=='C' || c=='c') {
				if ((c=*(p+1))!='H' && c!='h') {
					p++;
					len--;
				}
			}
			if (rc=cl_get_def_attr_opt(p,len,iParm,0x01,NULL,NULL)) return rc;
		}
		else {
			iParm[0] = attr;
			iParm[1] = pInfoParm1->pi_len;
			iParm[2] = pInfoParm1->pi_hlen;
			iParm[3] = pInfoParm1->pi_pos;
		}
/*
printf("cl_gx_cast: %s rc=%d iParm=%d %d %d %d\n",p,rc,iParm[0],iParm[1],iParm[2],iParm[3]);
*/
		if (iParm[0]==DEF_ZOK_DATE && iParm[2]) {
			ppParm[0] = pInfoParm2;
			ppParm[1] = pInfoParm1;
			return cl_func_to_date(pInfoParmW,2,ppParm);
		}
		else if (iParm[0]) {
			if (iParm[0]!=DEF_ZOK_VARI)
				rc = cl_set_parm_init(pInfoParmW,iParm,0x01|D_GX_OPT_ALC_TMP);
			else
				rc = cl_parm_set0(pInfoParmW);
			if (!rc) rc = cl_gx_rep_info_set(pInfoParmW,pInfoParm2,1|D_GX_OPT_ALC_TMP);
		}
		else rc = -100;	/*ECL_SCRIPT_ERROR; 2021.4.8 */
	}
/*	if (rc < 0) {	2021.4.8 */
	if (rc == -100) {
		/* cl_gx_cast: %s is not suported cast attr. */
		ERROROUT1(FORMAT(161),p0);
		if (rc == -100) rc = ECL_SYSTEM_ERROR;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_check_attr(pInfoParm,attr0,msg)
tdtINFO_PARM *pInfoParm;
int attr0;
char *msg;
{
	int ret,attr;

	if (ret=cl_check_data_id(pInfoParm,0)) return ret+ECL_CHK_VAR_ERROR;
	else if ((attr=pInfoParm->pi_attr) != attr0) {
				/* %s: f[^(%d)w葮(%d)ƈقȂĂ܂B */
		if (msg) ERROROUT3(FORMAT(160),msg,attr,attr0);
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_mk_cast(pInfoParmW,pm,nparm,ppParm)
tdtINFO_PARM *pInfoParmW,*pm;
int nparm;
tdtINFO_PARM *ppParm[];
{
	int rc,len,attr,size,iParm[4];
	tdtSubCommand *sc;
	char *p,c;

	rc = 0;
	p = pm->pi_data;
	len = pm->pi_dlen;
	if ((c=*p)=='C' || c=='c') {
		if ((c=*(p+1))!='H' && c!='h') {
			p++;
			len--;
		}
	}
	if (nparm<=0 || nparm>2) {
		/* %s: A܂́AxAʎ̎w萔(%d)słB */
		ERROROUT2(FORMAT(479),"cl_gx_mk_cast",nparm);
		return ECL_SCRIPT_ERROR;
	}

	if (sc=cl_get_name_attr2(p,len,0x01,0x20)) {
		size = sc->size;
		attr = sc->attr & D_AUX0_ZOK_MASK;	/* add & D_AUX0_ZOK_MASK 2021.11.4 */
/*
printf("cl_gx_mk_cast: nparm=%d attr=%d\n",nparm,attr);
*/
		if (attr==DEF_ZOK_DATE && nparm>0) {
			cl_gx_copy_info(pInfoParmW,ppParm[0]);
			pInfoParmW->pi_aux[0] = attr;
			pInfoParmW->pi_hlen   = pInfoParmW->pi_dlen;
		}
		else {
			if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) size = 0;
			iParm[0] = attr;
			iParm[1] = size;
			iParm[2] = 0;
			iParm[3] = 0;
			if (nparm > 0) {
				if (!(rc=cl_get_def_attr_check(nparm,ppParm,iParm,0x01))) {
					*pInfoParmW = *pm;
					pInfoParmW->pi_aux[0] = iParm[0];
					pInfoParmW->pi_len    = iParm[1];
					pInfoParmW->pi_hlen   = iParm[2];	/* precision */
					pInfoParmW->pi_pos    = iParm[3];	/* scale */
#if 1	/* add 2021.11.4 */
					if (attr==DEF_ZOK_BINA && (sc->attr & DEF_ZOK_USMASK))
						pInfoParmW->pi_scale |= D_DATA_UNSIGNED;
#endif
				}
			}
		}
	}
	else {
		ERROROUT2(FORMAT(480),"cl_gx_mk_cast",strmem(p,len));
		rc = ECL_NOT_CAST_NAME;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_conv(pInfoParmW,ope,pOperator,nparm,ppParm)
tdtINFO_PARM *pInfoParmW;
int ope;
char *pOperator;
int nparm;
tdtINFO_PARM *ppParm[];
{
	int rc;
	tdtINFO_PARM tInfoParm1,*pInfoParm1,tInfoParm;

	cl_set_parm_char(&tInfoParm,pOperator,strlen(pOperator));
	if (nparm >= 2) {
		pInfoParm1 = &tInfoParm1;
		rc = cl_gx_mk_cast(pInfoParm1,&tInfoParm,nparm-1,&ppParm[1]);
/*
printf("cl_func_conv: nparm=%d attr=%d\n",nparm,pInfoParm1->pi_attr);
*/
	/*
		if (pInfoParm1->pi_attr == DEF_ZOK_DATE) {
			return cl_func_to_date(pInfoParmW,nparm,ppParm);
		}
	*/
	}
	else {
		pInfoParm1 = &tInfoParm;
		pInfoParm1->pi_aux[0] = FUNCCAST;
		rc = 0;
	}
	if (!rc) rc = cl_gx_cast(pInfoParmW,pInfoParm1,ppParm[0]);
	return rc;
}
