// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
// Jone Bontus
//
// Description:
// This file is part of drtaeabi.dll.
//

#include "../symaehabi/unwind_env.h"
#include <unwind.h>
#include "../symaehabi/symbian_support.h"
#include <e32def_private.h>
#include <e32rom.h>
#include <e32svr.h>

extern "C" {

TRomExceptionSearchTable * GetROMExceptionSearchTable(void);
TExceptionDescriptor* SearchEST(uint32_t addr, TRomExceptionSearchTable* aESTp);
TExceptionDescriptor * GetRAMLoadedExceptionDescriptor(uint32_t addr);

_Unwind_Ptr __gnu_Unwind_Find_exidx (_Unwind_Ptr return_address, int *nrec)
{
	/* Check to see if address is in range covered by ROM EST. If
	   it is find the exception descriptor for the address,
	   checking that the address is in the range covered by the
	   descriptor.	Otherwise it comes from a RAM loaded
	   executable so get the kernel to find the exception
	   descriptor for us.
	*/
	TRomExceptionSearchTable * aESTp = GetROMExceptionSearchTable();
	TExceptionDescriptor * aEDp = NULL;
	if (aESTp && return_address >= aESTp->iEntries[0] && return_address < GET_EST_FENCEPOST(aESTp))
	{
		aEDp = SearchEST(return_address, aESTp);
		goto jobdone;
	}
	aEDp = GetRAMLoadedExceptionDescriptor(return_address);
	if (!aEDp)
	{
		// look in extension ROM if there is one
		TUint main_start = UserSvr::RomHeaderAddress();
		TUint main_end = main_start + ((TRomHeader*)main_start)->iUncompressedSize;

		TUint rda = UserSvr::RomRootDirectoryAddress();

		// Assume rom starts on multiple of 4k
		if (rda > main_end)
		{
			// ASSUMPTIONS HERE
			// 1. root directory is past the end of the main ROM so there must be an extension ROM
			// 2. the ROM file system in the extension ROM is at the beginning of the ROM (similar to the
			//	  main ROM)
			// 3. the extension ROM is mapped starting at a megabyte boundary
			// Thus the address of the extension ROM header may be obtained by rounding the root directory
			// address down to the next megabyte boundary.

			TUint ext_start = rda &~ 0x000fffffu;
			TRomExceptionSearchTable* extrom_exctab = (TRomExceptionSearchTable*)(((TExtensionRomHeader*)ext_start)->iRomExceptionSearchTable);
			if (extrom_exctab && return_address >= extrom_exctab->iEntries[0] && return_address < GET_EST_FENCEPOST(extrom_exctab))
				aEDp = SearchEST(return_address, extrom_exctab);
		}
	}

jobdone:
	SYMBIAN_EH_SUPPORT_PRINTF("__gnu_Unwind_Find_exidx: Exception descriptor for address 0x%08x = 0x%08x\n", return_address, aEDp);

	if (aEDp && ADDRESS_IN_EXCEPTION_DESCRIPTOR_RANGE(return_address, aEDp))
	{
		*nrec = (const __EIT_entry *)(aEDp->iExIdxLimit) - (const __EIT_entry *)(aEDp->iExIdxBase);
		return aEDp->iExIdxBase;
	}
	else
	{
		SYMBIAN_EH_SUPPORT_PRINTF("EH ERROR: no exception descriptor for address 0x%08x\n", return_address);
		abort();
		return 0;
	}
}

} // extern "C"
