// Copyright (C) 2021 Jone Bontus
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// ``Software''), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT.	 IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#include <bits/c++config.h>
#include <bits/exception.h>
#if __cplusplus >= 201103L
#include <bits/hash_bytes.h>
#endif

namespace __cxxabiv1
{
  class __class_type_info;
} // namespace __cxxabiv1

namespace std
{
  /**
   *  @brief  Part of RTTI.
   *
   *  The @c type_info class describes type information generated by
   *  an implementation.
  */
  class type_info
  {
  public:
	/** Destructor first. Being the first non-inline virtual function, this
	 *	controls in which translation unit the vtable is emitted. The
	 *	compiler makes use of that information to know where to emit
	 *	the runtime-mandated type_info structures in the new-abi.  */
	virtual ~type_info();

	/** Returns an @e implementation-defined byte string; this is not
	 *	portable between compilers!	 */
	const char* name() const _GLIBCXX_NOEXCEPT;

#if !__GXX_TYPEINFO_EQUALITY_INLINE
	// In old abi, or when weak symbols are not supported, there can
	// be multiple instances of a type_info object for one
	// type. Uniqueness must use the _name value, not object address.
	bool before(const type_info& __arg) const _GLIBCXX_NOEXCEPT;
	bool operator==(const type_info& __arg) const _GLIBCXX_NOEXCEPT;
#else
  #if !__GXX_MERGED_TYPEINFO_NAMES
	/** Returns true if @c *this precedes @c __arg in the implementation's
	 *	collation order.  */
	// Even with the new abi, on systems that support dlopen
	// we can run into cases where type_info names aren't merged,
	// so we still need to do string comparison.
	bool before(const type_info& __arg) const _GLIBCXX_NOEXCEPT
	{ return (__name[0] == '*' && __arg.__name[0] == '*')
	? __name < __arg.__name
	: __builtin_strcmp (__name, __arg.__name) < 0; }

	bool operator==(const type_info& __arg) const _GLIBCXX_NOEXCEPT
	{
	  return ((__name == __arg.__name)
		  || (__name[0] != '*' &&
		  __builtin_strcmp (__name, __arg.__name) == 0));
	}
  #else
	// On some targets we can rely on type_info's NTBS being unique,
	// and therefore address comparisons are sufficient.
	bool before(const type_info& __arg) const _GLIBCXX_NOEXCEPT
	{ return __name < __arg.__name; }

	bool operator==(const type_info& __arg) const _GLIBCXX_NOEXCEPT
	{ return __name == __arg.__name; }
  #endif
#endif

#if __cpp_impl_three_way_comparison < 201907L
	bool operator!=(const type_info& __arg) const _GLIBCXX_NOEXCEPT;
#endif

#if __cplusplus >= 201103L
	size_t hash_code() const noexcept
	{
#  if !__GXX_MERGED_TYPEINFO_NAMES
	  return _Hash_bytes(name(), __builtin_strlen(name()),
			 static_cast<size_t>(0xc70f6907UL));
#  else
	  return reinterpret_cast<size_t>(__name);
#  endif
	}
#endif // C++11

	// Return true if this is a pointer type of some kind
	virtual bool __is_pointer_p() const;

	// Return true if this is a function type
	virtual bool __is_function_p() const;

	// Try and catch a thrown type. Store an adjusted pointer to the
	// caught type in THR_OBJ. If THR_TYPE is not a pointer type, then
	// THR_OBJ points to the thrown object. If THR_TYPE is a pointer
	// type, then THR_OBJ is the pointer itself. OUTER indicates the
	// number of outer pointers, and whether they were const
	// qualified.
	virtual bool __do_catch(const type_info *__thr_type, void **__thr_obj,
				unsigned __outer) const;

	// Internally used during catch matching
	virtual bool __do_upcast(const __cxxabiv1::__class_type_info *__target,
				 void **__obj_ptr) const;

  protected:
	const char *__name;

	explicit type_info(const char *__n): __name(__n) { }

  private:
	/// Assigning type_info is not supported.
	type_info& operator=(const type_info&);
	type_info(const type_info&);
  };

  /**
   *  @brief  Thrown during incorrect typecasting.
   *  @ingroup exceptions
   *
   *  If you attempt an invalid @c dynamic_cast expression, an instance of
   *  this class (or something derived from this class) is thrown.	*/
  class bad_cast : public exception
  {
  public:
	bad_cast(const bad_cast& __x) _GLIBCXX_USE_NOEXCEPT;
	bad_cast() _GLIBCXX_USE_NOEXCEPT;
	bad_cast& operator=(const bad_cast& __x) _GLIBCXX_USE_NOEXCEPT;

	// This declaration is not useless:
	// http://gcc.gnu.org/onlinedocs/gcc-3.0.2/gcc_6.html#SEC118
	virtual ~bad_cast() _GLIBCXX_USE_NOEXCEPT;

	// See comment in eh_exception.cc.
	virtual const char* what() const _GLIBCXX_USE_NOEXCEPT;
  };

  /**
   *  @brief Thrown when a NULL pointer in a @c typeid expression is used.
   *  @ingroup exceptions
   */
  class bad_typeid : public exception
  {
  public:
	bad_typeid(const bad_typeid& __x) _GLIBCXX_USE_NOEXCEPT;
	bad_typeid() _GLIBCXX_USE_NOEXCEPT;
	bad_typeid& operator=(const bad_typeid& __x) _GLIBCXX_USE_NOEXCEPT;

	// This declaration is not useless:
	// http://gcc.gnu.org/onlinedocs/gcc-3.0.2/gcc_6.html#SEC118
	virtual ~bad_typeid() _GLIBCXX_USE_NOEXCEPT;

	// See comment in eh_exception.cc.
	virtual const char* what() const _GLIBCXX_USE_NOEXCEPT;
  };
} // namespace std

EXPORT_C const char* std::type_info::name() const _GLIBCXX_NOEXCEPT
{
	return __name[0] == '*' ? __name + 1 : __name;
}

EXPORT_C bool std::type_info::operator!=(const std::type_info& __arg) const _GLIBCXX_NOEXCEPT
{
	return !operator==(__arg);
}

EXPORT_C std::bad_typeid::bad_typeid(const std::bad_typeid& __x) _GLIBCXX_USE_NOEXCEPT { }

EXPORT_C std::bad_typeid::bad_typeid() _GLIBCXX_USE_NOEXCEPT { }

EXPORT_C std::bad_typeid& std::bad_typeid::operator=(const std::bad_typeid& __x) _GLIBCXX_USE_NOEXCEPT
{
	return *this;
}

EXPORT_C std::bad_cast::bad_cast(const std::bad_cast& __x) _GLIBCXX_USE_NOEXCEPT { }

EXPORT_C std::bad_cast::bad_cast() _GLIBCXX_USE_NOEXCEPT { }

EXPORT_C std::bad_cast& std::bad_cast::operator=(const std::bad_cast& __x) _GLIBCXX_USE_NOEXCEPT
{
	return *this;
}
