package jp.nanah.bastub.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import jp.nanah.bastub.util.BastubUtils;

public class BastubHttpRequest extends HttpServletRequestWrapper{

	private String uri = null;

	private StringBuffer url = null;

	/**
	 * Viewに遷移するためのHTTPリクエストクラス。
	 * 固定ファイルがあるときは、
	 * SpringFrameworkのControllerに、情報を
	 * @param req
	 */
	public BastubHttpRequest(HttpServletRequest req){
		super(req);
	}

	@Override
	public String getRequestURI(){
		return (uri == null) ? super.getRequestURI() : uri;
	}

	@Override
	public StringBuffer getRequestURL(){
		return (url == null) ? super.getRequestURL() : url;
	}

	public void setUrl(String path){
		url = new StringBuffer(path);
		uri = BastubUtils.getUriPath(path);
	}

}
