package jp.nanah.bastub.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.fasterxml.jackson.databind.ObjectMapper;

import jp.nanah.bastub.BastubConsts;
import jp.nanah.bastub.data.AppInfo;
import jp.nanah.bastub.service.JsonService;
import jp.nanah.bastub.service.PathService;
import jp.nanah.bastub.util.BastubUtils;

/**
 *
 * @author kemono
 *
 */
@Controller
public class AnyViewController {

	/** 動作ログ */
	private static final Logger logger = LoggerFactory.getLogger(AnyViewController.class);
	/** リクエストのみ */
	private static final Logger reqlog = LoggerFactory.getLogger("REQLOG");

	@Autowired
	private AppInfo appService = new AppInfo();

	@Autowired
	private JsonService jsonService;

	@Autowired
	private PathService pathService;


	//*********************************
	// 主処理
	//*********************************

	@RequestMapping(value = {"/**/*.$view"})
	public String path1(@RequestBody(required=false) ModelMap body, ModelMap model, HttpServletRequest req, HttpServletResponse res) throws IOException {
		return path_common(body, model, req, res);
	}

	@RequestMapping(path= "/**", consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
	public String path1_multipart( @RequestParam(required=false) Map<String, String> paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
		return path_common(paramMap, model, req, res);
	}

	//=================================
	// 共通処理
	//=================================

	public String path_common(Map paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res){
		appService.setCurrentThreadName();

		//リクエストを出力
		String method = req.getMethod();
		String reqPath = req.getRequestURL().toString();
		String queryStr = (req.getQueryString() == null) ? "" : req.getQueryString();
		Object bodyData = (paramMap == null) ? "" : paramMap;
		reqlog.info("[{}] {}, query={} body={}", method, reqPath, queryStr, bodyData);

		//同名フォルダ配下のjsonファイルを見つける
		File pageDir = pathService.getPageDir();
		List<String> pathList = new ArrayList<String>(pathService.getPathList(req));
		int lastIdx = pathList.size() - 1;

		// Viewに遷移するためにつけた拡張子を取り除く(元に戻す)
		String lastPath = pathList.get(lastIdx);
		pathList.set(lastIdx, BastubUtils.removeExtText(lastPath, BastubConsts.VIEW_TRANS_EXT));
		pathList.add("");
		lastIdx++;

		//遷移先のView名を取得する
		String viewName = getViewName(req);

		//
		//logger.debug("pageDir=[{}] Viewに遷移:[{}]", pageDir.getAbsolutePath(), viewName);
		File file = new File(pageDir, viewName);
		if (file.isDirectory()){
			File[] subDirFiles = file.listFiles();
			for (File f : subDirFiles){
				//logger.info("subdir=[{}", f.getAbsolutePath());
				String ext = BastubUtils.getExtText(f.getAbsolutePath());
				if (ext.equals(".json")){
					pathList.set(lastIdx, BastubUtils.removeExtText(f.getName(), ".json"));
					String jsonText = jsonService.getAny(pathList, paramMap, model, req, res);
					try {
						String modelKey = BastubUtils.removeExtText(f.getName(), null);
						if (jsonText.trim().startsWith("[") && jsonText.endsWith("]")){
							List<Object> response = new ObjectMapper().readValue(jsonText, ArrayList.class);
							model.addAttribute(modelKey, response);
						} else {
							Map<String, Object> response = new ObjectMapper().readValue(jsonText, HashMap.class);
							model.addAttribute(modelKey, response);
						}
					} catch (Exception e){
						logger.error("変換異常", e);
					}
				}
			}

		}

		logger.info("== △ ==");
		return viewName;
	}

	/**
	 * リクエストから、本来のView名
	 * @param req
	 * @return
	 */
	private String getViewName(HttpServletRequest req){
		String path = req.getRequestURI();
		int n = path.lastIndexOf(BastubConsts.VIEW_TRANS_EXT);
		String viewName = path.substring(0, n);
		return viewName;
	}


}
