package jp.nanah.bastub.controller;

import static org.springframework.web.bind.annotation.RequestMethod.*;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jp.nanah.bastub.data.AppInfo;
import jp.nanah.bastub.service.JsonService;
import jp.nanah.bastub.service.PathService;

@RestController
public class AnyRestController {
	/** 動作ログ */
	private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
	/** リクエストのみ */
	private static final Logger reqlog = LoggerFactory.getLogger("REQLOG");

	@Autowired
	private AppInfo appService;

	@Autowired
	private JsonService jsonService;

	@Autowired
	private PathService pathService;


	//*********************************
	// 主処理
	//*********************************

	/**
	 * HTTPリクエストを受け取って、JSONを返す。
	 * HTTPのメソッドは、GET/POST/DELETE/PUTのみ対応。(これ以外は使わないと思うので)
	 *
	 * @param body
	 * @param model
	 * @param req
	 * @param res
	 * @return
	 */
	@RequestMapping(path="/**", method={GET, POST, PUT, DELETE})
	public String path1(@RequestBody(required=false) ModelMap body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
		return path_common(body, model, req, res);
	}

	/**
	 * Context-typeが"multipart/form-data"のときはSpringがBody部分をModelMapに変換できないので@RequestParamで受け取らないとダメ。
	 *
	 * @param p1～p10
	 * @param paramMap
	 * @param model
	 * @param req
	 * @param res
	 * @return
	 */
	@RequestMapping(path= "/**", method={GET, POST, PUT, DELETE}
					, consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
	public String path1_multipart( @RequestParam(required=false) Map<String, String> paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
		return path_common(paramMap, model, req, res);
	}

	//=================================
	// 共通処理
	//=================================

	/**
	 * リクエストの共通処理。
	 */
	private String path_common(Map paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res){
		appService.setCurrentThreadName();

		//リクエストを出力
		String method = req.getMethod();
		String reqPath = req.getRequestURL().toString();
		String queryStr = (req.getQueryString() == null) ? "" : req.getQueryString();
		Object bodyData = (paramMap == null) ? "" : paramMap;
		reqlog.info("[{}] {} query={} body={}", method, reqPath, queryStr, bodyData);

		logger.info("== ▼ == [{}] {}", method, reqPath);
		res.setContentType("application/json;charset=UTF-8");

		List<String> pathList = pathService.getPathList(req);
		String jsonText = jsonService.getAny(pathList, paramMap, model, req, res);

		logger.info("== △ ==");

		return jsonText;
	}

}
