package jp.nanah.bastub.config;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

import jp.nanah.bastub.service.PathService;

@Configuration
@Import(ThymeleafAutoConfiguration.class)
public class BastubWebConfig {

	protected static final Logger logger = LoggerFactory.getLogger(BastubLinkBuilder.class);

	@Value("${pagedata.root:pagedata}")
	private String pagedataPath;

	@Autowired
    private SpringTemplateEngine templateEngine;

	@Autowired
    private BastubLinkBuilder bastubLinkBuilder;

    @Bean
    public SpringTemplateEngine customTemplateEngine() {
        this.templateEngine.setLinkBuilder(this.bastubLinkBuilder);

        Set<ITemplateResolver> resolvers = templateEngine.getTemplateResolvers();
        for (ITemplateResolver resol : resolvers){
        	if (resol instanceof SpringResourceTemplateResolver){
        		try {
            		SpringResourceTemplateResolver srtr = (SpringResourceTemplateResolver)resol;
        			srtr.setPrefix("file:" + PathService.pageDir.getAbsolutePath());
                	logger.info("Resource Path set to {}", srtr.getPrefix());
    		    } catch (Exception e){
        	    	logger.error("Bad Prefix Path", e);
        	    }
        	}
        }

        templateEngine.setLinkBuilder(bastubLinkBuilder);
        return this.templateEngine;
    }
}

