/*
 [df:title]
 プルダウン用ユーザID取得
 
 [df:description]
 重複しない作成者または更新者のユーザIDを取得する。
 値がnullのときはその値を含めて返す。
 作成者の場合は、pmb.setTarget("create")；
 更新者の場合は、pmb.setTarget("update")；
*/

-- #df:entity#

-- !df:pmb!
-- !!AutoDetect!!

select
	distinct 
/*BEGIN*/
	/*IF pmb.target == 'create'*/
	create_user_id, B.disp_no
	/*END*/
	/*IF pmb.target == 'update'*/
	, update_user_id, C.disp_no
	/*END*/
/*END*/
from
	t_distribution_template A
	/*IF pmb.target == 'create'*/
	left join m_user_dispinfo as B 
		on A.group_id = B.group_id AND A.create_user_id = B.user_id
	/*END*/
	/*IF pmb.target == 'update'*/
	left join m_user_dispinfo as C 
		on A.group_id = C.group_id AND A.update_user_id = C.user_id
	/*END*/
/*BEGIN*/
where
	/*IF pmb.groupId != null*/
	A.group_id = /*pmb.groupId*/'GRP00000000001'
	/*END*/
/*END*/
/*BEGIN*/
order by 
	/*IF pmb.target == 'create'*/
	B.disp_no, create_user_id
	/*END*/
	/*IF pmb.target == 'update'*/
	,C.disp_no, update_user_id
	/*END*/
/*END*/
;
