/*
 [df:title]
 配信メッセージ一覧取得
 
 [df:description]
 配信済みと未配信のメッセージをまとめて取得する。
 メッセージ配信から送信したメッセージは、t_distribution_messageから取得。
 直接メッセンジャーに送られたメッセージは、message/message_destinationから取得。
*/


-- #df:entity#

-- !df:pmb extends Paging!
-- !!AutoDetect!!

/*IF pmb.isPaging()*/
select 
	---基本情報
	distribution_id,
	distribution_no,
	message_kind,
	message_title,
	message_body,
	user_id,
	disp_no,
	post_at,
	service_id::varchar,
	message_id,
	reply1,
	reply2,
	reply3,
	reply4,
	reply5,
	coalesce(send_sts,10) as send_sts,
	---集約情報
	summary_send,
	summary_read,
	summary_reply,
	summary_error,
	summary_wait,
	summary_count,
	reply1_count,
	reply2_count,
	reply3_count,
	reply4_count,
	reply5_count
-- ELSE select count(*)
/*END*/
from (
select 
	---基本情報
	X.distribution_id ,
	(select max(distribution_no) from t_distribution_message where group_id = X.group_id and distribution_id = X.distribution_id) as distribution_no,
	X.message_kind,
	X.message_title,
	X.message_body,
	X.distribution_user_id as user_id,
	Y.disp_no,
	(
		select max(coalesce(A1.send_end_at, A1.plan_at)) 
		from t_distribution_message A1
		where A1.group_id = X.group_id 
		and A1.distribution_id = X.distribution_id
	) as post_at,  --配信済み時刻(未配信の場合は予定時刻）の最大値
	'SVC000000000012' as service_id,
	Z.message_id,
	X.reply1,
	X.reply2,
	X.reply3,
	X.reply4,
	X.reply5,
	coalesce(
	( select min(A.post_status) 
 	  from message_destination A
	  where message_id = Z.message_id
	), X.send_sts) as send_sts,
	---集約情報
	(select count(distinct A1.user_id) 
		from t_distribution_user A1
		where A1.group_id = X.group_id
		and A1.distribution_id = X.distribution_id
	) as summary_send, --送信数
	(select count(distinct A1.user_id) 
		from message_destination A1
			inner join t_distribution_message A2 
			on A2.group_id = X.group_id
			and A2.distribution_id = X.distribution_id
			and A2.message_id = A1.message_id
		where A1.is_read = true
	) as summary_read, --既読数
	(select count(distinct A1.user_id) 
		from message_destination A1
			inner join t_distribution_message A2 
			on A2.group_id = X.group_id
			and A2.distribution_id = X.distribution_id
			and A2.message_id = A1.message_id
		where A1.reply_status <> 0
	) as summary_reply,	 --返信数
	(select count(distinct A1.user_id) 
		from message_destination A1
			inner join t_distribution_message A2 
			on A2.group_id = X.group_id
			and A2.distribution_id = X.distribution_id
			and A2.distribution_no = (
				select max(distribution_no)
				from t_distribution_user A3
				where A3.group_id = A2.group_id
				and A3.distribution_id = A2.distribution_id
				and A3.user_id = A1.user_id
			)
			and A2.message_id = A1.message_id
		where A1.post_status = 11
	) as summary_error,	--送信エラー数 (最終送信のみカウントする）
	(select count(*) 
	 from t_wait_message A1 
		where A1.group_id = X.group_id
		  and A1.distribution_id = X.distribution_id
	) as summary_wait,	 --送信待ち
	(select count(*) 
	 from t_distribution_message A1 
		where A1.group_id = X.group_id
		  and A1.distribution_id = X.distribution_id
	) as summary_count,	 --送信宛先数
	-----各返答個数
	(select count(*) from message_reply_view A1 where A1.group_id = X.group_id and A1.distribution_id = X.distribution_id and A1.choice_no = 1) as reply1_count, --返答１個数
	(select count(*) from message_reply_view A1 where A1.group_id = X.group_id and A1.distribution_id = X.distribution_id and A1.choice_no = 2) as reply2_count, --返答２個数
	(select count(*) from message_reply_view A1 where A1.group_id = X.group_id and A1.distribution_id = X.distribution_id and A1.choice_no = 3) as reply3_count, --返答３個数
	(select count(*) from message_reply_view A1 where A1.group_id = X.group_id and A1.distribution_id = X.distribution_id and A1.choice_no = 4) as reply4_count, --返答４個数
	(select count(*) from message_reply_view A1 where A1.group_id = X.group_id and A1.distribution_id = X.distribution_id and A1.choice_no = 5) as reply5_count	 --返答５個数
from 
	t_distribution_message X
	left join m_user_dispinfo Y
		on X.group_id = Y.group_id and
			X.distribution_user_id = Y.user_id
	left join t_distribution_message Z
		on X.group_id = Z.group_id and
			X.distribution_id = Z.distribution_id and
			Z.distribution_no = (select max(distribution_no) from t_distribution_message 
			where group_id = X.group_id and
			distribution_id = X.distribution_id)
where 
	X.group_id = /*pmb.groupId*/'GRP000000000001'
	and X.distribution_no = 1
/*BEGIN*/
	and exists (
		select A.distribution_id
			from t_distribution_message A
			/*BEGIN*/
			where 
				/*IF '1' == '1'*/
				---以降のandを残すようにするためのIF文
				A.group_id = X.group_id and
				A.distribution_id = X.distribution_id
				/*END*/
				/*IF pmb.ymdStart != null*/
				and (
					A.send_end_at >= /*pmb.ymdStart*/'2018-04-01'
					or (
						A.send_sts = 0 and
						A.plan_at >= /*pmb.ymdStart*/'2018-04-01'
					)
				)
				/*END*/
				/*IF pmb.ymdEnd != null*/
				and (
					A.send_end_at < /*pmb.ymdEnd*/'2018-06-21'
					or (
						A.send_sts = 0 and
						A.plan_at < /*pmb.ymdEnd*/'2018-06-21'
					)
					)
				/*END*/
				/*IF pmb.userId != null*/
				and A.distribution_user_id = /*pmb.userId*/'USR000000000001'
				/*END*/
				/*END*/
				)
/*END*/
	/*IF pmb.serviceId != null*/
	and 'SVC000000000012' = /*pmb.serviceId*/'SVC000000000012' 
	/*END*/
	/*IF pmb.messageKind != null*/
	and X.message_kind = /*pmb.messageKind*/'確認'
	/*END*/
	/*IF pmb.patientUserId != null*/
	and exists (
		select B.distribution_id
			from t_distribution_user B
			where X.group_id = B.group_id and
				X.distribution_id = B.distribution_id and
				B.user_id = /*pmb.patientUserId*/'USR000000500003'
	)
	/*END*/

union all
select 
	---基本情報
	'' as distribution_id,
	0 as distribution_no,
	'' as message_kind,
	A.title as message_title,
	A.body as message_body,
	'' as user_id,
	null as disp_no,
	A.post_at,
	A.child_service_id as service_id,
	A.message_id,
	(select reply_comment from message_choice where message_id = A.message_id and choice_no = 1) as reply1,
	(select reply_comment from message_choice where message_id = A.message_id and choice_no = 2) as reply2,
	(select reply_comment from message_choice where message_id = A.message_id and choice_no = 3) as reply3,
	(select reply_comment from message_choice where message_id = A.message_id and choice_no = 4) as reply4,
	(select reply_comment from message_choice where message_id = A.message_id and choice_no = 5) as reply5,
	(select max(post_status) from message_destination A1 where A1.message_id = A.message_id) as send_sts,
	---集約情報
	(select count(distinct A1.user_id) from message_destination A1 where A1.message_id = A.message_id) as summary_send, --送信数(=1)
	(select count(distinct A1.user_id) from message_destination A1 where A1.message_id = A.message_id and is_read = true) as summary_read, --既読数
	(select count(distinct A1.user_id) from message_destination A1 where A1.message_id = A.message_id and A1.reply_status <> 0) as summary_reply, --返信数
	(select count(distinct A1.user_id) from message_destination A1 where A1.message_id = A.message_id and A1.post_status = 11) as summary_error, --エラー数
	(select count(*) from message_destination A1 where A1.message_id = A.message_id and A1.post_status <10) as summary_wait, --送信待ち
	(select count(*) from message_destination A1 where A1.message_id = A.message_id ) as summary_count, --送信宛先数
	(select count(*) from message_destination A1 where A1.message_id = A.message_id and A1.choice_no = 1) as reply1_count, --返信１個数
	(select count(*) from message_destination A1 where A1.message_id = A.message_id and A1.choice_no = 2) as reply2_count, --返信２個数
	(select count(*) from message_destination A1 where A1.message_id = A.message_id and A1.choice_no = 3) as reply3_count, --返信３個数
	(select count(*) from message_destination A1 where A1.message_id = A.message_id and A1.choice_no = 4) as reply4_count, --返信４個数
	(select count(*) from message_destination A1 where A1.message_id = A.message_id and A1.choice_no = 5) as reply5_count --返信５個数
from message A
where 
	A.child_service_id <> 'SVC000000000012'
	and A.notebook_id = /*pmb.groupId*/'GRP000000000001'
	/*IF pmb.userId != null*/
	and (1 = 0)	 --- 必ず失敗する
	/*END*/
	/*IF pmb.messageKind != null*/
	and (1 = 0)	 --- 必ず失敗する
	/*END*/
	/*IF pmb.ymdStart != null*/
	and A.post_at >= /*pmb.ymdStart*/'2018-04-01'
	/*END*/
	/*IF pmb.ymdEnd != null*/
	and A.post_at < /*pmb.ymdEnd*/'2018-06-21'
	/*END*/
	/*IF pmb.serviceId != null*/
	and A.child_service_id = /*pmb.serviceId*/'SVC000000000028'
	-- ELSE and A.child_service_id = 'SVC000000000028'
	/*END*/
	/*IF pmb.patientUserId != null*/
	and exists (
		select * from message_destination B
		where A.message_id = B.message_id
		and B.user_id = /*pmb.patientUserId*/'USR000000500003'
	)
	/*END*/
	--- メッセージ配信で管理していないもののみ抽出
	and not exists (
		select * from t_distribution_message B
		where A.message_id = B.message_id
	)
/*END*/
) as F
/*IF pmb.isPaging()*/
/*IF pmb.orderByText != null*/
order by 
	/*$pmb.orderByText*/F.distribution_id
/*END*/
/*END*/
