//文字コード：UTF-8

//検索条件を取得する
var saveCond;
function getConditionJson(sortcol, selections){

	// 検索条件
    var condition = saveCond;
	if (sortcol == "") {
		if (isConditionValid("#jk_departmentCode")){
		    condition = {
		   		"select_kind": 1,
		   		"department_code": $("#jk_departmentCode").val(),
		   		"ymd_start": $("#jk_exam_ymdStart").val(),
		   		"ymd_end": $("#jk_exam_ymdEnd").val(),
		   		"sex_type": $("#jk_sexType").val(),
		   		"age_start": $("#jk_ageStart").val(),
		   		"age_end": $("#jk_ageEnd").val(),
		   		"patient_id": $("#jk_patientId").val()
		   	};
		} else if (isConditionValid("#jk_reserveGroup")){
		    condition = {
		   		"select_kind": 2,
		   		"reservation_group_code": $("#jk_reserveGroup").val(),
		   		"reservation_space_code": $("#jk_reserveSpace").val(),
		   		"ymd_start": $("#jk_reserve_ymdStart").val(),
		   		"ymd_end": $("#jk_reserve_ymdEnd").val(),
		   		"sex_type": $("#jk_sexType").val(),
		   		"age_start": $("#jk_ageStart").val(),
		   		"age_end": $("#jk_ageEnd").val(),
		   		"patient_id": $("#jk_patientId").val()
		   	};
		} else {
		    condition = {
		   		"select_kind": 3,
		   		"sex_type": $("#jk_sexType").val(),
		   		"age_start": $("#jk_ageStart").val(),
		   		"age_end": $("#jk_ageEnd").val(),
		   		"patient_id": $("#jk_patientId").val()
		   	};
		}
		saveCond = condition;
	}

	//ソート条件を取得する
	var sort_param = getSortParams(".lmc_th_table table", sortcol);

	//JSON作成
   	var jsonData = {
   		"condition": condition,
   		"sort_params": sort_param,
   		"patients": selections
   	};

	return jsonData;
}

//検索結果入れ替え。
//先頭にある１行目をコピーして作成することでスタイル設定を省略。
//(in) tbody     : tbody要素
//(in) list_data : JSONの患者情報部分
function replacePatientList(tbody, list_data){
	var copy_base = $("tr", tbody).eq(0);  //非表示の先頭行
	for(var i=0; i<list_data.length; i++){
		var rowdata = list_data[i];
		var new_row = copy_base.clone();
		var tds = $("td", new_row);
		var sexcode = rowdata["patient_sex"];

		$("input", tds.eq(0)).prop("checked", rowdata["selected"]);
		tds.eq(1).text(rowdata["patient_id"]);
		tds.eq(2).text(rowdata["patient_name"]);
		tds.eq(3).text(sexcode == "1" ? "男" : "女");
		tds.eq(4).text(rowdata["patient_birthday"]);
		tds.eq(5).text(rowdata["patient_age"]);

		new_row.css("display","");
		tbody.append(new_row);
	}
}

function toggleCheck(imgelm, condNo){
	var isChecked = !isCheckOn(imgelm);
	var new_ext = isChecked ? "A.png" : "B.png";
	replacePathExt(imgelm, new_ext);

	//最後に選んだ方を有効にする
	if (isChecked){
		updateConditionColor(0);
	} else {
		updateConditionColor(condNo);
	}
}
function updateConditionColor(condNo){
	var forecolor = (condNo == 1) ? '#333333' : '#E8E8E8';
	var textcolor = (condNo == 1) ? '#6D6D6D' : '#E8E8E8';
	$("#jk_department span").css('color', forecolor);
	$("#jk_department select").css('color', forecolor);
	$("#jk_department input").css('color', textcolor);

	var forecolor = (condNo == 2) ? '#333333' : '#E8E8E8';
	var textcolor = (condNo == 2) ? '#6D6D6D' : '#E8E8E8';
	$("#jk_reserve span").css('color', forecolor);
	$("#jk_reserve select").css('color', forecolor);
	$("#jk_reserve input").css('color', textcolor);
}

//条件が有効か否か。
function isConditionValid(id){
	var VALID_COLOR = "rgb(51, 51, 51)";	//=#333333
	var elem = $(id);
	var textcolor = $(id).css('color');
	return (textcolor == VALID_COLOR);
}
function updateCondition(condition){
	if (isConditionValid("#jk_departmentCode")){
		setValueIfNotSame(saveCond, condition, 'ymd_start' , "#jk_exam_ymdStart");
		setValueIfNotSame(saveCond, condition, 'ymd_end' , "#jk_exam_ymdEnd");
	} else if (isConditionValid("#jk_reserveGroup")){
		setValueIfNotSame(saveCond, condition, 'ymd_start' , "#jk_reserve_ymdStart");
		setValueIfNotSame(saveCond, condition, 'ymd_end' , "#jk_reserve_ymdEnd");
	}
	setValueIfNotSame(saveCond, condition, 'patient_id' , "#jk_patientId");
	saveCond = condition;
}

//■ 過去に選択済の情報に今回選択状態を追加する
function mergeSelection(patients){
	//現状の画面の選択対象を取得
	var tbody = $("#patient_list");
	var input_all = $("input", tbody);
    
	//今回の選択情報を１つずつ追加
	input_all.each(function(i, elem) {
		if (i==0){
			//１行目は捨てる
			return true;
		}
		var pid = keep_patients[i-1]["patient_id"];
		var n = indexOfKey(patients, "patient_id", pid);
		
		var pat;
		if (n < 0){
			pat = {"patient_id": pid};
			patients.push(pat);
		} else {
			pat = patients[n];
		}
		pat["selected"] = $(elem).prop("checked");
	});
	return patients;
}
//■ 画面遷移前の選択状態から追加になっているか
function isSelectedChanged(patients){
	//現状の画面の選択対象を取得
	var tbody = $("#patient_list");
	var input_all = $("input", tbody);
    var isChanged = false;

	//今回の選択情報を１つずつ追加
	input_all.each(function(i, elem) {
		if (i==0){
			//１行目は捨てる
			return true;
		}
		var nowCheck = $(elem).prop("checked");
		var oldCheck = patients[i-1]["selected"];
		if (nowCheck != oldCheck){
			isChanged = true;
			return false;
		}
	});
	return isChanged;
}


