//文字コード：UTF-8

//検索条件を取得する
var saveCond;
function getConditionJson(pagemv, sortcol){

	// 検索条件
	var condition = saveCond;
	if (pagemv == 0 && sortcol == "") {
		condition = {
			"ymd_start": $("#jk_ymdStart").val(),
			"ymd_end": $("#jk_ymdEnd").val(),
			"kidoku_status": $("#jk_kidokuStatus").val(),
			"patient_name": $("#jk_patientName").val(),
			"reply_value": $("#jk_replyValue").val(),
			"resend_count_start": $("#jk_resendCountStart").val(),
			"resend_count_end": $("#jk_resendCountEnd").val(),
			"distribution_id": $("#distributionId").text(),
			"message_id": $("#messageId").text()
		};
		saveCond = condition;
	}

	//ソート条件取得
	var sort_param = getSortParams(".lmc_th_table table", sortcol);

	//ページ情報取得
	var pno = parseInt($("#page_no").text()) + pagemv;
	pno = (pno < 1) ? 1 : pno;
	var page_info = {
		"page_no": pno,
		"rows_per_page": 20
	};

	//JSON作成
	var jsonData = {
		"condition": condition,
		"sort_params": sort_param,
		"page_info": page_info
	};

	return jsonData;
}

//再通知パラメータを取得する
function getResendJson(){
	var patients = [];
	for (var i=0; i<keep_selections.length; i++){
		var pid = keep_selections[i]["patient_id"];
		patients.push({"patient_id": pid});
	}

	//JSON作成
	var jsonData = {
		"distribution_id": $("#distributionId").text(),
		"time_specified": isCheckOn($("#timeSpecified")),
		"send_ymd": $("#planYmd").val(),
		"send_hm": $("#planHm").val(),
		"patients": patients
	};

	return jsonData;
}


//選択状態（保存用）
var keep_selections = [];

//■ 選択状態を一時保存する
function storeNowSelection(json_res){
	var now_selections = [];

	//現状の画面の選択対象を取得
	var tbody = $("#reply_list");
	var input_all = $("img", tbody);
    
	//今回値の選択情報を１つずつ追加
	//前回値はこの関数内で壊される。
	input_all.each(function(i, elem) {
		if (json_res.length <= i){
			return false;
		}

		//選択されていたら追加
		if (isCheckOn($(elem))){
		    //再通知回数も残したいので1行丸ごと取っておく
			now_selections.push(json_res[i]);
		}

		//画面表示されているものは前回値から除外
		var pid = json_res[i]["patient_id"];
		var n = indexOfKey(keep_selections, "patient_id", pid);
		if (n >= 0){
			keep_selections[n] = null;
		}
	});

	//画面に表示されていない前回値を追加
	for (var i=0; i<keep_selections.length; i++){
		if (keep_selections[i] != null){
			now_selections.push(keep_selections[i]);
		}
	}

	keep_selections = now_selections;
	
	return now_selections;
}

//選択状態を復元する
function restoreResendSelection(json_res){
	if (json_res == null){
		return;
	}
	for (var i=0; i<json_res.length; i++){
		var pid = json_res[i]["patient_id"];
		var n = indexOfKey(keep_selections, "patient_id", pid);
		var imgtail = (n >= 0) ? "A.png" : "B.png";
		json_res[i]["resend_check"] = imgtail;
		//患者IDがあるときだけ使用可にする
		var isBadData = (pid == null) || (pid.length == 0);
		$("#resend_check_" + i).prop('disabled', isBadData);
		$("#resend_check_" + i).css('cursor', isBadData ? 'auto' : '');
	}
}

//再通知選択の有無を取得する
function isResendSelect(){
	return (keep_selections.length > 0);
}
//再通知の宛先を初期化する（検索時）
function resetResendSelect(){
	keep_selections = [];
}

//選択行に返信済みの有無を判定する
function isReplyExists(){
	for (var i=0; i<keep_selections.length; i++){
		var reply = keep_selections[i]["reply_value"];
		if (reply.length > 0){
			return true;
		}
	}
	return false;
}


//ハイフンならクラス無し
//そうでないならresend_count（●背景）
function updateResendStyle(list_data, dispcnt){
	for (var i=0; i<dispcnt; i++){
		if (i >= list_data.length){
			continue;
		}

		var row_data = list_data[i];
		var rowval = row_data["resend_count"];
		var classname = (rowval == "-") ? "" : "resend_count";
		$("#resend_count_" + i).attr("class", classname);
	}
}

//送信待ち、配信エラーに合わせて背景色を更新
function updateRowBackground(list_data, dispcnt){
	for (var i=0; i<dispcnt; i++){
		if (i >= list_data.length){
			continue;
		}

		var row_data = list_data[i];
		var bgcolor = "transparent";
		if (row_data["send_wait"] == "1"){
			bgcolor = "#DBE7F4";	//aqua
		} else if (row_data["last_error"] == "1"){
			bgcolor = "#FFEEEE";	//salmon pink
		}
		$("#row" + i).css("background-color", bgcolor);
	}
}

function toggleCheck(imgelm){
	var org_path = imgelm.attr("src");
	var path_head = org_path.substring(0, org_path.length - 5);
	var new_tail = isCheckOn(imgelm) ? "B.png" : "A.png";
	imgelm.attr("src", path_head + new_tail);

	var idval = $(imgelm).prop("id");
	if (idval == "timeSpecified"){
		timeSpecifiedChanged(new_tail);
	}
}

//時刻指定のチェックボックス変更時
function timeSpecifiedChanged(new_tail){
	var isoff = (new_tail == "B.png");
	$("#planYmd").prop('disabled', isoff);
	$("#planHm").prop('disabled', isoff);
}

//■再通知不可のときにボタンを不可にする
function setResendDisabled(){
	var resendMode = $("#resendMode").text()
	if (resendMode == "0"){
		$(".lmc_check_image").prop("disabled", true);
		$(".lmc_check_image").css("cursor", "auto");
		$("#resend").prop("disabled", true);
	}
}
function updateCondition(condition){
	setValueIfNotSame(saveCond, condition, 'ymd_start' , "#jk_ymdStart");
	setValueIfNotSame(saveCond, condition, 'ymd_end' , "#jk_ymdEnd");
	saveCond = condition;
}
