/*
 * eigen3_cardano
 * Copylight (C) 2012 mocchi
 * mocchi_2003@yahoo.co.jp
 * License: Boost ver.1
 */
// J_m̌ŌŗLl߁AA1𒼐ډČŗLxNg߂vO

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <cfloat>
#include <complex>
#include <windows.h>
typedef std::complex<double> dcomp_t;

#if 0
double cubert_newton(double a, double x){
	double er;
	do{
		er = (x * x * x - a) / (x * x * 3.0);
		x -= er;
	}while(std::abs(er) > DBL_EPSILON * 6.0);
//	// Z
//	er = x * x * x - a;
//	if (abs(er) > DBL_EPSILON) return std::pow(a, 1.0/3.0);
	return x;
}

double cubert_halley(double a, double x){
	double px;
	do{
		px = x;
		double x3 = x * x * x;
		x *= (x3 + a * 2.0) / (x3 * 2.0 + a);
	}while(std::abs(px-x) > DBL_EPSILON * 7.0);
	x -= (x - a / (x * x)) / 3.0;
//	// Z
//	er = x * x * x - a;
//	if (abs(er) > DBL_EPSILON) return std::pow(a, 1.0/3.0);
	return x;
}

dcomp_t cubert(dcomp_t &x, dcomp_t xi){
	if (x.imag() == 0){
//		return cubert_newton(x.real());
		return cubert_halley(x.real(), xi.real());
	}else{
//		dcomp_t xx = std::pow(x, 1.0/3.0);
//		return xx;
//		return cubert_newton(x);
		return cubert_halley(x, xi);
	}
}

double sqrt_real(double a){
	// a A b * 2^n ɕ (0.25 <= b < 1.0A n2̔{)
	int n;
	double b = std::frexp(a, &n);
	int na = (n < 0) ? ((-n) & 1) : (n & 1);
	n += na;
	if (na) b *= 0.5;

	// ̎_n͕K2̔{
	// wn/2ŕƂɂȂB
	n /= 2;

	// ̕ 0.625 (= (0.25 + 1) / 2) ̎2̍܂Ńe[[WJ 
	b = -0.50596442562694069311982296710923*b*b + 1.2649110640673517327995574177731*b + 0.19764235376052370824993084652706;

	double r = std::ldexp(b, n);
	double rp;
	do{
		r = (r + a/r)*0.5;
		r = (r + a/r)*0.5;
		rp = r = (r + a/r)*0.5;
		r = (r + a/r)*0.5;
	}while(std::abs(rp-r) > DBL_EPSILON * 2.0);
	return r;
}

dcomp_t sqrt_polar(dcomp_t &x){
	double xabs = std::abs(x);
	return std::polar(sqrt_real(xabs), std::arg(x)*0.5);
}

dcomp_t cubert_newton(dcomp_t &a, dcomp_t x){
	dcomp_t er;
	do{
		er = (x - a / (x * x)) / 3.0;
		x -= er;
	}while(std::abs(er) > DBL_EPSILON * 6.0);
//	// Z
//	er = x * x * x - a;
//	if (abs(er) > DBL_EPSILON) return std::pow(a, 1.0/3.0);
	return x;
}

dcomp_t cubert_halley(dcomp_t &a, dcomp_t x){
	dcomp_t px;
	do{
		px = x;
		dcomp_t x3 = x * x * x;
		x *= (x3 + a * 2.0) / (x3 * 2.0 + a);
	}while(std::abs(px-x) > DBL_EPSILON * 7.0);
	x -= (x - a / (x * x)) / 3.0;
//	// Z
//	er = x * x * x - a;
//	if (abs(er) > DBL_EPSILON) return std::pow(a, 1.0/3.0);
	return x;
}

dcomp_t cubert_polar(dcomp_t &x){
	QueryPerformanceCounter(&cnt[0]);
	double xabs = std::sqrt(x.real()*x.real()+x.imag()*x.imag());
	QueryPerformanceCounter(&cnt[1]);
	return std::polar(cubert_real(xabs), std::atan2(x.imag(), x.real()) / 3.0);
}

#endif
LARGE_INTEGER cnt[10];

struct polar_rep{
	double abs;
	double arg;
	polar_rep(double abs_, double arg_) : abs(abs_), arg(arg_){
	}
	polar_rep conj(){
		return polar_rep(abs, -arg);
	}
};

// http://people.freebsd.org/~lstewart/references/apple_tr_kt32_cuberoot.pdf
double cubert_real(double a){
//	QueryPerformanceCounter(&cnt[2]);
	// a A b * 2^n ɕ (0.125 <= b < 1.0A n3̔{)
	int n;
	double b = std::frexp(a, &n);
//	QueryPerformanceCounter(&cnt[3]);
	int na = (n < 0) ? ((-n) % 3) : ((3 - (n % 3)) % 3);
	n += na;
	b /= static_cast<double>(1 << na);

//	QueryPerformanceCounter(&cnt[4]);
	// ̎_n͕K3̔{
	// wn/3ŗƂɂȂB
	n /= 3;

	// ̗
	b = -0.46946116*b*b + 1.072302*b + 0.3812513; // x 6bit

	double r = std::ldexp(b, n);

//	QueryPerformanceCounter(&cnt[5]);
	r = 2.0/3.0 * r + 1.0/3.0 * a / (r * r); // 12bit
	r = 2.0/3.0 * r + 1.0/3.0 * a / (r * r); // 24bit
	r = 2.0/3.0 * r + 1.0/3.0 * a / (r * r); // 48bit
	r = 2.0/3.0 * r + 1.0/3.0 * a / (r * r); // 96bit
//	QueryPerformanceCounter(&cnt[6]);
	return r;
}

polar_rep cubert_polar_rep(dcomp_t &x){
//	QueryPerformanceCounter(&cnt[0]);
	double xabs = std::sqrt(x.real()*x.real()+x.imag()*x.imag());
//	QueryPerformanceCounter(&cnt[1]);
	return polar_rep(cubert_real(xabs), std::atan2(x.imag(), x.real()) / 3.0);
}

const static dcomp_t w1(-0.5,  0.86602540378443864676372317075294);
const static dcomp_t w2(-0.5, -0.86602540378443864676372317075294);

bool eigen_values3(double *A[], double l[6]){
	const double a11 = A[0][0], a12 = A[0][1], a13 = A[0][2];
	const double a21 = A[1][0], a22 = A[1][1], a23 = A[1][2];
	const double a31 = A[2][0], a32 = A[2][1], a33 = A[2][2];
	// ŗL |A - lI| = 0l̕B
	const double a = -1.0;
	const double b = a11 + a22 + a33;
	const double c = -a11*a22 - a11*a33 + a12*a21 + a13*a31 - a22*a33 + a23*a32;
	const double d =
		  a11*a22*a33 - a11*a23*a32 - a12*a21*a33
		+ a12*a23*a31 + a13*a21*a32 - a13*a22*a31;

	// a*l^3 + b*l^2 + c*l + d = 0 Ỏ̌ŉ
	//  R1 : ̒̒̕g
	dcomp_t R1sq;
	double R1 = 3*(27*a*a*d*d - 18*a*b*c*d + 4*a*c*c*c + 4*b*b*b*d - b*b*c*c);
	if (R1 >= 0) R1sq = std::sqrt(R1)*12.0*a;
	else R1sq = dcomp_t(0, std::sqrt(-R1)*12.0*a);
//	if (R1 >= 0) R1sq = sqrt_real(R1)*12.0*a;
//	else R1sq = dcomp_t(0, sqrt_real(-R1)*12.0*a);
	//  R2 : ̒g畽̍
	dcomp_t R2(4*(-27*a*a*d + 9*a*b*c - 2*b*b*b), 0);

	dcomp_t R2_plus_R1sq = R2 + R1sq;
	dcomp_t R2_minus_R1sq = R2 - R1sq;
//	dcomp_t R2_1cb = cubert_polar(R2_plus_R1sq);
	polar_rep R2_1cb = cubert_polar_rep(R2_plus_R1sq);
//	QueryPerformanceCounter(&cnt[7]);
	// R2_plus_R1sqR2_minus_R1sq́AƂɎ(R1̂Ƃ)A܂͕f̊֌W(R1̂Ƃ)
	// f(R2_minus_R1sq = std::conj(R2_plus_R1sq))̂ƂA R2_2cb = std::conj(R2_1cb)
	polar_rep R2_2cb = (R2_1cb.arg != 0) ? R2_1cb.conj() : polar_rep(cubert_real(R2_minus_R1sq.real()), 0);
//	dcomp_t R2_2cb = (R2_1cb.imag() != 0) ? std::conj(R2_1cb) : dcomp_t(cubert_real(R2_1cb.real()), 0);
//	dcomp_t R2_2cb = cubert_halley(R2_minus_R1sq, std::conj(R2_1cb));
//	QueryPerformanceCounter(&cnt[8]);

	double a3i = 1.0 / (3.0*a);
//	l[0] = (-2*b+R2_1cb.real()+R2_2cb.real())*a6i, l[1] = 0;
	if (R1 < 0){
		double cos_R2_1cb = std::cos(R2_1cb.arg);
//		double sin_R2_1cb = std::sin(R2_1cb.arg);
		double sin_R2_1cb = std::sqrt(1 - cos_R2_1cb * cos_R2_1cb);
		l[0] = (R2_1cb.abs*cos_R2_1cb - b)*a3i;
		l[2] = (R2_1cb.abs*(cos_R2_1cb*w1.real() - sin_R2_1cb*w1.imag()) - b)*a3i;
		l[4] = (R2_1cb.abs*(cos_R2_1cb*w1.real() + sin_R2_1cb*w1.imag()) - b)*a3i;
//		double t1 = R2_1cb.arg + 2.0 / 3.0 * 3.1415926535897932384626;
//		double t2 = R2_1cb.arg - 2.0 / 3.0 * 3.1415926535897932384626;
//		l[2] = (R2_1cb.abs*std::cos(t1) - b)*a3i;
//		l[4] = (R2_1cb.abs*std::cos(t2) - b)*a3i;
		l[1] = l[3] = l[5] = 0;
	}else{
		double a6i = a3i * 0.5;
		l[0] = (-2*b+R2_1cb.abs+R2_2cb.abs)*a6i, l[1] = 0;
		dcomp_t s2 = (-2*b+w1*R2_1cb.abs+w2*R2_2cb.abs)*a6i;
		l[2] = s2.real(), l[3] = s2.imag();
		dcomp_t s3 = (-2*b+w2*R2_1cb.abs+w1*R2_2cb.abs)*a6i;
		l[4] = s3.real(), l[5] = s3.imag();
	}
//	QueryPerformanceCounter(&cnt[9]);
	// e̐xj[g@ŏグB
	for (int i = 0; i < 6; ++i){
		if (l[i] == 0) continue;
		double ll = l[i];
		double l2 = ll * ll, l3 = ll * l2;
		l[i] = ll - (a*l3 + b*l2 + c*ll + d) / (3*a*l2 + 2*b*ll + c);
	}
//	QueryPerformanceCounter(&cnt[10]);
	return true;
}

bool eigen_vector3(double *A[], double l, double v[3]){
	const double a11 = A[0][0]-l, a12 = A[0][1], a13 = A[0][2];
	const double a21 = A[1][0], a22 = A[1][1]-l, a23 = A[1][2];
	const double a31 = A[2][0], a32 = A[2][1], a33 = A[2][2]-l;
	double denom;
	denom = a11*a22-a12*a21;
	if (denom != 0){
		v[0] = (a12*a23-a13*a22) / denom, v[1] = (a13*a21-a11*a23) / denom, v[2] = 1.0;
		return true;
	}
	denom = a11*a23-a13*a21;
	if (denom != 0){
		v[0] = (a13*a22-a12*a23) / denom, v[1] = 1.0, v[2] = (a12*a21-a11*a22) / denom;
		return true;
	}
	denom = a12*a23-a13*a22;
	if (denom != 0){
		v[0] = 1.0, v[1] = (a13*a21-a11*a23) / denom, v[2] = (a11*a22-a12*a21) / denom;
		return true;
	}

	denom = a11*a32-a12*a31;
	if (denom != 0){
		v[0] = (a12*a33-a13*a32) / denom, v[1] = (a13*a31-a11*a33) / denom, v[2] = 1.0;
		return true;
	}
	denom = a11*a33-a13*a31;
	if (denom != 0){
		v[0] = (a13*a32-a12*a33) / denom, v[1] = 1.0, v[2] = (a12*a31-a11*a32) / denom;
		return true;
	}
	denom = a12*a33-a13*a32;
	if (denom != 0){
		v[0] = 1.0, v[1] = (a13*a31-a11*a33) / denom, v[2] = (a11*a32-a12*a31) / denom;
		return true;
	}

	denom = a21*a32-a22*a31;
	if (denom != 0){
		v[0] = (a22*a33-a23*a32) / denom, v[1] = (a23*a31-a21*a33) / denom, v[2] = 1.0;
		return true;
	}
	denom = a21*a33-a23*a31;
	if (denom != 0){
		v[0] = (a23*a32-a22*a33) / denom, v[1] = 1.0, v[2] = (a22*a31-a21*a32) / denom;
		return true;
	}
	denom = a22*a33-a23*a32;
	if (denom != 0){
		v[0] = 1.0, v[1] = (a23*a31-a21*a33) / denom, v[2] = (a21*a32-a22*a31) / denom;
		return true;
	}
	return false;
}

void norm_vector3(double v[3]){
	double sum = std::sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
	v[0] /= sum;
	v[1] /= sum;
	v[2] /= sum;
}

void printv(double *v, int n){
	for (int j = 0; j < n; j++) std::printf("%.14f\t", v[j]);
	std::printf("\n");
}

void printm(double **v, int n){
	for (double **iter = v; *iter; ++iter){
		printv(*iter, n);
	}
}

double rnd(void){
	return static_cast<double>(std::rand()) / static_cast<double>(RAND_MAX + 1);
}

int main()
{
	LARGE_INTEGER c1, c2, freq;
	int i, j, k;
	double s, t;

	std::printf("̎ (̐) = ");
	unsigned int seed;
	scanf("%ul", &seed);
	std::srand(seed);
	double buf[9];
	double *a[4] = {&buf[0], &buf[3], &buf[6], 0};
	double lmd[6];
	double tsum = 0;
	for (int l = 0; l < 10; ++l){
		seed += l;
		for (i = 0; i < 3; i++)
			for (j = i; j < 3; j++)
				a[i][j] = a[j][i] = rnd() - rnd();
		std::printf("A:\n");
		printm(a, 3);
		QueryPerformanceCounter(&c1);
		eigen_values3(a, lmd);
		double ev[3][3];
		eigen_vector3(a, lmd[0], ev[0]);
		eigen_vector3(a, lmd[2], ev[1]);
		eigen_vector3(a, lmd[4], ev[2]);
		norm_vector3(ev[0]);
		norm_vector3(ev[1]);
		norm_vector3(ev[2]);
		QueryPerformanceCounter(&c2);
		std::printf("ŗLl:\n");
		printv(&lmd[0], 6);
		printf("ŗLxNg:\n");
		printv(ev[0], 3);
		printv(ev[1], 3);
		printv(ev[2], 3);
		printf("ŗLxNgԂ̓:\n");
		double sum[3] = {0};
		for (j = 0; j < 3; ++j){
			for (i = 0; i < 3; ++i){
				sum[j] += ev[j][i] * ev[(j+1)%3][i];
			}
			printf("%e ", sum[j]);
		}
		printf("\n");
		QueryPerformanceFrequency(&freq);

		double t;
		std::printf("calculation time:%f msec\n", (t = (double)(c2.QuadPart - c1.QuadPart) * 1000.0 / (double)freq.QuadPart));
		tsum += t;
//		for (int i = 0; i < 9; ++i){
//			std::printf("%f \n", (double)(cnt[i+1].QuadPart - cnt[i].QuadPart) * 1000.0 / (double)freq.QuadPart);
//		}
	}
	std::printf("total calculation time:%f msec\n", tsum);
	return EXIT_SUCCESS;
}
