#include "cppds/kdtree.h"
#include <stdio.h>

struct d3{
	double v[3];
	d3(double x, double y, double z){
		v[0] = x, v[1] = y, v[2] = z;
	}
	operator double *(){
		return v;
	}
};

int main(){
	cppds::kdtree<int,3> kdt;
	d3 d3s[] = {
		d3(100,100,100),
		d3(100,106,106),
		d3(100, 95,106),
		d3(105,100,106),
		d3(105, 95,100),
		d3(105, 95,100)
	};
	for (int i = 0; i < 6; ++i){
		kdt.insert(std::make_pair((double *)d3s[i],i));
	}
	cppds::kdtree<int,3> kdt_copy = kdt;
	for (int i = 0; i < 6; ++i){
		const double *d = d3s[i];
		printf("%f %f %f\n", d[0], d[1], d[2]);
		cppds::kdtree<int,3>::iterator_eukleide_range itr = kdt_copy.begin_range(d, 0);
		printf("%s\t", itr != kdt_copy.end_range() ? "" : "Ȃ");
		printf("%s\t", kdt_copy.count(d) ? "" : "Ȃ");
		printf("%s\t", kdt_copy.find(d) != kdt_copy.end_io() ? "" : "Ȃ");
		printf("%s\n", kdt_copy.count(cppds::kdtree<int,3>::key_type(d)) ? "" : "Ȃ");
		itr->second = 10;
	}
	getchar();
	return 0;
}
