static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	name service								*/
/*												*/
/*		coded   by A.Kobayashi	2010.06.10		*/
/*												*/
/************************************************/
#include	"akbcommon.h"

/************************************************/
/*												*/
/************************************************/
int akb_gs_akb_name2(cpBlock,cpName,cpArg,size)
char *cpBlock,*cpName,*cpArg;
int  size;
{
	char *argv[2];
	int n;

	if (!cpArg || size<=0) return -1;
	n = akb_gs_akb_stpl(cpBlock,cpName,argv,2);
	if (n != 2) {
		*cpArg = '\0';
		if (n >=0) n = -1;
		return n;
	}
	strnzcpy(cpArg,argv[1],size-1);
	return strlen(cpArg);
}

/************************************************/
/*												*/
/************************************************/
int akb_gs_akb_name(cpBlock,cpName,cpArg)
char *cpBlock,*cpName,*cpArg;
{
	return akb_gs_akb_name2(cpBlock,cpName,cpArg,D_RECORD_BUFSIZE);
}

/************************************************/
/*												*/
/************************************************/
int akbgetakbservname(cpProcName,service)
char *cpProcName,*service;
{
	int n;

	n = akb_gs_akb_name(BLK_SERVICE,cpProcName,service);
	if (n <= 0) {
		PRINTOUTL2(250,"akbgetakbservname : not found %s in %s",cpProcName,akb_akb_ini(0));
		*service = 0;
		return -1;
	}
	return (n);
}

/************************************************/
/*												*/
/************************************************/
char *akb_akb_home(iReSet)
int iReSet;
{
	static int iAkbHome=1;
	static char *cpHome=NULL;
	char *p;

	if (iAkbHome || iReSet) {
		iAkbHome = 0;
		if (cpHome) Free(cpHome);
		if (p = getenv(AKB_HOME)) {
			cpHome = Strdup(p);
		}
		else cpHome = p;
	}
	return cpHome;
}

/************************************************/
/*												*/
/************************************************/
char *akb_akb_home_add(cpFile)
char *cpFile;
{
	static char *cpPath=NULL;
	char *p;

	p = akxt_add_dir2(akb_akb_home(0),cpFile,&cpPath);
	if (!p) p = cpFile;
	return p;
}

#define OLD_GSAKBSTPL_MAXARGV
#define D_GSAKBSTPL_MAXARGV		128
#define D_GSAKBSTPL_INTERVAL	30
typedef struct {
	int  len;
	int  Nn;
	int  Nm;
	char buf[D_RECORD_BUFSIZE];
} qNaplCtl;

/************************************************/
/*												*/
/************************************************/
int akb_gs_akb_stpl(cpBlock,cpName,argv,maxargv)
char *cpBlock,*cpName,**argv;
int  maxargv;
{
/*
printf("akb_gs_akb_stpl: cpBlock=[%s] cpName=[%s]\n",cpBlock,cpName);
*/
	return akb_gs_akb_stpli(cpBlock,1,cpName,argv,maxargv);
}

/************************************************/
/*												*/
/************************************************/
int akb_gs_akb_stpli(cpBlock,colm,cpName,argv,maxargv)
char *cpBlock,*cpName,**argv;
int  maxargv,colm;
{
	return akb_gs_akb_stplix(cpBlock,colm,cpName,argv,maxargv,3);
}

/************************************************/
/*												*/
/************************************************/
static int _set_argv(pNt,argv)
qNaplCtl *pNt;
char **argv;
{
	int i,n,m;
	char *p;

	n = pNt->Nn;
	m = pNt->Nm;
	p = pNt->buf;
	for (i=0;i<m;i++) {
		argv[i] = p;
		p += strlen(p);
		if (i < n) p++;
	}
	return n;
}

/************************************************/
/*												*/
/************************************************/
int akb_gs_akb_stplix(cpBlock,colm,cpName,argv,maxargv,opt)
char *cpBlock,*cpName,**argv;
int  maxargv,colm,opt;
{
	int n, ret, i, len, m, optw;
	char key[D_RECORD_BUFSIZE],*cpPath,*p;
	static tdtCacheCtlHead *pCH=NULL;
	tdtCacheCtl qCt;
	qNaplCtl *pNt;
	static qNaplCtl qNt;
	tdtCONSTCT *pConstCt=NULL;

	if (opt & AKX_GSSTPLX_CACHE_INVALID) {
		ret = akxa_gs_fopen_free();
		if (pCH) {
#if 1	/* 2021.9.8 */
			if (pConstCt) akxm_cct_free(pConstCt);
			pConstCt = NULL;
#endif
			ret = akxs_cache_free(pCH);
			pCH = NULL;
		}
		return ret;
	}
	if (cpPath=akb_akb_home_add(akb_akb_ini(0))) {
		ret = 0;
		if (maxargv <= D_GSAKBSTPL_MAXARGV) {
			if (!pCH) {
#if 1	/* 2021.9.8 */
				if (!pConstCt) pConstCt = akxm_cct_new(1024,10);
				pCH = akxs_cache_new2(20,akxm_cct_malloc,pConstCt);
#else
				pCH = akxs_cache_new(20);
#endif
				if (pCH) pCH->ch_interval = D_GSAKBSTPL_INTERVAL;
			}
			if (pCH) ret = 1;
		}
		if (ret) {
			pCH->ch_opt |= 0x04;
			pCH->ch_cshlen = -1;
			sprintf(key,"%s.%d.%s.%d",cpBlock,colm,cpName,maxargv);
			ret = akxs_cache_chk(pCH,key,&qCt);
			if (ret) {
				optw = opt;
				if (ret > 0) optw |= AKX_GSFOPEN_CACHE_INVALID;
				m = maxargv;	/* add 2001.6.15 Koba */
				n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
				                qNt.buf,sizeof(qNt.buf),optw);
#if 1	/* 2000.12.18 Koba rsǎΉ */
				if (n == 0) {
					n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
					                qNt.buf,sizeof(qNt.buf),opt);
				}
#endif
				if (n >= 0) {
					qNt.Nn = n;
					qNt.Nm = m;
					qCt.ca_data = (char *)&qNt;
					qNt.len = sizeof(int)*2;
					for (i=0;i<m;i++) { /* n --> m */
						qNt.len += strlen(argv[i]) + 1;
					}
					if (ret == -22) {	/* Key o^ */
						qCt.ca_key  = key;
						qCt.ca_cmp1 = cpPath;
						i = akxs_cache_set(pCH,&qCt);
					}
					else if (ret > 0) {		/* LbV */
						i = akxs_cache_set(pCH,&qCt);
						if (i<0) akxs_cache_del(pCH,key);
					}
					if (i > 0) {
						ret = akxs_cache_get(pCH,i,&qCt);
						if (!ret) {
							_set_argv(qCt.ca_data,argv);
						}
					}
				}
			}
			else {
				n = _set_argv(qCt.ca_data,argv);
			}
		}
		else
			n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
			                qNt.buf,sizeof(qNt.buf),opt);
	}
	else n = -2;
	return n;
}

/************************************************/
/*												*/
/************************************************/
char *akb_get_proc_name(iPid,cpProcName)
int  iPid;
char *cpProcName;
{
	static char *argv[2];
	int iRc;
	char buf[12];

	sprintf(buf,"%d",iPid);
	iRc = akb_gs_akb_stpli(BLK_PROCESS,2,buf,argv,2);
	if (iRc > 0) {
		if (cpProcName) strcpy(cpProcName,argv[0]);
		else cpProcName = argv[0];
	}
	else {
		if (cpProcName) strcpy(cpProcName,buf);
		else cpProcName = NULL;
	}
	return cpProcName;
}

/************************************************/
/*												*/
/************************************************/
char *akb_akb_ini(iReSet)
int iReSet;
{
	static int icpIni=1;
	static char *cpIni=NULL;
	char *p;

	if (icpIni || iReSet) {
		icpIni = 0;
		if (!(p=getenv(AKB_INI))) p = AKBINI;
		if (cpIni) Free(cpIni);
		cpIni = Strdup(p);
	}
	return cpIni;
}

/************************************************/
/*												*/
/************************************************/
int akb_get_proc_name3(iPid,cpDefalt,cppProcName)
int  iPid;
char *cpDefalt,**cppProcName;
{
	int len;
	char *p,*cpName;

	if (!cppProcName) return -1;
	p = akb_get_proc_name(iPid,NULL);
	if (!p) {
		if (cpDefalt) p = cpDefalt;
		else return 0;
	}
	len = strlen(p) + 1;
	cpName = *cppProcName;
	if (cpName) {
		cpName = Realloc(cpName,len);
	}
	else {
		cpName = Malloc(len);
	}
	if (!cpName) return -2;
	strcpy(cpName,p);
	*cppProcName = cpName;
	return len;
}

/************************************************/
/*												*/
/************************************************/
int akb_gs_akb_stpl_func(namv,sep,order,argv,maxargv,pFunc,user_area)
char **namv,sep,**argv,*order,*user_area;
int  maxargv;
int (*pFunc)();
{
	char *cpBlock,*name1,*name2;
	char work[128],*key,c1,c2,*section,*na1,*na2,*p;
	int  n_order,len1,len2,n,i;

	cpBlock = namv[0];
	name1   = namv[1];
	name2   = namv[2];
	if (name1 && name2 && *name1 && *name2) {
		if (!order) return -1;
		if ((len1=strlen(name1))+(len2=strlen(name2))+2 >= sizeof(work))
			return -2;
		n_order = (strlen(order)+1)/2;
		for (i=0;i<n_order;i++) {
			c1 = *order++;
			c2 = *order++;
			section = cpBlock;
			switch (c1) {
			case '1':
				key = name1;
				na1 = name1;
				na2 = NULL;
				break;
			case '2':
				memcpy(work,name1,len1);
				p = work + len1;
				if (sep) {
					*p++ = sep;
				}
				memcpy(p,name2,len2+1);
				key = work;
				na1 = name1;
				na2 = name2;
				break;
			case '3':
				memcpy(work,name2,len2);
				p = work + len2;
				if (sep) {
					*p++ = sep;
				}
				memcpy(p,name1,len1+1);
				key = work;
				na1 = name2;
				na2 = name1;
				break;
			case '4':
				if (strcmp(cpBlock,name1)) {
					section = name1;
					key = name2;
					na1 = name2;
					na2 = NULL;
				}
				else c1 = '\0';
				break;
			default:
				c1 = '\0';
			}
			if (c1) {
				if ((n=akb_gs_akb_stpli(section,1,key,argv,maxargv)) > 0) {
					if (pFunc) {
						n = pFunc(c1,section,na1,na2,argv,n,user_area);
						if (n<0 || c2=='-' || (c2=='?' && n==0)) break;
					}
					else if (c2 != '+') break;
				}
				else if (n < 0) break;
			}
		}
		return n;
	}
	else if (name1 && *name1) key = name1;
	else if (name2 && *name2) key = name2;
	else return -1;

	n = akb_gs_akb_stpli(cpBlock,1,key,argv,maxargv);
	if (n>0 && pFunc) pFunc('0',cpBlock,key,NULL,argv,n,user_area);
	return n;
}
