static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  XNvgl                      @@@           *
*                                                                             *
*      ֐@@@F@int cl_get_script_name( pcmdID )                       *
*                                                                             *
*            F  (I)char    *pcmdID                                     *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>
extern  CLCOMMON CLcommon;
extern	CLPRTBL CLprocTable;
extern	condList CLcList;

#define  MAX_BUFFSIZE 256
#define  DSCMDSCRIPT  "dscmdscript"

static int _get_script_name_from_parm()
{
	int ret,len,opt_in,dtype;
	tdtInfoParm rInfoParm,rInfoParm0;
	char *p,*pp;
	ParList sc_nam;

	if (cl_parm_shift(&rInfoParm0) >= 0) {
		if (rInfoParm0.pi_dlen > 0) {
			ret= cl_code_trans(&rInfoParm0,&rInfoParm);
			if (ret < 0) {
				ERROROUT1("ParmSet: CodeTrans error ret=%d",ret);
				return ECL_SCR_PARM_ERR;
			}
			ret = 0;
			if (CLcList.fname = cl_const_malloc(rInfoParm.pi_dlen+1)) {
				p   = rInfoParm.pi_data;
				len = rInfoParm.pi_dlen;
				if (cl_trim_proc_name(p,len,&sc_nam) < len) {
					p   = sc_nam.par;
					len = sc_nam.parlen;
				}
				if (len>=2 && *p=='{') {
					if (*(pp=p+len-1) != '}') {
						ERROROUT("direct script error");
						ret = -1;
					}
					else {
						p++;
						*pp = '\0';
						if (len > 2) {
							CLcList.line = len - 2;
						}
						else {
							CLcList.line = 0;
						}
						CLcList.rbuf = CLcList.fname;
						memcpy(CLcList.rbuf,p,CLcList.line+1);
						CLcList.option = D_SCRPT_MEMORY | D_SCRPT_NEW_LEX;
#if 1	/* 2021.5.18 */
						dtype = akxt_get_code_type();
						if (opt_in = (cl_get_option(21,0)>>16) & 0x0f) dtype = opt_in;
						CLcList.option |= D_CLST_OPT_USE_DTYPE | (dtype<<16);
#endif
						CLcList.fname = "MEM:";
					}
				}
				else strcpy(CLcList.fname,p);
DEBUGOUTL1(195,"_get_script_name_from_parm: script name=[%s]",CLcList.fname);
			}
			else {
				ERROROUT("script name area malloc error");
				ret = -1;
			}
			if (rInfoParm0.pi_data != rInfoParm.pi_data) Free(rInfoParm.pi_data);
			Free(rInfoParm0.pi_data);
			return ret;
		}
	}
	return ECL_CMD_NOTFOUND;
}

int cl_get_script_name( pcmdID )
unsigned int *pcmdID;
{
	int  n;
	char *fname;
    char *argv[2],parm[MAX_BUFFSIZE];
    char ccmdIDw[10];
    unsigned int icmdID;

	icmdID = *pcmdID;
DEBUGOUTL1(195,"cl_get_script_name: icmdID = 0x%08x",icmdID);
	if (!icmdID) return _get_script_name_from_parm();

	fname = DSCMDSCRIPT;
	if (CLcommon.CmdScriptp) {
		if (*CLcommon.CmdScriptp) fname = CLcommon.CmdScriptp;
	}

	sprintf(ccmdIDw,"%08x",icmdID);
	n = akxagetstpl(akb_akb_home_add(fname),ccmdIDw,argv,2,parm,sizeof(parm));

	if (n < 0) {
		/* "cl_get_script_name: %s܂B */
		ERROROUT1(FORMAT(338),fname);
		return ECL_CMDSCR_NOTFD;
	}
	else if (n >= 2) {
		if (CLcList.fname=cl_const_malloc(strlen(argv[1])+1)) {
			strcpy(CLcList.fname,argv[1]);		/* XNvgZbg */
DEBUGOUTL1(195,"cl_get_script_name: script name=[%s]",CLcList.fname);
			return NORMAL;
		}
		else {
			ERROROUT("script name area malloc");
			return ECL_SYSTEM_ERROR;
		}
	}
	return ECL_CMD_NOTFOUND;
}

char *cl_set_script_name_extension(scrname,scrnamelen)
char *scrname;
int scrnamelen;
{
	int len,ext;
	char *p,*name;
/*
if (CLcommon.pExtension) printf("cl_set_script_name_extension: CLcommon.pExtension=[%s]\n",CLcommon.pExtension);
else  printf("cl_set_script_name_extension: CLcommon.pExtension=[(null)]\n");
*/
	len = scrnamelen + 1;
	ext = 0;
	name = akxt_get_last_name("\\/",scrname);
	if (CLcommon.pExtension && !strchr(name+1,'.')) {

DEBUGOUTL3(195,"cl_set_script_name_extension:scrname=[%s],scrnamelen=%d,Extension=[%s]",
scrname,scrnamelen,CLcommon.pExtension);

		len += strlen(CLcommon.pExtension) + 1;
		ext = 1;
	}
	if (p = cl_tmp_const_malloc(len)) {
		if (ext) sprintf(p,"%s.%s",scrname,CLcommon.pExtension);
		else strcpy(p,scrname);
DEBUGOUTL1(195,"cl_set_script_name_extension: script name=[%s]",p);
	}
	else {
		ERROROUT("cl_set_script_name_extension:script name area malloc error");
	}
	return p;
}
