/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.service;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import jp.nanah.bastub.controller.AnyRestController;
import nanah.oslib.ResUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PageDataService {
    private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
    @Value(value="${pagedata.root:pagedata}")
    private String pagedataPath;

    public File getPageDir() {
        File pageDir = new File(this.pagedataPath);
        if (!pageDir.isAbsolute()) {
            File appRoot = ResUtils.getRootDirAs(this.getClass());
            pageDir = new File(appRoot, this.pagedataPath);
        }
        try {
            pageDir = pageDir.getCanonicalFile();
        }
        catch (IOException e) {
            pageDir = pageDir.getAbsoluteFile();
        }
        return pageDir;
    }

    public File getPageDataFile(File dir, HttpServletRequest req) {
        File file = new File(dir, req.getRequestURI());
        logger.debug("Path=[{}]", (Object)file.getAbsolutePath());
        return file;
    }
}

