/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.nanah.bastub.data.JsonInfo;
import jp.nanah.bastub.service.UsingInfo;
import jp.nanah.bastub.util.BastubUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JsonService {
    protected static final Logger logger = LoggerFactory.getLogger(JsonService.class);
    public static final String JSON_DATA_NONE_TEXT = "{\"key\":\"auto created.\"}";
    @Value(value="${auto_create:false}")
    protected boolean isAutoCreate;

    public JsonInfo readJsonFile(File file) {
        String text;
        FileInputStream fis;
        JsonInfo jsonInfo;
        block12: {
            jsonInfo = new JsonInfo();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                jsonInfo.setErrorMessage("JSON\u30d5\u30a1\u30a4\u30eb\u304c\u672a\u8a2d\u5b9a\u3067\u3059");
                try {
                    if (this.isAutoCreate) {
                        FileUtils.writeByteArrayToFile((File)file, (byte[])JSON_DATA_NONE_TEXT.getBytes());
                        file.setLastModified(0L);
                    }
                }
                catch (Exception e) {
                    logger.info("\u5fdc\u7b54JSON - \u81ea\u52d5\u751f\u6210 [\u5931\u6557]: path=[{}]", (Object)file.getAbsolutePath());
                }
                return jsonInfo;
            }
            fis = null;
            fis = new FileInputStream(file);
            byte[] buff = new byte[(int)file.length()];
            IOUtils.readFully((InputStream)fis, (byte[])buff);
            text = new String(buff, "UTF-8");
            if (!text.equals(JSON_DATA_NONE_TEXT)) break block12;
            jsonInfo.setErrorMessage("JSON\u30d5\u30a1\u30a4\u30eb\u304c\u672a\u8a2d\u5b9a\u3067\u3059");
            JsonInfo jsonInfo2 = jsonInfo;
            IOUtils.closeQuietly((InputStream)fis);
            return jsonInfo2;
        }
        try {
            try {
                String reptext = this.adjustReplaceNumberValue(text);
                String trimText = reptext.trim();
                if (trimText.substring(0, 1).equals("[")) {
                    reptext = "{\"dummy\":" + reptext + "}";
                    jsonInfo.setTopArray(true);
                }
                try {
                    JSONObject jsonObject = new JSONObject(reptext);
                    jsonInfo.setJsonObject(jsonObject);
                }
                catch (Throwable th) {
                    jsonInfo.setErrorMessage("JSON\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u66f8\u5f0f\u304c\u6b63\u3057\u304f\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                }
            }
            catch (Throwable th) {
                logger.warn("\u5fdc\u7b54\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557: path=[{}]", (Object)file.getAbsolutePath(), (Object)th);
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return jsonInfo;
    }

    private String adjustReplaceNumberValue(String org) {
        int pos = 0;
        String dst = org;
        while (pos < dst.length()) {
            int top = dst.indexOf("${", pos);
            if (top < 0) break;
            int last = BastubUtils.getNumberLast(dst, top);
            if (last >= 0) {
                String v = String.valueOf(dst.substring(top, last)) + "#N";
                dst = String.valueOf(dst.substring(0, top)) + "\"" + v + "\"" + dst.substring(last);
                pos = last + 1;
                continue;
            }
            ++pos;
        }
        return dst;
    }

    public void setDataToJsonObject(List<String> keyList, JSONObject jsonObj, List<Row> dataList, UsingInfo ui) {
        if (keyList == null) {
            keyList = new ArrayList<String>();
        }
        if (dataList == null) {
            dataList = new ArrayList<Row>();
        }
        UsingInfo ud = new UsingInfo(dataList, ui);
        List<String> allkeys = BastubUtils.sortIterator(jsonObj.keys());
        for (String key : allkeys) {
            String orgval;
            if (key == null || jsonObj.optJSONArray(key) != null || jsonObj.optJSONObject(key) != null || (orgval = jsonObj.optString(key)) == null) continue;
            try {
                String dstval = ud.getDirectValue(keyList, key, orgval);
                jsonObj.put(key, (Object)dstval);
            }
            catch (Exception e) {
                logger.warn("\u7f6e\u63db\u7570\u5e38", (Throwable)e);
            }
        }
        List<Row> nextLayerTarget = ud.getLoweredData();
        if (nextLayerTarget == null) {
            return;
        }
        for (String key : allkeys) {
            if (key == null) continue;
            ArrayList<String> nextKeyList = new ArrayList<String>(keyList);
            nextKeyList.add(key);
            if (jsonObj.optJSONArray(key) != null) {
                JSONArray jsonAry = jsonObj.optJSONArray(key);
                JSONArray extendAry = this.getExtendJsonArray(nextKeyList, jsonAry, nextLayerTarget, ui);
                try {
                    jsonObj.put(key, (Object)extendAry);
                }
                catch (Throwable th) {
                    logger.warn("\u914d\u5217\u30c7\u30fc\u30bf\u8a2d\u5b9a\u7570\u5e38", th);
                }
                continue;
            }
            if (jsonObj.optJSONObject(key) == null) continue;
            JSONObject nextJson = jsonObj.optJSONObject(key);
            this.setDataToJsonObject(nextKeyList, nextJson, nextLayerTarget, ui);
        }
    }

    public JSONArray getExtendJsonArray(List<String> keyList, JSONArray jsonAry, List<Row> dataList, UsingInfo ui) {
        JSONArray extendAry = new JSONArray();
        UsingInfo ud = new UsingInfo(dataList, ui);
        int i = 0;
        while (i < jsonAry.length()) {
            try {
                if (jsonAry.optJSONObject(i) != null) {
                    String baseText = jsonAry.getJSONObject(i).toString();
                    ArrayList<String> extendedList = new ArrayList<String>();
                    int r = 1;
                    while (r < dataList.size()) {
                        ArrayList<Row> lowerDataList = new ArrayList<Row>();
                        lowerDataList.add(dataList.get(0));
                        lowerDataList.add(dataList.get(r));
                        JSONObject extendJson = new JSONObject(baseText);
                        this.setDataToJsonObject(keyList, extendJson, lowerDataList, ui);
                        String extendText = extendJson.toString();
                        if (!extendedList.contains(extendText)) {
                            extendedList.add(extendText);
                            extendAry.put(extendAry.length(), (Object)extendJson);
                        }
                        ++r;
                    }
                } else if (jsonAry.optJSONArray(i) != null) {
                    JSONArray thisAry = jsonAry.getJSONArray(i);
                    JSONArray childAry = this.getExtendJsonArray(keyList, thisAry, dataList, ui);
                    extendAry.put(extendAry.length(), (Object)childAry);
                } else {
                    String orgval = jsonAry.getString(i);
                    if (orgval != null) {
                        try {
                            String dstval = ud.getDirectValue(keyList, "", orgval);
                            extendAry.put(extendAry.length(), (Object)dstval);
                        }
                        catch (Exception e) {
                            logger.warn("\u7f6e\u63db\u7570\u5e38", (Throwable)e);
                        }
                    }
                }
            }
            catch (Throwable th) {
                logger.warn("\u5fdc\u7b54\u30c7\u30fc\u30bf\u751f\u6210\u7570\u5e38", th);
            }
            ++i;
        }
        return extendAry;
    }
}

