static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************/
/*	<clprdef.c>										*/
/*		Define process								*/
/****************************************************/
#include "colmn.h"

extern condList CLcList;
extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern int giOptions[];
extern CLCOMMON  CLcommon;
extern char *ScopeNames[];
extern char *ScopeMarks[];
extern int  ScopeGXOpts[];
extern int  ScopeAUX1s[];

int cl_pr_ex_dim();
int cl_pr_ex_define();
int cl_pr_ex_typedef();
int cl_process_define_exec();
static int _chk_array();
static char *gsep=" \t(){}[],'=+-*/&|";
static char *gsep2=" \t()[],'=";

/************************************/
/* cl_process_top_exec              */
/************************************/
int cl_process_top_exec(scrct,top_leaf,func1,ncmd,cmd_cid,func2)
ScrPrCT  *scrct;
Leaf *top_leaf;
int (*func1)();
int ncmd,cmd_cid[];
int (*func2[])();
{
	Leaf *leaf,*leafw;
	int cno,rc=0;

	if (!scrct || !top_leaf || !func1) return ECL_SYSTEM_ERROR;
	leaf = top_leaf;
	while (leaf) {
		if ((cno=leaf->cmd.cid)==C_NODE_SCRIPT || cno==C_NODE_IMPORT) {
			if (leafw=leaf->leftleaf) {
				leafw->pFlag |= D_LEAF_IMPORTMODE;			/* 2021.7.14 add */
				rc = func1(scrct,leafw,ncmd,cmd_cid,func2);
				if (rc) break;
			}
			leaf = leaf->rightleaf;
		}
		else {
			rc = func1(scrct,leaf,ncmd,cmd_cid,func2);
			break;
		}
	}
	return rc;
}

/************************************/
/* cl_process_define_exec           */
/************************************/
int cl_process_define_exec(scrct,leaf,ncmd,cmd_cid,func)
ScrPrCT  *scrct;
Leaf *leaf;
int ncmd,cmd_cid[];
int (*func[])();
{
	int rc,cno,i,iIMPORT;

	if (!leaf) return ECL_SYSTEM_ERROR;

	rc = 0;
	iIMPORT = leaf->pFlag & D_LEAF_IMPORTMODE;	/* 2021.7.14 add */
/*
printf("cl_process_define_exec: iIMPORT=%8x\n",iIMPORT);
*/
	while (leaf && rc==NormalEnd) {
		cno=leaf->cmd.cid;
		if (cno==C_PROC || cno==C_FUNCTION || cno==C_CLASS) break;
		else if (cno == C_NODE_DEFINE) leaf = leaf->leftleaf;
		else {
#if 1	/* 2021.7.1 */
/*
printf("cl_process_define_exec: leaf->pFlag=%8x\n",leaf->pFlag);
*/
			if (!(leaf->pFlag & D_LEAF_DEF_EXECUTED)) {
#endif
				for (i=0;i<ncmd;i++) {
					if (cno == cmd_cid[i]) {
DEBUGOUTL1(100,"[ %s ]",cl_get_pcmd_line(leaf));
						if (CLcommon.dbgopt[0]) {
							cl_debug_mode(leaf,NULL,0);
						}
						rc = func[i](leaf,scrct,NULL,0);
						if (rc) {
							clerrdisp(rc,leaf);
							return rc;
						}
#if 1	/* 2021.7.1 */
						if (iIMPORT) leaf->pFlag |= D_LEAF_DEF_EXECUTED;	/* 2021.7.14 add if (iIMPORT) */
#endif
						break;
					}
				}
#if 1	/* 2021.7.1 */
			}
#endif
			leaf = leaf->rightleaf;
		}
	}
	return rc;
}

/************************************/
/* cl_process_define                */
/************************************/
int cl_process_define(scrct,top_leaf)
ScrPrCT  *scrct;
Leaf     *top_leaf;
{
	int cmd[3];
	int (*func[3])();

	cmd[0] = C_DEFINE;
	cmd[1] = C_DIM;
/*	cmd[2] = C_TYPEDEF;	*/
	func[0] = cl_pr_ex_define;
	func[1] = cl_pr_ex_dim;
/*	func[2] = cl_pr_ex_typedef;	*/
	return cl_process_top_exec(scrct,top_leaf,cl_process_define_exec,2,cmd,func);
}
#if 0
/************************************/
/* cl_process_dim                   */
/************************************/
int cl_process_dim(scrct)
ScrPrCT  *scrct;
{
	return cl_process_top_exec(scrct,C_DIM,cl_process_define_exec,cl_pr_ex_dim);
}
#endif
/************************************/
/* cl_pr_ex_define                  */
/************************************/
int cl_pr_ex_define(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	static char *msg="[ Skipped ]";
	int  i, n, rc, scno, *obj;
	parmList **pprmp;
	char **da;
	CMDObject *cmdobj;

	if (!leaf || !scrct) return ECL_SYSTEM_ERROR;

	/* parameter check */
	if ( (n=leaf->cmd.prmnum) < 1 ) {
		/* cl_pr_ex_define:p[^܂ */
		ERROROUT1(FORMAT(42),"cl_pr_ex_define");
		return ECL_EX_DEFINE;
	}

	pprmp = leaf->cmd.prmp;
	if (scno=leaf->cmd.sub_cid) {
		switch (scno) {
		/*
			case CS_MAPPEDARRAY:
				rc = cl_pr_ex_def_map_ary(n, pprmp, scrct, proc, opt);
				break;
		*/
			case CS_TYPE:
				rc = cl_pr_ex_def_type(n, pprmp, scrct, proc, opt);
				break;
			case CS_VAR:
				cmdobj = leaf->cmd.cmdobj;
				rc = cl_pr_ex_def_var(cmdobj, n-1, pprmp+1, scrct, proc, opt);
				break;
			case CS_OPTION:
				rc = 0;
DEBUGOUTL(100,msg);
				break;
			case CS_OPTIONS:
				rc = 0;
DEBUGOUTL(100,msg);
				break;
			default:
				cmdobj = leaf->cmd.cmdobj;
				rc = cl_pr_ex_def_array(cmdobj,n,pprmp,scrct,proc,opt);
		}
	}
	else {
		sswitch ( pprmp[0]->prp )
		/*
			sicase ("MAPPEDARRAY")
				rc = cl_pr_ex_def_map_ary(n, pprmp, scrct, proc, opt);
		*/
			sicase2("TYPE","TYPEDEF")
				rc = cl_pr_ex_def_type(n, pprmp, scrct, proc, opt);
			sicase ("VAR")
				cmdobj = leaf->cmd.cmdobj;
				rc = cl_pr_ex_def_var(cmdobj, n-1, pprmp+1, scrct, proc, opt);
			sicase ("OPTION")
				rc = 0;
DEBUGOUTL(100,msg);
			sicase ("OPTIONS")
				rc = 0;
DEBUGOUTL(100,msg);
			sdefault
				cmdobj = leaf->cmd.cmdobj;
				rc = cl_pr_ex_def_array(cmdobj,n,pprmp,scrct,proc,opt);
		endssw
	}
	return rc;
}

/************************************/
/* cl_pr_ex_re_define               */
/************************************/
int cl_pr_ex_re_define(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	ScrPrCT *scrct;

	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;
	return cl_pr_ex_define(leaf,scrct,proc,D_GX_OPT_REDEFINE);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_check_define(pScCT,proc,varnam,vnlen,opt,argv)
ScrPrCT	*pScCT;
ProcCT  *proc;
char    *varnam;
int      vnlen;
int      opt;
char    *argv[];
{
	int ret,iParmNo,iLGopt,iNONE;
	tdtInfoParm ***pTBL_vnam;
	char *p,*pp;

DEBUGOUTL4(190,"cl_gx_check_define: pScCT=%016lx proc=%016lx varnam=[%s] opt=%08x",
pScCT,proc,varnam,opt);

	iNONE = !(opt & D_GX_OPT_SET_SCOPE);
	iParmNo = 0;
	pTBL_vnam = NULL;
	iLGopt= 0;
	p = "";
	if (proc && proc->pha_vnam) {
		if ((ret=cl_gx_chk_vnam('r',proc->pha_vnam,varnam,vnlen)) > 0) {
			if (iNONE || (opt & D_GX_OPT_SET_LOCAL)) {
				pTBL_vnam = proc->pTBL_vnam;
				iParmNo = ret;
				p = "LOCAL";
			}
			iLGopt = D_AUX1_LOCAL_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: LOCAL ParmNo=%d",ret);
			if (argv[0] && (opt & (D_GX_OPT_SET_PRIVATE | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				if (opt & D_GX_OPT_SET_PRIVATE) pp = "SCRIPT";
				else if (opt & D_GX_OPT_SET_PUBLIC) pp = "PUBLIC";
				else pp = "GLOBAL";
				/* %s:%s:(W)LOCALϐ[%s]`ς݂łB */
				ERROROUT3(FORMAT(421),argv[0],pp,varnam);
			}
		}
	}
	if (pScCT) {
		if ((ret=cl_gx_chk_vnam('r',pScCT->Vary->pha_vnam,varnam,vnlen)) > 0) {
			if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_PRIVATE))) {
				pTBL_vnam = pScCT->Vary->pTBL_vnam;
				iParmNo = ret;
				p = "SCRIPT";
			}
			iLGopt |= D_AUX1_PRIVATE_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: SCRIPT ParmNo=%d",ret);
			if (argv[0] && (opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				if (opt & D_GX_OPT_SET_PUBLIC) pp = "PUBLIC";
				else pp = "GLOBAL";
				/* %s:%s:(W)SCRIPTϐ[%s]`ς݂łB */
				ERROROUT3(FORMAT(422),argv[0],pp,varnam);
			}
		}
	}
	if ((ret=cl_gx_chk_vnam('r',pCLprocTable->pha_vnam,varnam,vnlen)) > 0) {
		if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_PUBLIC))) {
			pTBL_vnam = pCLprocTable->pTBL_vnam;
			iParmNo = ret;
			p = "PUBLIC";
		}
		iLGopt |= D_AUX1_PUBLIC_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: PUBLIC ParmNo=%d",ret);
		if (argv[0] && (opt & D_GX_OPT_SET_GLOBAL)) {
			pp = "GLOBAL";
			/* %s:%s:(W)PUBLICϐ[%s]`ς݂łB */
			ERROROUT3(FORMAT(607),argv[0],pp,varnam);
		}
	}
	if ((ret=cl_gx_chk_vnam('r',pGLprocTable->pha_vnam,varnam,vnlen)) > 0) {
		if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_GLOBAL))) {
			pTBL_vnam = pGLprocTable->pTBL_vnam;
			iParmNo = ret;
			p = "GLOBAL";
		}
		iLGopt |= D_AUX1_GLOBAL_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: GLOBAL ParmNo=%d",ret);
	}
	if (cl_chk_sysvar_name(varnam, vnlen)) {
						/* %s:(E)SYSTEMϐ[%s]`ς݂łB */
		if (argv[0]) ERROROUT2(FORMAT(423),argv[0],varnam);
		iParmNo = ECL_SCRIPT_ERROR;
	}
	argv[1] = (char *)pTBL_vnam;
	argv[2] = (char *)iLGopt;
	argv[3] = p;

DEBUGOUTL4(190,"cl_gx_check_define:Exit: iParmNo=%d pTBL_vnam=%016lx iLGopt=%08x p=[%s]",
iParmNo,pTBL_vnam,iLGopt,p);

	return iParmNo;
}

/************************************/
/*	_chk_define                     */
/************************************/
int _chk_define(scrct,proc,varnam,vnlen,opt,argv)
ScrPrCT *scrct;
ProcCT  *proc;
char    *varnam;
int      vnlen;
int      opt;
char    *argv[];
{
	XHASHB  *pha_vname;
	tdtInfoParm ***pTBL_vname;
	int ret,iAux,iARRAY;
	char *name,*p;

DEBUGOUTL5(190,"_chk_define:Enter: scrct=%016lx proc=%016lx varnam=%s vnlen=%d opt=%08x",
scrct,proc,varnam,vnlen,opt);

	argv[4] = argv[5] = NULL;
	name = argv[0];
	if ((ret=cl_gx_check_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return ret;
	iAux = (int)argv[2];
	iARRAY = opt & D_GX_OPT_SET_ARRAY;
#if 1	/* 2021.2.21 */
	/* cl_gx_check_define()̑OŐݒ肷ƁA`ς݂łAret==0 ƂȂ̂ŁA
	   cl_pr_ex_def_scalar_attr_info()cl_pr_ex_def_array_engine()炱ɈڂB */
	if (!(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}
#endif
	p = "";
	if (opt & D_GX_OPT_SET_LOCAL) {
		if (!proc) {
			/* %s: 葱OłLOCALϐ͒`ł܂B */
			ERROROUT1(FORMAT(424),name);
			return ECL_SCRIPT_ERROR;
		}
		if (pha_vname=proc->pha_vnam) {
			p = D_STR_NAME_LOCAL;
			if (iARRAY && (iAux & D_AUX1_LOCAL_VAR)) {
						/* %s: %sϐ[%s]`ς݂łB */
				ERROROUT3(FORMAT(425),name,p,varnam);
				return ECL_SCRIPT_ERROR;
			}
			pTBL_vname = proc->pTBL_vnam;
		}
		else return -1;
	}
	else if (opt & D_GX_OPT_SET_PUBLIC) {
		pha_vname = pCLprocTable->pha_vnam;
		pTBL_vname = pCLprocTable->pTBL_vnam;
		p = D_STR_NAME_PUBLIC;
	}
	else if (opt & D_GX_OPT_SET_GLOBAL) {
		pha_vname = pGLprocTable->pha_vnam;
		pTBL_vname = pGLprocTable->pTBL_vnam;
		p = D_STR_NAME_GLOBAL;
	}
	else {
		if (!scrct) return -1;
		pha_vname = scrct->Vary->pha_vnam;
		p = D_STR_NAME_PRIVATE;
		if ((iARRAY || !proc) && (iAux & D_AUX1_PRIVATE_VAR)) {
					/* %s: %sϐ[%s]`ς݂łB */
			ERROROUT3(FORMAT(425),name,p,varnam);
			return ECL_SCRIPT_ERROR;
		}
		pTBL_vname = scrct->Vary->pTBL_vnam;
	}
	if (!*(argv[3])) argv[3] = p;
	argv[4] = (char *)pha_vname;
	argv[5] = (char *)pTBL_vname;

DEBUGOUTL4(190,"_chk_define:Exit ret=%d pha_vname=%016lx pTBL_vname=%016lx argv[3]=[%s]",
ret,pha_vname,pTBL_vname,argv[3]);

	return ret;
}

/************************************/
/*	_set_index						*/
/*			is = 0 : mapped array	*/
/*			   = 1 : array			*/
/************************************/
int _set_index(is,prmnum,pprmp,offset,index,msg)
int is,prmnum;
parmList **pprmp;
int offset,index[];
char *msg;
{
	int i,rc,ixlen,ix,len,k,f,ndim,n,m1,m2;
	char *ixnam,*p;
	tdtInfoParm tInfoParm;
	tdtObjHead *Obj;
/*
printf("_set_index: is=%d prmnum=%d offset=%d msg=[%s]\n",is,prmnum,offset,msg);
*/
	ndim = prmnum - (1-is);
	if (ndim > MAX_ARRAY_DIM) {
		ERROROUT2(FORMAT(427),msg,prmnum);	/* %s: (%d)܂B */
		return ECL_SCRIPT_ERROR;
	}
/*
printf("_set_index: ndim=%d\n",ndim);
*/
	Obj = cl_gx_get_obj();
	ix = is + 3;
	m1 = n = 1;
	for (i=0;i<prmnum;i++,ix++) {
		if ((ixlen=pprmp[i+offset]->prmlen) > 0) {
			ixnam = pprmp[i+offset]->prp;
/*
printf("_set_index: ixnam=%s\n",ixnam);
*/
			if (rc = cl_gx_exp_obj(1,&pprmp[i+offset],Obj,&tInfoParm)) return ECL_SCRIPT_ERROR;
/*
printf("_set_index:1 rc=%d bxobj=%016lx\n",rc,pprmp[i+offset]->bxobj);
*/
			if (tInfoParm.pi_dlen > 0) {
				m2 = 0;
				if (pGlobTable->options[14] & 0x01) m2++;;
				rc = cl_get_parm_bin(&tInfoParm,&m1,msg);
				if (!rc && (tInfoParm.pi_alen & D_AULN_RANGE_DATA)) {
					if (ix <= 3) {
						/* %s: %d  }bvCfbNXɔ͈͎w[%s]́Awł܂B */
						ERROROUT3(FORMAT(420),msg,i+1,ixnam);
						return ECL_SCRIPT_ERROR;
					}
					else {
						memcpy(tInfoParm.pi_data,tInfoParm.pi_data+tInfoParm.pi_dlen,tInfoParm.pi_dlen);
						if (!(rc=cl_get_parm_bin(&tInfoParm,&m2,msg))) {
							if (m1 > m2) {
								/* %s: %d ڂ͈͎̔w[%s]słB */
								ERROROUT3(FORMAT(428),msg,i+1,ixnam);
								return ECL_SCRIPT_ERROR;
							}
/*
printf("_set_index:1 m1=%d m2=%d\n",m1,m2);
*/
							k = m2;
							m2 = m1;
							m1 = k - m1 + 1;
						}
					}
				}
				index[ix] = m1;
				if (ix > 3) index[ix+ndim] = m2;
				if (rc) {
/*
DEBUGOUT_InfoParm(0,"_cmpt_mult: ix=%d",&tInfoParm,ix,0);
*/
					/* %s: %d ڂ͈͎̔w[%s]lł͂܂B */
					ERROROUT3(FORMAT(429),msg,i+1,ixnam);
					return ECL_SCRIPT_ERROR;
				}
			}
			if (index[ix] <= 0) {
				/* %s: %d ڂ̗vf[%s]=%dsłB */
				ERROROUT4(FORMAT(430),msg,i+1,ixnam,index[ix]);
				return ECL_SCRIPT_ERROR;
			}
		}
/*
printf("_set_index: ixlen=%d\n",ixlen);
*/
		if (ix > 3) n *= m1;
/*
printf("%s: index[%d]=%d,%d f=%x index[2]=%x n=%d\n",
msg,ix,index[ix],index[ix+ndim],f,index[2],n);
*/
	}
	if (ndim > 0) {
		index[0] = ndim;
		index[1] = n;
	}
	return 0;
}

/************************************/
/*	_check_redefine                 */
/************************************/
static int _check_redefine(varnam,vnlen,ppInfoParm,id,msg)
char *varnam;
int vnlen;
tdtInfoParm **ppInfoParm;
char id,*msg;
{
	int rc;
	char *ary;
	tdtInfoParm tInfoParm,*pInfoParm;
	parmList prmp;

	pInfoParm = &tInfoParm;
	prmp.prp = varnam;
	prmp.prmlen = vnlen;
	if (rc=cl_conv_parm_opt(&prmp,pInfoParm,D_GX_OPT_SET_ADDR)) {
		if (rc == ECL_DEFINED_ARRAY) rc = 0;
		else {
			ERROROUT2(FORMAT(125),msg,varnam);	/* %s: [%s]Ă܂B */
			return rc;
		}
	}
	if (pInfoParm->pi_id == 'S') {
		pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
	}
	if (id=='A' || id=='R') {
		if (id && pInfoParm->pi_id != id) {
			if (id == 'A') ary = "MAPPEDARRAY";
			else ary = "ARRAY";
			/* %s: ϐ(%s)%sł͂܂B */
			ERROROUT3(FORMAT(431),msg,varnam,ary);
			rc = ECL_SCRIPT_ERROR;
		}
	}
	*ppInfoParm = pInfoParm;
	return rc;
}

/************************************/
/*	cl_get_def_scope				*/
/************************************/
int cl_get_def_scope(p)
char *p;
{
	int opt,i,k;

	i = opt = 0;
	if (k=akxs_seqr_str(ScopeNames,D_MAX_SCOPE,p,1)) i = k;
	else if (k=akxs_seqr_str(ScopeMarks,D_MAX_SCOPE,p,1)) i = k;
	if (i) opt = ScopeGXOpts[i-1];
/*
printf("cl_get_def_scope: p=[%s] opt=%08x\n",p,opt);
	if (!stricmp(p,"GLOBAL") || !stricmp(p,D_STR_SCOPE_GLOBAL))
		opt = D_GX_OPT_SET_GLOBAL;
	else if (!stricmp(p,"PUBLIC") || !stricmp(p,D_STR_SCOPE_PUBLIC))
		opt = D_GX_OPT_SET_PUBLIC;
	else if (!stricmp(p,"PRIVATE") || !stricmp(p,D_STR_SCOPE_PRIVATE))
		opt = D_GX_OPT_SET_PRIVATE;
	else if (!stricmp(p,"LOCAL") || !stricmp(p,D_STR_SCOPE_LOCAL))
		opt = D_GX_OPT_SET_LOCAL;
*/
	return opt;
}

/****************************************/
/*										*/
/****************************************/
char *cl_get_scope_name_from_opt(opt)
int opt;
{
	char *pp;
	int k;

	pp = "";
	if ((k=akxs_iseq_opt(ScopeGXOpts,D_MAX_SCOPE,opt,1)) > 0) pp = ScopeNames[k-1];
/*
	for (k=0;k<D_MAX_SCOPE;k++) {
		if (opt & ScopeGXOpts[k]) {
			pp = ScopeNames[k];
			break;
		}
	}
printf("cl_get_scope_name_from_opt: opt=%08x pp=[%s]\n",opt,pp);
*/
/*
	if (opt & D_GX_OPT_SET_LOCAL) pp = "LOCAL";
	else if (opt & D_GX_OPT_SET_PRIVATE) pp = "PRIVATE";
	else if (opt & D_GX_OPT_SET_PUBLIC) pp = "PUBLIC";
	else if (opt & D_GX_OPT_SET_GLOBAL) pp = "GLOBAL";
	else pp = "";
*/
	return pp;
}

/************************************/
/*	cl_get_def_modifier_SSP			*/
/************************************/
int cl_get_def_modifier_SSP(s,slen,ssp,sep,check,iParm,bxobj,Obj)
char   *s;
int    slen;
SSPL_S *ssp;
char   *sep;
int    check[],iParm[];
GXObject *bxobj[];
tdtObjHead *Obj;
{
	int  iCONST,iARRAY,iMAPPED,iSTATIC,iCLEAR,iEXPORT;
	int  np,i,n,n1,iOpt,iCHK,iCHK2,iOK,rc,opt,len,spw,iParm2[8];
	char *p;

	iCONST = iARRAY = iMAPPED = iSTATIC = iCLEAR = iEXPORT = 0;
	n1 = n = iOpt = iOK = opt = rc = 0;
	iCHK = check[1];
	iCHK2 = ~iCHK;
	spw = ssp->sp;
	while ((len=akxtgwnsl(s,slen,ssp,sep,0x41)) > 0) {
		n1 = n;
		p = strtemp(ssp->wd,len);
/*
printf("cl_get_def_modifier_SSP: p=[%s]\n",p);
*/
		if (iOpt=cl_get_def_scope(p)) {
			if (opt & iOpt) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			opt |= iOpt;
			iOK |= 0x01;
		}
		else if (!stricmp(p,"CONST")) {
			if (iCONST) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			iCONST = D_AUX1_PROTECTED;
			opt |= D_GX_OPT_SET_CONST;
			iOK |= 0x02;
		}
		else if (!stricmp(p,"ARRAY")) {
			if (iARRAY || iMAPPED) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			iARRAY = 1;
			opt |= D_GX_OPT_SET_ARRAY;
			iOK |= 0x04;
		}
		else if (!stricmp(p,"MAPPEDARRAY") || !stricmp(p,"MAPPED")) {
			if (iMAPPED || iARRAY) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			iMAPPED = 1;
			opt |= D_GX_OPT_SET_MAPPED;
			iOK |= 0x20;
		}
		else if (!stricmp(p,"STATIC")) {
			if (iSTATIC) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			iSTATIC = 1;
			opt |= D_GX_OPT_SET_STATIC;
			iOK |= 0x08;
		}
		else if (!stricmp(p,"CLEAR")) {
			if (iCLEAR) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			iCLEAR = 1;
			opt |= D_GX_OPT_SET_CLEAR;
			iOK |= 0x10;
		}
		else if (!stricmp(p,"EXPORT")) {
			if (iEXPORT) {
				rc = ECL_DUPLICATE;
				break;
			}
			n++;
			iEXPORT = 1;
			opt |= D_GX_OPT_SET_EXPORT;
			iOK |= 0x40;
		}
		if (n == n1) {
			ssp->sp = spw;
			break;
		}
		else if (iOK & iCHK2) {
			rc = ECL_SYNTAX_ERROR;
			break;
		}
		spw = ssp->sp;
/*
printf("cl_get_def_modifier_SSP: spw=%d\n",spw);
*/
	}
	if (!rc) {
		check[2] = iOK;
		check[3] = opt;
/*
printf("cl_get_def_modifier_SSP: sp=%d\n",ssp->sp);
*/
		if (rc=cl_get_def_attr_SSP(s,slen,ssp,sep,iParm,bxobj,Obj)) return rc;
		else if (iParm[0] > 0) n++;
		else {
			ssp->sp = spw;
		}
	}
	if (rc) {
		if (rc == ECL_DUPLICATE) ERROROUT1(FORMAT(365),p);
		else ERROROUT1(FORMAT(158),p);
		n = rc;
	}
/*
printf("cl_get_def_modifier_SSP: sp=%d n=%d iOk=%02x opt=%08x iParm[0]=%d\n",
ssp->sp,n,check[2],check[3],iParm[0]);
*/
	return n;
}

/************************************/
/*	cl_def_chk_name_opt				*/
/************************************/
int cl_def_chk_name_opt(varnam,vnlen,func,msg,redef_flg)
char *varnam;
int   vnlen;
char *func,*msg;
int   redef_flg;
{
	static char *p0=NULL;
	char work[256],*p,c;
	int  opt,rc;
	ParList pr_nam;

	opt = 0x1000;
	if (redef_flg) opt |= 0x01;	/* sIhnj */

	if ((c=*varnam)=='$' || c=='%' || c=='#') {
		varnam++;
		vnlen--;
	}
	else c = '\0';
	rc = 0;
	memnzcpy(work,varnam,vnlen,sizeof(work));
/*
printf("cl_def_chk_name_opt: opt=%d\n",opt);
*/
	if (redef_flg) {
		opt |= 0x10;
		if (!c) opt |= 0x20;
		pr_nam.par = work;
		pr_nam.parlen = strlen(work);
		rc = cl_dot_name_check_opt(func,&pr_nam,opt);
	}
	else {
		if (vnlen > Var_NM_MAX) {
			ERROROUT3(FORMAT(496),func,work,vnlen);	/* %s: ϐ(%s)̒(%d)܂B */
			rc = ECL_SCRIPT_ERROR;
		}
		else if (cl_chk_name_opt(varnam,vnlen,opt)) {
			if (func && msg) {
				if (vnlen > 0)
					/* %s: %s(%s)Ă܂B */
					ERROROUT3(FORMAT(432),func,msg,work);
				else
					ERROROUT2(FORMAT(76),func,msg);	/* %s: %s܂B */
			}
			rc = ECL_SCRIPT_ERROR;
		}
		else if (cl_chk_sysvar_name(varnam,vnlen)) {
			ERROROUT2(FORMAT(453),func,work);
			rc = ECL_EX_DEFINE;
		}
		else if (!c) {
			if (cl_is_yoyakugo(work)) {
				ERROROUT2(FORMAT(121),func,work);
				rc = ECL_EX_DEFINE;
			}
		}
	}
	return rc;
}

/************************************/
/*	cl_def_chk_name					*/
/************************************/
int cl_def_chk_name(varnam,vnlen,func,msg)
char *varnam;
int   vnlen;
char *func,*msg;
{
	return cl_def_chk_name_opt(varnam,vnlen,func,msg,0);
}

/************************************/
/*	_get_varname					*/
/************************************/
int _get_varname(s,slen,ssp,proc,bxobj,pp)
char *s;
int  slen;
SSPL_S *ssp;
ProcCT *proc;
GXObject *bxobj[];
char **pp;
{
	int rc,pos,llen,vnlen,iSKIP,len;
	tdtObjHead *pObj;
	tdtInfoParm tInfoParm;
	char c,*p,*line,*varnam;
/*
printf("_get_varname:Enter: bxobj=%016lx bxobj[0]=%016lx\n",bxobj,bxobj[0]);
*/
	if (bxobj && bxobj[0]) {
		line = NULL;
		llen = 0;
		c = '(';
	}
	else {
		iSKIP = 0;
		pos = ssp->sp;
/*
printf("_get_varname: pos=%d s+pos=[%s]\n",pos,s+pos);
*/
		ssp->sp += akxnskipin(s+pos,slen-pos," \t");
		pos = ssp->sp;
/*
printf("_get_varname: pos=%d s+pos=[%s]\n",pos,s+pos);
*/
		if ((c=*(s+pos)) == '(') iSKIP = pos + 1;
		else {
			vnlen = akxtgwnsl(s,slen,ssp,gsep2,0x41);
			varnam = ssp->wd;
			len = akxnskipin(varnam,vnlen,"$%#");
			if (len<=0 || (vnlen>1 && len<=1)) {
/*
printf("_get_varname:Exit: len=%d varnam=[%s] len=%d\n",vnlen,varnam,len);
*/
				return 0;
			}
			pos++;
			llen = vnlen - 1;
			if (len >= vnlen) {
				clpeeksl(s,slen,ssp,gsep2,0x41);
				if (*ssp->wd == '(') iSKIP = ssp->sp + 1;
				else {
					/* _get_varname: [%s]͕ϐɕϊł܂B */
					ERROROUT1(FORMAT(585),strtemp(varnam,vnlen));
					return ECL_SCRIPT_ERROR;
				}
			}
		}
		line = s + pos;
		if (iSKIP) {
			ssp->sp = iSKIP - 1;
			if (rc=cl_skip_to_delm(s,slen,"()",ssp,gsep2,0)) {
				ERROROUT1(FORMAT(433),"_get_varname");	/* %s: JbRĂ܂B */
				return ECL_SCRIPT_ERROR;
			}
			llen = ssp->sp - pos;
		}
	}
	if (bxobj) {
		if (proc) pObj = proc->Obj;
		else pObj = cl_gx_get_scr_obj();
	}
	else pObj = NULL;
/*
printf("_get_varname: llen=%d line=[%s]\n",llen,line);
*/
	if (rc=cl_gx_expsn_obj_opt(line,llen,bxobj,pObj,&tInfoParm,0)) return rc;
	if ((llen=parm_to_char_tmp(&tInfoParm,pp,0)) < 0) return rc;
	if (c != '(') {
		if (!(p=cl_tmp_const_malloc(llen+2))) return -1;
		*p = c;
		memzcpy(p+1,*pp,llen);
		*pp = p;
		llen++;
	}
/*
printf("_get_varname:Exit: bxobj=%016lx bxobj[0]=%016lx vnlen=%d varnam=[%s]\n",bxobj,bxobj[0],llen,*pp);
*/
	return llen;
}

/************************************/
/*	_set_array_info_values			*/
/************************************/
int _set_array_info_values(pInfoParm,tInfoParm2)
tdtInfoParm *pInfoParm,tInfoParm2[];
{
	int  i,rc,len;
	int  nparm;
	char *prnam,id;
	tdtInfoParm tInfoParm,**ppParm,*pInfoParmW,tInfoParmW[2];

	pInfoParmW = tInfoParm2;
	if (pInfoParmW->pi_alen & D_AULN_PARMINFO2) {
		cl_gx_copy_info(tInfoParmW, pInfoParmW);
		if (pInfoParmW->pi_alen & D_AULN_PARMINFO2)
			memcpy(tInfoParmW+1,pInfoParmW+1,sizeof(tdtInfoParm));
		if (rc = _kakko_tenkai(NULL,tInfoParm2,tInfoParmW)) return rc;
	}
	if (pInfoParmW->pi_alen & D_AULN_PARMINFO2) {
		if (nparm=tInfoParm2[1].pi_pos) {
			pInfoParmW = (tdtInfoParm *)tInfoParm2[1].pi_data;
		}
	}
	else {
		nparm = 1;
	}
	if ((id=pInfoParm->pi_id)=='A' || id=='R' || id=='T') {
		if (!(ppParm=(tdtInfoParm **)cl_tmp_const_malloc(sizeof(tdtInfoParm *)*(nparm+2)))) return -1;
		ppParm[0] = pInfoParm;
		ppParm[1] = &tInfoParm;
		cl_set_parm_bin(&tInfoParm,0);
		for (i=0;i<nparm;i++) {
			if (!(pInfoParmW->pi_alen & D_AULN_RANGE_DATA)) pInfoParmW->pi_alen &= ~D_AULN_RANGE_INTVAL;
			ppParm[i+2] = pInfoParmW++;
		}
		if (id == 'T') rc = cl_set_struct(&len,pInfoParm,nparm,&ppParm[2]);
		else rc = cl_set_array(&len,nparm+2,ppParm);
	}
	else if (!id || id==' ') rc = cl_gx_rep_info_set(pInfoParm,&pInfoParmW[nparm-1],1);
	else rc = -1;
	return rc;
}

/************************************/
/*	_set_array_values				*/
/************************************/
int _set_array_values(pInfoParm,prmnum,pprmp,Obj)
tdtInfoParm *pInfoParm;
int      prmnum;
parmList **pprmp;
tdtObjHead *Obj;
{
	int  rc;
	tdtInfoParm tInfoParm2[2];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_set_array_values: prmnum=%d pInfoParm=",pInfoParm,prmnum,0);

	if (rc=cl_gx_exp_obj_opt(prmnum,pprmp,Obj,tInfoParm2,D_GX_OPT_PARMINFO2)) return rc;

	return _set_array_info_values(pInfoParm,tInfoParm2);
}

/************************************/
/*	cl_def_get_psize				*/
/************************************/
int cl_def_get_psize(cn,scrct,proc,opt,ppSize,ppTBL)
char cn;
ScrPrCT *scrct;
ProcCT  *proc;
int opt,**ppSize;
tdtInfoParm ****ppTBL;
{
	int *pSize,rc;
	tdtInfoParm ***pTBL;
/*
printf("cl_def_get_psize:Enter cn=[%c] scrct=%016lx proc=%016lx opt=%08x\n",cn,scrct,proc,opt);
printf("cl_def_get_psize:      ppSize=%016lx ppTBL=%016lx\n",ppSize,ppTBL);
*/
DEBUGOUTL4(140,"cl_def_get_psize:Enter cn=[%c] scrct=%016lx proc=%016lx opt=%08x",cn,scrct,proc,opt);
DEBUGOUTL2(140,"cl_def_get_psize:      ppSize=%016lx ppTBL=%016lx",ppSize,ppTBL);

	if (!ppSize) return -1;
	*ppSize = NULL;
	if (ppTBL) *ppTBL = NULL;
	rc = 0;
	if (!scrct) scrct = cl_search_src_ct();
	if (scrct) {
		if (cn == '#') pTBL = scrct->Vary->pTBL_igeta;
		else if (cn == '%') {
			if (opt & D_GX_OPT_SET_LOCAL) {
				if (!proc) proc = cl_search_proc_ct();
				if (!proc) return SysError;
				pTBL = proc->pTBL_pasento;
			}
			else pTBL = scrct->Vary->pTBL_pasento;
		}
		else pTBL = scrct->Vary->pTBL_dolu;
		if (pTBL) {
			if (ppTBL) *ppTBL = pTBL;
			pSize = (int *)pTBL[0];
DEBUGOUTL4(140,"cl_def_get_psize: pSize = %d %d %d [%s]",pSize[0],pSize[1],pSize[2],&pSize[3]);
DEBUGOUTL2(140,"                          %d %d",pSize[5],pSize[6]);
			*ppSize = pSize;
		}
		else rc = -1;
	}
	else rc = -1;
	return rc;
}

/************************************/
/*	cl_def_map_ary_max_chk			*/
/************************************/
int cl_def_map_ary_max_chk(c,index,scrct,proc,opt)
char c;
int *index;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	int *pSize,i,ndim,m,rc;
	tdtInfoParm ***pTBL_pas;

#if 1	/* 2021.6.14 */
	if ((rc=cl_def_get_psize(c,scrct,proc,opt,&pSize,NULL)) < 0) return rc;
#else
	if (c == '#') pSize = (int *)scrct->Vary->pTBL_igeta[0];
	else if (c == '%') {
		if (opt & D_GX_OPT_SET_LOCAL) {
			if (!proc) return -1;
			if (!(pTBL_pas=proc->pTBL_pasento)) return -1;
		}
		else pTBL_pas =scrct->Vary->pTBL_pasento;
		pSize = (int *)pTBL_pas[0];
	}
	else pSize = (int *)scrct->Vary->pTBL_dolu[0];
#endif
	if (index[3]+index[1]-1 > pSize[2]) {
		/* cl_pr_ex_def_map_ary: ͈͎w(%d[%d,%d,%d])ϐž(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(434),index[0],index[1],index[2],index[3],pSize[2]);
		return ECL_SCRIPT_ERROR;
	}
/*
printf("cl_def_map_ary_max_chk: c=[%c] pSize[2]=%d pSize[7]=%d\n",c,pSize[2],pSize[7]);
printf("cl_def_map_ary_max_chk: index=%d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4]);
*/
	if (c=='$' || c=='%') {
		if ((m=pSize[7]-index[3]+1) > index[2]) index[2] = m;
/*
printf("cl_def_map_ary_max_chk: index[2]=%d\n",index[2]);
*/
	/*	if (index[2] < 0) index[2] = 0;	*/
	}
	return 0;
}

/************************************/
/*	cl_pr_ex_def_map_ary			*/
/*  ̃}bvhzƂɎgpĂ */
/************************************/
int cl_pr_ex_def_map_ary(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	char *argv[6], *_name_;
	XHASHB *pha_vname;
	int  i, iParmNo, rc, vnlen, n, *pSize, ixlen, nparm,len,is,line_len;
	char c, *varnam, *p, *ixnam, wrk[128],*line,*pp;
	tdtInfoParm *pInfoParm,tInfoParm;
	tdtArrayIndex tIndex;
	int *index;
	tdtInfoParm ***pTBL_vname,***pTBL_pas;
	uchar ucLOCAL=0;
	int iARRAY,iEQU,iSET,iCONST;
	SSPL_S ssp;
	parmList *qprmp[MAX_ARRAY_DIM+1];
	tdtObjHead *pObj;

	argv[0] = _name_ = "cl_pr_ex_def_map_ary";
/*
printf("cl_pr_ex_def_map_ary: prmnum=%d pprmp=%016lx scrct=%016lx proc=%016lx opt=%d\n",
prmnum, pprmp, scrct, proc, opt);
*/
DEBUGOUTL5(120,"cl_pr_ex_def_map_ary:Enter prmnum=%d pprmp=%016lx scrct=%016lx proc=%016lx opt=%08x",
prmnum, pprmp, scrct, proc, opt);

	/* parameter check */
	if (!proc && prmnum<2) {
		ERROROUT1(FORMAT(42),_name_);	/* %s: p[^܂B */
		return ECL_EX_DEFINE;
	}
	rc = iEQU = iSET = iCONST = 0;
	iARRAY = 1;
#if 1	/* 2021.5.5 */
	line = pprmp[0]->prp;
	line_len  = pprmp[0]->prmlen;
#else
	line = pprmp[1]->prp;
	line_len  = pprmp[1]->prmlen;
#endif
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL4(120,"%s: prmnum=%d line_len=%d line=[%s]",_name_,prmnum,line_len,line);

	memset(&ssp,0,sizeof(SSPL_S));
	is = ssp.sp;
	/* ϐ̎擾 */
	vnlen = akxtgwnsl(line,line_len,&ssp,gsep,0x41);
	if (vnlen <= 0) {
		ERROROUT1(FORMAT(435),argv[0]);	/* %s: ϐ܂B */
		return ECL_EX_DEFINE;
	}
	memnzcpy(wrk,ssp.wd,vnlen,sizeof(wrk));
	varnam = wrk;
	c = *varnam;
	/* z񖼂ɕϐw\Ƃ */
	if (c=='(' || c=='$' || c=='#' || c=='%') {
		ssp.sp = is;
		if ((len=_get_varname(line,line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		}
	}
/*
printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,strtemp(varnam,vnlen));
*/
	/* z񖼂̃`FbN */
	if (c=='$') {
		vnlen--;
		varnam++;
	}
	else if (c!='#' && c!='%') c = '$';
	p = varnam;
	len = vnlen;
	if (c=='%' || c=='#') {
		p++;
		len--;
	}
	if (rc=cl_def_chk_name(p,len,_name_,FORMAT(441))) return rc;
	/* z`̎擾 */
	nparm = cl_get_array_def_parm(line,line_len,"=",&ssp,gsep,MAX_ARRAY_DIM+1,qprmp,&iEQU);
	if (nparm < 0) return n;
	else if (!nparm) {
		if (proc) iARRAY = 2;
	}
/*
printf("%s: nparm=%d iARRAY=%d iEQU=%d\n",_name_,nparm,iARRAY,iEQU);
*/
DEBUGOUTL4(120,"%s: nparm=%d iARRAY=%d iEQU=%d",_name_,nparm,iARRAY,iEQU);

	if (opt & D_GX_OPT_REDEFINE) {
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,'A',_name_)) return rc;
		iParmNo = 0;
	}
	else {
		if ((iParmNo=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return iParmNo;
		if (iARRAY==2 && !iParmNo) {
			ERROROUT2(FORMAT(438),argv[0],varnam);	/* %s: [%s]͖`łB */
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: iParmNo=%d\n",_name_,iParmNo);
*/
	}
	if (iARRAY == 1) {
		if (nparm>0 && iParmNo>0) {
			/* %s: `ςMAPPEDARRAŶ߃CfbNX܂͎͎wł܂B */
			ERROROUT1(FORMAT(439),_name_);
			return ECL_SCRIPT_ERROR;
		}
		memset(&tIndex,0,sizeof(tdtArrayIndex));
		tIndex.uAttr[0] = DEF_ZOK_VARI;
		tIndex.size = sizeof(tdtInfoParm *);
		index = tIndex.index;
		index[0] = 1;
		index[3] = 1;
		index[4] = 10;
		index[1] = index[4];
/*
printf("cl_pr_ex_def_map_ary:1 index = %d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4]);
*/
		if (rc = _set_index(0,nparm,qprmp,0,index,_name_)) return rc;
		if ((rc=cl_def_map_ary_max_chk(c,index,scrct,proc,opt)) < 0) return rc;
	}

	if (opt & D_GX_OPT_REDEFINE) {
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
	}
	else if (iParmNo > 0) {
		pTBL_vname = (tdtInfoParm ***)argv[1];
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
	}
	else {
		pha_vname  = (XHASHB *)argv[4];
		if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen))<1){
					/* %s: %s%sGgp̋󂫂܂B */
			ERROROUT3(FORMAT(323),_name_,varnam,argv[3]);
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: pha_vname=%016lx varnam=[%s] vnlen=%d iParmNo=%d\n",
argv[0],pha_vname,varnam,vnlen,iParmNo);
*/
		pTBL_vname = (tdtInfoParm ***)argv[5];
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
		if (!pInfoParm) return (ECL_SCRIPT_ERROR);
		info_parm_clear(pInfoParm);
		pInfoParm->pi_id   = 'A';
		pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
		pInfoParm->pi_attr = DEF_ZOK_VARI;
		pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);

		if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return ECL_MALLOC_ERROR;
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));

		if (!(p=Malloc(vnlen+1))) {
			ERROROUT("Array name area malloc");
			return ECL_MALLOC_ERROR;
		}
		strnzcpy(p,varnam,vnlen);
		pInfoParm->pi_pos = (long)p;

		if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
		else pInfoParm->pi_hlen = scrct->ScrGid;

		if (c=='%' && (opt & D_GX_OPT_SET_LOCAL)) ucLOCAL = D_AUX1_LOCAL_VAR;
		pInfoParm->pi_aux[1] = ucLOCAL;
#if 0	/* 2021.6.14 */
		cl_get_array_index_tbl(pInfoParm,NULL,NULL,NULL);
#endif
DEBUGOUT_InfoParm(120,"%s: pInfoParm:",pInfoParm,_name_,0);

		if ((rc=cl_gx_clear_var_define(scrct,proc,p,opt)) < 0) return rc;
	}
	if (iEQU) {
/*
printf("%s: iARRAY=%d is=%d prmnum=%d\n",argv[0],iARRAY,is,prmnum);
printf("%s: iEQU=%d ssp.sp=%d\n",argv[0],iEQU,ssp.sp);
*/
#if 1	/* 2021.5.5 */
		pprmp[1]->prp = line + iEQU;
		pprmp[1]->prmlen = line_len - iEQU;
#else
		pprmp[2]->prp = line + iEQU;
		pprmp[2]->prmlen = line_len - iEQU;
#endif
		if (proc) pObj = proc->Obj;
		else pObj = scrct->Obj;
		rc = _set_array_values(pInfoParm,1,&pprmp[1],pObj);
	}
DEBUGOUTL2(120,"Exit %s: rc=%d",_name_,rc);
	return rc;
}

/************************************/
/*									*/
/************************************/
static int _mk_tmp_var_exp(par_exp,scrct,proc,opt,line,line_len,ssp,ieq,mcat,tmpvname,ppInfoParm,piOpt)
ParList *par_exp;
ScrPrCT *scrct;
ProcCT  *proc;	/* defineR}ĥƂ́ANULL */
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
char *line;
int   line_len;
SSPL_S *ssp;
int    ieq;
MCAT *mcat;
char *tmpvname;
tdtInfoParm **ppInfoParm;
int *piOpt;
{
	int  atr,iFound,iParmNo,tmpvnlen,opt_tmp,iOpt,gid;
	char c, *argv[6],*p;
	tdtInfoParm ***pTBL_vname,*pInfoParm;
	XHASHB *pha_vname;

	argv[0] = "_mk_tmp_var_exp";
/*
printf("%s: Enter opt=%08x line_len=%d ssp->sp=%d ieq=%d iOpt=%08x\n",argv[0],opt,line_len,ssp->sp,ieq,*piOpt);
*/
DEBUGOUTL5(120,"%s: Enter opt=%08x line_len=%d ssp->sp=%d ieq=%d",argv[0],opt,line_len,ssp->sp,ieq);
DEBUGOUTL2(120,"%s: Enter iOpt=%08x",argv[0],*piOpt);

	iFound = 0;
	while ((atr=cmpgwnsl(line,line_len,ssp,0)) > 0) {
/*
printf("%s: atr=%d\n",argv[0],atr);
*/
		if (atr==3000 || atr==10000) iFound = 1;
		break;
	}
	if (!iFound) return 0;

	gid = ++pGLprocTable->gid;
	sprintf(tmpvname,"_%x_%d",proc,gid);
/*
printf("%s: tmpvname=[%s]\n",argv[0],tmpvname);
*/
	tmpvnlen = strlen(tmpvname);
	opt_tmp = (opt & ~D_GX_OPT_SET_SCOPE) | D_GX_OPT_SET_LOCAL;
	if ((iParmNo=_chk_define(scrct,proc,tmpvname,tmpvnlen,opt_tmp,argv)) < 0) return iParmNo;
	if (iParmNo) pTBL_vname = (tdtInfoParm ***)argv[1];
	else {
		pha_vname  = (XHASHB *)argv[4];
		if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,tmpvname,tmpvnlen))<1){
				/* %s: %s%sGgp̋󂫂܂B */
			ERROROUT3(FORMAT(323),argv[0],tmpvname,argv[3]);
			return ECL_SCRIPT_ERROR;
		}
		pTBL_vname = (tdtInfoParm ***)argv[5];
	}
	pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);

DEBUGOUTL4(111,"%s:tmpvname: scope=%s iParmNo=%d pInfoParm=%016lx",argv[0],argv[3],iParmNo,pInfoParm);

	if (!pInfoParm) return ECL_SCRIPT_ERROR;

	cl_im_mman_init(mcat,"DF",256,0,D_OPT_ALC_TMP);
	cl_im_mcat(mcat,tmpvname,tmpvnlen);
	cl_im_mcat(mcat,line+ieq,line_len-ieq);
	p = mcat->mc_bufp;

DEBUGOUTL2(111,"%s: p=[%s]",argv[0],p);

	par_exp->par = p;
	par_exp->parlen = mcat->mc_ipos;

	*ppInfoParm = pInfoParm;
	*piOpt = (*piOpt & ~D_GX_OPT_SET_SCOPE) | D_GX_OPT_SET_LOCAL;

	return tmpvnlen;
}

/************************************/
/*	cl_pr_ex_def_scalar_attr_info	*/
/************************************/
int cl_pr_ex_def_scalar_attr_info(prmnum, pprmp, scrct, proc, opt, iParm, ppInfoParm)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;	/* defineR}ĥƂ́ANULL */
int      opt;	/* 0x01=0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
int      iParm[];
tdtInfoParm  **ppInfoParm;
{
	int  i,iParmNo,rc,vnlen,iOpt,iNew,len,iCONST,isp,iAux,iSet,tmpvnlen,isp1,ieq;
	int  iFound,option,line_len,vnlen0,opt_tmp,iSCOPE,iCHKDEF,iDef;
	char c,*varnam,*p,*argv[6],*pp,cLET,*vrn,*line,*varnam0,*pexp,id;
	prmList *pprmList;
	GWPRM_S gwprm;
	SSPL_S ssp;
	char wrk[4096],tmpvname[40];
	int atr,attr,atr0,size,size_old,attr_old,alsize,iParm_old[4];
	Leaf tLeaf;
	tdtInfoParm  *pInfoParm,tInfoParm1,*pInfoParm2;
	parmList   qpL;
	tdtInfoParm ***pTBL_vname;
	XHASHB *pha_vname;
	MCAT mcat;
	ParList par_exp;

	argv[0] = "cl_pr_ex_def_scalar_attr_info";
/*
printf("%s:Enter: proc=%016lx opt=%08x prmnum=%d iParm=%d %d %d %d\n",argv[0],proc,opt,prmnum,iParm[0],iParm[1],iParm[2],iParm[3]);
*/
DEBUGOUTL3(120,"%s:Enter: opt=%08x prmnum=%d",argv[0],opt,prmnum);
DEBUGOUTL5(120,"%s: iParm=%d %d %d %d",argv[0],iParm[0],iParm[1],iParm[2],iParm[3]);

	iCONST = 0;
	if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
	iOpt = opt & D_GX_OPT_SET_SCOPE;
	if (!proc && !iOpt) {
		opt |= D_GX_OPT_SET_PRIVATE;
	}
	if (opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL)) {
		iOpt |= D_GX_OPT_ALC_CONST;
	}
	iSCOPE = iOpt & D_GX_OPT_SET_SCOPE;
	attr = iParm[0];
	gwprm.line = pprmp[0]->prp;
	gwprm.line_len = pprmp[0]->prmlen;

DEBUGOUTL3(120,"%s: opt=%08x iOpt=%08x",argv[0],opt,iOpt);
DEBUGOUTL4(120,"%s: attr=%d line_len=%d line=[%s]",argv[0],attr,gwprm.line_len,gwprm.line);
/*
printf("%s: opt=%08x iOpt=%08x\n",argv[0],opt,iOpt);
printf("%s: attr=%d line_len=%d line=[%s]\n",argv[0],attr,gwprm.line_len,gwprm.line);
*/
	pprmp[1]->prp = line = gwprm.line + prmnum;
	pprmp[1]->prmlen = line_len = gwprm.line_len - prmnum;
/*
printf("%s: line_len=%d line=[%s]\n",argv[0],line_len,line);
*/
	ssp.sp = prmnum;
	ssp.wd = wrk;
	ssp.wdmax = sizeof(wrk);
	atr0 = cmp_gtwd(&gwprm,&ssp,0);
	vnlen  = strlen(wrk);
	varnam = wrk;
/*
printf("%s: vnlen=%d varnam=[%s] atr0=%d ssp.sp=%d\n",argv[0],vnlen,varnam,atr0,ssp.sp);
*/
DEBUGOUTL5(120,"%s: vnlen=%d varnam=[%s] atr0=%d ssp.sp=%d",argv[0],vnlen,varnam,atr0,ssp.sp);

	isp1 = ssp.sp;
	ssp.wd = wrk + vnlen + 1;
	ssp.wdmax -= vnlen + 1;
	atr = cmp_gtwd(&gwprm,&ssp,0);
	c = *ssp.wd;

DEBUGOUTL2(120,"%s: c=%c",argv[0],c);

	cLET = c;
	rc = iNew = isp = ieq = iDef = 0;
	if (proc) {
		if (attr || (opt & D_GX_OPT_SET_CONST)) iDef = 1;
		if (!attr && !(opt & (D_GX_OPT_SET_SCOPE | D_GX_OPT_SET_CONST))) iNew = 1;
		else if (!attr && (atr0>=14 && atr0<=17)) iNew = 1;
		else {
			while ((atr<71 || atr>90)&&(atr<14 || atr>17)) {
				isp1 = ssp.sp;
				if ((atr=cmp_gtwd(&gwprm,&ssp,0)) <= 0) break;

DEBUGOUTL2(121,"%s: atr=%d",argv[0],atr);

			}
			if ((atr>=71 && atr<=90)||(atr>=14 && atr<=17)) {
				if (!attr) iNew = 1;
			/*	else if (c != '=') rc = -1;	*/
				isp = ssp.sp;
				ieq = isp1;

DEBUGOUTL4(120,"%s: ieq=%d [%c] isp=%d",argv[0],ieq,*(gwprm.line+ieq),isp);

			}
			else if (atr0!=62 && atr0<=100/* || c*/) rc = -2;
		}
		cLET = *ssp.wd;

DEBUGOUTL2(120,"%s: cLET=[%c]",argv[0],cLET);

	}
	else iDef = 1;
	if (opt & D_GX_OPT_REDEFINE) iNew = 0;	/* 2021.2.8 */

DEBUGOUTL4(120,"%s: attr=%d atr0=%d c=[%c]",argv[0],attr,atr0,c);
DEBUGOUTL5(120,"%s: atr=%d iDef=%d iNew=%d wd=[%s]",argv[0],atr,iDef,iNew,ssp.wd);

	if (rc) {
		ERROROUT2(FORMAT(440),argv[0],rc);	/* %s: SYNTAXĂ܂Brc=%d */
		return ECL_SCRIPT_ERROR;
	}
	else if (!iDef && iNew) {
		tLeaf.cmd.prmnum = 1;
		tLeaf.cmd.prmp = &pprmp[1];
		iOpt |= D_GX_OPT_GET_ADDR;
		pInfoParm = NULL;
/*
printf("%s: exec let_compute_info() iNew=%d proc=%016lx iOpt=%08x line=[%s]\n",argv[0],iNew,proc,iOpt,line);
*/
		if ((rc=let_compute_info(&tLeaf,proc,iOpt,&pInfoParm)) < 0) return rc;
		if (pInfoParm && iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
		if (ppInfoParm) *ppInfoParm = pInfoParm;
/*
printf("%s: exec let_compute_info() rc=%d\n",argv[0],rc);
*/
/*
DEBUGOUT2("%s: bxobj=%016lx",argv[0],pprmp[1]->bxobj);
*/
		return 0;
	}
/*
printf("%s: varnam=[%s]\n",argv[0],varnam);
*/
	opt |= D_GX_OPT_DEFINE;

	/* ϐ̎擾 */
	c = *varnam;
	/* ϐɕϐw\Ƃ */
	if (c=='(' || c=='$') {
		memset(&ssp,0,sizeof(SSPL_S));
		ssp.sp = prmnum;
		if ((len=_get_varname(gwprm.line,gwprm.line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		}
	}

DEBUGOUTL3(120,"%s: vnlen=%d varnam=[%s]",argv[0],vnlen,strtemp(varnam,vnlen));

	varnam0 = varnam;
	vnlen0 = vnlen;
	if (c == '$') {
		varnam++;
		vnlen--;
	}
	else if (c=='%' || c=='#') {
		ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}

	if (!proc) {
		if (rc=cl_def_chk_name(varnam0,vnlen0,argv[0],FORMAT(441))) return rc;	/* ϐ */
	}
	else if (cl_chk_name(varnam,vnlen)) {
		ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}
	iSet = opt & 0x01;
	tmpvnlen = 0;
	iNew = iCHKDEF = 0;
	if (opt & D_GX_OPT_REDEFINE) {
		iSet = 1;
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,' ',argv[0])) return rc;
		pInfoParm->pi_aux[1] &= ~D_AUX1_PROTECTED;	/* 2021.2.8 */
		pInfoParm2 = pInfoParm;
		if (proc && isp>0 && ieq) {
			ssp.sp = isp;
			tmpvnlen = _mk_tmp_var_exp(&par_exp,scrct,proc,opt,gwprm.line,gwprm.line_len,&ssp,ieq,&mcat,tmpvname,&pInfoParm,&iOpt);
			if (tmpvnlen < 0) return tmpvnlen;
			else if (tmpvnlen > 0) {
				pprmp[1]->prp = par_exp.par;
				pprmp[1]->prmlen = par_exp.parlen;
				pprmp[1]->bxobj = NULL;
				cl_gx_copy_info(pInfoParm,pInfoParm2);
			}
		}
		attr_old = pInfoParm->pi_attr;
		if (!attr) attr = attr_old;
		if ((attr>=DEF_ZOK_BINA && attr<=DEF_ZOK_DECI) && (attr_old>=DEF_ZOK_BINA && attr_old<=DEF_ZOK_DECI)) ;
		else if (attr != attr_old) {
			/* %s:̑(%d)ƍĒ`(%d)Ă܂B */
			ERROROUT3(FORMAT(442),argv[0],attr_old,attr);
			return ECL_SCRIPT_ERROR;
		}
		if (opt & D_GX_OPT_SET_CLEAR) {
			info_parm_clear(pInfoParm);
			cl_set_parm_init(pInfoParm,iParm,0x01);
		}
		else if (pInfoParm->pi_aux[0]) {
			if (attr_old==DEF_ZOK_CHAR || attr_old==DEF_ZOK_BULK) {
				alsize = size = iParm[1];
				if (size > 0) {
					size_old = pInfoParm->pi_len;
					p = pInfoParm->pi_data;
					if (size > size_old) {
						if (attr == DEF_ZOK_CHAR) alsize++;
						else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
						if (!(p=Realloc(p,alsize))) return -1;
						pInfoParm->pi_paux = pInfoParm->pi_data = p;
						if (attr == DEF_ZOK_BULK) {
							memcpy(&len,p+size_old,sizeof(int));
							memcpy(p+size,&len,sizeof(int));
						}
					}
					else if (size < size_old) {
						if (attr == DEF_ZOK_BULK) {
							memcpy(&len,p+size_old,sizeof(int));
							len = X_MIN(size,len);
							memcpy(p+size,&len,sizeof(int));
						}
						else {
							*(p+size) = '\0';
							len = strlen(p);
						}
					}
					pInfoParm->pi_dlen = len;
				}
				pInfoParm->pi_len = size;
			}
			else if (attr == attr_old) {
				if (attr==DEF_ZOK_DECI &&
				    (pInfoParm->pi_hlen!=iParm[2] || pInfoParm->pi_pos!=iParm[3])) {
					pInfoParm->pi_hlen = iParm[2];	/* precision */
					pInfoParm->pi_pos = iParm[3];	/* scale */
					if ((rc=cl_mpa_scale(pInfoParm->pi_data,iParm[2],iParm[3])) < 0) return rc;
					rc = 0;
				}
			}
			else if (attr>=DEF_ZOK_BINA && attr<=DEF_ZOK_DECI) {
				cl_gx_copy_info(&tInfoParm1,pInfoParm);
				cl_set_parm_init(pInfoParm,iParm,0x01);
				rc = cl_gx_rep_val_set(pInfoParm,&tInfoParm1);
				info_parm_clear(&tInfoParm1);
			}
		}
	}
	else {
#if 0	/* 2021.2.21 */ /* Őݒ肷ƁA`ς݂łA_chk_define()==0 ƂȂ */
		if (!(opt & D_GX_OPT_SET_SCOPE) && proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
		}
#endif
		if ((iParmNo=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return iParmNo;
		iAux = (int)argv[2];
		if (iParmNo) {
			iCHKDEF = 1;
			pTBL_vname = (tdtInfoParm ***)argv[1];
			if (!(opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				iSet = 1;
				iNew = 1;	/* PUBLIC/GLOBALłȂAredefinełȂƂ́AɎw̃f[^^ŏB */
			}
#if 1	/* 2021.2.19 */
			else {
				if (proc) iSet = 1;
			}
#endif
		}
		else {
			pha_vname = (XHASHB *)argv[4];
			if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen))<1){
					/* %s: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
				return ECL_SCRIPT_ERROR;
			}
			pTBL_vname = (tdtInfoParm ***)argv[5];
			iSet = iNew = 1;
		}

		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);

DEBUGOUTL5(111,"%s: iNew=%d iSet=%d iParmNo=%d pInfoParm=%016lx",argv[0],iNew,iSet,iParmNo,pInfoParm);

		if (!pInfoParm) return ECL_SCRIPT_ERROR;
		pInfoParm2 = pInfoParm;
#if 0
		if (iCHKDEF && iDef && iNew) {	/* iNew!=0 ̂Ƃ́Alocal or private */
DEBUGOUT_InfoParm(120,"%s:",pInfoParm,argv[0],0);
			if (cl_get_info_fixed_attr(pInfoParm,iParm_old) || (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED)) {
						/* %s: ϐ[%s]͒`ς݂łB*/
				ERROROUT2(FORMAT(617),argv[0],varnam);
				return ECL_SCRIPT_ERROR;
			}
		}
#endif
/*
printf("%s: iCHKDEF=%d proc=%016lxisp=%d ieq=%d\n",argv[0],iCHKDEF,proc,isp,ieq);
*/
		if (iCHKDEF && proc && isp>0 && ieq) {
			ssp.sp = isp;
			tmpvnlen = _mk_tmp_var_exp(&par_exp,scrct,proc,opt,gwprm.line,gwprm.line_len,&ssp,ieq,&mcat,tmpvname,&pInfoParm,&iOpt);
			if (tmpvnlen < 0) return tmpvnlen;
			else if (tmpvnlen > 0) {
				pprmp[1]->prp = par_exp.par;
				pprmp[1]->prmlen = par_exp.parlen;
				pprmp[1]->bxobj = NULL;
			}
		}
		if (!iSet || !cLET) {
			if ((rc=cl_gx_clear_var_define(scrct,proc,varnam,opt)) < 0) return rc;
		}
#if 1	/* 2021.2.19 */
		if (iNew) {
			if ((c=pInfoParm->pi_id)==' ' || !c) {
				if (c && !tmpvnlen) info_parm_clear(pInfoParm);
				if (!iParm[0]) iParm[0] = DEF_ZOK_VARI;
				cl_set_parm_init(pInfoParm,iParm,0x01);
			}
		}
		else {
			if (iParm[0] != (attr_old=pInfoParm->pi_aux[0])) {
						/* %s: f[^^قȂĂ܂Bold=%d new=%d */
				ERROROUT3(FORMAT(450),argv[0],attr_old,iParm[0]);
				if (cl_get_option(23,0) & 0x01) return ECL_SCRIPT_ERROR;
				else ERROROUT2(FORMAT(611),argv[0],varnam);	/* %s:(W)%s̃f[^^w𖳎܂B */
			}
		}
#else
		if (iNew && ((c=pInfoParm->pi_id)==' ' || !c)) {
			if (c && !tmpvnlen) info_parm_clear(pInfoParm);
			if (!iParm[0]) iParm[0] = DEF_ZOK_VARI;
			cl_set_parm_init(pInfoParm,iParm,0x01);
		}
		else if (iParm[0]) {
			ERROROUT2(FORMAT(611),argv[0],varnam);	/* %s:(W)%s̃f[^^w𖳎܂B */
		}
#endif
	}

DEBUGOUT_InfoParm(160,"%s:",pInfoParm2,argv[0],0);

	if (ppInfoParm) *ppInfoParm = pInfoParm2;
/*
if (scrct) {
DEBUGOUTL3(111,"%s: ProCT=%016lx Vary=%016lx",argv[0],scrct->ProCT,scrct->Vary);
}
*/
	if (iSet) {
		if (cLET) {
		/*
			if (iSCOPE) {
				iOpt &= ~iSCOPE;
				pp = cl_get_scope_name_from_opt(iSCOPE);
				len = strlen(pp);
				if (!(p=cl_tmp_const_malloc(pprmp[1]->prmlen+2+len))) return ECL_MALLOC_ERROR;
				memcpy(p,pp,len);
				*(p+len) = ' ';
				memzcpy(p+len+1,pprmp[1]->prp,pprmp[1]->prmlen);
				pprmp[1]->prp = p;
				pprmp[1]->prmlen += len+1;
			}
		*/
/*
printf("%s: exec let_compute_opt() iOpt=%08x p=[%s]\n",argv[0],iOpt,pprmp[1]->prp);
*/
			tLeaf.cmd.prmnum = 1;
			tLeaf.cmd.prmp = &pprmp[1];
			rc = let_compute_opt(&tLeaf,proc,iOpt);
/*
if (scrct) {
DEBUGOUTL3(111,"%s:after LET: ProCT=%016lx Vary=%016lx",argv[0],scrct->ProCT,scrct->Vary);
}
*/
/*
DEBUGOUT2("%s: bxobj=%016lx",argv[0],pprmp[isp]->bxobj);
*/
		}
	}
	else if (cLET) {
		ERROROUT2(FORMAT(612),argv[0],varnam);	/* %s:(W)%s̃f[^̑𖳎܂B */
	}
DEBUGOUT_InfoParm(160,"%s:2 pInfoParm=",pInfoParm,argv[0],0);
	if (tmpvnlen) {
		if (c) info_parm_clear(pInfoParm2);
		cl_gx_copy_info(pInfoParm2,pInfoParm);
		pInfoParm2->pi_aux[1] = (pInfoParm2->pi_aux[1] & ~D_AUX1_LOCAL_VAR) | cl_gx_get_aux1_from_opt(iSCOPE);
DEBUGOUT_InfoParm(160,"%s:3 pInfoParm2=",pInfoParm2,argv[0],0);
		if (opt & D_GX_OPT_SET_EXPORT) pInfoParm2->pi_aux[0] |= D_AUX0_VAR_EXPORT;
		cl_parm_set0(pInfoParm);
	}
	if (iCONST) pInfoParm2->pi_aux[1] |= D_AUX1_PROTECTED;
	return rc;

 Parm_Less:
	ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
	return ECL_SCRIPT_ERROR;
}

/************************************/
/*	cl_pr_ex_def_array              */
/************************************/
int cl_pr_ex_def_array(cmdobj,prmnum,pprmp,scrct,proc,opt)
CMDObject *cmdobj;
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	int  i,rc,vnlen,n,len,is,line_len,pos,pos_var_end,nvar,posa[4],rc_srch_equ,kind,type,scope,attr;
	char c,*varnam,*pp,*p,*argv[6],*line,wrk[128],**da;
	tdtInfoParm *pInfoParm,*pParmIO[2],tInfoParm,tInfoParm2[2];
	int iParm[MAX_ARRAY_DIM+1],check[4],*obj,npr,iob,exec_flg,ipr,ida,ipr_pos,ida_nam,iob_ary;
	tdtObjHead *pObj;
	int iARRAY,iEQU,iCONST,iSKIP,iSTATIC,iCLEAR,iCOM,iARRAY0,iMAPPED,iEXPORT;
	Leaf tLeaf;
	SSPL_S ssp;
	parmList *qprmp[MAX_ARRAY_DIM+1];

	argv[0] = "cl_pr_ex_def_array";

	/* parameter check */
	if (prmnum < 1) {
		ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
		return ECL_SCRIPT_ERROR;
	}
	iCLEAR = iSTATIC = iCONST = iARRAY = iEQU = iSKIP = iMAPPED = iEXPORT = 0;
	mem_set_int(iParm,0,4);
	line = pprmp[0]->prp;
	line_len = pprmp[0]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL4(170,"%s: prmnum=%d line_len=%d line=[%s]",argv[0],prmnum,line_len,line);
	memset(&ssp,0,sizeof(SSPL_S));

	exec_flg = 0;
	if (proc) pObj = proc->Obj;
	else pObj = scrct->Obj;
/*
printf("cl_pr_ex_def_array: proc=%016lx scrct=%016lx pObj=%016lx\n",proc,scrct,pObj);
*/
DEBUGOUTL4(170,"%s: proc=%016lx scrct=%016lx pObj=%016lx",argv[0],proc,scrct,pObj);

	if (cmdobj->nobj) goto Exobj;

	if (!(obj=cmdobj->exobj)) cl_im_expand(CLcList.mcat_obj,50,&obj);
	if (!(da=cmdobj->da)) cl_im_expand(CLcList.mcat_da,10,&da);
	npr = ida = 0;
	obj[0] = 0;	/* sub_id */
	obj[1] = 0;	/* npr */
	obj[2] = 3;	/* ipr_pos */
	iob = obj[2];

	/* ̎擾 */
	exec_flg = 1;
	npr++;
	obj[iob++] = 1;	/* hc̎擾 */
	ipr_pos = iob++;
	obj[iob++] = ida;	/* w莮 */
	da[ida] = NULL;
	check[1] = 0x7f;
	if ((n=cl_get_def_modifier_SSP(line,line_len,&ssp,gsep,check,iParm,&da[ida],pObj)) < 0) return n;
	else if (n > 0) {
		if (check[2]) {
			if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
			opt |= check[3];
			if (!proc && (opt & D_GX_OPT_SET_LOCAL)) {
				ERROROUT1(FORMAT(443),argv[0]);	/* %s: LOCAL͎wł܂B */
				return ECL_SCRIPT_ERROR;
			}
			if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
			if (opt & D_GX_OPT_SET_ARRAY) iARRAY = 1;
			if (opt & D_GX_OPT_SET_STATIC) iSTATIC = 1;
			if (opt & D_GX_OPT_SET_CLEAR) iCLEAR = 1;
			if (opt & D_GX_OPT_SET_MAPPED) {
				iARRAY = iMAPPED = 1;
			}
			if (opt & D_GX_OPT_SET_EXPORT) iEXPORT = 1;
/*
printf("%s: iCONST=%016lx iARRAY=%d iMAPPED=%d iSTATIC=%d iCLEAR=%d\n",argv[0],iCONST,iARRAY,iMAPPED,iSTATIC,iCLEAR);
*/
		}
	}

	/* ̃T[` */
	is = ssp.sp;
	if ((len=_define_srch_equ(line,line_len,&ssp,posa)) < 0) return len;
	iEQU = posa[0];
	pos_var_end = posa[1];
	kind = posa[2];
/*
printf("%s: pos_var_end=%d iEQU=%d len=%d\n",argv[0],pos_var_end,iEQU,len);
*/
	if (len<0 || (kind & 4)) {
		ERROROUT1(FORMAT(171),argv[0]);	/* %s: SYNTAXG[B */
		return ECL_EX_DEFINE;
	}

#if 1	/* 2021.1.18 */
	type = 0;
	if (!iParm[0] && !iARRAY) {
		if ((type=cl_get_def_type(line,pos_var_end,&ssp,is,proc,NULL,0,iParm,&tInfoParm)) < 0) return type;
		else if (type) is = ssp.sp;
	}
#endif
	if (iMAPPED || type==D_AUX0_TYPE_MAPPED) {
		rc = 0;
		*wrk = '\0';
		if (opt & (D_GX_OPT_SET_SCOPE & ~D_GX_OPT_SET_PRIVATE)) {
			strcpy(wrk,FORMAT(513));
			rc = ECL_SCRIPT_ERROR;
		}
		if ((attr=iParm[0]) && attr!=DEF_ZOK_VARI) {
			if (rc) strcat(wrk,FORMAT(514));
			strcat(wrk,FORMAT(571));
			rc = ECL_SCRIPT_ERROR;
		}
		if (rc) {
			ERROROUT2(FORMAT(125),argv[0],wrk);	/* %s: [%s]Ă܂B*/
			return ECL_SCRIPT_ERROR;
		}
	}

	ida++;
	memcpy(&obj[iob],iParm,sizeof(int)*6);
	iob += 6;

	obj[iob++] = opt;
	obj[iob++] = iEQU;		/* add 2020.11.3 */
	obj[iob++] = iCONST;
/*
printf("%s: is=%d iob=%d\n",argv[0],is,iob);
*/
	/* 2020.11.1 */
	/* ϐ̒` */
	iParm[6] = is;
	iParm[7] = pos_var_end;
	iParm[8] = npr;
	iParm[9] = ipr_pos;
	cmdobj->nobj  = iob;
	cmdobj->nda   = ida;
	cmdobj->exobj = obj;
	cmdobj->da    = da;
	rc = cl_def_var_mult(cmdobj,prmnum,pprmp,scrct,proc,opt,iParm);
	if (rc < 0) return rc;
	npr     = iParm[8];
	ipr_pos = iParm[9];
	nvar    = iParm[10];
	iARRAY  = iParm[11];
	iob_ary = iParm[12];
	iob = cmdobj->nobj;
	ida = cmdobj->nda;
	obj = cmdobj->exobj;
	da  = cmdobj->da;
/*
printf("%s: nvar=%d iARRAY=%d iob_ary=%d\n",argv[0],nvar,iARRAY,iob_ary);
*/
	if (nvar==1 && iARRAY<0 && !type) {
		npr--;
		iob -=2;
		obj[1] = npr;
		obj[iob_ary] = -2;

if (DEBUGOUTCHECK(250)) {
for (i=0;i<iob;i++)
DEBUGOUTL2(250,"SCLR: obj[%d]=%d",i,obj[i]);
for (i=0;i<ida;i++)
DEBUGOUTL3(250,"SCLR: da[%d]=0x%016lx[%s]",i,da[i],da[i]);
}
		cmdobj->nobj = iob;
		cmdobj->nda = ida;
		cmdobj->exobj = (int *)clmemdup(obj,iob*sizeof(int),0);		/* LEAF */
		cmdobj->da = (char **)clmemdup(da,ida*sizeof(char *),0);

		return cl_pr_ex_def_scalar_attr_info(is,pprmp,scrct,proc,opt,iParm,&pInfoParm);
	}

	cl_im_expand(CLcList.mcat_obj,iob+4,&obj);
	cl_im_expand(CLcList.mcat_da,ida+1,&da);

	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 5;	/* hc */
	ipr_pos = iob++;

	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 6;	/* hcCONST */
	ipr_pos = iob++;

	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 7;	/* hcpInfoParmԂ */
	ipr_pos = iob++;
/*
printf("%s: iob=%d ida=%d da=%016lx npr=%d\n",argv[0],iob,ida,da,npr);
*/
	obj[iob++] = ida++;

	obj[1] = npr;

if (DEBUGOUTCHECK(250)) {
for (i=0;i<iob;i++)
DEBUGOUTL2(250,"ARRY: obj[%d]=%d",i,obj[i]);
for (i=0;i<ida;i++)
DEBUGOUTL3(250,"ARRY: da[%d]=0x%016lx[%s]",i,da[i],da[i]);
}
	cmdobj->nobj  = iob;
	cmdobj->nda   = ida;
	cmdobj->exobj = (int *)clmemdup(obj,iob*sizeof(int),0);
	cmdobj->da    = (char **)clmemdup(da,ida*sizeof(char *),0);

	if (iEQU && (kind & 2)) {
		memzcpy(wrk,line+posa[3],iEQU-posa[3]);
				/* %s:(W)Zq[%s]́Awł܂B'='ƌȂ܂B */
		ERROROUT2(FORMAT(608),argv[0],wrk);
	}

Exobj:

	rc = cl_pr_ex_def_array_engine(cmdobj,prmnum,pprmp,scrct,proc,opt);
/*
printf("%s: return cl_pr_ex_def_array_engine() rc=%d\n",argv[0],rc);
*/
	if (rc == C_EX_DEF_SCALAR) rc = 0;
	return rc;
}

/************************************/
/*	_get_def_type					*/
/************************************/
static int _get_def_type(pp,proc,iParm)
char *pp;
ProcCT *proc;
int iParm[];
{
	SSPL_S ssp;
	tdtInfoParm tInfoParm;
/*
printf("_get_def_type: pp=[%s]\n",pp);
*/
	memset(&ssp,0,sizeof(SSPL_S));
	return cl_get_def_type(pp,strlen(pp),&ssp,0,proc,NULL,1,iParm,&tInfoParm);
}

/************************************/
/*	cl_pr_ex_def_array_engine		*/
/************************************/
int cl_pr_ex_def_array_engine(cmdobj,prmnum,pprmp,scrct,proc,opt)
CMDObject *cmdobj;
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	XHASHB *pha_vname;
	tdtInfoParm ***pTBL_vname;
	int  i,iParmNo,rc,vnlen,n,len,iARRAY,iEQU,is,line_len,count,vlen,dot_opt,optw;
	int  attr,size,nparm,attr_old,type,def_attr;
	char c,*varnam,*pp,*p,*p_old,*argv[6],*line,**da,*vnam,id;
	tdtInfoParm *pInfoParm,**ppParm,*pInfoDef,tInfoParm2[2];
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	int iParm[MAX_ARRAY_DIM+1],iParm_old[4];
	int check[4],*obj,npr,iob,exec_flg,ipr,ida,ipr_pos,ida_nam;
	tdtObjHead *pObj;
	int iCONST,iSET,iNAME_OPT,iGET_NAM,iSTATIC,iCLEAR,iMAPPED,iEXPORT;
	parmList *qprmp[MAX_ARRAY_DIM+1];
	tdtObjHead *phObj;
	tdtDefType *pDeftypeP;
	SSPL_S ssp;
	uchar ucLOCAL;

	argv[0] = "cl_pr_ex_def_array_engine";

	/* parameter check */
	if (prmnum < 1) {
		ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
		return ECL_SCRIPT_ERROR;
	}

	iCLEAR = iSTATIC = iCONST = iARRAY = iMAPPED = iEQU = iSET = iParmNo = iGET_NAM = iEXPORT = 0;
	if (opt & D_GX_OPT_SET_CLEAR) iCLEAR = 1;
	if (opt & D_GX_OPT_SET_MAPPED) iMAPPED = 1;
	memset(&ssp,0,sizeof(SSPL_S));
	mem_set_int(iParm,0,4);
	type = 0;
	pInfoDef = NULL;
	pDeftypeP = NULL;
	attr_old = attr = 0;
	size = sizeof(tdtInfoParm *);
	line = pprmp[0]->prp;
	line_len = pprmp[0]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL5(120,"%s:Enter: prmnum=%d opt=%08x line_len=%d line=[%s]",argv[0],prmnum,opt,line_len,line);

	exec_flg = 0;
	if (proc) pObj = proc->Obj;
	else pObj = scrct->Obj;

DEBUGOUTL5(170,"%s: proc=%016lx scrct=%016lx pObj=%016lx cmdobj->nobj=%d",argv[0],proc,scrct,pObj,cmdobj->nobj);

	if (cmdobj->nobj <= 0) {
		ERROROUT1(FORMAT(606),argv[0]);	/* %s: zϐ`R}h܂B */
		return ECL_SCRIPT_ERROR;
	}
	obj = cmdobj->exobj;
	da = cmdobj->da;
	npr = obj[1];
	ipr_pos = obj[2];

DEBUGOUTL4(170,"%s: exec_flg=%d obj[1]=%d obj[2]=%d",argv[0],exec_flg,obj[1],obj[2]);

	while (npr-- > 0) {
		ipr = obj[ipr_pos];
		iob = ipr_pos + 2;
		ipr_pos = obj[ipr_pos+1];
/*
printf("%s: npr=%d ipr=%d iob=%d ipr_pos=%d\n",argv[0],npr,ipr,iob,ipr_pos);
*/
DEBUGOUTL5(170,"%s: npr=%d ipr=%d iob=%d ipr_pos=%d",argv[0],npr,ipr,iob,ipr_pos);

		if (ipr==1 && exec_flg<1) {	/* hc̎擾 */
/*
printf("%s: iob=%d\n",argv[0],iob);
*/
			ida = obj[iob++];
			memcpy(iParm,&obj[iob],sizeof(int)*6);
			iob += 6;
/*
printf("%s: ida=%d da[ida]=%016lx\n",argv[0],ida,da[ida]);
*/
			if (rc=cl_get_def_attr_opt(NULL,0,iParm,opt,&da[ida],pObj)) return rc;
/*
printf("%s: opt=%08x iParm=%d %d %016lx %d\n",
argv[0],opt,iParm[0],iParm[1],iParm[2],iParm[3]);
*/
			def_attr = attr = iParm[0];
			type = iParm[0];
			size = iParm[1];
			pInfoDef = NULL;
			for (i=0;i<2;i++) {
#if defined(_LP64)	/* 2021.2.13 */
				memcpy(&p,iParm+2,sizeof(char *));
				memcpy(&pp,iParm+4,sizeof(char *));
				if (!type && p) {
					if (pInfoDef = (tdtInfoParm *)p) {
#else
				if (!type && iParm[2]) {
					pp = (char *)iParm[4];
					if (pInfoDef = (tdtInfoParm *)iParm[2]) {
#endif
DEBUGOUT_InfoParm(170,"%s: pInfoDef=",pInfoDef,argv[0],0);
						attr = type = pInfoDef->pi_aux[0];
						if (pInfoDef->pi_id!='P' || !type) {
							if (!i) {
								if ((type=_get_def_type(pp,proc,iParm)) < 0) return type;
								attr = type = iParm[0];
								continue;
							}
							else {
											/* %s: ^`񂪕słBid=[%c] type=%d */
								ERROROUT3(FORMAT(618),argv[0],pInfoDef->pi_id,type);
								return -1;
							}
						}
					}
				}
				break;
			}
			opt = obj[iob++];
			iCLEAR  = opt & D_GX_OPT_SET_CLEAR;
			iMAPPED = opt & D_GX_OPT_SET_MAPPED;	/* add 2021.8.4 */
			iEXPORT = opt & D_GX_OPT_SET_EXPORT;	/* add 2021.8.6 */
			iEQU = obj[iob++];		/* add 2020.11.3 */
			iCONST = obj[iob++];
			is = obj[iob++];

DEBUGOUTL5(170,"%s: opt=%08x iCONST=%016lx is=%d iCLEAR=%d",argv[0],opt,iCONST,is,iCLEAR);
DEBUGOUTL3(170,"%s: type=%d pInfoDef=%016lx",argv[0],type,pInfoDef);

		}
		else if (ipr==2 && exec_flg<2) {	/* hcz`擾̏ */
/*
printf("%s: iob=%d\n",argv[0],iob);
*/
			iARRAY = obj[iob++];	/* z` */
/*
printf("%s: iARRAY=%d\n",argv[0],iARRAY);
*/
			if (iARRAY >= 0) {
				/* z`̎擾 */
				ida = obj[iob++];	/* z` */
				n = obj[iob++];
				memcpy(qprmp,&da[ida],sizeof(parmList *)*n);
				iARRAY = obj[iob++];
/*
printf("%s: ida=%d n=%d iARRAY=%d iEQU=%d\n",argv[0],ida,n,iARRAY,iEQU);
*/
			}
/*
printf("%s: iARRAY=%d\n",argv[0],iARRAY);
*/
DEBUGOUTL2(170,"%s: iARRAY=%d",argv[0],iARRAY);

			if (iARRAY == -2) {
/*
printf("%s: exec cl_pr_ex_def_scalar_attr_info() iARRAY=%d\n",argv[0],iARRAY);
*/
				rc = cl_pr_ex_def_scalar_attr_info(is,pprmp,scrct,proc,opt,iParm,&pInfoParm);
				if (rc >= 0) rc = C_EX_DEF_SCALAR;
				return rc;
			}
		}
		else if (ipr == 3) {	/* hcϐ擾̏ */
			ida_nam = obj[iob++];
			varnam = da[ida_nam];
			vnlen = strlen(varnam);
			c = *varnam;
/*
printf("%s: ida_nam=%d vnlen=%d varnam=[%s]\n",argv[0],ida_nam,vnlen,varnam);
*/
			if ((ida=obj[iob++]) >= 0) {
				if ((len=_get_varname(varnam,vnlen,&ssp,proc,&da[ida],&pp)) < 0) return len;
				else if (len > 0) {
					varnam = pp;
					vnlen = len;
					c = *varnam;
				}
				iGET_NAM = 1;
			}

DEBUGOUTL4(170,"%s: ida=%d vnlen=%d varnam=[%s]",argv[0],ida,vnlen,varnam);
/*
printf("%s: ida=%d vnlen=%d varnam=[%s]\n",argv[0],ida,vnlen,varnam);
*/
			iNAME_OPT = 1;
			if (!proc) {
				if (rc=cl_def_chk_name_opt(varnam,vnlen,argv[0],FORMAT(441),0)) return rc;
			}
			if (c == '$') {
				vnlen--;
				varnam++;
				vlen = vnlen;
				vnam = varnam;
			}
			else if (c=='%' || c=='#') {
				if (type==D_AUX0_TYPE_MAPPED || iMAPPED) {
					vlen = vnlen - 1;
					vnam = varnam + 1;
				}
				else {
					ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
					return ECL_SCRIPT_ERROR;
				}
			}
			else {
				c = '$';
				vlen = vnlen;
				vnam = varnam;
			}
DEBUGOUTL3(170,"%s: vnlen=%d varnam=[%s]",argv[0],vnlen,varnam);
#if 1	/* 2021.8.6 */
			if (iEXPORT) {
			}
#endif
		}
		else if (ipr == 4) {	/* hcϐ`/Ē` */

		opt |= D_GX_OPT_DEFINE;

#if 1	/* 2021.8.28 */
			if (iARRAY>=1 && (type==D_AUX0_TYPE_ARRAY || type==D_AUX0_TYPE_MAPPED)) {
						/* %s: ϐ[%s]̔z`łȂ(%d)łB */
				if (c=='%' || c=='#') {
					ERROROUT3(FORMAT(473),argv[0],varnam,type);
					return ECL_EX_DEFINE;
				}
			}
#endif

			if (proc) {
				dot_opt = opt & D_GX_OPT_REDEFINE;
				if (iARRAY==2 || iARRAY==-2) dot_opt |= 1;
				if (rc=cl_def_chk_name_opt(vnam,vlen,argv[0],FORMAT(441),dot_opt)) return rc;
			}
			if (iEQU) {
				pprmp[2]->prp = line + iEQU;
				pprmp[2]->prmlen = line_len - iEQU;
/*
printf("%s: exec cl_gx_exp_obj_opt() iEQU=%d prmlen=%d prp=[%s]\n",argv[0],iEQU,pprmp[2]->prmlen,pprmp[2]->prp);
*/
#if 0	/* 2021.4.3 */
				if (rc=cl_gx_exp_obj_opt(1,&pprmp[2],pObj,tInfoParm2,D_GX_OPT_PARMINFO2)) return rc;
#endif
			}
#if 0	/* 2021.2.21 */ /* Őݒ肷ƁA`ς݂łA_chk_define()==0 ƂȂ */
	if ((iARRAY==1) && !(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}
#endif
	if (iARRAY == 1) opt |= D_GX_OPT_SET_ARRAY;
	else opt &= ~D_GX_OPT_SET_ARRAY;

	if (opt & D_GX_OPT_REDEFINE) {
		if (iMAPPED) id = 'A';
		else id = 'R';
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,id,"cl_pr_ex_def_array")) return rc;
		pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
		attr_old = pIndex->uAttr[0];
		if (!attr) {
			type = attr = attr_old;
			size = pIndex->size;
		}
	}
	else {
		pIndex = NULL;
		if (!attr) attr = DEF_ZOK_VARI;
		len = akxnskipto(varnam,vnlen,".");
		if (iARRAY==1 && (len<vnlen)) {
			/* %s: STRUCT̃o[%s]͎wł܂B */
			ERROROUT2(FORMAT(444),argv[0],varnam);
			return ECL_SCRIPT_ERROR;
		}
		if ((iParmNo=_chk_define(scrct,proc,varnam,len,opt,argv)) < 0) return iParmNo;
		if (iARRAY==2 && !iParmNo) {
			ERROROUT2(FORMAT(438),argv[0],varnam);	/* %s: [%s]͖`łB */
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: iParmNo=%d\n",argv[0],iParmNo);
*/
DEBUGOUTL3(170,"%s: iParmNo=%d iARRAY=%d",argv[0],iParmNo,iARRAY);
	}

	if (!attr) attr = DEF_ZOK_VARI;
	iParm[0] = attr;
	iParm[1] = size;
	if (!iParmNo && iARRAY==1) {
		if (rc=_def_array(n,&qprmp[0],opt,iParm,&tIndex,attr_old,pIndex)) return rc;
/*
printf("%s: qprmp[0]=%016lx qprmp[0]->bxobj=%016lx\n",argv[0],qprmp[0],qprmp[0]->bxobj);
*/
if (n>0) {
DEBUGOUTL3(170,"%s: qprmp[0]=%016lx qprmp[0]->bxobj=%016lx",argv[0],qprmp[0],qprmp[0]->bxobj);
}
	}

	if (opt & D_GX_OPT_REDEFINE) {
		if (iARRAY == 1) {
			memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
		}
		iSET = 1;
		if (iCLEAR) {
			if (iARRAY > 0) {
				ppParm = &pInfoParm;
				if (rc=cl_array_ope_opt(&count,1,ppParm,D_FUC_ARRAY_CLR,0)) return rc;
			}
		}
	}
	else {
		if (iParmNo > 0) {
			pTBL_vname = (tdtInfoParm ***)argv[1];
			pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
			if (iARRAY == 2) {
				if (pInfoParm->pi_id=='T') {
					if (++len < vnlen) {
						if (rc=_ex_get_member(&pInfoParm,opt,varnam+len,vnlen-len)) return rc;
					}
				}
				if ((id=pInfoParm->pi_id)!='R' && id!='A') {
					/* %s: [%s]͔zł͂܂B */
					ERROROUT2(FORMAT(445),argv[0],varnam);
					return ECL_SCRIPT_ERROR;
				}
				iSET = 1;
			}
			else if (iARRAY == 1) {
				if (opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL)) {
					if (rc = _chk_array(n,&qprmp[0],iParm,iCONST,pInfoParm)) {
						if (cl_get_option(23,0) & 0x01) return rc;
						rc = 0;
								/* %s:(W)ϐ[%s]̒`̈Ⴂ𖳎܂B*/
						ERROROUT2(FORMAT(616),argv[0],varnam);
					}
				/*	else return rc;	*/
				}
				else if (proc) {
					if (cl_get_info_fixed_attr(pInfoParm,iParm_old)) {
								/* %s: %sϐ[%s %s]`ς݂łB */
						ERROROUT4(FORMAT(426),argv[0],argv[3],varnam,cl_get_attr_name(iParm_old));
					}
					else if (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED) {
						ERROROUT3(FORMAT(425),argv[0],FORMAT(255),varnam);
					}
					return ECL_SCRIPT_ERROR;
				}
				if (proc) iSET = 1;
DEBUGOUTL3(170,"%s: iSET=%d iEQU=%d",argv[0],iSET,iEQU);
			}
			else {
				if (opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL)) {
					if (iParm[0] != (attr_old=pInfoParm->pi_aux[0])) {
								/* %s: f[^^قȂĂ܂Bold=%d new=%d */
						ERROROUT3(FORMAT(450),argv[0],attr_old,iParm[0]);
						if (cl_get_option(23,0) & 0x01) return ECL_SCRIPT_ERROR;
									/* %s:(W)ϐ[%s]̃f[^^w𖳎܂B*/
						else ERROROUT2(FORMAT(611),argv[0],varnam);
					}
					if (proc) iSET = 1;
				}
				else iSET = 1;
			}
		}
		else {
			iSET = 1;
			pha_vname  = (XHASHB *)argv[4];
			if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
					/* %s: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
				goto Error;
			}
			pTBL_vname = (tdtInfoParm ***)argv[5];
			pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
/*
printf("%s: pha_vname=%016lx pTBL_vname=%016lx pInfoParm=%016lx\n",argv[0],pha_vname,pTBL_vname,pInfoParm);
*/
DEBUGOUTL4(170,"%s: pha_vname=%016lx pTBL_vname=%016lx pInfoParm=%016lx",argv[0],pha_vname,pTBL_vname,pInfoParm);
			if (!pInfoParm) return ECL_SCRIPT_ERROR;
			if (iARRAY > 0) {
				info_parm_clear(pInfoParm);
				if (iMAPPED) id = 'A';
				else id = 'R';
				pInfoParm->pi_id   = id;
				pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
				pInfoParm->pi_attr = DEF_ZOK_BULK;	/* attr;	*/
				pInfoParm->pi_dlen = sizeof(tdtArrayIndex);
				if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return -1;
				memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
				if (!(p=Malloc(vnlen+1))) {
					ERROROUT1("%s: Array name area malloc",argv[0]);
					goto Error;
				}
				strnzcpy(p,varnam,vnlen);
				pInfoParm->pi_pos = (long)p;
				pInfoParm->pi_aux[0] = iParm[0];
#if 1	/* 2021.3.30 */
				if (!((optw=opt) & D_GX_OPT_SET_SCOPE)) optw = cl_get_def_scope(argv[3]);
				pInfoParm->pi_hlen = _get_gid(scrct,proc,optw);
#else
				if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
				else if (!(opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) pInfoParm->pi_hlen = scrct->ScrGid;
#endif
				pInfoParm->pi_paux = (char *)pInfoParm;	/* Rs[ꂽƂɁA̔z񂪗L`FbN邽߂ɕۑ */
#if 1	/* 2021.6.14 */
			/*	if (id == 'A') cl_get_array_index_tbl(pInfoParm,NULL,NULL,NULL);	*/
				if (id == 'A') {
					pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
					if ((rc=cl_def_map_ary_max_chk(c,pIndex->index,scrct,proc,opt)) < 0) return rc;
				}
#endif
			}
			else {
/*
printf("%s: iParm[0]=%d pInfoDef=%016lx\n",argv[0],iParm[0],pInfoDef);
*/
				if (def_attr || !pInfoDef) {
					if (rc=cl_set_parm_init(pInfoParm,iParm,0x01)) {
						/* cl_pr_ex_def_var:%s̏ݒG[B */
						ERROROUT2(FORMAT(459),argv[0],varnam);
						return rc;
					}
				}
				else {
					if (rc=cl_gx_rep_info_set(pInfoParm,pInfoDef,1)) return rc;
					if (!(p=Malloc(vnlen+1))) {
						ERROROUT("cl_pr_ex_def_var: Array name area malloc");
						return ECL_EX_DEFINE;
					}
					strnzcpy(p,varnam,vnlen);
					pInfoParm->pi_pos = (long)p;
					pInfoParm->pi_alen &= ~D_AULN_NO_AL_LPOS;
					pInfoParm->pi_aux[1] |= D_AUX1_HASHED_NAME;

					if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
					else if (opt & D_GX_OPT_SET_PRIVATE) pInfoParm->pi_hlen = scrct->ScrGid;

					if (attr == D_AUX0_TYPE_STRUCT) {
						/* 2020.10.11 */
						pDeftypeP = (tdtDefType *)pInfoDef->pi_data;
						if (rc = _def_var_struct(pInfoParm,pDeftypeP,(char *)pInfoDef->pi_pos,opt)) return rc;
					}
					else {
						pInfoParm->pi_len = 0;
						if (type == D_AUX0_TYPE_ARRAY) {
							pInfoParm->pi_id = 'R';
							if (rc=_def_var_array_member(pInfoParm)) return rc;
						}
						else if (type == D_AUX0_TYPE_MAPPED) {
							pInfoParm->pi_id = 'A';
							pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
							if ((rc=cl_def_map_ary_max_chk(c,pIndex->index,scrct,proc,opt)) < 0) return rc;
							if (opt & D_GX_OPT_SET_LOCAL) ucLOCAL = D_AUX1_LOCAL_VAR;
							else ucLOCAL = 0;
							pInfoParm->pi_aux[1] = ucLOCAL;
						}
						else {
									/* %s: ^`񂪕słBid=[%c] type=%d */
							ERROROUT3(FORMAT(618),argv[0],pInfoDef->pi_id,attr);
							return -1;
						}
					}
					pInfoParm->pi_scale |= D_DATA_MALLOC | D_DATA_INDEX_FREE;
				/*	pInfoParm->pi_scale |= D_DATA_INDEX_FREE;	*/
				}
			}
			if ((rc=cl_gx_clear_var_define(scrct,proc,varnam,opt)) < 0) return rc;
		}
DEBUGOUT_InfoParm(194,"cl_pr_ex_def_array_engine: attr=%d size=%d",pInfoParm,attr,size);
	}

		}
		else if (ipr == 5) {	/* hc */

	if (iSET && iEQU) {
/*
printf("%s: iSET=%d iEQU=%d exec _set_array_info_values()\n",argv[0],iSET,iEQU);
*/
#if 1	/* 2021.4.3 */
		if (rc=cl_gx_exp_obj_opt(1,&pprmp[2],pObj,tInfoParm2,D_GX_OPT_PARMINFO2)) return rc;
#endif
		if (rc = _set_array_info_values(pInfoParm,tInfoParm2)) return rc;
	}
	else if (iEQU) {
		ERROROUT2(FORMAT(612),argv[0],varnam);	/* %s:(W)ϐ[%s]ւ̃f[^̑𖳎܂B */
	}

		}
		else if (ipr == 6) {	/* hcCONST */

	if (iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;

		}
		else if (ipr == 7) {	/* pInfoParmԂ */
			ida = obj[iob];
/*
printf("%s: iob=%d ida=%d pInfoParm=%016lx da=%016lx\n",argv[0],iob,ida,pInfoParm,da);
*/
			da[ida] = (char *)pInfoParm;
		}
	}
DEBUGOUT_InfoParm(194,"cl_pr_ex_def_array:Exit ",pInfoParm,0,0);
	return 0;

 Error:
	if (tIndex.xhp) akxs_xhash_free(tIndex.xhp);
	if (tIndex.pVarIndex) Free(tIndex.pVarIndex);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/* _def_array_set_init_by_attr      */
/*  쐬 : 2020.10.12               */
/************************************/
int _def_array_set_init_by_attr(attr,n,alsize,ptIndex,iParm)
int attr,n,alsize,iParm[];
tdtArrayIndex *ptIndex;
{
	char *p;
	int na,rc,i;
	tdtInfoParm *pInfo,*pInfoP,**ppInfo;
	tdtDefType *pDeftypeP;
/*
printf("_def_array_set_init_by_attr: attr=%d n=%d alsize=%d\n",attr,n,alsize);
*/
	na = n*alsize;
	if (!(p=Malloc(na))) return -10;
	memset(p,0,na);
	ptIndex->pVarIndex = (tdtInfoParm **)p;
	if (attr==DEF_ZOK_DECI && alsize==sizeof(MPA))
		m_set_array((MPA *)p,m_get_i(0),n);
#if 1	/* 2021.8.28 */
	else if (attr & 0x10) {
#else
	else if (attr == D_AUX0_TYPE_STRUCT) {
#endif
#if defined(_LP64)	/* 2021.2.13 */
		memcpy(&pInfoP,iParm+2,sizeof(char *));
		if (pInfoP) {
#else
		if (pInfoP = (tdtInfoParm *)iParm[2]) {
#endif
		/*
			pDeftypeP = (tdtDefType *)pInfoP->pi_data;
			ppInfo = (tdtInfoParm **)p;
			for (i=0;i<n;i++) {
				if (!(p=Malloc(sizeof(tdtInfoParm)))) return -11;
				pInfo = (tdtInfoParm *)p;
				cl_parm_set0(pInfo);
				if (rc=cl_gx_rep_info_set(pInfo,pInfoP,1)) return rc;
				if (rc=_def_var_struct(pInfo,pDeftypeP,(char *)pInfoP->pi_pos,0)) return rc;
				pInfo->pi_aux[1] &= ~D_AUX1_VAR_SCOPE;
				*ppInfo++ = pInfo;
			}
		*/
			iParm[0] = DEF_ZOK_VARI;
			iParm[2] = 0;
		}
	}
	return 0;
}

/************************************/
/* _def_array                       */
/* iParm[0]=1,2,3,4,5,6,7           *
/*         ,D_AUX0_TYPE_ARRAY  (17) */
/*         ,D_AUX0_TYPE_MAPPED (18) */
/*         ,D_AUX0_TYPE_STRUCT (19) */
/************************************/
int _def_array(prmnum, pprmp, opt, iParm, ptIndex, attr_old, pIndex)
int      prmnum;
parmList **pprmp;
int      opt,iParm[],attr_old;
tdtArrayIndex *ptIndex,*pIndex;
{
	static char *_fn_="_def_array";
	int  i,rc,n,len,id,attr,size,iHASH,prmnum0,iParmW[2],m_opt,is;
	int  n_old,na,na_old,alsize,size_old,alsize_old,size_min,pre,old_pre,sca,old_sca,set_old;
	char c,*pp,*p,*p_old;;
	int *index;
	MPA ma,mn;
	tdtInfoParm *pInfo;
/*
printf("%s:Enter: prmnum=%d pprmp=%016lx opt=%08x attr_old=%d\n",_fn_,prmnum,pprmp,opt,attr_old);
*/
	if (prmnum < 0) return 0;
	else if (!pprmp) return -1;

	prmnum0 = prmnum;
	attr = iParm[0];
	size = iParm[1];
	pre  = iParm[2];
	sca  = iParm[3];
/*
printf("%s: attr=%d size=%d pre=%d sca=%d\n",_fn_,attr,size,pre,sca);
*/
/* ɁAl͐ݒ肳ĂȂ
p = ptIndex->uAttr;
printf("%s: new uAttr=%d %d %d %d\n",_fn_,p[0],p[1],p[2],p[3]);
*/
	set_old = 0;	/* 2021.2.4 */
	if (opt & D_GX_OPT_REDEFINE) {
		if (!attr_old || !pIndex) return -2;
		else if (attr_old != attr) {
			/* %s: ̑(%d)ƍĒ`(%d)Ă܂B */
			ERROROUT3(FORMAT(442),_fn_,attr_old,attr);
			return ECL_SCRIPT_ERROR;
		}
		size_old = pIndex->size;
		index = pIndex->index;
		n_old = index[1];
		set_old = index[2];	/* 2021.2.4 */
/*
printf("attr=%d size=%d attr_old=%d size_old=%d n_old=%d\n",attr,size,attr_old,size_old,n_old);
*/
		p_old = pIndex->uAttr;
/*
printf("%s: old uAttr=%d %d %d %d\n",_fn_,p_old[0],p_old[1],p_old[2],p_old[3]);
*/
		old_pre = p_old[2];
		old_sca = p_old[3];
	}

	memset(ptIndex,0,sizeof(tdtArrayIndex));
	index = ptIndex->index;
	if ((opt & D_GX_OPT_REDEFINE) && !prmnum) {
		memcpy(index,pIndex->index,sizeof(pIndex->index));
	}
	else {
		index[0] = 1;
		index[2] = 0;
		index[3] = 1;
		for (i=0;i<index[0]*2;i+=2) {
			index[i+4] = 1;
			index[i+5] = 0;
		}
		index[4] = 10;
		index[1] = index[4];
	}

	if (prmnum>0 && !stricmp(pprmp[0]->prp,"HASH")) {
		if (opt & D_GX_OPT_REDEFINE) {
			ERROROUT1(FORMAT(447),_fn_);	/* %s: HASHw͍Ē`ł܂B */
			return ECL_SCRIPT_ERROR;
		}
		index[2] = -1;	/* 0x80; 2020.4.30 */
		iHASH = 1;
		pprmp++;
		prmnum--;
		if (prmnum > 1) goto Parm_More;
	}
	else iHASH = 0;
	if (prmnum > 0) {
		if (opt & D_GX_OPT_SET_MAPPED) is = 0;
		else is = 1;
		if (rc = _set_index(is,prmnum,pprmp,0,index,"_def_array: ")) return rc;
#if 1	/* 2021.2.4 */
		if (set_old > 0) {
			if (set_old > index[1]) set_old = index[1];
			index[2] = set_old;
		}
#endif
	}
	n = index[1];
	if (n < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_fn_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
/*
printf("_def_array: iHASH=%d index=%d[%d,%d,%d]\n",iHASH,index[0],index[1],index[2],index[3]);
*/
	if (iHASH) {
		if (!(opt & D_GX_OPT_NOALLOC_INDX)) {
			if (!(ptIndex->xhp=akxs_xhash_new2(0,index[1],0,sizeof(tdtInfoParm *)))) return -9;
		}
	}
	else if ((opt & D_GX_OPT_REDEFINE) &&
	         ((attr!=DEF_ZOK_DECI && size_old==size && n==n_old)
	       || (attr==DEF_ZOK_DECI && pre==old_pre && sca==old_sca))) {
		ptIndex->pVarIndex = pIndex->pVarIndex;
	}
	else {
		if ((opt & D_GX_OPT_REDEFINE) &&
		    ((!size_old && size) || (size_old && !size))) {
			_redefine_size_zero(attr,size,n,size_old,n_old,ptIndex,pIndex);
		}
		else {
			iParmW[0] = attr;
			iParmW[1] = size;
			if ((alsize=cl_get_def_alsize(iParmW)) < 0) return alsize;
			na = n*alsize;
/*
printf("_def_array: n=%d alsize=%d na=%d\n",n,alsize,na);
*/
			if (n > 0x7fffff) {
				m_i2mpa(n,&mn);
				m_i2mpa(alsize,&ma);
				m_mul1(&mn,&ma);
				if (m_cmp(&mn,m_get_INTMAX(0))>0) na = -1;
			}
			if (na < 0) {
					/* %s: zf[^(%d * %d)ől(%d)𒴂Ă܂B */
				ERROROUT4(FORMAT(456),_fn_,n,alsize,INT_MAX);
				return ECL_SCRIPT_ERROR;
			}
			if (opt & D_GX_OPT_REDEFINE) {
				iParmW[0] = attr;
				iParmW[1] = size_old;
				if ((alsize_old=cl_get_def_alsize(iParmW)) < 0) return alsize_old;
				na_old = n_old*alsize_old;
				if (!(pp=Malloc(na))) {
					/* "%s: %spMallocG[B */
					ERROROUT2(FORMAT(321),_fn_,FORMAT(586));	/*  zf[^ */
					return -11;
				}
				p_old = (char *)pIndex->pVarIndex;
				if ((attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) && size_old!=size) {
					p = pp;
					size_min = X_MIN(size,size_old);
					for (i=0;i<X_MIN(n,n_old);i++) {
						if (attr == DEF_ZOK_CHAR) strnzcpy(p,p_old,size_min);
						else if (attr == DEF_ZOK_BULK) {
							memcpy(&len,p_old+size_old,sizeof(int));
							memcpy(p,p_old,size_min);
							len = X_MIN(len,size);
							memcpy(p+size,&len,sizeof(int));
						}
						p += alsize;
						p_old += alsize_old;
					}
				}
				else if (attr==DEF_ZOK_DECI && iParm[2]>0) {
					m_opt = cl_get_option(12,0);
					p = pp;
					for (i=0;i<X_MIN(n,n_old);i++) {
						memcpy(p,p_old,alsize);
						if ((rc=cl_mpa_scale_opt((MPA *)p,iParm[2],iParm[3],m_opt))<0) return rc;
						p += alsize;
						p_old += alsize;
					}
				}
				else memcpy(pp,p_old,X_MIN(na,na_old));
				if (na > na_old) memset(pp+na_old,0,na-na_old);
				ptIndex->pVarIndex=(tdtInfoParm **)pp;
				Free(pIndex->pVarIndex);
			}
			else {
				pInfo = (tdtInfoParm *)iParm[2];
/*
printf("%s: attr=%d pInfo=%016lx\n",_fn_,attr,pInfo);
*/
#if 1	/* 2021.8.28 */
				if (attr & 0x10)
#else
				if (attr == D_AUX0_TYPE_STRUCT)
#endif
					ptIndex->pInfoType = pInfo;
				if (!(opt & D_GX_OPT_NOALLOC_INDX)) {
					if (rc=_def_array_set_init_by_attr(attr,n,alsize,ptIndex,iParm)) return rc;
				}
			}
		}
	}
	ptIndex->uAttr[0] = iParm[0];
	ptIndex->uAttr[2] = iParm[2];
	ptIndex->uAttr[3] = iParm[3];
	ptIndex->size = iParm[1];
/*
printf("%s:Exit iParm=%d %d %d %d\n",_fn_,iParm[0],iParm[1],iParm[2],iParm[3]);
*/
	return 0;

 Parm_More:
	/* "%s: ]ȃp[^(nparm=%d [%s])܂B */
	ERROROUT3(FORMAT(605),_fn_,prmnum0,pprmp[1]->prp);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/* _chk_array                       */
/* iParm[0]=1,2,3,4,5,6,7           *
/*         ,D_AUX0_TYPE_ARRAY  (17) */
/*         ,D_AUX0_TYPE_MAPPED (18) */
/*         ,D_AUX0_TYPE_STRUCT (19) */
/************************************/
static int _chk_array(prmnum,pprmp,iParm,iCONST,pInfoParm)
int      prmnum;
parmList **pprmp;
int      iParm[],iCONST;
tdtInfoParm *pInfoParm;
{
	static char *_fn_="_chk_array";
	tdtArrayIndex tIndex,*pIndex;
	int  i,rc,n,len,id,attr,size,iHASH,ndim,prmnum0,ndim_new,m_new,ix;
	int  attr_old,size_old,iCONST_old,ndim_old,m_old;
	int *index;
	char c;

	if (prmnum < 0) return 0;
	else if (!pprmp) return -1;

	if ((c=pInfoParm->pi_id)!='A' && c!='R') {
				/* %s: zł͂܂B*/
		ERROROUT1(FORMAT(202),_fn_);
		return ECL_SCRIPT_ERROR;
	}
	memset(&tIndex,0,sizeof(tdtArrayIndex));
	index = tIndex.index;
	index[0] = 1;
	index[2] = 0;
	index[3] = 1;
	for (i=0;i<index[0]*2;i+=2) {
		index[i+4] = 1;
		index[i+5] = 0;
	}
	index[4] = 10;
	index[1] = index[4];
	prmnum0 = prmnum;
	if (prmnum>0 && !stricmp(pprmp[0]->prp,"HASH")) {
		iHASH = 1;
		pprmp++;
		prmnum--;
		if (prmnum > 1) {
			/* "%s: ]ȃp[^(nparm=%d [%s])܂B */
			ERROROUT3(FORMAT(605),_fn_,prmnum0,pprmp[1]->prp);
			return ECL_SCRIPT_ERROR;
		}
	}
	else iHASH = 0;
	if (prmnum > 0) {
		if (rc = _set_index(1,prmnum,pprmp,0,index,"_chk_array: ")) return rc;
	}
	n = index[1];
	if (n < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_fn_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	attr = iParm[0];
	size = iParm[1];
	pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
	attr_old = pIndex->uAttr[0];
	size_old = pIndex->size;
	rc = 0;
	iCONST_old = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
	if ((iCONST && !iCONST_old) || (!iCONST && iCONST_old)) {
		/* %s: 萔`قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(449),_fn_,iCONST_old,iCONST);
		rc |= 1;
	}
	if (attr_old != attr) {
		/* %s: f[^^قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(450),_fn_,attr_old,attr);
		rc |= 2;
	}
	if (size_old != size) {
		/* %s: قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(451),_fn_,size_old,size);
		rc |= 4;
	}
	ndim_new = index[0];
	ndim_old = pIndex->index[0];
	ndim = X_MAX(ndim_old,ndim_new);
/*
printf("_def_array: ndim_old=%d ndim_new=%d\n",ndim_old,ndim_new);
*/
	for (i=4,ix=1;ix<=ndim;i++,ix++) {
		if (ix > ndim_old) m_old = 1;
		else m_old = pIndex->index[i];
		if (ix > ndim_new) m_new = 1;
		else m_new = index[i];
/*
printf("_def_array: ix=%d m_old=%d m_new=%d\n",ix,m_old,m_new);
*/
		if (m_old != m_new) {
			/* %s: %d ڂقȂĂ܂Bold=%d new=%d */
			ERROROUT4(FORMAT(452),_fn_,ix,m_old,m_new);
			rc |= 8;
		}
	}
	if (rc) rc = ECL_SCRIPT_ERROR;
	return rc;
}

/************************************/
/* cl_pr_ex_dim						*/
/************************************/
int cl_pr_ex_dim(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	return cl_pr_ex_def_var(leaf->cmd.cmdobj,leaf->cmd.prmnum,leaf->cmd.prmp,scrct,proc,opt);
}
#if 0
/************************************/
/* cl_pr_ex_typedef					*/
/************************************/
int cl_pr_ex_typedef(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	return cl_pr_ex_def_type(leaf->cmd.prmnum,leaf->cmd.prmp,scrct,proc,opt);
}
#endif
/************************************/
/* _redefine_size_zero				*/
/************************************/
int _redefine_size_zero(attr,size0,n,size0_old,n_old,pIndex,pIndex_old)
int attr,size0,n,size0_old,n_old;
tdtArrayIndex *pIndex,*pIndex_old;
{
	static char *_fn_="_redefine_size_zero";
	int  i,len,na,na_old,alsize,size_old,alsize_old,size_min,m;
	char *p,*pp,*p_old,*p1;
	tdtInfoParm **ppParm,*pInfoParm;
/*
printf("%s: attr=%d size0=%d n=%d size0_old=%d n_old=%d\n",_fn_,attr,size0,n,size0_old,n_old);
*/
	alsize = size0 ? size0 : size0_old;
	if (attr == DEF_ZOK_CHAR) alsize++;
	else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
	if (size0) {
		m = alsize;
		na_old = n_old*sizeof(tdtInfoParm *);
	}
	else {
		m = sizeof(tdtInfoParm *);
		na_old = alsize*n_old;
	}
	na = n*m;
/*
printf("%s: alsize=%d m=%d na_old=%d na=%d\n",_fn_,alsize,m,na_old,na);
*/
	if (na < 0) {
		/* %s: zf[^悪ől(%d)𒴂Ă܂B */
		ERROROUT4(FORMAT(456),_fn_,na,alsize,INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	if (!(pp=Malloc(na))) {
		/* "%s: %spMallocG[B */
		ERROROUT2(FORMAT(321),_fn_,FORMAT(586));	/* zf[^ */
		return -11;
	}
	if (size0) {
		p = pp;
		ppParm = pIndex_old->pVarIndex;
		for (i=0;i<X_MIN(n,n_old);i++) {
			if (pInfoParm=ppParm[i]) {
				p_old = pInfoParm->pi_data;
				size_old = pInfoParm->pi_dlen;
				size_min = X_MIN(size0,size_old);
/*
printf("%s: size_old=%d size_min=%d na=%d\n",_fn_,size_old,size_min);
*/
				if (attr == DEF_ZOK_CHAR) memzcpy(p,p_old,size_min);
				else if (attr == DEF_ZOK_BULK) {
					memcpy(&len,p_old+size_old,sizeof(int));
					memcpy(p,p_old,size_min);
					len = X_MIN(len,size0);
/*
printf("%s: len=%d\n",_fn_,len);
*/
					memcpy(p+size0,&len,sizeof(int));
				}
				else return -1;
			}
			else {
				if (attr == DEF_ZOK_CHAR) *p = '\0';
				else if (attr == DEF_ZOK_BULK) memset(p,0,alsize);
			}
			p += alsize;
		}
	}
	else {
		p = (char *)pIndex_old->pVarIndex;
		ppParm = (tdtInfoParm **)pp;
		for (i=0;i<X_MIN(n,n_old);i++) {
			if (attr == DEF_ZOK_CHAR) len = strlen(p);
			else if (attr == DEF_ZOK_BULK) memcpy(&len,p+size0_old,sizeof(int));
/*
printf("%s: len=%d\n",_fn_,len);
*/
#if 1	/* 2021.2.4 */
			if (!(pInfoParm=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) {
				/* "%s: %spMallocG[B */ /* zf[^\ */
				ERROROUT2(FORMAT(321),_fn_,FORMAT(587));
				return -11;
			}
			ppParm[i] = pInfoParm;
			if (len > 0) {
				if (attr == DEF_ZOK_CHAR) {
					if (!(p1=Malloc(len+1))) return -11;
					memzcpy(p1,p,len);
				}
				else if (attr == DEF_ZOK_BULK) {
					if (!(p1=Malloc(len+sizeof(int)))) return -11;
					memzcpy(p1,p,len);
					memcpy(p1+len,&len,sizeof(int));
				}
				else return -1;
			}
			else if (len < 0) len = 0;
			cl_set_parm_char(pInfoParm,p1,len);
			pInfoParm->pi_attr = attr;
			pInfoParm->pi_len = 0;
			pInfoParm->pi_aux[0] = attr;
			pInfoParm->pi_paux = pInfoParm->pi_data;
#else
			if (len > 0) {
				if (!(pInfoParm=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) {
					/* "%s: %spMallocG[B */ /* zf[^\ */
					ERROROUT2(FORMAT(321),_fn_,FORMAT(587));
					return -11;
				}
				ppParm[i] = pInfoParm;
				if (attr == DEF_ZOK_CHAR) {
					if (!(p1=Malloc(len+1))) return -11;
					memzcpy(p1,p,len);
				}
				else if (attr == DEF_ZOK_BULK) {
					if (!(p1=Malloc(len+sizeof(int)))) return -11;
					memzcpy(p1,p,len);
					memcpy(p1+len,&len,sizeof(int));
				}
				else return -1;
				cl_set_parm_char(pInfoParm,p1,len);
				pInfoParm->pi_attr = attr;
				pInfoParm->pi_len = 0;
				pInfoParm->pi_aux[0] = attr;
				pInfoParm->pi_paux = pInfoParm->pi_data;
			}
			else ppParm[i] = NULL;
#endif
			p += alsize;
		}
	}
	if (n > n_old) {
		i = m*n_old;
		memset(pp+i,0,na-i);
	}
	pIndex->pVarIndex=(tdtInfoParm **)pp;
	Free(pIndex_old->pVarIndex);
	return 0;
}

/************************************/
/* cl_get_def_alsize				*/
/************************************/
int cl_get_def_alsize(iParmW)
int iParmW[];
{
	int size,attr,alsize;

	attr = iParmW[0];
	size = iParmW[1];
	if (size) {
		alsize = size;
		if (attr == DEF_ZOK_CHAR) alsize++;
		else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
	}
	else {
		if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) {
			attr = DEF_ZOK_VARI;
			size = sizeof(tdtInfoParm);
			alsize = size;
		}
		else return -1;
	}
	iParmW[0] = attr;
	iParmW[1] = size;
	return alsize;
}

/************************************/
/* cl_get_info_fixed_attr			*/
/************************************/
int cl_get_info_fixed_attr(pInfoParm,iParm)
tdtInfoParm *pInfoParm;
int iParm[];
{
	int attr,size,pre,sca;
	char c;
	tdtArrayIndex *pIndex;

	pre = sca = 0;
	if ((c=pInfoParm->pi_id)=='A' || c=='R') {
		pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
		attr = pIndex->uAttr[0];
		size = pIndex->size;
		pre  = pIndex->uAttr[2];
		sca  = pIndex->uAttr[3];
	}
	else {
		attr = pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA;
		if (attr) size = pInfoParm->pi_len;
		else size = pInfoParm->pi_dlen;
		if (attr == DEF_ZOK_DECI) {
			pre = pInfoParm->pi_hlen;
			sca = pInfoParm->pi_pos;
		}
	}
DEBUGOUTL4(110,"cl_get_info_fixed_attr: attr=%d size=%d pre=%d sca=%d",attr,size,pre,sca);
	iParm[0] = attr;
	iParm[1] = size;
	iParm[2] = pre;
	iParm[3] = sca;
	return attr;
}

/************************************/
/* _chk_def_attr					*/
/************************************/
int _chk_def_attr(iParm,iCONST,pInfoParm)
int iParm[],iCONST;
tdtInfoParm *pInfoParm;
{
	static char *_fn_="_chk_def_attr";
	int rc,iCONST_old,iParm_old[4];

	rc = 0;
	cl_get_info_fixed_attr(pInfoParm,iParm_old);
	iCONST_old = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
	if ((iCONST && !iCONST_old) || (!iCONST && iCONST_old)) {
		/* %s: 萔`قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(449),_fn_,iCONST_old,iCONST);
		rc |= 1;
	}
	if (iParm_old[0] != iParm[0]) {
		/* %s: f[^^قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(450),_fn_,iParm_old[0],iParm[0]);
		rc |= 2;
	}
	else if (iParm_old[1] != iParm[1]) {
		/* %s: قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(451),_fn_,iParm_old[1],iParm[1]);
		rc |= 4;
	}
	if (rc) rc = ECL_SCRIPT_ERROR;
	return rc;
}

/************************************/
/* _get_gid							*/
/************************************/
int _get_gid(scrct,proc,opt)
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	int gid;

	gid = 0;
	if (opt & D_GX_OPT_SET_LOCAL) {
		if (!proc) proc = cl_search_proc_ct();
		if (proc) gid = proc->ProcGid;
	}
	else if (opt & D_GX_OPT_SET_PRIVATE) {
		if (!scrct) scrct = cl_search_src_ct();
		if (scrct) gid = scrct->ScrGid;
	}
	else if (opt & D_GX_OPT_SET_PUBLIC)
		gid = pCLprocTable->myGid;
	else if (opt & D_GX_OPT_SET_GLOBAL)
		gid = pGLprocTable->myGid;
	else {
		if (proc) gid = proc->ProcGid;
		else if (scrct) gid = scrct->ScrGid;
	}
DEBUGOUTL4(170,"_get_gid: scrct=%016lx proc=%016lx opt=%08x gid=%d",scrct,proc,opt,gid);
	return gid;
}
