/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.nanah.bastub.data.JsonInfo;
import jp.nanah.bastub.util.BastubUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JsonService {
    protected static final Logger logger = LoggerFactory.getLogger(JsonService.class);
    public static final String JSON_DATA_NONE_TEXT = "{\"key\":\"auto build\"}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonInfo readJsonFile(File file) {
        String text;
        FileInputStream fis;
        JsonInfo jsonInfo;
        block11: {
            jsonInfo = new JsonInfo();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                try {
                    FileUtils.writeByteArrayToFile((File)file, (byte[])JSON_DATA_NONE_TEXT.getBytes());
                    file.setLastModified(0L);
                }
                catch (Exception e) {
                    logger.info("\u5fdc\u7b54JSON - \u81ea\u52d5\u751f\u6210 [\u5931\u6557]: path=[{}]", (Object)file.getAbsolutePath());
                }
                return jsonInfo;
            }
            fis = null;
            fis = new FileInputStream(file);
            byte[] buff = new byte[(int)file.length()];
            IOUtils.readFully((InputStream)fis, (byte[])buff);
            text = new String(buff, "UTF-8");
            if (!text.equals(JSON_DATA_NONE_TEXT)) break block11;
            JsonInfo jsonInfo2 = jsonInfo;
            IOUtils.closeQuietly((InputStream)fis);
            return jsonInfo2;
        }
        try {
            text = BastubUtils.replaceEmbedText(text);
            String reptext = this.adjustReplaceNumberValue(text);
            String trimText = reptext.trim();
            if (trimText.substring(0, 1).equals("[")) {
                reptext = "{\"dummy\":" + reptext + "}";
                jsonInfo.setTopArray(true);
            }
            try {
                JSONObject jsonObject = new JSONObject(reptext);
                jsonInfo.setJsonObject(jsonObject);
            }
            catch (Throwable th) {
                logger.warn("JSONObject\u5909\u63db\u5931\u6557: path=[{}]", (Object)file.getAbsolutePath(), (Object)th);
                logger.debug("text={}", (Object)reptext);
            }
        }
        catch (Throwable th) {
            try {
                logger.warn("\u5fdc\u7b54\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u5931\u6557: path=[{}]", (Object)file.getAbsolutePath(), (Object)th);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        IOUtils.closeQuietly((InputStream)fis);
        return jsonInfo;
    }

    private String adjustReplaceNumberValue(String org) {
        int top;
        int pos = 0;
        String dst = org;
        while (pos < dst.length() && (top = dst.indexOf("${", pos)) >= 0) {
            int last = BastubUtils.getNumberLast(dst, top);
            if (last >= 0) {
                String v = dst.substring(top, last) + "#N";
                dst = dst.substring(0, top) + "\"" + v + "\"" + dst.substring(last);
                logger.debug("\u2605top={}, last={}, v={}, dst={}", new Object[]{top, last, v, dst});
                pos = last + 1;
                continue;
            }
            ++pos;
        }
        return dst;
    }

    public JSONObject buildResponseJson(JSONObject orgJson, List<Row> resultTarget) {
        this.replaceJson("", orgJson, resultTarget);
        return orgJson;
    }

    public void replaceJson(String path, JSONObject json, List<Row> resultTarget) {
        if (resultTarget == null || resultTarget.size() == 0) {
            return;
        }
        int[] usedRow = new int[resultTarget.get(0).getLastCellNum()];
        logger.debug("[{}]:\u25a0[\u8d70\u67fb\uff11] (res.size={})", (Object)path, (Object)resultTarget.size());
        Iterator it = json.keys();
        while (it.hasNext()) {
            int colNum;
            String key = (String)it.next();
            if (key == null) continue;
            if (json.optJSONArray(key) != null) {
                logger.debug("[{}]:>> Array---> [{}]", (Object)path, (Object)key);
                continue;
            }
            if (json.optJSONObject(key) != null) {
                logger.debug("[{}]:>>JOBJT---> [{}]", (Object)path, (Object)key);
                continue;
            }
            String v = json.optString(key);
            if (v == null || (colNum = BastubUtils.getColumnNoForReplace(v, resultTarget, key)) < 0) continue;
            String toText = "";
            if (resultTarget.size() > 1) {
                int dataRow = usedRow[colNum] + 1;
                if (dataRow < resultTarget.size()) {
                    toText = BastubUtils.getCellText(resultTarget.get(dataRow).getCell(colNum));
                    int n = colNum;
                    usedRow[n] = usedRow[n] + 1;
                    logger.debug("[{}]: \u25ce\u7f6e\u63db\uff1a{\"{}\": \"{}\"} <-- {\"{}\": \"{}\"} ({},{}) ", new Object[]{path, key, v, key, toText, dataRow, colNum});
                } else {
                    logger.warn("[{}]: JSON\u5185\u3067\u30ad\u30fc {\"{}\" \u304c\u91cd\u8907\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u3042\u308a", (Object)path, (Object)key);
                }
            }
            try {
                if (toText != null) {
                    json.put(key, (Object)toText);
                    continue;
                }
                json.put(key, (Object)"");
            }
            catch (Exception e) {
                logger.warn("\u7f6e\u63db\u7570\u5e38", (Throwable)e);
            }
        }
        logger.debug("[{}]:\u25a0\u4e0b\u5c64\u9001\u308a\u30c7\u30fc\u30bf\u751f\u6210", (Object)path);
        List<Row> nextLayerTarget = this.getUniqueRow(resultTarget, usedRow);
        if (nextLayerTarget == null) {
            return;
        }
        logger.debug("[{}]:\u25a0[\u8d70\u67fb\uff12]", (Object)path);
        it = json.keys();
        while (it.hasNext()) {
            String here;
            String key = (String)it.next();
            String string = here = StringUtils.isEmpty((CharSequence)path) ? key : path + "." + key;
            if (json.optJSONArray(key) != null) {
                int colNum;
                String v;
                JSONObject basejo;
                JSONArray extendArray;
                logger.debug("{}: ***** \u4e0b\u5c64\u306b\u914d\u5217\u3042\u308a={} *****", (Object)path, (Object)key);
                JSONArray jsarray = json.optJSONArray(key);
                logger.debug("{}:>> Array---> [{}] length={}", new Object[]{path, key, jsarray.length()});
                logger.debug("{}:>> array as JObj---> [{}] ", new Object[]{path, key, json.optJSONObject(key)});
                if (jsarray.length() == 1) {
                    logger.debug("\u25a0\u914d\u5217\u9577\uff1d\uff11");
                    extendArray = new JSONArray();
                    ArrayList<String> jsonStringList = new ArrayList<String>();
                    try {
                        if (jsarray.optJSONObject(0) != null) {
                            basejo = jsarray.getJSONObject(0);
                            logger.debug("*** \u5c55\u958b\uff11\uff1a[{}]", (Object)basejo.toString(2));
                            for (int i = 1; i < nextLayerTarget.size(); ++i) {
                                List<Row> lowerDataList;
                                boolean isArrayExists = BastubUtils.isArrayExists(basejo);
                                if (isArrayExists) {
                                    lowerDataList = nextLayerTarget;
                                } else {
                                    lowerDataList = new ArrayList<Row>();
                                    lowerDataList.add(nextLayerTarget.get(0));
                                    lowerDataList.add(nextLayerTarget.get(i));
                                }
                                logger.debug("\u6295\u5165\u30c7\u30fc\u30bf: ({})[{}]", (Object)i, BastubUtils.getRowValueList(nextLayerTarget.get(i), true));
                                JSONObject jsobj = new JSONObject(basejo.toString());
                                this.replaceJson(here, jsobj, lowerDataList);
                                String objstr = jsobj.toString();
                                if (!jsonStringList.contains(objstr)) {
                                    jsonStringList.add(objstr);
                                    extendArray.put(extendArray.length(), (Object)jsobj);
                                }
                                if (!isArrayExists) {
                                    continue;
                                }
                                break;
                            }
                        } else if (jsarray.optJSONArray(0) != null) {
                            logger.warn("\u2605\u914d\u5217\u306e\u914d\u5217\u306f\u30b5\u30dd\u30fc\u30c8\u5916\u3002\u5c06\u6765\u5bfe\u5fdc\u3059\u308b\u304b\u3082\u3002");
                        } else {
                            v = jsarray.getString(0);
                            colNum = BastubUtils.getColumnNoForReplace(v, nextLayerTarget, key);
                            logger.debug("\u2605\u2605\u2605\u914d\u5217\u9577\uff1d\uff11\u306e\u5b9f\u5024\u5c55\u958b\uff1a[{}] colnum={}", (Object)v, (Object)colNum);
                            if (colNum >= 0) {
                                for (int i = 1; i < nextLayerTarget.size(); ++i) {
                                    String s = BastubUtils.getCellText(nextLayerTarget.get(i).getCell(colNum));
                                    if (jsonStringList.contains(s)) continue;
                                    jsonStringList.add(s);
                                    extendArray.put(extendArray.length(), (Object)s);
                                }
                            } else {
                                extendArray.put(extendArray.length(), (Object)v);
                            }
                        }
                        json.put(key, (Object)extendArray);
                    }
                    catch (Throwable th) {
                        logger.warn("\u5fdc\u7b54\u30c7\u30fc\u30bf\u751f\u6210\u7570\u5e38\uff11", th);
                    }
                    continue;
                }
                logger.debug("[{}]:\u25b2\u914d\u5217\u304c\uff12\u3064\u4ee5\u4e0a\u3042\u308b\u306e\u3067\u968e\u5c64\u3067\u5c55\u958b[{}]", (Object)path, (Object)key);
                extendArray = new JSONArray();
                try {
                    for (int i = 0; i < jsarray.length(); ++i) {
                        if (jsarray.optJSONObject(i) != null) {
                            basejo = jsarray.getJSONObject(i);
                            this.replaceJson(here, basejo, nextLayerTarget);
                            continue;
                        }
                        if (jsarray.optJSONArray(i) != null) {
                            logger.debug("\u2605\u914d\u5217\u306e\u914d\u5217\u306f\u30b5\u30dd\u30fc\u30c8\u5916\u3002\u5c06\u6765\u5bfe\u5fdc\u3059\u308b\u304b\u3082\u3002");
                            continue;
                        }
                        v = jsarray.getString(i);
                        colNum = BastubUtils.getColumnNoForReplace(v, nextLayerTarget, key);
                        if (colNum >= 0) {
                            String s = BastubUtils.getCellText(nextLayerTarget.get(1).getCell(colNum));
                            extendArray.put(extendArray.length(), (Object)s);
                            continue;
                        }
                        extendArray.put(extendArray.length(), (Object)v);
                    }
                    json.put(key, (Object)extendArray);
                }
                catch (Throwable th) {
                    logger.warn("\u5fdc\u7b54\u30c7\u30fc\u30bf\u751f\u6210\u7570\u5e38\uff12", th);
                }
                continue;
            }
            if (json.optJSONObject(key) == null) continue;
            logger.debug("{}: ***** \u4e0b\u5c64\u306bJSON\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3042\u308a={} *****", (Object)path, (Object)key);
            logger.debug("[{}]: >> JOBJT---> [{}]", (Object)path, (Object)key);
            JSONObject nextJson = json.optJSONObject(key);
            this.replaceJson(here, nextJson, nextLayerTarget);
        }
        logger.debug("{}:\u25a0\u5b8c\u4e86", (Object)path);
    }

    private List<Row> getUniqueRow(List<Row> oldTarget, int[] usedRow) {
        ArrayList<Row> uniqueList = new ArrayList<Row>();
        if (oldTarget.size() < 2) {
            logger.debug("\u5143\u30c7\u30fc\u30bf\u9577\u4e0d\u8db3 (\u30c7\u30fc\u30bf\u884c\u6570={})", (Object)oldTarget.size());
            return null;
        }
        uniqueList.add(oldTarget.get(0));
        ArrayList<String> topValueList = null;
        for (int r = 1; r < oldTarget.size(); ++r) {
            Row rowVal = oldTarget.get(r);
            ArrayList<String> rowValueList = new ArrayList<String>();
            for (int i = 0; i < usedRow.length; ++i) {
                if (usedRow[i] <= 0) continue;
                rowValueList.add(BastubUtils.getCellText(rowVal.getCell(i)));
                logger.debug("\u5217\u30c7\u30fc\u30bf\u4f7f\u7528\uff1a{},{}", (Object)i, rowValueList.get(rowValueList.size() - 1));
            }
            if (rowValueList.size() == 0) continue;
            if (topValueList == null) {
                topValueList = rowValueList;
            }
            if (!BastubUtils.equals(topValueList, rowValueList)) continue;
            uniqueList.add(oldTarget.get(r));
            logger.debug("[{}]\u884c\u76ee\u30c7\u30fc\u30bf\u306f\u4e0b\u4f4d\u9001\u308a val=[{}]", (Object)r, BastubUtils.getRowValueList(rowVal, true));
        }
        if (uniqueList.size() == 1) {
            logger.debug("\u5168\u30c7\u30fc\u30bf\u7e70\u308a\u8d8a\u3057");
            return oldTarget;
        }
        return uniqueList;
    }
}

