static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************/
/*  Program name                                 */
/*       long       col_mn_tr_bexp               */
/* --------------------------------------------- */
/*  (I/O)                                        */
/*       Out        0   :Normal                  */
/*                 -1   :AbNormal                */
/* --------------------------------------------- */
/*  Function :                                   */
/*     Paragraph ^ȌsB              */
/* --------------------------------------------- */
/*************************************************/
#include "colmn.h"

extern condList  CLcList;	/* 񃊃Xg */

static qSubCommand tSC[]=
	{"OPTIONS"		,0,1,CS_OPTIONS		,0,0
	,"OPTION"		,0,3,CS_OPTION		,0,0
	,"SHIFT"		,0,1,CS_SHIFT		,0,0
	,"BREAK"		,0,1,CS_BREAK		,0,0
	,"CONTINUE"		,0,1,CS_CONTINUE	,0,0
	,"LPRINT"		,0,1,CS_LPRINT		,0,0
	,"PRINT"		,0,1,CS_PRINT		,0,0
	,"ECHO"			,0,1,CS_ECHO		,0,0
	,"SAY"			,0,1,CS_ECHO		,0,0
	,"DUMP"			,0,1,CS_DUMP		,0,0
	,"LPRINTF"		,0,1,CS_LPRINTF		,0,0
	,"PRINTF"		,0,1,CS_PRINTF		,0,0
	,"EXIT"			,0,1,CS_EXIT		,0,0
	,"BYE"			,0,1,CS_EXIT		,0,0
	,"QUIT"			,0,1,CS_EXIT		,0,0
	,"INTERACTIVE"	,5,1,CS_INTERACTIVE	,0,0
	,"LOGPARM"		,0,1,CS_LOGPARM		,0,0
	,"MAPPEDARRAY"	,6,2,CS_MAPPEDARRAY	,0,0
	,"ARRAY"		,0,2,CS_ARRAY		,0,D_GX_OPT_SET_ARRAY
	,"TYPE"			,0,4,CS_TYPE		,0,0
	,"TYPEDEF"		,0,4,CS_TYPE		,0,0
	,"VAR"			,0,4,CS_VAR			,0,0
	,"AS"			,0,0x40,CS_AS		,0,0
	,"GLOBAL"		,0,8,CS_GLOBAL		,0,D_GX_OPT_SET_GLOBAL
	,"PUBLIC"		,0,8,CS_PUBLIC		,0,D_GX_OPT_SET_PUBLIC
	,"LOCAL"		,0,8,CS_LOCAL		,0,D_GX_OPT_SET_LOCAL
	,"PRIVATE"		,0,8,CS_PRIVATE		,0,D_GX_OPT_SET_PRIVATE
	,"CONST"		,0,0x10,CS_CONST	,0,D_GX_OPT_SET_CONST
	,"STATIC"		,0,0x10,CS_STATIC	,0,D_GX_OPT_SET_STATIC
	,"CHAR"			,0,0x20,CS_ATTR	,sizeof(char)	,DEF_ZOK_CHAR
	,"BINARY"		,3,0x20,CS_ATTR	,sizeof(int)	,DEF_ZOK_BINA
	,"FLOAT"		,0,0x20,CS_ATTR	,sizeof(double)	,DEF_ZOK_FLOA
	,"FLT"			,0,0x20,CS_ATTR	,sizeof(double)	,DEF_ZOK_FLOA
	,"DECIMAL"		,3,0x20,CS_ATTR	,sizeof(MPA)	,DEF_ZOK_DECI
	,"BULK"			,0,0x20,CS_ATTR	,sizeof(char)	,DEF_ZOK_BULK
	,"DATE"			,0,0x20,CS_ATTR	,sizeof(MPA)	,DEF_ZOK_DATE
	,"VARIANT"		,4,0x20,CS_ATTR	,sizeof(tdtInfoParm *),DEF_ZOK_VARI
	,"INTEGER"		,3,0x20,CS_ATTR	,sizeof(int)	,DEF_ZOK_BINA
	,"LONG"			,0,0x20,CS_ATTR	,sizeof(long)	,DEF_ZOK_LONG
	,"LNG"			,0,0x20,CS_ATTR	,sizeof(long)	,DEF_ZOK_LONG
	,"DOUBLE"		,0,0x20,CS_ATTR	,sizeof(double)	,DEF_ZOK_FLOA
	,"DBL"			,0,0x20,CS_ATTR	,sizeof(double)	,DEF_ZOK_FLOA
	,"STRING"		,3,0x20,CS_ATTR	,sizeof(char)	,DEF_ZOK_CHAR
	,"IN"			,0,0x40,CS_IN		,0,0
	,"EACH"			,0,0x40,CS_EACH		,0,0
	,"TO"			,0,0x40,CS_TO		,0,0
	,"STEP"			,0,0x40,CS_STEP		,0,0
	,"DO"			,0,0x40,CS_DO		,0,0
	,"THEN"			,0,0x40,CS_THEN		,0,0
	,"IP"			,0,0x80,CS_IP		,0,0
	,"EP"			,0,0x80,CS_EP		,0,0
	,"SC"			,0,0x80,CS_SC		,0,0
	,"SM"			,0,0x80,CS_SM		,0,0
	,"EXTENDS"		,0,0x100,CS_EXTENDS	,0,0
	,NULL,0,0,0,0
	};

int _is_cast(/*line,line_len*/);

/********************************************/
/*											*/
/********************************************/
qSubCommand *cl_get_name_attr(name, name_len, opt,sel)
char *name;
int  name_len,opt,sel;
{
	qSubCommand *sc;
	int len,osize,plen;
	char *pn;

	len = name_len;

	for (sc=&tSC[0];pn=sc->name;sc++) {
		if (sc->selector & sel) {
			osize = sc->osize;
			plen = strlen(pn);
			if ((osize>0 && len>=osize && plen>=len) || (len==plen)) {
				if (opt & 0x01) {
					if (!memicmp(name,pn,len)) return sc;
				}
				else {
					if (!memcmp(name,pn,len)) return sc;
				}
			}
		}
	}
	return NULL;
}

/*********************************************/
/*                                           */
/*********************************************/
qSubCommand *cl_tr_sc_set_scno(cmd,scno0,opt,select)
cmdInfo *cmd;
int select,scno0,opt;
{
	int scno,len;
	qSubCommand *sc;
	parmList *pL;
	char *p;

	pL = cmd->prmp[0];
	len = akxnskipto(p=pL->prp,pL->prmlen,"(");
	if (sc=cl_get_name_attr(p,len,opt,select))
		scno = sc->scid;
	else scno = scno0;
	cmd->sub_cid = scno;
	return sc;
}

/*********************************************/
/*                                           */
/*********************************************/
int cl_tr_set_scno(cmd,scno0,opt,select)
cmdInfo *cmd;
int select,scno0,opt;
{
	qSubCommand *sc;
	int scno;

	if (sc=cl_tr_sc_set_scno(cmd,scno0,opt,select))
		scno = sc->scid;
	else scno = scno0;
	return scno;
}

/*********************************************/
/*                                           */
/*********************************************/
int col_mn_tr_bexp(y)
condList *y;
{
	int rc,scno,is,line_len;
	char *p,*pName,*line;
	qSubCommand *sc;
	parmList *pL;
	SSPL_S ssp;
	cmdInfo *cmd;

	cmd = y->cmd;
	if (cmd->prmnum == 0) {
		ERROROUT(FORMAT(51));	/* col_mn_tr_bexp: KvłB */
		return ECL_TR_BEXP;
	}
	if (cmd->cid == C_LET) {
		cl_tr_split(y,0,"(");
		sc = cl_tr_sc_set_scno(cmd,0,0x01,0x00ff);
/*
printf("col_mn_tr_bexp: sc=%08x\n",sc);
if (sc) {
printf("col_mn_tr_bexp: name=[%s] selector=%04x\n",sc->name,sc->selector);
}
*/
		scno = 0;
		if (!sc) is = 0;
		else {
			scno = sc->scid;
			if (sc->selector & 0x3e) {
				if (scno == CS_TYPE) {
					if (!stricmp(cmd->prmp[1]->prp,"STRUCT")) is = 3;
					else is = 2;
				}
				else is = cl_tr_get_def_is(sc->scid);
			}
			else is = -1;
		}
		if (is >= 0) {
			if ((rc=cl_tr_gather(y,is)) > 0) rc = 0;
		}
/*
printf("col_mn_tr_bexp: scno=%d\n",scno);
*/
		if (/*cmd->prmnum>=2 && */(scno==CS_LPRINT || scno==CS_PRINT || scno==CS_ECHO
		    || scno==CS_LPRINTF || scno==CS_PRINTF)) {
			memset(&ssp,0,sizeof(SSPL_S));
			line = cmd->parl[0].par;
			line_len = cmd->parl[0].parlen;
/*
printf("col_mn_tr_bexp: line_len=%d line=[%s]\n",line_len,line);
*/
			akxtgwnsl(line,line_len,&ssp,NULL,0x01);	/* print,lprint,echo,say,printf,lprintf */
			if (line[ssp.sp] == '(')
				cmd->sub_cid = 0;	/* ŏ悤ɂ */
		}
	}
/*
printf("col_mn_tr_bexp: nparm=%d parm[0]=[%s] parm[1]=[%s]\n",
cmd->prmnum,cmd->prmp[0]->prp,cmd->prmp[1]->prp);
*/
	if (!(rc = cl_make_leaf(y))) rc = cl_push(y);

	return rc;
}

/*********************************************/
/*                                           */
/*********************************************/
int cl_tr_gather(y,ip)
condList *y;
int ip;
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	int len,num,i,rc,f;
	char *pnm;
	parmList **prmp;
	cmdInfo *cmd;

	if (ip < 0) return 0;
	cmd = y->cmd;
	prmp = cmd->prmp;
	num = cmd->prmnum;
	if (!ip) {
		if (num > 0) {
			prmp[0]->prp = cmd->parl[0].par;
			prmp[0]->prmlen = len = cmd->parl[0].parlen;
			cmd->prmnum = num = 1;
		}
		else len = 0;
		return len;
	}
	if (num > ip+1) {
		mcat.mc_ipos = f = 0;
		for (i=ip;i<num;i++) {
			len = prmp[i]->prmlen;
			pnm = prmp[i]->prp;
			if (len>0 && pnm) {
				if (f) if ((rc=akxtmcat(&mcat," ",1))<0) return rc;
				if ((rc=akxtmcat(&mcat,pnm,len))<0) return rc;
				f = 1;
			}
		}
		if ((rc=akxtmcat(&mcat,"",1))<0) return rc;
		len = mcat.mc_ipos;
		pnm = mcat.mc_bufp;
/*
printf("cl_tr_gather: ip=%d len=%d p=%08x [%s]\n",ip,len,pnm,pnm);
*/
		cmd->prmnum = ip;
		if (rc=clparmset(y,pnm,len-1)) return rc;
	}
	else len = 0;

	return len;
}

/*********************************************/
/*                                           */
/*********************************************/
int col_mn_tr_label(y)
condList *y;
{
	int rc;

	if (!(rc = cl_make_leaf(y))) rc = cl_push(y);

	return rc;
}
