static char sccsid[]="%Z% %M% %I% %D% %T%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */  
/*                                                   */
/*           coded by A.Kobayashi  96.09.19          */  
/*                                                   */
/*===================================================*/
/*         int   fil_cr_tree(obj,iobj,tree)          */
/*  static int   fil_cr_nest(is,tree,nest,nnest)     */
/*         int   fil_cr_nest0(tree,nest)             */
/*         int   fil_chk_tree(is,tree)               */
/*****************************************************/
#include "somn.h"

int fil_cr_tree(obj,iob,tree)
int iob,obj[];
WHERE_TREE tree[];
{
	int irs,itr,rstk[100],ntr;
	int ib,mc,rdt,v,a,b,t,j;

	ib=irs=0;
	ntr=1;
	if (iob<1) return 1;
	while (ib<=iob) {
		mc = obj[ib++];
#ifdef DEBUG_TREE
printf("cr_tree:ib+1=%d,mc=%d\n",ib,mc);
#endif
		if (mc==99) {
#ifdef DEBUG_TREE
printf("cr_tree:mc=%d,irs=%d\n",mc,irs);
#endif
			if (irs>1) return -1;
			else if (irs==1) {
				irs--;
				ntr = rstk[irs];
#ifdef DEBUG_TREE
printf("cr_tree:mc=%d,rstk[%d]=%d\n",mc,irs,ntr);
#endif
				tree[0].mcode = tree[ntr].mcode;
				tree[0].t2    = tree[ntr].t2;
				tree[0].t1    = tree[ntr].t1;
			}
			return 0;
		}
		if (mc==31) {
			if (ntr >= FIL_MAX_TREE) return ERROR_MAX_TREE;
			tree[ntr].mcode = 0;
			tree[ntr].t1 = obj[ib++];
			tree[ntr].t2 = 0;
			rstk[irs++]=ntr++;
#ifdef DEBUG_TREE
printf("cr_tree:mc=%d,obj=%d,rstk[%d]=%d\n",mc,obj[ib-1],irs-1,rstk[irs-1]);
#endif
		}
		else if (mc==32) {
			continue;
		}
		else if (mc==-7) {
			if (irs<1) return -1;
			b = rstk[--irs];
			if (ntr >= FIL_MAX_TREE) return ERROR_MAX_TREE;
			tree[ntr].mcode = mc;
			tree[ntr].t2    = b;
			tree[ntr].t1    = 0;
			rstk[irs++]=ntr++;
#ifdef DEBUG_TREE
printf("cr_tree:mc=%d,rstk[%d]=%d,\n",mc,irs-1,rstk[irs-1]);
#endif
		}
		else if (mc>=1 && mc<=30) {
			if (irs<2) return -1;
			if (ntr >= FIL_MAX_TREE) return ERROR_MAX_TREE;
			tree[ntr].mcode = mc;
			tree[ntr].t2    = rstk[--irs];
			tree[ntr].t1    = rstk[--irs];
			rstk[irs++]=ntr++;
#ifdef DEBUG_TREE
printf("cr_tree:mc=%d,rstk[%d]=%d,\n",mc,irs-1,rstk[irs-1]);
#endif
		}
		else break;
	}
	return -99;
}

static int fil_cr_nest(is,tree,nest,nnest)
int is;
short *nest,nnest;
WHERE_TREE *tree;
{
	int mc,i1,i2;

	mc = tree[is].mcode;
	if (mc == 21) {	/* and */
		i1 = tree[is].t1;
		i2 = tree[is].t2;
/*
printf("cr_nest:is=%d,mc=%d,i1=%d,i2=%d\n",is,mc,i1,i2);
*/
		if (tree[i1].mcode) nnest = fil_cr_nest(i1,tree,nest,nnest);
		if (tree[i2].mcode) nnest = fil_cr_nest(i2,tree,nest,nnest);
	}
	else {
		if (nnest >= FIL_MAX_NEST) return ERROR_MAX_NEST;
		nest[nnest++] = is;
/*
printf("cr_nest:nnest=%d,is=%d\n",nnest,is);
*/
	}
	return nnest;
}

int fil_cr_nest0(bndp,tree,nest,nest_flg)
SQLDA_FIL *bndp;
WHERE_TREE *tree;
short *nest,*nest_flg;
{
	int i,rc,nnest;

	nnest = fil_cr_nest(0,tree,nest,0);
	if (nnest < 0) return nnest;
	for (i=0;i<nnest;i++) {
		rc = fil_chk_tree(bndp,nest[i],tree);
/*
printf("cr_nest0_tree:i=%d,rc=%d\n",i,rc);
*/
		nest_flg[i] = rc;
	}
	return nnest;
}

int fil_chk_tree(bndp,is,tree)
SQLDA_FIL *bndp;
int is;
WHERE_TREE *tree;
{
	int mc,i1,i2;
	int i,rc=0;

	mc = tree[is].mcode;
	i1 = tree[is].t1;
	i2 = tree[is].t2;
	if (mc) {
/*
printf("chk_tree:is=%d,mc=%d,i1=%d,i2=%d\n",is,mc,i1,i2);
*/
		if (i1>0) {
			rc = fil_chk_tree(bndp,i1,tree);
			if (rc) return rc;
		}
		if (i2>0) rc = fil_chk_tree(bndp,i2,tree);
	}
	else {
/*
printf("chk_tree:is=%d,mc=%d,i1=%d\n",is,mc,i1);
*/
		/* rowid ȊÕJACfbNXĂȂƂAPɂ */
#ifdef NO_INDEX
		if ((i1>101 && i1<201) || (i1>201 && i1<301)) rc = 1;
#else
		if (i1>101 && i1<201) {
			if (!bndp->M[i1-101]) rc = 1;
		}
		else if (i1>201 && i1<301) {
			if (!bndp->M[i1-201]) rc = 1;
		}
#endif
	}
	return rc;
}
