#"%Z% %M% %I% %D% %T%"
#---------------------------------------------------------------
#
#			Configuration
#
#---------------------------------------------------------------
#OSDEPEND	= -DAIX
#OSDEPEND	= -DSUNOS
#OSDEPEND	= -DSUNOS5
#OSDEPEND	= -DLINUX
OSDEPEND	= -DHPUX

#---------------------------------------------------------------
#
#           UNIX commands
#
#---------------------------------------------------------------
SHELL                   = /bin/csh
RM                      = /bin/rm
CP                      = /bin/cp
MV                      = /bin/mv
ECHO                    = @/bin/echo
SYNC                    = /bin/sync
#GET                     = myget
GET                     = /usr/bin/get
MAKE                    = /usr/bin/make
AR                      = /usr/bin/ar
RANLIB                  = /usr/bin/ranlib
CC                      = /bin/cc
#CC                      = gcc
LINK                    = /bin/cc
#LINK                    = gcc
INSTALL                 = /bin/install
SCCS                    = /usr/ucb/sccs

#---------------------------------------------
DEVELOPHOME      = ../../..
DEVELOPBIN       = $(DEVELOPHOME)/bin
DEVELOPLIB       = $(DEVELOPHOME)/lib
DEVELOPTOOLS     = $(DEVELOPHOME)/tools
DEVELOPSRC       = $(DEVELOPHOME)/src
DEVELOPLIB       = $(DEVELOPSRC)/lib
LIBINC           = $(DEVELOPLIB)/include
LIBAKA           = $(DEVELOPLIB)/aka
LIBAKB          = $(DEVELOPLIB)/akb
LIBAKX          = $(DEVELOPLIB)/akx
#---------------------------------------------------------------
#
#			install flags
#
#---------------------------------------------------------------
INSTFLGS		=

#---------------------------------------------------------------
#
#			include paths
#
#---------------------------------------------------------------
INCLUDES		= \
				-I. \
				-I/usr/include \
				-I$(LIBINC)

#---------------------------------------------------------------
#
#			C compiler flags
#
#---------------------------------------------------------------

#---------------------------------------------------------------
#			debugging options
#---------------------------------------------------------------
#DEBUGOPTS		= -g -DDEBUG
DEBUGOPTS		= -g -DDEBUGOUT_ON

#---------------------------------------------------------------
#			cpf options
#---------------------------------------------------------------
#AKBOPTS			= -DNOTICE -DPERROR -DTIME -DMEMCTL
AKBOPTS			= -DNOTICE -DPERROR -DMEMCTL

#---------------------------------------------------------------
#           C Compiler Options
#---------------------------------------------------------------
CFLAGS			= \
				$(OSDEPEND) \
				$(INCLUDES) \
				$(AKBOPTS) \
				$(DEBUGOPTS)

#---------------------------------------------------------------
#			Link Options
#---------------------------------------------------------------
LINKFLGS =

#---------------------------------------------------------------
#
#			Objects
#
#---------------------------------------------------------------

#---------------------------------------------------------------
#			object files for cpTest Component
#---------------------------------------------------------------
HEADERS = 

OBJS = 	dar.o

AKBCOMLIB = \
			$(LIBAKX)/libakx.a

#OTHERLIB  = -lsocket -lnsl -lmalloc

#---------------------------------------------------------------
#
#           LINKER target file
#
#---------------------------------------------------------------
TARGETFILE = dar

#---------------------------------------------------------------
#
#       rules
#
#---------------------------------------------------------------
all : $(TARGETFILE) $(HEADERS)

#---------------------------------------------------------------
#       rules for TARGETFILE
#---------------------------------------------------------------
$(TARGETFILE) : $(OBJS) $(AKBCOMLIB)
		$(LINK) $(OBJS) $(AKBCOMLIB) $(OTHERLIB) -o $(TARGETFILE)
		@\rm -f date.o vers.o date.c

release : $(OBJS) $(AKBCOMLIB)
		$(LINK) $(OBJS) $(AKBCOMLIB) $(OTHERLIB) -o $(TARGETFILE)
		@\cp $(TARGETFILE) $(TARGETFILE).`cat version`.`cat revision`
#		@\rm -f date.o vers.o date.c vers.c

link :  date.o vers.o
		$(LINK) $(LINKFLGS) $(OBJS) $(AKBCOMLIB) $(OTHERLIB) -o $(TARGETFILE)
#		@\rm -f date.o vers.o date.c

#date.c : $(DEVELOPTOOLS)/newdate.sh
#		@sh $(DEVELOPTOOLS)/newdate.sh

#vers.c : $(DEVELOPTOOLS)/newvers.sh
#		@sh $(DEVELOPTOOLS)/newvers.sh

#
# object compile
#
.c.o : $(HEADERS) nofree.mk
		$(CC) $(CFLAGS) -c $*.c

#---------------------------------------------------------------
#
#       other rules
#
#---------------------------------------------------------------

clean :
	-$(RM) -f $(TARGETFILE) $(OBJS)

cleansrc :
	$(SCCS) clean

new : clean all

depend :
	makedepend $(INCLUDES) *.c

install : $(TARGETFILE)
	$(INSTALL) $(INSTFLGS) $(TARGETFILE) $(DEVELOPBIN)

info :
	$(SCCS) info

