static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <clprdeftype.c>                                                  */
/*      Define process   @                          */
/*                                            (2009/05/17 Ver 0.01) */
/********************************************************************/

#include "colmn.h"

extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern CLCOMMON CLcommon;
extern int giOptions[];

#if 1	/* 2020.10.25 */
static char *gsep=" \t(){}[],'=+-*/&|";
#else
static char *gsep=" \t(){}[],'=";
#endif

/************************************/
/*	cl_get_def_attr_check			*/
/************************************/
int cl_get_def_attr_check(nparm,ppParm,iParm,opt)
int nparm;
tdtInfoParm *ppParm[];
int iParm[];
int opt;
{
	static char *name="cl_get_def_attr_check";
	int rc,n,attr,size,opt2;
	int dec_pre,dec_sca;
	char *p0;

	dec_pre = dec_sca = 0;
	attr = iParm[0];
	size = iParm[1];
	if (attr == DEF_ZOK_DECI) {
		rc = cl_get_parm_bin(ppParm[0],&dec_pre,"cl_get_def_attr_check: ");
		if (rc) {
			p0 = NULL;
			if ((rc=parm_to_char(ppParm[0],&p0,NULL)) < 0) return rc;
			/* %s: x(%s)Ă܂Brc=%d */
			ERROROUT3(FORMAT(463),name,p0,rc);
			return ECL_SCRIPT_ERROR;
		}
		if (dec_pre<=0 || dec_pre>NMPA10) {
			/* %s: x(%d)Ă܂B */
			ERROROUT2(FORMAT(464),name,dec_pre);
			return ECL_SCRIPT_ERROR;
		}
		if (nparm >= 2) {
			rc = cl_get_parm_bin(ppParm[1],&dec_sca,"cl_get_def_attr_check: ");
			if (rc) {
				p0 = NULL;
				if ((rc=parm_to_char(ppParm[1],&p0,NULL)) < 0) return rc;
				/* %s: ʎ(%s)Ă܂Brc=%d */
				ERROROUT3(FORMAT(475),name,p0,rc);
				return ECL_SCRIPT_ERROR;
			}
			if (X_ABS(dec_sca) > dec_pre) {
				/* %s: ʎ(%d)Ă܂B */
				ERROROUT2(FORMAT(476),name,dec_sca);
				return ECL_SCRIPT_ERROR;
			}
		}
	}
	else {
		opt2 = opt & 0x02;
		if (opt2 || (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK)) {
			rc = cl_get_parm_bin(ppParm[0],&size,"cl_get_def_attr_check: ");
			if (rc) {
				p0 = NULL;
				if ((rc=parm_to_char(ppParm[0],&p0,NULL)) < 0) return rc;
				/* %s: TCY(%s)Ă܂Brc=%d */
				ERROROUT3(FORMAT(461),name,p0,rc);
				return ECL_SCRIPT_ERROR;
			}
			if (size <= 0) {
				/* %s: TCY(%d)Ă܂B */
				ERROROUT2(FORMAT(462),name,size);
				return ECL_SCRIPT_ERROR;
			}
		}
	}
	iParm[1] = size;
	iParm[2] = dec_pre;
	iParm[3] = dec_sca;
/*
printf("%s: attr=%d size=%d dec_pre=%d dec_sca=%d\n",name,attr,size, dec_pre,dec_sca);
*/
	return 0;
}

/************************************/
/*	_get_def_attr					*/
/************************************/
static int _get_def_attr(line0,llen,iParm,opt,bxobj,Obj)
char *line0;
int   llen;
int   iParm[];
int   opt;
GXObject *bxobj[];
tdtRbChain *Obj;
{
	int rc,nparm,attr,opt1;
	char *line;
	tdtInfoParm *ppParm[2],tInfoParm2[2],*pInfoParm;

	line = line0;
/*
printf("_get_def_attr: llen=%d line=[%s]\n",llen,line);
*/
	if (*line == '(') {
		line++;
		llen -=2 ;
	}
	nparm = rc = 0;
	attr = iParm[0];
	if ((opt & 0x02) || attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK || attr==DEF_ZOK_DECI) {
		iParm[2] = 0;
		iParm[3] = 0;
		opt1 = (opt & D_GX_OPT_GET_DEF_ATTR) | D_GX_OPT_PARMINFO2;
		rc = cl_gx_expsn_obj_opt(line,llen,bxobj,Obj,tInfoParm2,opt1);
		if (rc) {
			/* %s: A܂́AxAʎ̎w(%s)Ă܂Brc=%d */
			ERROROUT3(FORMAT(478),"_get_def_attr",strtemp(line,llen),rc);
			return ECL_SCRIPT_ERROR;
		}
		else {
			if (nparm=tInfoParm2[1].pi_pos) {
				if (!(rc=tInfoParm2[1].pi_hlen)) {
					pInfoParm = (tdtInfoParm *)tInfoParm2[1].pi_data;
					ppParm[0] = pInfoParm;
					if (nparm >= 2) {
						ppParm[1] = pInfoParm + 1;
						nparm = 2;
					}
				}
			}
			else {
				ppParm[0] = tInfoParm2;
				nparm = 1;
			}
			if (!rc) rc = cl_get_def_attr_check(nparm,ppParm,iParm,opt);
		}
	}
	return rc;
}

/************************************/
/*	cl_get_def_attr_opt				*/
/************************************/
int cl_get_def_attr_opt(varnam,vnlen,iParm,opt,bxobj,Obj)
char *varnam;
int   vnlen;
int   iParm[];
int   opt;
GXObject *bxobj[];
tdtRbChain *Obj;
{
	int rc,len,attr,size,line_len,iGET;
	qSubCommand *sc;
	char *line;
/*
printf("cl_get_def_attr_opt: vnlen=%d varnam=[%s]\n",vnlen,varnam);
*/
	iGET = 0;
	if (varnam && vnlen>0) {
		attr = 0;
		size = sizeof(tdtInfoParm *);
		len = akxnskipto(varnam,vnlen,"(");
		if (sc=cl_get_name_attr(varnam,len,0x01,0x20)) {
			size = sc->size;
			attr = sc->attr;
			if ((opt & 0x01) && (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK)) size = 0;
		}
		iParm[0] = attr;
		iParm[1] = size;
		iParm[2] = 0;
		iParm[3] = 0;
		line     = varnam + len;
		line_len = vnlen - len;
		if (vnlen > len) iGET = 1;
	}
	else {
		line     = "";
		line_len = 0;
		if (bxobj && bxobj[0]) iGET = 1;
	}
	rc = 0;
	if (iGET) {
		rc = _get_def_attr(line,line_len,iParm,opt,bxobj,Obj);
	}
	return rc;
}

/************************************/
/*	cl_set_parm_init				*/
/************************************/
int cl_set_parm_init(pInfoParm,iParm,opt)
tdtInfoParm *pInfoParm;
int iParm[],opt;
{
	int rc,attr,size,im;
	char *p;

	size = iParm[1];
	switch (attr=iParm[0]) {
		case DEF_ZOK_VARI:
			rc = cl_parm_set0(pInfoParm);
			break;
		case DEF_ZOK_CHAR:
			rc = cl_set_parm_char(pInfoParm,NULL,0);
			break;
		case DEF_ZOK_BINA:
			rc = cl_set_parm_bin(pInfoParm,0);
			break;
		case DEF_ZOK_FLOA:
			rc = cl_set_parm_double(pInfoParm,0.0);
			break;
		case DEF_ZOK_DECI:
		case DEF_ZOK_DATE:
			if (!(rc=cl_set_parm_mpa(pInfoParm,NULL))) {
				pInfoParm->pi_attr = attr;
				pInfoParm->pi_hlen = iParm[2];	/* precision */
				pInfoParm->pi_pos = iParm[3];	/* scale */
			}
			break;
		case DEF_ZOK_BULK:
			rc = cl_set_parm_char(pInfoParm,NULL,0);
			pInfoParm->pi_attr = attr;
			break;
		default:
			rc = -100;
	}
	if ((opt & 0x01) && (attr!=DEF_ZOK_VARI) && !rc) {
		pInfoParm->pi_len = size;
		pInfoParm->pi_aux[0] = attr;
		if (attr!=DEF_ZOK_BINA && attr!=DEF_ZOK_FLOA) {
			if (attr == DEF_ZOK_CHAR) size++;
			else if (attr == DEF_ZOK_BULK) size += sizeof(int);
			im = (opt & D_GX_OPT_ALC_MASK)>>12;
			if (!im) im = D_OPT_ALC_MALLOC;
			if (im & (D_OPT_ALC_TMP | D_OPT_ALC_MALLOC)) {
				if (p = cl_opt_malloc(im,size)) {
					if ((attr==DEF_ZOK_DECI || attr==DEF_ZOK_DATE) && pInfoParm->pi_data)
						memcpy(p,pInfoParm->pi_data,size);
					else memset(p,0,size);
					if (im == D_OPT_ALC_MALLOC) pInfoParm->pi_scale |= D_DATA_MALLOC;
				}
				else rc = -1;
				pInfoParm->pi_data = p;
			}
			else rc = -1;
		}
		pInfoParm->pi_paux = pInfoParm->pi_data;
	}
DEBUGOUT_InfoParm(151,"cl_set_parm_init: attr=%d rc=%d",pInfoParm,attr,rc);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_skip_to_delm(s,slen,delms,ssp,sep,level)
char *s,*delms,*sep;
int  slen;
SSPL_S *ssp;
int  level;
{
	char c,delm1,delm2;
	int len;
	int kk_level;	/* ()̃lXgx */

	kk_level = level;
	delm1 = delms[0];
	delm2 = delms[1];
	ssp->wdmax = 0;
	while ((len=akxtgwnsl(s,slen,ssp,sep,0x41)) > 0) {
		if (ssp->attr[0] > 10) {
			c = *ssp->wd;
/*
printf("cl_skip_to_delm: sp=%d c=[%c]\n",ssp->sp,c);
*/
			if (c == delm1) kk_level++;
			else if (c == delm2) {
				if (kk_level > 0) {
					kk_level--;
					if (!kk_level) break;
				}
				else return -2;
			}
		}
	}
	if (len < 0) kk_level = len;
/*
printf("cl_skip_to_delm: sp=%d kk_level=%d\n",ssp->sp,kk_level);
*/
	return kk_level;
}

/****************************************/
/*										*/
/****************************************/
int clpeeksl(s,slen,ssp,sep,opt)
char *s,*sep;
int  slen,opt;
SSPL_S  *ssp;
{
	int sp,len;

	if (!ssp) return -1;

	sp = ssp->sp;
	len = akxtgwnsl(s,slen,ssp,sep,opt);
	ssp->sp = sp;
	return len;
}

/************************************/
/*	cl_get_def_attr_SSP_opt_sub		*/
/*  OUT : ssp->sp : int,dec(p,q)A܂́AȊO1[hǂݍ񂾈ʒu */
/************************************/
int cl_get_def_attr_SSP_opt_sub(s,slen,ssp,sep,iParm,opt,bxobj,Obj)
char *s;
int   slen;
SSPL_S *ssp;
char  *sep;
int   iParm[];
int   opt;	/* 0x01:size=0, 0x02:int(n), 0x04:only error when (, 0x08: error when no attr */
GXObject *bxobj[];
tdtRbChain *Obj;
{
	static char *_fn_="cl_get_def_attr_SSP_opt";
	int rc,len,pos,wdmax_save;
	int attr,size,dec_pre,dec_sca;
	qSubCommand *sc;
	char *line,*attr_name,*wrk,c,*wd_save;

	if ((!s || slen<=0) && (bxobj && bxobj[0])) {
		return _get_def_attr("",0,iParm,opt,bxobj,Obj);
	}
	rc = 0;
	attr = dec_pre = dec_sca = 0;
	size = sizeof(tdtInfoParm *);
	iParm[0] = 0;
	iParm[1] = size;
	iParm[2] = 0;
	iParm[3] = 0;
	wd_save = ssp->wd;
	wdmax_save = ssp->wdmax;
	ssp->wdmax = 0;
	len = akxtgwnsl(s,slen,ssp,sep,0x1);
	attr_name = ssp->wd;
	if (len>0 && (((c=*attr_name)>='A' && c<='Z') || (c>='a' && c<='z') || (opt & 0x08))) {
		if (sc=cl_get_name_attr(attr_name,len,0x01,0x20)) {
			size = sc->size;
			attr = sc->attr;
			if ((opt & 0x01) && (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK)) size = 0;
			iParm[0] = attr;
			iParm[1] = size;
		}
		if ((opt & 0x08) && !sc) goto AttrErr;
		else if (sc || ((opt & 0x04) && !sc)) {
			clpeeksl(s,slen,ssp,sep,0x41);
			if (*ssp->wd == '(') {
				if (!sc) goto AttrErr;
				if ((opt & 0x02) ||
				    (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_DECI || attr==DEF_ZOK_BULK)) {
					pos = ssp->sp;
					line = s + pos;
					if (rc=cl_skip_to_delm(s,slen,"()",ssp,sep,0)) {
						/* %s: JbRĂ܂B */
						ERROROUT1(FORMAT(433),_fn_);
						rc = ECL_SCRIPT_ERROR;
					}
					else {
						rc = _get_def_attr(line,ssp->sp-pos,iParm,opt|D_GX_OPT_GET_DEF_ATTR,bxobj,Obj);
					}
				}
			}
		}
	}
	else if (opt & 0x08) {
		/* %s: w肪܂B */
		ERROROUT1(FORMAT(498),_fn_);
		rc = ECL_SCRIPT_ERROR;
	}
	goto End;
 AttrErr:
	wrk = strname(attr_name,len);
	/* %s: Ă܂Battr=[%s] */
	ERROROUT2(FORMAT(477),_fn_,wrk);
	rc = ECL_SCRIPT_ERROR;
 End:
	ssp->wd = wd_save;
	ssp->wdmax = wdmax_save;
	return rc;
}

/************************************/
/*	cl_get_def_attr_SSP_opt			*/
/************************************/
int cl_get_def_attr_SSP_opt(s,slen,ssp,sep,iParm,opt,bxobj,Obj)
char *s;
int   slen;
SSPL_S *ssp;
char  *sep;
int   iParm[];
int   opt;	/* 0x01:size=0, 0x02:int(n), 0x04:only error when (, 0x08: error when no attr */
GXObject *bxobj[];
tdtRbChain *Obj;
{
	int rc,spw,iParm2[8];

	rc = cl_get_def_attr_SSP_opt_sub(s,slen,ssp,sep,iParm,opt,bxobj,Obj);
	if (!rc && iParm[0]>0) {
		spw = ssp->sp;
		if (rc=cl_get_def_attr_SSP_opt_sub(s,slen,ssp,sep,iParm2,0,NULL,Obj)) return rc;
		else if (iParm2[0] > 0) {
			ERROROUT1(FORMAT(365),FORMAT(588));	/* f[^^w肪dĂ܂B */
			rc = ECL_DUPLICATE;
		}
		else ssp->sp = spw;
	}
	return rc;
}

/************************************/
/*	cl_get_def_attr_SSP				*/
/************************************/
int cl_get_def_attr_SSP(s,slen,ssp,sep,iParm,bxobj,Obj)
char *s;
int   slen;
SSPL_S *ssp;
char  *sep;
int   iParm[];
GXObject *bxobj[];
tdtRbChain *Obj;
{
	return cl_get_def_attr_SSP_opt(s,slen,ssp,sep,iParm,0x01,bxobj,Obj);
}

/************************************/
/*	cl_im_parmset					*/
/************************************/
int cl_im_parmset(im,qprmp,pp,len)
int  im;
parmList *qprmp[];
char *pp;
int  len;
{
	parmList *prmp;
	char *p;
	int rc;

	if (!(p=cl_opt_malloc(im,sizeof(parmList)+len+1))) return ECL_MALLOC_ERROR;
	prmp = (parmList *)p;
	memset(prmp,0,sizeof(parmList));
	p += sizeof(parmList);
	memzcpy(p,pp,len);
/*
printf("cl_im_parmset: n=%d len=%d wd=[%s]\n",n,len,p);
*/
	prmp->prp = p;
	prmp->prmlen = len;
	qprmp[0] = prmp;
	return 0;
}

/************************************/
/*	cl_im_parmcpy					*/
/************************************/
int cl_im_parmcpy(im,qprmp,prmp0)
int  im;
parmList *qprmp[],*prmp0;
{
	int rc;
	parmList *prmp;

	if (rc=cl_im_parmset(im,qprmp,prmp0->prp,prmp0->prmlen)) return rc;
	prmp = qprmp[0];
	prmp->opt = prmp0->opt;
	prmp->bxobj = prmp0->bxobj;
	return 0;
}

/************************************/
/*	_parmset						*/
/************************************/
static int _parmset(qprmp,nmax,n,pp,len)
parmList *qprmp[];
int   nmax,n;
char *pp;
int  len;
{
	int rc;

	if ((rc=cl_im_parmset(D_OPT_ALC_TMP,&qprmp[n],pp,len)) >= 0) rc = n + 1;
	return rc;
}

/********1*********2*********3*********4*********5*********6*********/
/*	cl_get_array_def_parm											*/
/*	(nmax<=0 || !qprmp)̂Ƃ́Az`ǂݔ΂B				*/
/*	AƂAssp.sṕAz`̎̃[hǂ񂾌̈ʒuA	*/
/*	z`ȂƂ́AŏɃ[hǂ񂾌̈ʒuA			*/
/*  ܂́AslenwB											*/
/********************************************************************/
int cl_get_array_def_parm(s,slen,dlm,ssp,sep,nmax,qprmp,iEQU)
char *s;
int   slen;
char  *dlm;
SSPL_S  *ssp;
char  *sep;
int   nmax;
parmList *qprmp[];
int  *iEQU;
{
	static char *name="cl_get_array_def_parm";
	int len,kk,n,iSET,iRANGE,is,atr0,kk_level,i,atr_gw;
	char c,c1,*p,*pp,wrk[128],k1,k2,wsep[37],*pat;
	parmList *prmp;
	SSPL_S  sspl;
	uchar uc;
/*
printf("%s:Enter: nmax=%d dlm=[%s] sep=[%s]\n",name,nmax,dlm,sep);
printf("%s:Enter: sp=%d slen=%d s=[%s]\n",name,ssp->sp,slen,s);
*/
	/*sep = cmp_sep2;*/	/* 2020.10.25 */
	len = clpeeksl(s,slen,ssp,sep,0x41);
/*
printf("%s: len=%d sp=%d\n",name,len,ssp->sp);
*/
	n = 0;
/*	if (len==4 && !memicmp(pp,"HASH",4)) {	*/
	if (len > 0) {
		pp = strmem(ssp->wd,len);
/*
printf("%s: wd=%s\n",name,pp);
*/
		if (!stricmp(pp,"HASH")) {
			len = akxtgwnsl(s,slen,ssp,sep,0x41);
			if (n<nmax && qprmp) {
				if ((n=_parmset(qprmp,nmax,n,pp,len)) < 0) {
					return n;
				}
			}
			len = clpeeksl(s,slen,ssp,sep,0x41);
		}
#if 0	/* 2021.5.7 */
		else if (ssp->attr[0] == 1) {
			if (cl_is_yoyakugo(pp)) {
				ERROROUT2(FORMAT(121),name,pp);	/* %s: [%s]͗\łB */
				return ECL_EX_DEFINE;
			}
		}
#endif
	}
	if (len <= 0) {
/*
printf("%s:Exit: n=%d sp=%d wd=[%s]\n",name,n,ssp->sp,strmem(ssp->wd,len));
*/
		return n;
	}
	strcpy(p=wsep," \t'+-*/&|");
	p += strlen(p);
	pp = dlm;
	for (i=0;i<30 && (uc=*pp++);i++) {
		if (uc == '`');
		else if ((uc>=' ' && uc<'0') || (uc>'9' && uc <'A') ||
		    (uc>'Z' && uc<'a') || (uc>'z' && uc <0x7f)) *p++ = uc;
	}
	*p = '\0';
	if ((k1=*ssp->wd)=='[' || k1=='(') {
		kk = 1;
		akxtgwnsl(s,slen,ssp,sep,0x41);
		is = ssp->sp;
		if (k1 == '[') k2 = ']';
		else k2 = ')';
		*p++ = k1;
		*p++ = k2;
		strcpy(p,",");
		kk_level = 1;
	}
	else {
		is = ssp->sp;
		kk = 0;
	}
/*
printf("%s: kk=%d wsep=[%s]\n",name,kk,wsep);
*/
	iSET = iRANGE = 0;
	while ((len=akxtgwnsl(s,slen,ssp,wsep,0x41)) > 0) {
/*
printf("%s: n=%d sp=%d wd=[%s]\n",name,n,ssp->sp,strtemp(ssp->wd,len));
*/
		c = *ssp->wd;
		if (kk) {
			if (c == k2) {
				if (kk_level > 0) kk_level--;
				else {
					ERROROUT2("%s: '%c' unmatched.\n",name,c);
						return ECL_EX_DEFINE;
				}
				if (kk_level > 0) continue;
				iSET = ssp->sp;
/*
printf("%s: sp=%d\n",name,ssp->sp);
*/
				if ((len=akxtgwnsl(s,slen,ssp,wsep,0x41)) > 0) {
/*
printf("%s: len=%d sp=%d wd=[%s]\n",name,len,ssp->sp,strmem(ssp->wd,len));
*/
					if (*dlm == '`')
						pat = strname3("`",1,ssp->wd,len,"`",1);
					else
						pat = strname(ssp->wd,len);
/*
printf("%s: pat=[%s]\n",name,pat);
*/
					if (!inistr(dlm,pat)) {
#if 1	/* 2021.5.7 */
						ERROROUT2(FORMAT(567),name,pat);	/* %%s: ]ȕ(%s)܂B */
#else
						ERROROUT1(FORMAT(171),name);	/* %s: SYNTAXG[B */
#endif
						return ECL_EX_DEFINE;
					}
					if (iEQU) *iEQU = ssp->sp;
				}
/*
printf("%s: len=%d sp=%d wd=[%s]\n",name,len,ssp->sp,strmem(ssp->wd,len));
*/
			}
			else if (c == ',') {
				iSET = ssp->sp;
			}
			else {
				if (c == k1) kk_level++;
				continue;
			}
		}
		else {
			if (instrchar("+-*/&|",c) > 0) {
				c1 = *(s+ssp->sp);
/*
printf("%s: c1=[%c]\n",name,c1);
*/
				if (c1 == '=') {
					ERROROUT1(FORMAT(171),name);	/* %s: SYNTAXG[B */
					return ECL_EX_DEFINE;
				}
				else if (c1!=' ' && c1!='\t') continue;
				c1 = *(s+ssp->sp-2);
				if (c1!=' ' && c1!='\t') continue;
			}
			if (*dlm == '`')
				pat = strname3("`",1,ssp->wd,len,"`",1);
			else
				pat = strname(ssp->wd,len);
/*
printf("%s: pat=[%s]\n",name,pat);
*/
			if (inistr(dlm,pat)) {
/*
printf("%s: c=[%c]\n",name,c);
*/
				if (c=='=' && n>0) {
					sspl.sp = 0;
					sspl.wd = wrk;
					sspl.wdmax = sizeof(wrk);
					p = stradd(qprmp[n-1]->prp,"=");
					atr0 = cmpgwnsl(p,qprmp[n-1]->prmlen+1,&sspl);
/*
printf("%s: atr0=%d p=[%s]\n",name,atr0,p);
*/
					if (atr0>=71 && atr0<=90) n--;
				}
				if (c == '=') {
					if (iEQU) *iEQU = ssp->sp;
				}
				break;
			}
			pp = s + ssp->sp;
			for (i=ssp->sp;i<slen;i++) {
/*
printf("%s: i=%d c=[%c]\n",name,i,*pp);
*/
				if (instrchar(" \t\n\r,]=",*pp) > 0) break;
				pp++;
			}
			ssp->sp = i;
			iSET = ssp->sp + 1;
		}
		if (n<nmax && qprmp) {
		/*	if (kk) {	*/
				len = iSET - is - 1;
				pp = s + is;
		/*	}
			else pp = ssp->wd;	*/
#if 1	/* 2021.5.7 */
			pp = strmem(pp,len);
			if (!stricmp(pp,"HASH")) {
				ERROROUT2(FORMAT(469),name,pp);	/* %s: \"%s\"̈ʒusłB*/
				return ECL_EX_DEFINE;
			}
			else if (cl_is_yoyakugo(pp)) {
				ERROROUT2(FORMAT(121),name,pp);	/* %s: [%s]͗\łB */
				return ECL_EX_DEFINE;
			}
#endif
/*
printf("%s: n=%d sp=%d pp=[%s]\n",name,n,ssp->sp,strmem(pp,len));
*/
			if ((n=_parmset(qprmp,nmax,n,pp,len)) < 0) break;
		}
/*
printf("%s: c=[%c]\n",name,c);
*/
		if (c == k2) break;
		is = iSET;
	}
/*
printf("%s:Exit: n=%d sp=%d\n",name,n,ssp->sp);
*/
	return n;
}

/************************************/
/*	_def_type_mappedarray			*/
/************************************/
static int _def_type_mappedarray(nparm,qprmp,pIndex)
int nparm;
parmList *qprmp[];
tdtArrayIndex *pIndex;
{
	static char *_name_="_def_type_mappedarray";
	int *index,i,rc;

	memset(pIndex,0,sizeof(tdtArrayIndex));
	pIndex->uAttr[0] = DEF_ZOK_VARI;
	pIndex->size = sizeof(tdtInfoParm *);
	index = pIndex->index;
	index[0] = 1;
	index[2] = 0;
	for (i=0;i<=index[0];i++) index[i+3] = 1;
	index[4] = 10;
	index[1] = index[4];
	if (rc = _set_index(0,nparm,qprmp,0,index,_name_)) return rc;
	if (index[3]+index[1]-1 < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_name_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/************************************/
/*	_get_def_member					*/
/************************************/
static int _get_def_member(s,slen,ssp,varlen,pTypeInfo,parmName,type,opt,pos,bxobj,Obj)
char *s;
int  slen;
SSPL_S *ssp;
int  varlen;
tdtInfoParm *pTypeInfo[];
parmList  *parmName[];
int  type,opt,pos;
GXObject *bxobj[];
tdtRbChain *Obj;
{
	static char *_func="_get_def_member";
	int  i,iParmNo,rc,vnlen,attr,len,nparm,n,attr_set,kk,nset;
	int  size;
	char c,*varnam,*pp,*p,*argv[6],*name,id;
	tdtInfoParm *pInfoParm,tInfoParm,tInfoParm2[2];
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	int dec_pre,dec_sca,iParm[4];
	parmList *pL,**ppPrm,*prmpi,prmW;
	parmList *qprmp[4];

	id = 'R';
	if (type == D_AUX0_TYPE_STRUCT) {
		name = FORMAT(465);	/* o */
		nset = 3;
	}
	else {
		name = FORMAT(466);	/* ^` */
		if (type == D_AUX0_TYPE_ARRAY) nset = 3;
		else {
			nset = 4;
			id = 'A';
		}
	}
	varnam = ssp->wd;
	vnlen  = varlen;

	/* ϐpInfoParm̎擾 */
	if (!(pInfoParm=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return ECL_MALLOC_ERROR;
	pTypeInfo[0] = pInfoParm;

	/* ̎擾 */
	if (id == 'R') {	/* MAPPEDARRAŶƂ́A͎włȂ */
		if (rc=cl_get_def_attr_SSP(s,slen,ssp,gsep,iParm,NULL,NULL)) return rc;
		/* ̎_Ńf[^^̎w肪ȂƂ́Assp->sp͕ϐ̌ɈړĂ */
		/* f[^^̎w肪Ƃ́Ǎ̕ϐǂݍޕKv */
		attr_set = iParm[0];	/* >0 ̂ƂAf[^^̎w肠 */
		if (!attr_set) iParm[0] = DEF_ZOK_VARI;
		attr = iParm[0];
		size = iParm[1];
		cl_set_parm_init(pInfoParm,iParm,0);
		if (attr != DEF_ZOK_VARI) {
			pInfoParm->pi_aux[0] = attr;
			pInfoParm->pi_len = size;
		}
	}
	else {
		attr_set = 1;	/* ssp->sp͕ϐ̑Oɂ̂ŁAϐǂݍŁA
							ϐ̌Ɉړ邽 */
		iParm[0] = attr = DEF_ZOK_VARI;
		cl_set_parm_init(pInfoParm,iParm,0);
	}
/*
printf("attr_set=%d sp=%d\n",attr_set,ssp->sp);
*/
	/* ϐ̎擾 */
	if (attr_set) {
		vnlen = akxtgwnsl(s,slen,ssp,gsep,0x41);
		if (vnlen <= 0) {
			ERROROUT2(FORMAT(76),_func,name);	/* %s: %s܂B */
			return ECL_EX_DEFINE;
		}
		varnam = ssp->wd;
	}

	if (!(pL=(parmList *)Malloc(sizeof(parmList)))) return ECL_MALLOC_ERROR;
	parmName[0] = pL;
	pL->prp = Memdup(varnam,vnlen);
	pL->prmlen = vnlen;
	pL->opt = pos;
	if (attr == DEF_ZOK_BULK) size += sizeof(int);
	if (pInfoParm->pi_aux[0])
		pos += ((size+sizeof(int)-1)/sizeof(int))*sizeof(int);
/*
printf("varnam=[%s] vnlen=%d\n",pL->prp,vnlen);
*/
	if (rc=cl_def_chk_name(varnam,vnlen,_func,name)) return rc;

	/* z`̎擾 */
	n = cl_get_array_def_parm(s,slen,",",ssp,gsep,nset,qprmp,NULL);
	if (n < 0) return n;
	else if (n>0 || (type==D_AUX0_TYPE_ARRAY || type==D_AUX0_TYPE_MAPPED)) {
		if (id == 'R') {
			if (rc=_def_array(n,qprmp,opt|D_GX_OPT_NOALLOC_INDX,iParm,&tIndex,0,0)) return rc;
		}
		else {
			if (rc=_def_type_mappedarray(n,qprmp,&tIndex)) return rc;
		}
		attr = iParm[0];
		pInfoParm->pi_id   = id;
		pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
		pInfoParm->pi_attr = DEF_ZOK_BULK;	/* attr;	*/
		pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);
		if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return ECL_MALLOC_ERROR;
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
		if (!(p=Malloc(vnlen+1))) {
			ERROROUT1("%s: Array name area malloc",_func);
			rc = ECL_MALLOC_ERROR;
			goto Error;
		}
		strnzcpy(p,varnam,vnlen);
		pInfoParm->pi_pos = (long)p;
		index = tIndex.index;
		size = tIndex.size;
		if (attr=tIndex.uAttr[0]) {
			if (attr == DEF_ZOK_CHAR) size++;
			else if (attr == DEF_ZOK_BULK) size += sizeof(int);
			len = index[1]*size;
			pos = pL->opt + ((len+sizeof(int)-1)/sizeof(int))*sizeof(int);
		}
		else pos = pL->opt;

DEBUGOUT_InfoParm(194,"cl_pr_ex_def_type: attr=%d size=%d",pInfoParm,attr,size);

	}
	return pos;
 Error:
	return rc;
}

/************************************/
/*	cl_pr_ex_def_type				*/
/************************************/
int cl_pr_ex_def_type(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	static char *sep=" \t(){}[],'";
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	XHASHB *pha_vname,*xhp;
	tdtInfoParm ***pTBL_vname;
	int  i,iParmNo,rc,vnlen,attr,len,nparm,n,attr_set,type,is;
	int  size,pos,slen;
	char c,*varnam,*pp,*p,*argv[6],*s;
	tdtInfoParm *pInfoParm,tInfoParm,tInfoParm2[2];
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	int dec_pre,dec_sca,iParm[4];
	parmList  *parmName[MAX_MEMBER],*pL,**ppPrm,*prmpi,prmW;
	tdtInfoParm *pTypeInfo[MAX_MEMBER];
	tdtDefType *pDeftype;
	int ntype;
	SSPL_S ssp;
	parmList *qprmp[3];

	argv[0] = "cl_pr_ex_def_type";
	/* parameter check */
	/* DEFINE TYPE STRUCT name
	      var_type var_name,
	      var_type var_name;
	   DEFINE TYPE ARRAY var_type var_name;
	   DEFINE TYPE MAPPEDARRAY var_type var_name;	*/
	nparm = 3;
	if (prmnum >= 2) {
		p = pprmp[1]->prp;
		if (!stricmp(p,"ARRAY")) type = D_AUX0_TYPE_ARRAY;
		else if (!stricmp(p,"MAPPEDARRAY")) type = D_AUX0_TYPE_MAPPED;
		else if (!stricmp(p,"STRUCT")) {
			type = D_AUX0_TYPE_STRUCT;
			nparm = 4;
		}
		else type = -1;
	}
	if (prmnum < nparm) {
		/* %s: p[^܂Bprmnum=%d */
		ERROROUT2(FORMAT(467),argv[0],prmnum);
		return ECL_EX_DEFINE;
	}

	is = 2;
	pha_vname = NULL;
	if (type == D_AUX0_TYPE_STRUCT) {
		varnam = pprmp[2]->prp;
		vnlen  = pprmp[2]->prmlen;
		if (rc=cl_def_chk_name(varnam,vnlen,argv[0],FORMAT(466))) return rc;	/* ^` */
		is = 3;
	}
	else if (type!=D_AUX0_TYPE_ARRAY && type!=D_AUX0_TYPE_MAPPED) {
		/* %s: ^w肪Ă܂Btype=[%s] */
		ERROROUT2(FORMAT(468),argv[0],p);
		return ECL_EX_DEFINE;
	}

	ntype = pos = 0;
	s = pprmp[is]->prp;
	slen = pprmp[is]->prmlen;
/*
printf("cl_pr_ex_def_type: type=%d slen=%d s=[%s]\n",type,slen,s);
*/
	memset(&ssp,0,sizeof(SSPL_S));
	if (type==D_AUX0_TYPE_ARRAY || type==D_AUX0_TYPE_MAPPED) {
		if ((vnlen=clpeeksl(s,slen,&ssp,gsep,0x41)) > 0) {
			if ((pos=_get_def_member(s,slen,&ssp,vnlen,&pTypeInfo[0],&parmName[0],type,opt,pos,0,0)) < 0) goto Error;
			varnam = parmName[0]->prp;
			vnlen  = parmName[0]->prmlen;
		}
	}
	else {
		while ((vnlen=clpeeksl(s,slen,&ssp,sep,0x41)) > 0) {
			if ((pos=_get_def_member(s,slen,&ssp,vnlen,&pTypeInfo[ntype],&parmName[ntype],type,opt,pos,0,0)) < 0) goto Error;
			ntype++;
		}
		varnam = pprmp[2]->prp;
		vnlen  = pprmp[2]->prmlen;
	}
 	if (!(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}
	attr = DEF_ZOK_BULK;
	if ((rc=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return rc;
	pha_vname  = (XHASHB *)argv[4];
	pTBL_vname = (tdtInfoParm ***)argv[5];

	if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
		/* %s: %s%sGgp̋󂫂܂B */
		ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
		rc = ECL_SCRIPT_ERROR;
		goto Error;
	}
	pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
	if (!pInfoParm) return ECL_SCRIPT_ERROR;

	info_parm_clear(pInfoParm);
	if (type==D_AUX0_TYPE_STRUCT) {
		pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
		pInfoParm->pi_attr = attr;
		pInfoParm->pi_dlen = sizeof(tdtDefType);
		pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
		if (!(pDeftype=(tdtDefType *)Malloc(sizeof(tdtDefType)))) return ECL_MALLOC_ERROR;
		memset(pDeftype,0,sizeof(tdtDefType));
		pDeftype->size = pos;
		pDeftype->ntype = ntype;
		pInfoParm->pi_data = (char *)pDeftype;
		if (!(pDeftype->vname=(parmList **)Malloc(ntype*sizeof(parmList *)))) return ECL_MALLOC_ERROR;
		memcpy(pDeftype->vname,parmName,ntype*sizeof(parmList *));
		if (!(pDeftype->pType=(tdtInfoParm **)Malloc(ntype*sizeof(tdtInfoParm *)))) return ECL_MALLOC_ERROR;
		memcpy(pDeftype->pType,pTypeInfo,ntype*sizeof(tdtInfoParm *));
		if (!(p=Malloc(vnlen+1))) {
			ERROROUT1("%s: Type def name area malloc",argv[0]);
			rc = ECL_MALLOC_ERROR;
			goto Error;
		}
		strnzcpy(p,varnam,vnlen);
		pInfoParm->pi_pos = (long)p;
	}
	else {
		*pInfoParm = *pTypeInfo[0];
		pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
	}
	pInfoParm->pi_id     = 'P';
	pInfoParm->pi_aux[0] = type;
	pInfoParm->pi_len    = ++pGLprocTable->gid;
	i = akxs_xhasl(pGLprocTable->pha_gid,'S',pInfoParm->pi_len,0);
/*
printf("cl_pr_ex_def_type: Store gid=%ld ix=%d\n",pInfoParm->pi_len,i);
*/

#if 1	/* 2021.3.30 */
	pInfoParm->pi_hlen = _get_gid(scrct,proc,opt);
#else
	if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
	else if (opt & D_GX_OPT_SET_PRIVATE) pInfoParm->pi_hlen = scrct->ScrGid;
#endif

DEBUGOUT_InfoParm(194,"cl_pr_ex_def_type: attr=%d",pInfoParm,attr,0);

	rc =  0;

 Error:
	return rc;
}

/************************************/
/*	_def_var_array_member			*/
/************************************/
int _def_var_array_member(pParm)
tdtInfoParm *pParm;
{
	tdtArrayIndex *pIndex;
	int *index,attr,size,len,n,iParmW[4],rc;
	char *p,*p0;

DEBUGOUT_InfoParm(170,"_def_var_array_member:Enter:",pParm,0,0);

	if (!(pIndex = (tdtArrayIndex *)Malloc(sizeof(tdtArrayIndex)))) return -1;
	memcpy(pIndex,pParm->pi_data,sizeof(tdtArrayIndex));
	pParm->pi_data = (char *)pIndex;
#if 1	/* 2021.3.1 */
	if (p0=(char *)pParm->pi_pos) {
		if (!(p=Malloc((len=strlen(p0))+1))) {
			ERROROUT("_def_var_array_member: array name area malloc");
			return ECL_MALLOC_ERROR;
		}
		strnzcpy(p,p0,len);
		pParm->pi_pos = (long)p;
	}
#endif
	index = pIndex->index;
	if (index[2] < 0) {	/* HASH */
		if (!(pIndex->xhp = akxs_xhash_new2(0,index[4],0,pIndex->size))) return -9;
	}
	else {
		iParmW[0] = pIndex->uAttr[0];
		iParmW[1] = pIndex->size;
		iParmW[2] = 0;
		if ((size=cl_get_def_alsize(iParmW)) < 0) return size;
		n = index[1];
		if (rc=_def_array_set_init_by_attr(iParmW[0],n,size,pIndex,iParmW)) return rc;
	}
	pParm->pi_hlen = 0;
	pParm->pi_paux = (char *)pParm;	/* Rs[ꂽƂɁA̔z񂪗L`FbN邽߂ɕۑ */
	return 0;
}

/************************************/
/*	_def_var_struct					*/
/*  쐬 : 2020.10.12				*/
/************************************/
int _def_var_struct(pInfoParm,pDeftypeP,pDefname,opt)
tdtInfoParm *pInfoParm;
tdtDefType *pDeftypeP;
char *pDefname;
int opt;
{
	tdtInfoParm *pParm;
	tdtDefType *pDeftype;
	parmList  **parmName;
	int  j,rc,ntype,attr,size;
	char id,*p,*p1,*p0;

DEBUGOUT_InfoParm(170,"_def_var_struct:Enter: pDefname=[%s] opt=%08x",pInfoParm,nval(pDefname),opt);
/*
printf("_def_var_struct:Enter: pDefname=[%s]\n",nval(pDefname));
*/
	pInfoParm->pi_id = 'T';
	pDeftype = (tdtDefType *)pInfoParm->pi_data;
	ntype = pDeftype->ntype;
	parmName = pDeftype->vname;
	if (!(pDeftype->pType=(tdtInfoParm **)Malloc(ntype*sizeof(tdtInfoParm *)))) return -1;
	rc = 0;
	for (j=0;j<ntype;j++) {
		if (!(pParm=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
		pDeftype->pType[j] = pParm;
		cl_gx_copy_info(pParm,pDeftypeP->pType[j]);
		if ((id=pParm->pi_id)=='A' || id=='R') {
			if (rc=_def_var_array_member(pParm)) return rc;
		}
		else if (attr=pParm->pi_aux[0]) {
			if (attr!=DEF_ZOK_BINA && attr!=DEF_ZOK_FLOA) {
				size = pParm->pi_len;
				if (attr == DEF_ZOK_CHAR) size++;
				else if (attr == DEF_ZOK_BULK)
					size += sizeof(int);
				if (p = Malloc(size)) {
					if (attr==DEF_ZOK_DECI || attr==DEF_ZOK_DATE)
						memcpy(p,pParm->pi_data,size);
					else strcpy(p,pParm->pi_data);
					pParm->pi_scale |= D_DATA_MALLOC;
				}
				else rc = -1;
				pParm->pi_data = p;
			}
			pParm->pi_paux = pParm->pi_data;
			pParm->pi_aux[1] &= ~D_AUX1_PROTECTED;
		}
	}
	rc = cl_set_struct_name(pInfoParm,pDefname);
	pInfoParm->pi_hlen = _get_gid(NULL,NULL,opt);
/*
printf("_def_var_struct: rc=%d\n",rc);
*/
	return rc;
}

/************************************/
/*	cl_set_struct_name_len			*/
/************************************/
int cl_get_struct_name_len(pDefname)
char *pDefname;
{
	int pos;

	if (pDefname) {
		if ((pos=instrchar(pDefname,'.')) < 0) return pos;
		else if (pos > 0) {
			pos--;
		}
		else pos = strlen(pDefname);
	}
	else pos = -1;
	return pos;
}

/************************************/
/*	cl_set_struct_name				*/
/************************************/
int cl_set_struct_name(pInfoParm,pDefname)
tdtInfoParm *pInfoParm;
char *pDefname;
{
	int pos;
	char *p,*p0,*p1;

	if ((pos=cl_get_struct_name_len(pDefname)) >= 0) {
		if (!(p=Malloc(strlen(p1=(char *)pInfoParm->pi_pos)+pos+2))) return ECL_MALLOC_ERROR;
		p0 = p;
		memzcpy(p,pDefname,pos);
		p += pos;
		*p++ = '.';
		strcpy(p,p1);
		pInfoParm->pi_pos = (long)p0;
/*
printf("cl_set_struct_name:Exit: name=[%s]\n",p0);
*/
		pos = 0;
	}
	return pos;
}

/************************************/
/*	cl_pr_ex_def_var                 */
/************************************/
int cl_pr_ex_def_var(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	XHASHB *pha_vname;
	tdtInfoParm ***pTBL_vname;
	int  i,j,k,iParmNo,rc,vnlen,iParm[4],ias,ntype,datalen,check[4],iCONST,nvar;
	int  iEQU,line_len,sp_save,pos,iCOM,type,vlen,iARRAY,n,pos_var_end;
	char c,*varnam,*p,id,*argv[6],*line,wrk[128],*pp,*vnam;
	tdtInfoParm *pInfoParm,tInfoParm,*pParm,*pInfoDef;
	tdtDefType *pDeftype,*pDeftypeP;
	parmList  **parmName;
	tdtArrayIndex *pIndex;
	int *index,attr,size,len;
	SSPL_S ssp;
	parmList qprmp,*pPrmp;
	parmList *qprmp3[4];
	tdtObjHead *pObj;
	GXObject *bxobj[2];
	uchar ucLOCAL;

	argv[0] = "cl_pr_ex_def_var";
	/* parameter check */
	/* DEFINE VAR [GLOBAL|PUBLIC|PRIVATE|LOCAL] var_name AS type; */
	if (prmnum < 1) {
		/* %s: p[^܂Bprmnum=%d */
		ERROROUT2(FORMAT(467),argv[0],prmnum);
		return ECL_EX_DEFINE;
	}

	pha_vname = NULL;
	iCONST = iEQU = 0;
	line = pprmp[0]->prp;
	line_len = pprmp[0]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL4(170,"%s: prmnum=%d line_len=%d line=[%s]",argv[0],prmnum,line_len,line);
	memset(&ssp,0,sizeof(SSPL_S));
	/* ANZX̎擾 */
	check[1] = 0x03;
	if ((rc=cl_get_def_modifier_SSP(line,line_len,&ssp,gsep,check,iParm,NULL,NULL)) < 0) return rc;
	else if (rc > 0) {
		if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
		opt |= check[3];
		if (!proc && (opt & D_GX_OPT_SET_LOCAL)) {
			ERROROUT1(FORMAT(443),argv[0]);	/* %s: LOCAL͎wł܂B */
			return ECL_SCRIPT_ERROR;
		}
		if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
		if (iParm[0] > 0) {
			/* %s: \"%s\"̈ʒusłB */
			ERROROUT2(FORMAT(469),argv[0],cl_get_attr_name(iParm));
			return ECL_SCRIPT_ERROR;
		}
	}
/*
printf("%s: ssp.sp=%d\n",argv[0],ssp.sp);
printf("%s:1 iParm[0]=%d\n",argv[0],iParm[0]);
*/
	/* ϐ̃XLbv */
	pos = ssp.sp;
	while ((len=akxtgwnsl(line,line_len,&ssp,gsep,0x41)) > 0) {
		if ((c=*ssp.wd) == '=') {
			len = -2;
			iEQU = ssp.sp;
			break;
		}
		else if (!stricmp(strtemp(ssp.wd,len),"AS")) break;
	}
	pos_var_end = ssp.sp;
	iARRAY = 0;
  if (len <= 0) {
	iParm[0] = DEF_ZOK_VARI;
	type = 0;
	if (!len) ssp.sp--;
  }
  else {
	/* f[^^܂͌^`̎擾 */
	sp_save = ssp.sp;
	if (rc=cl_get_def_attr_SSP(line,line_len,&ssp,gsep,iParm,NULL,NULL)) return rc;
	type = 0;
/*
printf("%s:2 iParm[0]=%d\n",argv[0],iParm[0]);
*/
	if (!iParm[0]) {
		ssp.sp = sp_save;
		if ((vnlen=akxtgwnsl(line,line_len,&ssp,gsep,0x41)) <= 0) {
			ERROROUT1(FORMAT(457),argv[0]);	/* %s: ^w肪܂B */
			return ECL_EX_DEFINE;
		}
		varnam = clmemdup(ssp.wd,vnlen,3);
		/* ^`ɕϐw\Ƃ */
		c = *varnam;
		if (c=='(' || c=='$') {
			ssp.sp = sp_save;
			if ((len=_get_varname(line,line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
			else if (len > 0) {
				varnam = pp;
				vnlen = len;
			}
		}
		if (rc=cl_def_chk_name(varnam,vnlen,argv[0],FORMAT(466))) return rc;	/* ^` */
		qprmp.prp = varnam;
		qprmp.prmlen = vnlen;
		if ((rc=cl_conv_parm_opt(&qprmp,&tInfoParm,0))==ECL_DEFINED_ARRAY) rc=0;
		else if (rc) return rc;
		if (tInfoParm.pi_id != 'P') {
			/* %s: ^w肪Ă܂Btype=[%s] */
			ERROROUT2(FORMAT(468),argv[0],varnam);
			return ECL_EX_DEFINE;
		}
		pInfoDef = &tInfoParm;
		pDeftypeP = (tdtDefType *)tInfoParm.pi_data;
		type = tInfoParm.pi_aux[0];
/*
printf("%s: type=%d\n",argv[0],type);
*/
	}
  }

 	if (!(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}

	if ((len=akxtgwnsl(line,line_len,&ssp,gsep,0x41)) < 0) return len;
	else if (*ssp.wd == '=') iEQU = ssp.sp;

	/* ϐ̒` */
	nvar = 0;
	iCOM = 1;
	ssp.sp = pos;
	while ((vnlen=akxtgwnsl(line,line_len,&ssp,gsep,0x41)) > 0) {
		varnam = clmemdup(ssp.wd,vnlen,3);
/*
printf("%s 0: ssp.sp=%d vnlen=%d varnam=[%s]\n",argv[0],ssp.sp,vnlen,varnam);
*/
DEBUGOUTL4(170,"%s 0: ssp.sp=%d vnlen=%d varnam=[%s]",argv[0],ssp.sp,vnlen,varnam);
		if (!stricmp(varnam,"AS") || *varnam=='=') break;
		c = *varnam;
		if (c == ',') {
			if (iCOM) {
				ERROROUT1(FORMAT(458),argv[0]);	/* %s: ϐ͏ȗł܂B */
				return ECL_EX_DEFINE;
			}
			iCOM = 1;
			continue;
		}
/*
printf("%s 1: pos=%d vnlen=%d varnam=[%s]\n",argv[0],pos,vnlen,varnam);
*/
DEBUGOUTL4(170,"%s 1: pos=%d vnlen=%d varnam=[%s]",argv[0],pos,vnlen,varnam);
		iCOM = 0;
		/* ϐɕϐw\Ƃ */
		bxobj[0] = NULL;
		if (c=='(' || c=='$' || c=='#' || c=='%') {
			ssp.sp = pos;
			if ((len=_get_varname(line,line_len,&ssp,proc,bxobj,&pp)) < 0) return len;
			else if (len > 0) {
				varnam = pp;
				vnlen = len;
				c = *varnam;
			}
		}
		if (c=='$') {
			vnlen--;
			varnam++;
		}
		else if (c!='#' && c!='%') c = '$';
/*
printf("%s 2: pos=%d vnlen=%d varnam=[%s]\n",argv[0],pos,vnlen,varnam);
*/
DEBUGOUTL4(170,"%s 2: pos=%d vnlen=%d varnam=[%s]",argv[0],pos,vnlen,varnam);

		/* z`̎擾 */
		n = cl_get_array_def_parm(line,line_len,"`,`=`AS`",&ssp,gsep,3,qprmp3,NULL);
		if (n < 0) return n;
		if (n > 0) {
			iParm[0] = type;
			iParm[2] = (int)&tInfoParm;
/*
printf("%s : iParm=%d %d %d %d\n",argv[0],iParm[0],iParm[1],iParm[2],iParm[3]);
*/
		if (rc=_def_var_define_array(&pInfoParm,prmnum,pprmp,scrct,proc,
		                    iParm,varnam,vnlen,bxobj,n,qprmp3,opt,pos)) return rc;
	  }
	  else {
		/* ϐ̃`FbN */
		vnam = varnam;
		vlen = vnlen;
		if (type==D_AUX0_TYPE_MAPPED && (c=='%' || c=='#')) {
			vnam = varnam + 1;
			vlen = vnlen - 1;
		}
		if (rc=cl_def_chk_name(vnam,vlen,argv[0],FORMAT(441))) return rc;	/* ϐ */
		if ((rc=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return rc;
		pha_vname  = (XHASHB *)argv[4];
		pTBL_vname = (tdtInfoParm ***)argv[5];

		if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
			/* %s: %s%sGgp̋󂫂܂B */
			ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
			return ECL_EX_DEFINE;
		}
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
		if (!pInfoParm) return ECL_SCRIPT_ERROR;
		info_parm_clear(pInfoParm);

		if (iParm[0]) {
			if (rc=cl_set_parm_init(pInfoParm,iParm,0x01)) {
				/* cl_pr_ex_def_var:%s̏ݒG[B */
				ERROROUT2(FORMAT(459),argv[0],varnam);
				return rc;
			}
		}
		else {
			if (rc=cl_gx_rep_info_set(pInfoParm,&tInfoParm,1)) return rc;
			if (!(p=Malloc(vnlen+1))) {
				ERROROUT("cl_pr_ex_def_var: Array name area malloc");
				return ECL_EX_DEFINE;
			}
			strnzcpy(p,varnam,vnlen);
			pInfoParm->pi_pos = (long)p;
			pInfoParm->pi_alen &= ~D_AULN_NO_AL_LPOS;

			if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
			else if (opt & D_GX_OPT_SET_PRIVATE) pInfoParm->pi_hlen = scrct->ScrGid;

			if (type == D_AUX0_TYPE_STRUCT) {
				if (rc = _def_var_struct(pInfoParm,pDeftypeP,(char *)pInfoDef->pi_pos,opt)) return rc;
			}
			else {
				pInfoParm->pi_len = 0;
				if (type == D_AUX0_TYPE_ARRAY) {
					pInfoParm->pi_id = 'R';
					if (rc=_def_var_array_member(pInfoParm)) return rc;
				}
				else {
					pInfoParm->pi_id = 'A';
					pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
					if ((rc=cl_def_map_ary_max_chk(c,pIndex->index,scrct,proc,opt)) < 0) return rc;
					if (opt & D_GX_OPT_SET_LOCAL) ucLOCAL = D_AUX1_LOCAL_VAR;
					else ucLOCAL = 0;
					pInfoParm->pi_aux[1] = ucLOCAL;
				}
			}
		/*	pInfoParm->pi_scale |= D_DATA_INDEX_FREE;	*/
			pInfoParm->pi_scale |= D_DATA_MALLOC | D_DATA_INDEX_FREE;
		}
		pInfoParm->pi_aux[1] |= iCONST;

		if ((rc=cl_gx_clear_var_define(scrct,proc,varnam,opt)) < 0) return rc;

DEBUGOUT_InfoParm(194,"cl_pr_ex_def_var:",pInfoParm,0,0);

	  }
		pos = ssp.sp;
		if (pos >= pos_var_end) {
			break;
		}
	}
	if (iEQU) {
#if 0
		if (type == D_AUX0_TYPE_STRUCT) {
			/* %s: \x8d\\̂ւ̏lݒ͂ł܂B */
			ERROROUT1(FORMAT(472),argv[0]);
			return ECL_EX_DEFINE;
		}
#endif
		pprmp[1]->prp = line + iEQU;
		pprmp[1]->prmlen = line_len - iEQU;
		if (proc) pObj = proc->Obj;
		else pObj = scrct->Obj;
		if (rc = _set_array_values(pInfoParm,1,&pprmp[1],pObj)) return rc;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_free_deftype(id,pDeftype)
char id;
tdtDefType *pDeftype;
{
	int i,ntype;
	parmList *pL,**pparmL;
	tdtInfoParm **ppParm,*pInfoParm;

	ntype = pDeftype->ntype;
	if (id == 'P') {
		pparmL = pDeftype->vname;
		for (i=0;i<ntype;i++) {
			pL = *pparmL++;
			Free(pL->prp);
			Free(pL);
		}
		Free(pDeftype->vname);
	}
	ppParm = pDeftype->pType;
	for (i=0;i<ntype;i++) {
		cl_free_info_parm(pInfoParm=*ppParm);
		Free(pInfoParm);
		ppParm++;
	}
	Free(pDeftype->pType);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _def_var_define_array(ppInfoParmW,prmnum,pprmp,scrct,proc,
                          iParm,vnam,vlen,bxobj,n,qprmp3,opt,is)
tdtInfoParm **ppInfoParmW;
int      prmnum;
parmList **pprmp;
ScrPrCT *scrct;
ProcCT  *proc;
int  iParm[];
char *vnam;
int  vlen;
int  n;
GXObject *bxobj[];
parmList *qprmp3[];
int  opt,is;
{
	CMDObject cmdobj;
	char *da[10],*p;
	int  rc,i,ipr_pos,npr,iob,ida,obj[50],iCONST,iARRAY;

	iCONST = npr = ida = 0;
	obj[0] = 0;	/* sub_id */
	obj[1] = 0;	/* npr */
	obj[2] = 3;	/* ipr_pos */
	iob = obj[2];

	/* ̎擾 */
	iARRAY = 1;
	if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
	npr++;
	obj[iob++] = 1;	/* hc̎擾 */
	ipr_pos = iob++;
	obj[iob++] = ida;	/* w莮 */
	da[ida++] = NULL;
	memcpy(&obj[iob],iParm,sizeof(int)*4);
	iob += 4;
	obj[iob++] = opt;
	obj[iob++] = iCONST;
	obj[iob++] = is;

	obj[ipr_pos] = iob;
	npr++;
	obj[iob++] = 2;	/* hcz`擾̏ */
	ipr_pos = iob++;
	obj[iob++] = iARRAY;	/* z` */
	obj[iob++] = ida;	/* z` */
	obj[iob++] = n;
	obj[iob++] = iARRAY;
	obj[iob++] = 0;
	memcpy(&da[ida],qprmp3,sizeof(parmList *)*n);
	ida += n;

	/* ϐ̎擾 */
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 3;	/* hcϐ擾̏ */
	ipr_pos = iob++;
	obj[iob++] = ida;
	da[ida++] = vnam;	/*clstrdup(varnam,0);*/
	/* z񖼂ɕϐw\Ƃ */
	da[ida] = (char *)bxobj[0];
	if (da[ida]) obj[iob] = ida;
	else obj[iob] = -1;
	ida++;
	iob++;

	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 4;	/* hcϐ`^Ē` */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 5;	/* hc */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 6;	/* hcCONST */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 7;	/* pInfoParmԂ */
	ipr_pos = iob++;
	obj[iob++] = ida;
	da[ida++] = NULL;
	npr++;
	obj[ipr_pos] = iob;

	obj[1] = npr;
/*
	for (i=0;i<iob;i++) printf("obj[%d]=%d\n",i,obj[i]);
	for (i=0;i<ida;i++) printf("da[%d]=0x%08x[%s]\n",i,da[i],da[i]);
*/
	cmdobj.nobj = iob;
	cmdobj.nda = ida;
	cmdobj.exobj = obj;
	cmdobj.da = da;
	if (!(rc=cl_pr_ex_def_array(&cmdobj,prmnum,pprmp,scrct,proc,opt))) {
		if (ppInfoParmW && (p=da[ida-1])) {
			*ppInfoParmW = (tdtInfoParm *)p;
		}
	}
	return rc;
}
