package com.xxxxxxx.drvpp.fw.batch.controller;

import java.util.List;

import org.apache.ibatis.session.SqlSession;
import org.springframework.context.ApplicationContext;

import com.xxxxxxx.drvpp.fw.batch.util.BatchParameter;
import com.xxxxxxx.drvpp.fw.batch.util.Business;
import com.xxxxxxx.drvpp.fw.common.log.Logger;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactory;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactoryBuilder;
import com.xxxxxxx.drvpp.fw.common.mybatis.MyBatisSessionFactory;
import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;

/**
 * アプリケーションコントローラ.
 */
public class ApplicationControllerImpl implements ApplicationController {
	/** バッチパラメータ */
	private BatchParameter parameter = null;

	/**
	 * バッチ実行.<br>
	 * フローに従い業務機能を呼び出す。
	 * <ul>
	 * <li>フローの定義は、XXX設定ファイルに設定する。
	 * <li>フレームワークSQLセッションの取得を行う。
	 * <li>業務がエラー、例外を返した場合は、SQLセッションをロールバックする。その他の場合は、コミットをする。
	 * <li>最後に実行した業務の処理結果が、戻り値となる。業務が例外を返した場合は、XXXとする。
	 * </ul>
	 * 
	 * @param args
	 *            コマンドライン引数
	 * @return 処理結果
	 */
	public int doExecute(String[] args) {
		// ロガー取得
		LoggerFactoryBuilder loggerFactoryBuilder = LoggerFactoryBuilder
				.getInstance();
		LoggerFactory loggerFactory = loggerFactoryBuilder.getLoggerFactory();
		Logger logger = loggerFactory.getLogger(this.getClass());

		// DBセッション取得
		MyBatisSessionFactory sessionFactory = MyBatisSessionFactory
				.getInstance();
		SqlSession sqlSession = sessionFactory.openSession();

		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		// フローの決定
		List<Business> flow = (List<Business>) applicationContext
				.getBean("businessList");

		// 実行
		int result = -1;
		try {
			for (Business b : flow) {
				// パラメータ設定
				parameter = new BatchParameter();
				parameter.setSqlSession(sqlSession);
				// parameter.setRequestParameter(requestParameter);
				// parameter.setRequest(request);
				// parameter.setModel(model);
				// parameter.setViewName("error");
				parameter.setArgs(args);

				// ビジネスロジック起動
				result = b.doExecute(parameter);
			}
		} catch (Exception e) {
			// TODO
			e.printStackTrace();
		} finally {
			// 起動後処理
			if (result == 0) {
				sqlSession.commit();
			} else {
				sqlSession.rollback();
			}
		}

		return result;
	}

	/**
	 * バッチパラメータ取得.
	 * 
	 * @return バッチパラメータ
	 */
	public BatchParameter getParameter() {
		return parameter;
	}

	/**
	 * バッチパラメータ設定.
	 * 
	 * @param parameter
	 *            バッチパラメータ
	 */
	public void setParameter(BatchParameter parameter) {
		this.parameter = parameter;
	}
}
