/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	TODOCMD_SRC_SCENERY
#include"todocmd.h"

/* ===================================================================*/
TODOCMD_SCENERY_EXTERN
int
	Scenery_CompleteTask(
			char	*pstr_id,
			DWord	dw_option )
{
	int		i_result;
	int		i_err;
	int		i_taskid	= NO_TODODATA;
	int		i_len;
	int		i_confirm;
	char	str_buffer[512];
	LibToDo_Data	t_data;

	if( NULL == pstr_id )	{ return 0x03; }

	if( NO_TODODATA == LibToDo_GetTopDataID() )	{
		fputs("  Error!: Do not exist default TaskList in the cache.\n\n", stderr);
		fputs("  Please load default TaskList from Google Cloud by executing the \"todocmd list -r\" command.\n\n", stderr );
		return 0x03;
	}

	i_confirm    = Common_GetToDoID_fromIndicateStr( &i_taskid, pstr_id );
	if( 0x00 > i_confirm )		{
		puts(" Error!: Invalid TaskID.");
		return 0x05;
	}

	if( NO_TODODATA == i_taskid )	{
		fputs("  Error!: Invalid TaskID or TaskNum. exit.\n\n", stderr );
		return 0x06;
	}

	// Print Proc. Task Info. ---
	LibToDo_GetData( &t_data, i_taskid );
	i_len	= strnlen( t_data.str_item, 512 );
	Common_ConvLanguage_toTerminal( str_buffer, (size_t)512, t_data.str_item, i_len );

	puts(" -<Num> Task Name --------------------------------------- Task ID --------------");
	printf( "  <%3d> %-39s %32s\n\n", i_taskid, str_buffer, t_data.str_id );

	// User Confirm Mode --
	if( 0x01 == i_confirm )	{
		fputs(" Is the selected task the above task? (Y/N): ", stdout );

		i_err	= getchar();
		if(( 'y' != i_err ) && ( 'Y' != i_err ))
			{ return 0x00; }
	}

	if( TODO_STATUS_DELETED & t_data.b_status )	{
		puts(" Can't Complete Task because this task is DELETED status!");
		return 0x00;
	}

	LibToDo_SetStatus( i_taskid, TODO_STATUS_COMPLETED );

	if( OPTION_SYNC & dw_option )	{
		assert( NO_TODODATA != i_taskid );
		i_result  = LibToDo_UpdateStatus( i_taskid, TODO_STATUS_COMPLETED );
	}

	return i_result;
}


/* ===================================================================*/
TODOCMD_SCENERY_EXTERN
int
	Scenery_UndoCompleteTask(
			char	*pstr_id,
			DWord	dw_option )
{
	int		i_result;
	int		i_err;
	int		i_taskid	= NO_TODODATA;
	int		i_len;
	int		i_confirm;
	char	str_buffer[512];
	LibToDo_Data	t_data;

	if( NULL == pstr_id )	{ return 0x03; }

	if( NO_TODODATA == LibToDo_GetTopDataID() )	{
		fputs("  Error!: Do not exist default TaskList in the cache.\n\n", stderr);
		fputs("  Please load default TaskList from Google Cloud by executing the \"todocmd list -r\" command.\n\n", stderr );
		return 0x03;
	}

	i_confirm    = Common_GetToDoID_fromIndicateStr( &i_taskid, pstr_id );
	if( 0x00 > i_confirm )		{
		puts(" Error!: Invalid TaskID.");
		return 0x05;
	}

	if( NO_TODODATA == i_taskid )	{
		fputs("  Error!: Invalid TaskID or TaskNum. exit.\n\n", stderr );
		return 0x06;
	}

	// Print Proc. Task Info. ---
	LibToDo_GetData( &t_data, i_taskid );
	i_len	= strnlen( t_data.str_item, 512 );
	Common_ConvLanguage_toTerminal( str_buffer, (size_t)512, t_data.str_item, i_len );

	puts(" -<Num> Task Name --------------------------------------- Task ID --------------");
	printf( "  <%3d> %-39s %32s\n\n", i_taskid, str_buffer, t_data.str_id );

	// User Confirm Mode --
	if( 0x01 == i_confirm )	{
		fputs(" Is the selected task the above task? (Y/N): ", stdout );

		i_err	= getchar();
		if(( 'y' != i_err ) && ( 'Y' != i_err ))
			{ return 0x00; }
	}

	if( TODO_STATUS_DELETED & t_data.b_status )	{
		LibToDo_SetStatus( i_taskid, (TODO_STATUS_DELETED ^ t_data.b_status) );
	}
	else if( TODO_STATUS_COMPLETED & t_data.b_status )	{
		LibToDo_SetStatus( i_taskid, TODO_STATUS_NEEDSACTION );

		if( OPTION_SYNC & dw_option )	{
			assert( NO_TODODATA != i_taskid );
			i_result  = LibToDo_UpdateStatus( i_taskid, TODO_STATUS_NEEDSACTION );
		}
	}
	else
		{ puts("  Above Task is not DELETED or COMPLETED! So, can't undo this task status." ); }

	return i_result;
}


/* ===================================================================*/
/*--------------------------------------------------------------------*/
int
	Scenery_AddTask_GetToDoData(
			LibToDo_Data	*p_tdata,
			char	*pstr_id,
			int		i_defaultid )
{
	int		i_err	= 0x00;
	int		i_retid;

	if(( NULL == pstr_id ) && ( NO_TODODATA == i_defaultid ))
		{ return i_defaultid; }

	i_retid	= i_defaultid;

	if( NULL != pstr_id )
		{ i_err    = Common_GetToDoID_fromIndicateStr( &i_retid, pstr_id ); }
	if( 0x00 > i_err )	{ return -0x02; }

	if( NO_TODODATA == i_retid )
		{ return i_retid; }

	i_err	= LibToDo_GetData( p_tdata, i_retid );
	assert( 0x00 == i_err );

	return i_retid;
}


/*--------------------------------------------------------------------*/
TODOCMD_SCENERY_EXTERN
int
	Scenery_AddTask(
			char	*pstr_title,
			char	*pstr_listid,
			char	*pstr_previd,
			DWord	dw_option )
{
	int				i_len;
	int				i_err;
	int				i_result	= 0;
	int				i_level		= 1;
	int				i_listid	= 1;
	int				i_previd	= NO_TODODATA;
	int				i_parentid	= NO_TODODATA;
	char			str_buffer[512];
	LibToDo_Data	*p_tdata	= NULL;
	LibToDo_Data	*p_tlist;
	LibToDo_Data	*p_tprev;
	LibToDo_Data	*p_tparent;

	if( NULL == pstr_title )	{ return 0x02; }

	if( NO_TODODATA == LibToDo_GetTopDataID() )	{
		fputs("  Error!: Do not exist default TaskList in the cache.\n\n", stderr);
		fputs("  Please load default TaskList from Google Cloud by executing the \"todocmd list -r\" command.\n\n", stderr );
		return 0x03;
	}

	// Alloc ToDoData Buffer ---
	p_tdata	= (LibToDo_Data *)malloc( 3 * sizeof( LibToDo_Data ) );
	if( NULL == p_tdata )	{ return 0x04; }

	memset( p_tdata, 0x00, ( 3 * sizeof( LibToDo_Data )) );

	p_tlist		= (p_tdata + 0);
	p_tprev		= (p_tdata + 1);
	p_tparent	= (p_tdata + 2);

	// Prev. ToDoData ---
	if( NULL != pstr_previd )	{
		i_previd	= Scenery_AddTask_GetToDoData( p_tprev, pstr_previd, i_previd );
		if( NO_TODODATA >= i_previd )	{
			fputs("  Error!: Invalid prev. TaskID or TaskNum. exit.\n\n", stderr );
			i_result	= 0x07;
			goto	goto_Scenery_AddTask_post;
		}

		if((OPTION_ADD_CHILD & dw_option) && (2 == p_tprev->i_level))	{
			fputs("  Error!: Can't add task to SubTask's child. exit.\n\n", stderr );
			i_result	= 0x07;
			goto	goto_Scenery_AddTask_post;
		}
	}

	// Check Operand 1(usually prev. id) is ListData ---
	if(( 0 < p_tprev->i_id) && (0 == p_tprev->i_level))	{
		// Swap ToDoData Area --
		p_tlist	= (p_tdata + 1);
		p_tprev	= (p_tdata + 0);

		i_listid	= p_tlist->i_id;
		i_previd	= NO_TODODATA;
	}
	else	{
		// List ---
		i_listid	= Scenery_AddTask_GetToDoData( p_tlist, pstr_listid, i_listid );
		if( NO_TODODATA >= i_listid )	{
			fputs("  Error!: Invalid ListID or ListNum. exit.\n\n", stderr );
			i_result	= 0x06;
			goto	goto_Scenery_AddTask_post;
		}

		if( 0 != p_tlist->i_level )	{
			fputs("  Error!: ListID or ListNum is NOT List. exit.\n\n", stderr );
			i_result	= 0x06;
			goto	goto_Scenery_AddTask_post;
		}
	}

	// Parent ToDoData ---
	if( NO_TODODATA < i_previd )	{
		i_parentid	= LibToDo_GetParentDataID( i_previd );
		if( NO_TODODATA < i_parentid )	{
			i_err	= LibToDo_GetData( p_tparent, i_parentid );
			i_level	= 2;
		}
	}
	else	{
		i_parentid	= p_tlist->i_id;
		p_tparent	= p_tlist;
		i_level		= 1;
	}


	if(( NO_TODODATA == i_parentid )
			&& ( NO_TODODATA != i_previd )
			&& ( OPTION_ADD_CHILD & dw_option ))	{
		
		i_parentid	= i_previd;
		p_tparent	= p_tprev;

		i_previd	= NO_TODODATA;
		p_tprev		= NULL;

		i_level	= 2;
	}


	// Print Proc. Task Info. ---
	puts(" ----<Num> Task Name --------------------------------------- Task ID --------------");
	PrintToDo_PrintToDoData( p_tlist, OPTION_LIST_ALL );

	if((NO_TODODATA != i_parentid) && (p_tlist != p_tparent))
		{ PrintToDo_PrintToDoData( p_tparent, OPTION_LIST_ALL ); }
	if( NO_TODODATA != i_previd )
		{ PrintToDo_PrintToDoData( p_tprev, OPTION_LIST_ALL ); }

	printf("    ADD >>>>> %s%s\n\n",
			(( 2 == i_level ) ? "   - " : "* " ), pstr_title );

	// User Confirm Mode --
	fputs(" Insert the above task? (Y/N): ", stdout );

	i_err	= getchar();
	if(( 'y' != i_err ) && ( 'Y' != i_err ))	{
		i_result	= 0x00;
		goto	goto_Scenery_AddTask_post;
	}

	i_len	= strnlen( pstr_title, 512 );
	Common_ConvLanguage_toGLAPI( str_buffer, 512, pstr_title, i_len );

	i_err	= LibToDo_InsertToDo( str_buffer, i_listid, i_previd, i_parentid,
					((OPTION_SYNC & dw_option) ? TODO_MODE_SYNC : TODO_MODE_NOSYNC) );

goto_Scenery_AddTask_post:
	free( p_tdata );

	return i_result;
}


/*--------------------------------------------------------------------*/
TODOCMD_SCENERY_EXTERN
int
	Scenery_MoveTask(
			char	*pstr_taskid,
			char	*pstr_previd,
			DWord	dw_option )
{
	int				i_len;
	int				i_err;
	int				i_level;
	int				i_result	= 0;
	int				i_listid	= 1;
	int				i_taskid	= NO_TODODATA;
	int				i_previd	= NO_TODODATA;
	int				i_parentid	= NO_TODODATA;
	char			str_buffer[512];
	LibToDo_Data	*p_tdata	= NULL;
	LibToDo_Data	*p_ttask;
	LibToDo_Data	*p_tlist;
	LibToDo_Data	*p_tprev;
	LibToDo_Data	*p_tparent;
	LibToDo_Data	*p_tnow;

	if(( NULL == pstr_taskid ) || ( NULL == pstr_previd ))
		{ return 0x03; }

	if( ! strncmp( pstr_taskid, pstr_previd, 64) )
		{ return 0x03; }

	if( NO_TODODATA == LibToDo_GetTopDataID() )	{
		fputs("  Error!: Do not exist default TaskList in the cache.\n\n", stderr);
		fputs("  Please load default TaskList from Google Cloud by executing the \"todocmd list -r\" command.\n\n", stderr );
		return 0x03;
	}

	// Alloc ToDoData Buffer ---
	p_tdata	= (LibToDo_Data *)malloc( 5 * sizeof( LibToDo_Data ) );
	if( NULL == p_tdata )	{ return 0x04; }

	p_ttask		= (p_tdata + 0);
	p_tlist		= (p_tdata + 1);
	p_tprev		= (p_tdata + 2);
	p_tparent	= (p_tdata + 3);
	p_tnow		= (p_tdata + 4);

	// Task ---
	i_taskid	= Scenery_AddTask_GetToDoData( p_ttask, pstr_taskid, i_taskid );
	if( NO_TODODATA >= i_taskid )	{
		fputs("  Error!: Invalid TaskID or TaskNum.\n\n", stderr );
		i_result	= 0x06;
		goto	goto_Scenery_MoveTask_post;
	}
	i_level		= p_ttask->i_level;

	// List ---
	i_listid	= LibToDo_GetListDataID( i_taskid );
	if( NO_TODODATA >= i_listid )	{
		i_result	= 0x07;
		goto	goto_Scenery_MoveTask_post;
	}
	i_err		= LibToDo_GetData( p_tlist, i_listid );
	assert( 0x00 == i_err );

	// Prev. ToDoData ---
	i_previd	= Scenery_AddTask_GetToDoData( p_tprev, pstr_previd, i_previd );
	if( NO_TODODATA >= i_previd )	{
		fputs("  Error!: Invalid prev. TaskID or TaskNum.\n\n", stderr );
		i_result	= 0x07;
		goto	goto_Scenery_MoveTask_post;
	}

	// Check ---
	if((OPTION_ADD_CHILD & dw_option) && ( 2 == p_tprev->i_level ))	{
		fputs("  Error!: Can't move task to SubTask's child. exit.\n\n", stderr );
		i_result	= 0x08;
		goto	goto_Scenery_MoveTask_post;
	}

	// Parent ToDoData ---
	if( NO_TODODATA < i_previd )	{
		i_level	= p_tprev->i_level;

		i_parentid	= LibToDo_GetParentDataID( i_previd );
		if( NO_TODODATA < i_parentid )	{
			i_err	= LibToDo_GetData( p_tparent, i_parentid );
		}
		else	{
			if(0 == p_tprev->i_level)	{
				if( i_previd != i_listid )	{
					i_result	= 0x08;
					goto	goto_Scenery_MoveTask_post;
				}

				dw_option	|= OPTION_ADD_CHILD;
			}
		}
	}

	if(( NO_TODODATA == i_parentid )
			&& ( NO_TODODATA != i_previd )
			&& ( OPTION_ADD_CHILD & dw_option ))	{

		i_parentid	= i_previd;
		p_tparent	= p_tprev;

		i_previd	= NO_TODODATA;
		p_tprev		= NULL;

		i_level++;	
	}


	// Print Proc. Task Info. ---
	puts(" -<Num> Task Name --------------------------------------- Task ID --------------");
	PrintToDo_PrintToDoData( p_tlist, OPTION_LIST_ALL );

	if((NO_TODODATA != i_parentid) && (p_tlist->i_id != p_tparent->i_id))
		{ PrintToDo_PrintToDoData( p_tparent, OPTION_LIST_ALL ); }
	if( NO_TODODATA != i_previd )
		{ PrintToDo_PrintToDoData( p_tprev, OPTION_LIST_ALL ); }

	i_len	= strnlen( p_ttask->str_item, 512 );
	Common_ConvLanguage_toTerminal( str_buffer, 512, p_ttask->str_item, i_len );

	printf("    MOVE >>>> %s%s\n\n", (( 2 == i_level ) ? "   - " : "* " ), str_buffer );

	// User Confirm Mode --
	fputs(" Move the above task? (Y/N): ", stdout );

	i_err	= getchar();
	if(( 'y' != i_err ) && ( 'Y' != i_err ))	{
		i_result	= 0x00;
		goto	goto_Scenery_MoveTask_post;
	}

	if( NO_TODODATA == i_parentid )
		{ i_parentid	= i_listid; }

	i_err	= LibToDo_MoveToDo( i_taskid, i_listid, i_previd, i_parentid,
					((OPTION_SYNC & dw_option) ? TODO_MODE_SYNC : TODO_MODE_NOSYNC) );

goto_Scenery_MoveTask_post:
	free( p_tdata );

	return i_result;
}


/* ===================================================================*/
TODOCMD_SCENERY_EXTERN
int
	Scenery_DeleteTask(
			char	*pstr_id,
			DWord	dw_option )
{
	int		i_result;
	int		i_err;
	int		i_taskid	= NO_TODODATA;
	int		i_len;
	int		i_confirm;
	char	str_buffer[512];
	LibToDo_Data	t_data;

	if( NULL == pstr_id )	{ return 0x03; }

	if( NO_TODODATA == LibToDo_GetTopDataID() )	{
		fputs("  Error!: Do not exist default TaskList in the cache.\n\n", stderr);
		fputs("  Please load default TaskList from Google Cloud by executing the \"todocmd list -r\" command.\n\n", stderr );
		return 0x03;
	}

	i_confirm    = Common_GetToDoID_fromIndicateStr( &i_taskid, pstr_id );
	if( 0x00 > i_confirm )		{
		puts(" Error!: Invalid TaskID.");
		return 0x05;
	}

	if( NO_TODODATA == i_taskid )	{
		fputs("  Error!: Invalid TaskID or TaskNum. exit.\n\n", stderr );
		return 0x06;
	}

	// Print Proc. Task Info. ---
	LibToDo_GetData( &t_data, i_taskid );

	// Check ----
	if( 0 == t_data.i_level )	{
		fputs(" Can't delete TaskList by todocmd. exit.\n", stderr );
		return 0x00;
	}

	if( NO_TODODATA != LibToDo_GetChildDataID( i_taskid ) )	{
		fputs(" Can't delete Task with SubTask. Please delete SubTask at first. exit.\n", stderr );
		return 0x00;
	}

	i_len	= strnlen( t_data.str_item, 512 );
	Common_ConvLanguage_toTerminal( str_buffer, (size_t)512, t_data.str_item, i_len );

	puts(" -<Num> Task Name --------------------------------------- Task ID --------------");
	printf( "  <%3d> %-39s %32s\n\n", i_taskid, str_buffer, t_data.str_id );

	fputs(" Is the selected task the above task? (Y/N): ", stdout );

	i_err	= getchar();
	if(( 'y' != i_err ) && ( 'Y' != i_err ))
		{ return 0x00; }

	LibToDo_SetStatus( i_taskid, (TODO_STATUS_DELETED | t_data.b_status) );

	if( OPTION_SYNC & dw_option )	{
		assert( NO_TODODATA != i_taskid );
		i_result  = LibToDo_DeleteTask( i_taskid );
	}

	return i_result;
}


/* EOF of main.c ******************************************************/
