/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	TODOCMD_SRC_COMMON
#include"todocmd.h"

static	char	gstr_lang_terminal[64];
static	iconv_t	gt_iconv_in		= (iconv_t)(-1);
static	iconv_t	gt_iconv_out	= (iconv_t)(-1);


/* ===================================================================*/
int
	Common_SearchToDoID(
			int		i_list,
			char	*pstr_param )
{
	int				i_result;
	int				i_todo;
	int				i_child;
	LibToDo_Data	t_data;

	i_todo	= i_list;
	while( NO_TODODATA != i_todo )	{
		// Check Child ToDoData ---
		i_child	= LibToDo_GetChildDataID( i_todo );
		if( NO_TODODATA != i_child )	{
			i_result	= Common_SearchToDoID( i_child, pstr_param );
			if( NO_TODODATA != i_result )	{ return i_result; }
		}

		// Check ID ---
		LibToDo_GetData( &t_data, i_todo );
		if( ! strncmp( t_data.str_id, pstr_param, 64 ))
			{ return i_todo; }

		i_todo	= LibToDo_GetNextDataID( i_todo );
	}

	return NO_TODODATA;
}


/* ===================================================================*/
TODOCMD_COMMON_EXTERN
int
	Common_GetToDoID_fromIndicateStr(
			int		*pi_taskid,
			char	*pstr_param )
{
	int		i_len;
	int		i_taskid	= 0;
	int		i_topid;
	int		i_result	= -0x03;
	int		i_err;
	char	*pstr_pos;
	LibToDo_Data	t_data;

	if( NULL == pstr_param )	{
		*pi_taskid	= NO_TODODATA;
		return -0x01;
	}

	i_len	= strnlen( pstr_param, 32 );
	pstr_pos	= pstr_param;

	while(0 < i_len)	{
		if( ! isdigit( (int)*pstr_pos ))	{ break; }

		i_taskid	= (i_taskid * 10) + ((int)(*pstr_pos - 0x30));
		pstr_pos++;
		i_len--;
	}

	if( 0 == i_len )	{
		// XXX
		i_err	= LibToDo_GetData( &t_data, i_taskid );
		if( 0x00 > i_err )	{
			i_taskid	= NO_TODODATA;
			i_result	= -0x02;
		}
		else	{
			i_result	= 0x01;		// User Confirm Mode.
		}
	}
	else	{
		i_topid		= LibToDo_GetTopDataID();
		i_taskid	= Common_SearchToDoID( i_topid, pstr_param );
		i_result	= 0x00;		// None Confirm Mode.
	}

	*pi_taskid	= i_taskid;

	return i_result;
}


/* ===================================================================*/
int
	Common_SetTerminalLang(
			char *pstr_lang )
{
	int		i_len;
	char	*pstr_term;
	char	*pstr_dest;

	if( NULL == pstr_lang )	{
		pstr_term	= getenv( "LANG" );
		if( NULL == pstr_term )	{
			return -0x01;
		}

		i_len	= strnlen( pstr_term, 64 );
		if( 64 <= i_len )	{
			return -0x02;
		}

		while(( '.' != *pstr_term ) && ( '\0' != *pstr_term ))
			{ pstr_term++; }

		pstr_dest	= gstr_lang_terminal;
		while( '\0' != *pstr_term++ )
			{ *pstr_dest++	= toupper( *pstr_term ); }
		*pstr_dest	= '\0';

		if( '\0' == gstr_lang_terminal[0] )
			{ strncpy( gstr_lang_terminal, "EUC-JP", 64 ); }
	}
	else
		{ strncpy( gstr_lang_terminal, pstr_lang, 64 ); }

	return 0x00;
}


/* ===================================================================*/
TODOCMD_COMMON_EXTERN
int
	Common_ConvLanguage_toTerminal(
			char	*pstr_dest, 
			size_t	sz_dest,
			char	*pstr_src, 
			size_t	sz_src )	{

	int		i_errcount  = 0;
	size_t	sz_result;

	while(( 0 < sz_src ) && ( ICONV_PERMIT_ERRCOUNT > i_errcount ))		{
		sz_result   = iconv( gt_iconv_in, (char **)&pstr_src, &sz_src, &pstr_dest, &sz_dest );

		if( -1 == sz_result )	{
			if( 0 < sz_src )	{
				*pstr_dest++	= *pstr_src++;
				sz_src--;
				sz_dest--;
			}
			i_errcount++;
		}
	}

	*pstr_dest  = '\0';

	return i_errcount;
}


/* ===================================================================*/
TODOCMD_COMMON_EXTERN
int
	Common_ConvLanguage_toGLAPI(
			char	*pstr_dest, 
			size_t	sz_dest,
			char	*pstr_src, 
			size_t	sz_src )	{

	int		i_errcount  = 0;
	size_t	sz_result;

	while(( 0 < sz_src ) && ( ICONV_PERMIT_ERRCOUNT > i_errcount ))		{
		sz_result   = iconv( gt_iconv_out, (char **)&pstr_src, &sz_src, &pstr_dest, &sz_dest );

		if( -1 == sz_result )	{
			if( 0 < sz_src )	{
				*pstr_dest++	= *pstr_src++;
				sz_src--;
				sz_dest--;
			}
			i_errcount++;
		}
	}

	*pstr_dest  = '\0';

	return i_errcount;
}


/* ===================================================================*/
TODOCMD_COMMON_EXTERN
int
	Common_InitLibiconv(
			char *pstr_lang )
{
	int		i_result;

	i_result	= Common_SetTerminalLang( pstr_lang );
	if( 0 > i_result )	{
		return -0x01;
	}

	gt_iconv_in	= iconv_open( gstr_lang_terminal, "UTF-8" );
	if( (iconv_t)(-1) == gt_iconv_in )	{
		fprintf( stderr, "Error!!: Can't Initialize libiconv(in: %d)\n", errno );
		return -0x02;
	}

	gt_iconv_out	= iconv_open( "UTF-8", gstr_lang_terminal );
	if( (iconv_t)(-1) == gt_iconv_in )	{
		fprintf( stderr, "Error!!: Can't Initialize libiconv(out: %d)\n", errno );
		return -0x02;
	}

	return 0x00;
}


/* ===================================================================*/
TODOCMD_COMMON_EXTERN
int
	Common_TermLibiconv(
			void )
{
	iconv_close( gt_iconv_in );
	gt_iconv_in		= (iconv_t)(-1);

	iconv_close( gt_iconv_out );
	gt_iconv_out	= (iconv_t)(-1);

	return 0x00;
}

/* EOF of main.c ******************************************************/
