/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#ifndef	LIBTODO_HEADER_TODODATA
#define	LIBTODO_HEADER_TODODATA

#ifdef LIBTODO_SRC_TODODATA
	#define LIBTODO_TODODATA_EXTERN
#else
	#define LIBTODO_TODODATA_EXTERN	extern
#endif

#define	TODODATA_ALLOC_UNITS	1024

#define	TODODATA_APPEND			0xffffffffffffffff

#define	NO_TDATA	-0x01

#define	TODODATA_TYPE_NONE		0x00
#define	TODODATA_TYPE_MASTER	0x01
#define	TODODATA_TYPE_LIST		0x02
#define	TODODATA_TYPE_TASK		0x04
#define	TODODATA_TYPE_SUB		0x08

#define	TODODATA_FLAG_CLEAR		0x00
#define	TODODATA_FLAG_SYNCED	0x01

#define	TODODATA_FLAG_UNSYNC_MASK	0xf8
#define	TODODATA_FLAG_UNSYNC_STATUS	0x10
#define	TODODATA_FLAG_UNSYNC_TITLE	0x20
#define	TODODATA_FLAG_UNSYNC_UPDATE	0x30
#define	TODODATA_FLAG_UNSYNC_INSERT	0x40
#define	TODODATA_FLAG_UNSYNC_DELETE	0x80
#define	TODODATA_FLAG_UNSYNC_MOVE	0x08

#define	TODODATA_POSITION_TOP	0xfffffffffffffffe

typedef	struct	{
	int		i_id;

	int		i_parent;
	int		i_child;
	int		i_prev;
	int		i_next;

	Byte	b_type;
	Byte	b_status;
	Byte	b_flag;

	int		i_index;
	DWord	dw_hash;
	char	str_id[64];
	QWord	qw_position;

	char	str_parent[64];

	LibToDo_Data	t_data;		/* id, item, update */

} ToDo_Data;

typedef struct	{
	DWord	dw_hash;
	int		i_id;
} ToDo_Index;


typedef	struct	{
	char	str_header[16];		/* LIBTODO_CACHE___ */
	Word	w_version;

	int		i_items;
	char	str_lastupdate[32];

} ToDo_CacheHeader;


#ifdef LIBTODO_SRC_TODODATA
static	ToDo_Data	*gp_tododata		= NULL;
static	ToDo_Index	*gp_todoindex	 	= NULL;
static	int			gi_alloc_tododata	= 0;
static	int			gi_max_tododata		= 0;
static	int			gi_empty_chain;
static	int			gi_topdata;
static	char		gstr_lastupdated[32];
static	QWord		gqw_lastupdated;
#endif

LIBTODO_TODODATA_EXTERN
	void ToDoData_UpdatePosition( ToDo_Data *p_tdata );
LIBTODO_TODODATA_EXTERN
	void ToDoData_UpdateIndex( ToDo_Data *p_tdata );
LIBTODO_TODODATA_EXTERN
	void ToDoData_RenewLastUpdated( char *pstr_updated );
LIBTODO_TODODATA_EXTERN
	char *ToDoData_GetLastUpdated( void );
LIBTODO_TODODATA_EXTERN
	void ToDoData_UpdateFlag( ToDo_Data *p_tdata, Byte b_flag );
LIBTODO_TODODATA_EXTERN
	int ToDoData_UpdateFlag_AllToDoData( Byte b_flag );
LIBTODO_TODODATA_EXTERN
	int ToDoData_ClearDoneTask( void );
LIBTODO_TODODATA_EXTERN
	int ToDoData_ReNumberingDataID( void );
LIBTODO_TODODATA_EXTERN
	int ToDoData_SetStatus( ToDo_Data *p_tdata, Byte b_status );
LIBTODO_TODODATA_EXTERN
	ToDo_Data *ToDoData_GetToDoData( int i_tdata_id );
LIBTODO_TODODATA_EXTERN
	int ToDoData_ReadInCache( char *pstr_filepath );
LIBTODO_TODODATA_EXTERN
	int ToDoData_WriteOutCache( char *pstr_filepath );
LIBTODO_TODODATA_EXTERN
	int ToDoData_SearchParent( ToDo_Data *p_tlist, char *pstr_parent );
LIBTODO_TODODATA_EXTERN
	int ToDoData_SearchData( char *pstr_id );
LIBTODO_TODODATA_EXTERN
	void ToDoData_ClearToDoData( ToDo_Data *p_tdata );
LIBTODO_TODODATA_EXTERN
	void ToDoData_SortIndex( void );
LIBTODO_TODODATA_EXTERN
	int ToDoData_AppendChain( int i_tdata, int i_parent, Byte b_type, QWord qw_position );
LIBTODO_TODODATA_EXTERN
	int ToDoData_InsetToDoData( int i_parent, Byte b_type, char *pstr_id, QWord qw_position );
LIBTODO_TODODATA_EXTERN
	void ToDoData_DisConnectChain( ToDo_Data *p_tdata );
LIBTODO_TODODATA_EXTERN
	void ToDoData_FreeToDoData( ToDo_Data *p_tdata );
LIBTODO_TODODATA_EXTERN
	int ToDoData_Init( void );
LIBTODO_TODODATA_EXTERN
	void ToDoData_Term( void ); 

#ifdef LIBTODO_SRC_TODODATA
ToDo_Data *ToDoData_AllocToDoData( char *pstr_id );
void ToDoData_InsertEmptyChain( ToDo_Data *p_tdata );
void ToDoData_DisConnectToDoData( ToDo_Data *p_tdata );
#endif

#endif

/* EOF of main.c ******************************************************/
