/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_GLAPI_TASK

#include"libtodo_header.h"

/*==========================================================================
list
GET		https://www.googleapis.com/tasks/v1/lists/<tasklist id>/tasks
Returns all tasks in the specified task list.
==========================================================================*/
#define	GLAPI_URL_TASKS	"https://www.googleapis.com/tasks/v1/"

int
	GLAPI_Tasks_GetTask_RegistTaskfromJson(
			char		*pstr_nexttoken,
			json_object	*p_json,
			ToDo_Data	*p_tlist,
			Byte		b_option )
{
	int		i_cnt;
	int		i_tasks		= 0;
	int		i_result	= 0x00;
	int		i_task_id;
	int		i_tparent;
	char	str_parentid[64];
	char	str_temp[512];
	Byte	b_type;
	QWord	qw_position;
	json_object		*p_jitems;
	json_object		*p_jtask;
	ToDo_Data		*p_tdata;

	if( 0x00 != ProcJson_CheckKind( p_json, JSON_VALUE_TASKS_KIND ) )	{
		SET_ERRINFO( "Failed function call: ProcJson_CheckKind()" );
		i_result	= -0x01;
		goto	goto_GLAPI_Tasks_GetTask_RegistTaskfromJson_post;
	}

	ProcJson_GetJsonChildString( pstr_nexttoken, p_json, JSON_KEY_TASKS_NEXTPAGETOKEN, 255 );

	p_jitems	= ProcJson_GetJsonChildArray( p_json, JSON_KEY_TASKS_ITEMS );
	if( NULL == p_jitems )	{
		// Supress Error Msg: becase the case exists that the TaskList don't exist the tasks.
		goto	goto_GLAPI_Tasks_GetTask_RegistTaskfromJson_post;
	}

	for( i_cnt = 0; i_cnt < json_object_array_length( p_jitems ); i_cnt++ )	{
		str_parentid[0]	= '\0';
		p_jtask	= json_object_array_get_idx( p_jitems, i_cnt );
		assert( NULL != p_jtask );

		// parent:
		ProcJson_GetJsonChildString( str_parentid, p_jtask, JSON_KEY_TASK_PARENT, 64 );
		if( '\0' != str_parentid[0] )	{ b_type	= TODODATA_TYPE_SUB; }
		else							{ b_type	= TODODATA_TYPE_TASK; }
		i_tparent	= p_tlist->i_id;

		// position:
		ProcJson_GetJsonChildString( str_temp, p_jtask, JSON_KEY_TASK_POSITION, 32 );
		qw_position	= Common_ConvStr2QWord( str_temp );

		// id
		ProcJson_GetJsonChildString( str_temp, p_jtask, JSON_KEY_TASK_ID, 64 );
		// Alloc ToDo Data ---
		i_task_id	= ToDoData_InsetToDoData( i_tparent, b_type, str_temp, qw_position );
		if( 0 > i_task_id )	{
			SET_ERRINFO1( "Failed function call: ToDoData_InsetToDoData()", i_task_id );
			i_result	= -0x02;
			goto	goto_GLAPI_Tasks_GetTask_RegistTaskfromJson_post;
		}

		p_tdata	= ToDoData_GetToDoData( i_task_id );
		assert( NULL != p_tdata );

		// etag: NOT USE.

		// status: "needsAction" or "completed"
		ProcJson_GetJsonChildString( str_temp, p_jtask, JSON_KEY_TASK_STATUS, 32 );
		if( !strncmp( str_temp, "completed", 32 ) )
			{ p_tdata->b_status	= TODO_STATUS_COMPLETED; }
		else
			{ p_tdata->b_status	= TODO_STATUS_NEEDSACTION; }
		p_tdata->t_data.b_status	= p_tdata->b_status;

		// title
		ProcJson_GetJsonChildString( str_temp, p_jtask, JSON_KEY_TASK_TITLE, 512 );
		if((p_tdata->b_status == TODO_STATUS_NEEDSACTION) || (str_temp[0] != '\0'))
			{ strncpy( p_tdata->t_data.str_item, str_temp, 512 ); }
		// updated
		ProcJson_GetJsonChildString( p_tdata->t_data.str_update, p_jtask, JSON_KEY_TASK_UPDATED, 32 );
		ToDoData_RenewLastUpdated( p_tdata->t_data.str_update );
		// parentid
		strncpy( p_tdata->str_parent, str_parentid, 64 );
		// selflink: NOT USE.

		// Flag update
		ToDoData_UpdateFlag( p_tdata, TODODATA_FLAG_SYNCED );

		// level
		p_tdata->t_data.i_level	= ((TODODATA_TYPE_TASK == b_type) ? 1 : 2);
		p_tdata->t_data.i_id	= p_tdata->i_id;

		i_tasks++;
	}

	i_result	= i_tasks;

goto_GLAPI_Tasks_GetTask_RegistTaskfromJson_post:
	return i_result;
}

//--------------------------------------------------------------------------
LIBTODO_GLAPI_TASK_EXTERN
int
	GLAPI_Task_GetTasks(
			ToDo_Data	*p_tlist,
			Byte		b_option )
{
	int				i_err;
	int				i_tasks	= 0;
	json_object		*p_json;
	GLAPI_Result	t_glresult;
	char			str_url[256];
	char			str_nexttoken[256];
	char			str_lastupdated[32];

	str_nexttoken[0]	= '\0';

	GLAPI_Base_AllocResultArea( &t_glresult );

	do	{
		// Assemble URL ---
		snprintf( str_url, 255, GLAPI_URL_TASKS
			"lists/%s/tasks?showCompleted=%s&showHidden=%s&maxResults=100"
			"&fields=kind,nextPageToken,items(id,title,position,status,parent,updated)",
				p_tlist->str_id, 
				((GETTASK_OPTION_SHOWALL & b_option) ? "true" : "false" ),
				((GETTASK_OPTION_SHOWALL & b_option) ? "true" : "false" ) );

		if( ! (GETTASK_OPTION_RELOAD & b_option) )	{
			strncpy( str_lastupdated, ToDoData_GetLastUpdated(), 32 );
			Common_URL_Encode( str_lastupdated, 0 );
			strncat( str_url, "&updatedMin=", 255 );
			strncat( str_url, str_lastupdated, 255 );
		}

		if( '\0' != str_nexttoken[0] )	{
			Common_URL_Encode( str_nexttoken, 0 );
			strncat( str_url, "&pageToken=", 255 );
			strncat( str_url, str_nexttoken, 255 );
		}

		// Do API ---
		GLAPI_Base_ClearResultArea( &t_glresult, 0x00 );
		i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_GET, str_url );
		if( 0x00 != i_err )	{
			SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err );
			i_tasks	= -0x01;
			goto	goto_GLAPI_Task_GetTasks_post;
		}

		//printf( "debug: %s\n%s\n", str_url, (const char *)t_glresult.pb_result );
		
		p_json	= json_tokener_parse( (const char *)t_glresult.pb_result );
		i_err	= GLAPI_Tasks_GetTask_RegistTaskfromJson(
							str_nexttoken, p_json, p_tlist, b_option );
		if( 0 < i_err )	{ i_tasks	+= i_err; }
		json_object_put( p_json );

	}while( '\0' != str_nexttoken[0] );

goto_GLAPI_Task_GetTasks_post:
	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_tasks;
}


/*==========================================================================
get
GET		https://www.googleapis.com/tasks/v1/lists/tasklist/tasks/task
Returns the specified task.
==========================================================================*/

/*==========================================================================
insert
POST	https://www.googleapis.com/tasks/v1/lists/tasklist/tasks
Creates a new task on the specified task list.
==========================================================================*/
LIBTODO_GLAPI_TASK_EXTERN
int
	GLAPI_Task_InsertTask(
			char		*pstr_title,
			ToDo_Data	*p_tnow,
			ToDo_Data	*p_tlist,
			ToDo_Data	*p_tprev,
			ToDo_Data	*p_tparent )
{
	int				i_err;
	int				i_options	= 0;
	json_object		*p_json;
	GLAPI_Result	t_glresult;
	char			str_url[256];
	char			str_buffer[1024];

	GLAPI_Base_AllocResultArea( &t_glresult );

	// Assemble URL ---
	snprintf( str_url, 255, GLAPI_URL_TASKS"lists/%s/tasks", p_tlist->str_id );
	if( NULL != p_tparent )	{
		snprintf(str_buffer, 1024, "%cparent=%s",
					((0 == i_options) ? '?' : '&'), p_tparent->str_id );
		strncat( str_url, str_buffer, 255 );
		i_options++;
	}
	if( NULL != p_tprev )	{
		snprintf(str_buffer, 1024, "%cprevious=%s",
					((0 == i_options) ? '?' : '&'), p_tprev->str_id );
		strncat( str_url, str_buffer, 255 );
		i_options++;
	}

	// Assemble POST JSON data ---
	strcat( (char *)t_glresult.pb_request, "{\n" );
	strcat( (char *)t_glresult.pb_request, "  \"" JSON_KEY_TASK_KIND "\": " JSON_VALUE_TASK_KIND ",\n" );
	
	snprintf( str_buffer, 1024, "  \"" JSON_KEY_TASK_TITLE "\": \"%s\"", pstr_title );
	strncat( (char *)t_glresult.pb_request, str_buffer, 1024 );

	strcat( (char *)t_glresult.pb_request, "\n}" );

	// Do API ---
	i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_POST | SENDAPI_BODY_JSON, str_url );
	if( 0x00 > i_err )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err ); }
	//printf( "debug: %s\n%s\n-------------------", str_url, (const char *)t_glresult.pb_result );

	// Data Regist ---
	p_json	= json_tokener_parse( (const char *)t_glresult.pb_result );

	if( 0x00 != ProcJson_CheckKind( p_json, JSON_VALUE_TASK_KIND ) )	{
		SET_ERRINFO( "Failed function call: ProcJson_CheckKind()" );
		i_err	= -0x01;
		goto	goto_GLAPI_Task_InsertTask_endjson;
	}

	// position:
	ProcJson_GetJsonChildString( str_buffer, p_json, JSON_KEY_TASK_POSITION, 32 );
	p_tnow->qw_position	= Common_ConvStr2QWord( str_buffer );

	// id
	ProcJson_GetJsonChildString( str_buffer, p_json, JSON_KEY_TASK_ID, 64 );
	strncpy( p_tnow->str_id, str_buffer, 64 );
	strncpy( p_tnow->t_data.str_id, str_buffer, 64 );
	p_tnow->dw_hash	= Common_CalcDJBhash( p_tnow->str_id );
	ToDoData_UpdateIndex( p_tnow );

	// etag: NOT USE.

	// updated
	ProcJson_GetJsonChildString( p_tnow->t_data.str_update, p_json, JSON_KEY_TASK_UPDATED, 32 );
	ToDoData_RenewLastUpdated( p_tnow->t_data.str_update );

	// parentid
	ProcJson_GetJsonChildString( str_buffer, p_json, JSON_KEY_TASK_PARENT, 64 );
	strncpy( p_tnow->str_parent, str_buffer, 64 );

	// selflink: NOT USE.

goto_GLAPI_Task_InsertTask_endjson:
	json_object_put( p_json );

	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_err;
}


/*==========================================================================
update
PUT		https://www.googleapis.com/tasks/v1/lists/<tasklist>/tasks/<task>
Updates the specified task.
==========================================================================*/
LIBTODO_GLAPI_TASK_EXTERN
int
	GLAPI_Task_UpdateTask(
			ToDo_Data	*p_ttask,
			ToDo_Data	*p_tlist,
			char		*pstr_title,
			char		*pstr_status,
			Byte		b_hidden )
{
	int				i_err;
	GLAPI_Result	t_glresult;
	char			str_url[256];
	char			str_buffer[1024];


	GLAPI_Base_AllocResultArea( &t_glresult );

	// Assemble URL ---
	snprintf( str_url, 255, GLAPI_URL_TASKS"lists/%s/tasks/%s", p_tlist->str_id, p_ttask->str_id );

	// Assemble PUT data ---
	
	strcat( (char *)t_glresult.pb_request, "{\n" );
	
	snprintf( str_buffer, 1024, "  \"" JSON_KEY_TASK_ID "\": \"%s\"", p_ttask->str_id );
	strncat( (char *)t_glresult.pb_request, str_buffer, 32768 );

	if( NULL != pstr_title )	{
		strcat( (char *)t_glresult.pb_request, ",\n" );
		snprintf( str_buffer, 1024, "  \"" JSON_KEY_TASK_TITLE "\": \"%s\"", pstr_title );
		strncat( (char *)t_glresult.pb_request, str_buffer, 32768 );
	}
	if( NULL != pstr_status )	{
		strcat( (char *)t_glresult.pb_request, ",\n" );
		snprintf( str_buffer, 1024, "  \"" JSON_KEY_TASK_STATUS "\": \"%s\"", pstr_status );
		strncat( (char *)t_glresult.pb_request, str_buffer, 32768 );
	}
	strcat( (char *)t_glresult.pb_request, "\n}" );

	// Do API ---
	i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_PUT, str_url );
	if( 0x00 > i_err )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err ); }

	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_err;
}


/*==========================================================================
delete
DELETE	https://www.googleapis.com/tasks/v1/lists/tasklist/tasks/task
Deletes the specified task from the task list.
==========================================================================*/
LIBTODO_GLAPI_TASK_EXTERN
int
	GLAPI_Task_DeleteTask(
			ToDo_Data	*p_ttask,
			ToDo_Data	*p_tlist )
{
	int				i_err;
	GLAPI_Result	t_glresult;
	char			str_url[256];

	GLAPI_Base_AllocResultArea( &t_glresult );

	// Assemble URL ---
	snprintf( str_url, 255, GLAPI_URL_TASKS"lists/%s/tasks/%s", p_tlist->str_id, p_ttask->str_id );

	// Do API ---
	i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_DELETE, str_url );
	if( 0x00 > i_err )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err ); }

	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_err;
}


/*==========================================================================
clear
POST	https://www.googleapis.com/tasks/v1/lists/<tasklist>/clear
Clears all completed tasks from the specified task list.
The affected tasks will be marked as 'hidden' and no longer be returned by
 default when retrieving all tasks for a task list.
==========================================================================*/
LIBTODO_GLAPI_TASK_EXTERN
int
	GLAPI_Task_ClearTasks(
			ToDo_Data	*p_tlist )
{
	int				i_err;
	GLAPI_Result	t_glresult;
	char			str_url[256];

	GLAPI_Base_AllocResultArea( &t_glresult );

	// Assemble URL ---
	snprintf( str_url, 255, GLAPI_URL_TASKS"lists/%s/clear", p_tlist->str_id );

	// Do API ---
	GLAPI_Base_ClearResultArea( &t_glresult, 0x00 );
	i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_POST, str_url );
	if( 0x00 > i_err )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err ); }

	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_err;
}


/*==========================================================================
move
POST	https://www.googleapis.com/tasks/v1/lists/tasklist/tasks/task/move
Moves the specified task to another position in the task list.
This can include putting it as a child task under a new parent and/or
 move it to a different position among its sibling tasks.
==========================================================================*/
LIBTODO_GLAPI_TASK_EXTERN
int
	GLAPI_Task_MoveTask(
			ToDo_Data	*p_ttask,
			ToDo_Data	*p_tlist,
			ToDo_Data	*p_tprev,
			ToDo_Data	*p_tparent )
{
	int				i_err;
	int				i_options	= 0;
	GLAPI_Result	t_glresult;
	char			str_url[256];
	char			str_buffer[1024];

	GLAPI_Base_AllocResultArea( &t_glresult );

	// Assemble URL ---
	snprintf( str_url, 255, GLAPI_URL_TASKS"lists/%s/tasks/%s/move", p_tlist->str_id, p_ttask->str_id );
	if(( NULL != p_tparent ) && (p_tlist != p_tparent))	{
		snprintf(str_buffer, 1024, "%cparent=%s",
					((0 == i_options) ? '?' : '&'), p_tparent->str_id );
		strncat( str_url, str_buffer, 255 );
		i_options++;
	}
	if( NULL != p_tprev )	{
		snprintf(str_buffer, 1024, "%cprevious=%s",
					((0 == i_options) ? '?' : '&'), p_tprev->str_id );
		strncat( str_url, str_buffer, 255 );
		i_options++;
	}

	// Do API ---
	i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_POST | SENDAPI_BODY_JSON, str_url );
	if( 0x00 > i_err )
		{ SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err ); }

	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_err;
}


/*==========================================================================
patch
PATCH	https://www.googleapis.com/tasks/v1/lists/tasklist/tasks/task
Updates the specified task. This method supports patch semantics. 
==========================================================================*/



/* EOF of main.c ******************************************************/
