/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_CONFIGFILE

#include"libtodo_header.h"


/* ===================================================================*/
void
	ConfigFile_Debug_PrintConfig( void )
{
	printf( CONFIGFILE_KEY_ACCESS_TOKEN	"=%s\n", gt_config.str_access_token );
	printf( CONFIGFILE_KEY_REFRESH_TOKEN"=%s\n", gt_config.str_refresh_token );
	printf( CONFIGFILE_KEY_TOKEN_TYPE	"=%s\n", gt_config.str_token_type );
	printf( CONFIGFILE_KEY_CLIENT_ID	"=%s\n", gt_config.str_client_id );
	printf( CONFIGFILE_KEY_CLIENT_SECRET"=%s\n", gt_config.str_client_secret );

	return;
}


/* ===================================================================*/
LIBTODO_CONFIGFILE_EXTERN
int
	ConfigFile_Global_Import_GLClientSecretJson(
			char	*pstr_importfilepath )
{
	int				i_result	= 0x00;
	char			str_client_id[256];
	char			str_client_secret[256];
	FILE			*fp;
	json_object		*p_jfile;
	json_object		*p_json;

	p_jfile	= json_object_from_file( pstr_importfilepath );
	if( NULL == p_jfile )	{
		SET_ERRINFO( "Failed function call: json_object_from_file()" );
		return -0x01;
	}

	p_json	= ProcJson_GetJsonChildObject( p_jfile, JSON_KEY_GLAPI_INSTALLED );
	if( NULL == p_json )	{
		i_result	= -0x02;
		SET_ERRINFO( "Failed function call: ProcJson_GetJsonChildObject()" );
		goto	goto_ConfigFile_Global_Import_GLClientSecretJson_put;
	}

	ProcJson_GetJsonChildString( str_client_id, p_json, JSON_KEY_GLAPI_CLIENT_ID, 256 );
	ProcJson_GetJsonChildString( str_client_secret, p_json,  JSON_KEY_GLAPI_CLIENT_SECRET, 256 );

	fp	= fopen( LIBTODO_GLOBAL_CONFIG_DIR LIBTODO_GLOBAL_CONFIG_FILE, "w" );
	if( NULL == fp )	{
		i_result	= -0x03;
		SET_ERRINFO( "Failed function call: fopen()" );
		goto	goto_ConfigFile_Global_Import_GLClientSecretJson_put;
	}

	fprintf( fp, CONFIGFILE_KEY_CLIENT_ID"=%s\n", str_client_id );
	fprintf( fp, CONFIGFILE_KEY_CLIENT_SECRET"=%s\n", str_client_secret );
	
	fclose( fp );

goto_ConfigFile_Global_Import_GLClientSecretJson_put:
	json_object_put( p_json );

	return i_result;
}


/* ===================================================================*/
LIBTODO_CONFIGFILE_EXTERN
int
	ConfigFile_Global_CreateOAuthURL(
			char	*pstr_url )
{
	int		i_result	= 0x00;
	int		i_len;
	FILE	*fp;
	char	str_buf[512];
	char	str_clientid[256];

	if( NULL == pstr_url )	{
		SET_ERRINFO( "Invalied Param. (pstr_url == NULL)" );
		return -0x01;
	}

	fp	= fopen( LIBTODO_GLOBAL_CONFIG_DIR LIBTODO_GLOBAL_CONFIG_FILE, "r" );
	if( NULL == fp )	{
		SET_ERRINFO( "Failed function call: fopen()" );
		return -0x02;
	}

	if( NULL == fgets( str_buf, 512, fp ))	{
		i_result	= -0x03;
		SET_ERRINFO( "Failed function call: fgets()" );
		goto	goto_ConfigFile_Global_CreateOAuthURL_post;
	}

	i_len	= strnlen( str_buf, 512 );
	if( 14 > i_len )	{
		i_result	= -0x04;
		SET_ERRINFO( "Invalid Global-Configfile format.(Line Size is less than 14bytes.)" );
		goto	goto_ConfigFile_Global_CreateOAuthURL_post;
	}

	str_buf[13]	= '\0';		// '=' -> NULL (for seperate key & value)
	if( '\n' == str_buf[i_len - 1] )	{
		str_buf[i_len - 1]	= '\0';
		i_len--;
	}

	if( 0x00 != strcmp( str_buf, CONFIGFILE_KEY_CLIENT_ID ))	{
		i_result	= -0x05;
		SET_ERRINFO( "Invalid Global-Configfile format.(Can't find the client_id key.)" );
		goto	goto_ConfigFile_Global_CreateOAuthURL_post;
	}

	strncpy( str_clientid, (str_buf + 14), 256 );

// XXX SECURITY RISK!!! --- Must URL-Encode.
	snprintf( pstr_url, 1024,
				"https://accounts.google.com/o/oauth2/auth"
				"?client_id=%s"
				"&redirect_uri=urn%%3Aietf%%3Awg%%3Aoauth%%3A2.0%%3Aoob"
				"&scope=https://www.googleapis.com/auth/tasks"
				"&response_type=code"
				"&access_type=offline",
				str_clientid );

goto_ConfigFile_Global_CreateOAuthURL_post:
	fclose( fp );

	return i_result;
}


/* ===================================================================*/
LIBTODO_CONFIGFILE_EXTERN
int
	ConfigFile_CreateConfig(
			char *pstr_code )
{
	int		i_len;
	int		i_result;
	FILE	*fp;
	char	str_buf[1024];
	struct stat	t_buf;

	if( LIBTODO_MODE_DEBUG != gb_mode )	{
		if( 0x00 == stat( gstr_configfile, &t_buf ) )
			{ return 0x01; }
	}

	memset( &gt_config, 0x00, sizeof( LibToDo_Config ) );


	fp	= fopen( LIBTODO_GLOBAL_CONFIG_DIR LIBTODO_GLOBAL_CONFIG_FILE, "r" );
	if( NULL == fp )	{
		SET_ERRINFO( "Failed function call: fopen()" );
		return -0x01;
	}

	do	{
		if( NULL == fgets( str_buf, 1024, fp ))	{ break; }

		i_len	= strnlen( str_buf, 1024 );
		if( 14 > i_len )	{ continue; }

		str_buf[13]	= '\0';		// '=' -> NULL (for seperate key & value)
		if( '\n' == str_buf[i_len - 1] )	{
			str_buf[i_len - 1]	= '\0';
			i_len--;
		}
		if( !strcmp( str_buf, CONFIGFILE_KEY_CLIENT_ID ))
			{ strncpy( gt_config.str_client_id, (str_buf + 14), 256 ); }
		if( !strcmp( str_buf, CONFIGFILE_KEY_CLIENT_SECRET ))
			{ strncpy( gt_config.str_client_secret, (str_buf + 14), 256 ); }
		
	}while( !feof(fp) );
	fclose( fp );

	strncpy( gt_config.str_code, pstr_code, 256 );

	i_result	= GLAPI_Base_GetToken();
	if( 0x00 != i_result )	{
		SET_ERRINFO( "Failed function call: GLAPI_Base_GetToken()" );
		return -0x02;
	}

	// ConfigFile_Debug_PrintConfig();

	i_result	= ConfigFile_WriteConfig( LIBTODO_MODE_NORMAL );
	if( 0x00 != i_result )	{
		SET_ERRINFO( "Failed function call: ConfigFile_WriteConfig()" );
		return -0x03;
	}

	return 0x00;
}


/* ===================================================================*/
LIBTODO_CONFIGFILE_EXTERN
void
	ConfigFile_SetConfigFilePath(
			char	*pstr_cfgpath )
{
	struct stat	t_buf;
	char	str_curpath[256];

	getcwd( str_curpath, 255 );
	if( strncmp( str_curpath, getenv("HOME"), 255) )	{
		if( 0x00 == stat( "./"LIBTODO_USER_CONFIGFILE, &t_buf ) )	{
			strncpy( gstr_configfile, "./"LIBTODO_USER_CONFIGFILE, 255 );
			puts(" --- DEBUG MODE ---\n   * Use ConfigFile in this dir. (./.todocmd).\n" );
			gb_mode	= LIBTODO_MODE_DEBUG;
			return;
		}
	}

	if( NULL == pstr_cfgpath )	{
		strncpy( gstr_configfile, getenv("HOME"), 255 );
		strncat( gstr_configfile, "/"LIBTODO_USER_CONFIGFILE, 255 );
	}
	else	{
		strncpy( gstr_configfile, pstr_cfgpath, 255 );
	}

	if( 0x00 == stat( gstr_configfile, &t_buf ) )
		{ gb_mode	= LIBTODO_MODE_NORMAL; }

	return;
}


/* ===================================================================*/
LIBTODO_CONFIGFILE_EXTERN
int
	ConfigFile_ReadConfig(
			void )
{
	int		i_len;
	FILE	*fp;
	char	str_buf[1024];
	struct stat	t_buf;

	memset( &gt_config, 0x00, sizeof( LibToDo_Config ) );

	if( 0x00 != stat( gstr_configfile, &t_buf ) )	{ return 0x00; }

	fp	= fopen( gstr_configfile, "r" );
	if( NULL == fp )	{
		SET_ERRINFO( "Failed function call: fopen()" );
		return -0x01;
	}

	do	{
		if( NULL == fgets( str_buf, 1024, fp ))	{ break; }

		i_len	= strnlen( str_buf, 1024 );
		if( 14 > i_len )	{ continue; }

		str_buf[13]	= '\0';		// '=' -> NULL (for seperate key & value)
		if( '\n' == str_buf[i_len - 1] )	{
			str_buf[i_len - 1]	= '\0';
			i_len--;
		}
		if( !strcmp( str_buf, CONFIGFILE_KEY_ACCESS_TOKEN ))
			{ strncpy( gt_config.str_access_token, (str_buf + 14), 256 ); }
		if( !strcmp( str_buf, CONFIGFILE_KEY_REFRESH_TOKEN ))
			{ strncpy( gt_config.str_refresh_token, (str_buf + 14), 256 ); }
		if( !strcmp( str_buf, CONFIGFILE_KEY_TOKEN_TYPE ))
			{ strncpy( gt_config.str_token_type, (str_buf + 14), 64 ); }
		if( !strcmp( str_buf, CONFIGFILE_KEY_CLIENT_ID ))
			{ strncpy( gt_config.str_client_id, (str_buf + 14), 256 ); }
		if( !strcmp( str_buf, CONFIGFILE_KEY_CLIENT_SECRET ))
			{ strncpy( gt_config.str_client_secret, (str_buf + 14), 256 ); }
		
	}while( !feof(fp) );

	fclose( fp );
	
	//ConfigFile_Debug_PrintConfig();

	return 0x00;
}


/* ===================================================================*/
LIBTODO_CONFIGFILE_EXTERN
int
	ConfigFile_WriteConfig(
			Byte	b_mode )
{
	FILE	*fp;

	if(( LIBTODO_MODE_NORMAL != b_mode ) && ( LIBTODO_MODE_DEBUG != b_mode ))
		{ return 0x00; }

	fp	= fopen( gstr_configfile, "w" );
	if( NULL == fp )	{
		SET_ERRINFO( "Failed function call: fopen()" );
		return -0x01;
	}

	fprintf( fp, CONFIGFILE_KEY_ACCESS_TOKEN	"=%s\n", gt_config.str_access_token );
	fprintf( fp, CONFIGFILE_KEY_REFRESH_TOKEN	"=%s\n", gt_config.str_refresh_token );
	fprintf( fp, CONFIGFILE_KEY_TOKEN_TYPE		"=%s\n", gt_config.str_token_type );
	fprintf( fp, CONFIGFILE_KEY_CLIENT_ID		"=%s\n", gt_config.str_client_id );
	fprintf( fp, CONFIGFILE_KEY_CLIENT_SECRET	"=%s\n", gt_config.str_client_secret );
	
	fclose( fp );

	return 0x00;
}


/* EOF of main.c ******************************************************/
