/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#ifndef	LIBTODO_HEADER
#define	LIBTODO_HEADER

#define	NO_TODODATA	-0x01

// b_status
#define	TODO_STATUS_NONE		0x00
#define	TODO_STATUS_NEEDSACTION	0x01
#define	TODO_STATUS_COMPLETED	0x02
#define	TODO_STATUS_DELETED		0x04

#define	TODO_MODE_SHOW_NORMAL	0x00	// needsActions's Task Only.
#define	TODO_MODE_SHOW_ALL		0x01	// needsAction & completed Tasks.
#define	TODO_MODE_UPDATE		0x00
#define	TODO_MODE_RELOAD		0x02
#define	TODO_MODE_NOSYNC		0x00
#define	TODO_MODE_SYNC			0x04

typedef	struct	{
	int		i_id;
	int		i_level;

	char	str_id[64];
	char	str_item[512];
	char	str_update[32];

	char	chr_flag;
	Byte	b_status;

	QWord	qw_position;

} LibToDo_Data;


#ifdef LIBTODO_SRC_LIBTODO_SYSTEM
	#define LIBTODO_API_SYSTEM_EXTERN
#else
	#define LIBTODO_API_SYSTEM_EXTERN	extern
#endif

LIBTODO_API_SYSTEM_EXTERN
	int LibToDo_Init( void );
LIBTODO_API_SYSTEM_EXTERN
	void LibToDo_Term( void );

#ifdef LIBTODO_SRC_LIBTODO_ERROR
	#define LIBTODO_API_ERROR_EXTERN
#else
	#define LIBTODO_API_ERROR_EXTERN	extern
#endif

LIBTODO_API_ERROR_EXTERN
	int LibToDo_GetErrorInfo( char *pstr_errmsg, int i_len, int i_history );
LIBTODO_API_ERROR_EXTERN
	void LibToDo_PrintErrorInfo( void );

#ifdef LIBTODO_SRC_LIBTODO_API
	#define LIBTODO_API_API_EXTERN
#else
	#define LIBTODO_API_API_EXTERN	extern
#endif
LIBTODO_API_API_EXTERN
	int LibToDo_ImportClientJson( char *pstr_import_filepath );
LIBTODO_API_API_EXTERN
	int LibToDo_CreateUserOAuthURL( char *pstr_url );
LIBTODO_API_API_EXTERN
	int LibToDo_CreateConfigFile( char *pstr_code );
LIBTODO_API_API_EXTERN
	int LibToDo_ReadToDoCache( char *pstr_filepath );
LIBTODO_API_API_EXTERN
	int LibToDo_WriteToDoCache( char *pstr_filepath );
LIBTODO_API_API_EXTERN
	int LibToDo_SearchDataID( char *pstr_id );
LIBTODO_API_API_EXTERN
	int LibToDo_GetData( LibToDo_Data *p_data, int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_SetStatus( int i_id, Byte b_status );
LIBTODO_API_API_EXTERN
	int LibToDo_GetTopDataID( void );
LIBTODO_API_API_EXTERN
	int LibToDo_GetListDataID( int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_GetParentDataID( int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_GetChildDataID( int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_GetPrevDataID( int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_GetNextDataID( int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_InsertToDo( char *pstr_title, int i_listid, int i_previd, int i_parentid, Byte b_mode );
LIBTODO_API_API_EXTERN
	int LibToDo_UpdateStatus( int i_id, Byte b_status );
LIBTODO_API_API_EXTERN
	int LibToDo_LoadToDoList( void );
LIBTODO_API_API_EXTERN
	int LibToDo_LoadToDoData( Byte b_showmode );
LIBTODO_API_API_EXTERN
	int LibToDo_ClearToDoData( void );
LIBTODO_API_API_EXTERN
	int LibToDo_MoveToDo( int i_taskid, int i_listid, int i_previd, int i_parentid, Byte b_mode );
LIBTODO_API_API_EXTERN
	int LibToDo_DeleteTask( int i_id );
LIBTODO_API_API_EXTERN
	int LibToDo_Sync( void );

#endif

/* EOF of main.c ******************************************************/
