static    char    sccsid[]="%Z% %M% %I% %E% %U%";
#include "colmn.h"

extern CLPRTBL CLprocTable,*pCLprocTable;
extern CLCOMMON *pCLcommon;

/*************************************************/
/*  Program name                                 */
/*************************************************/
ScrPrCT *cl_mk_scr_pr_ct()
{
	ScrPrCT  *Dummy;

	Dummy = (ScrPrCT *)Malloc(sizeof(ScrPrCT));
	if (Dummy) memset(Dummy,0,sizeof(ScrPrCT));
	return Dummy;
}

/*************************************************/
/*  Program name                                 */
/*       leaf      *cl_mk_lk_make                */
/* --------------------------------------------- */
/*  (I/O)                                        */
/*       Out                                     */
/*              Normal                           */
/*                  leaf  *RootLeaf              */
/*              AbNormal   NULL                  */
/* --------------------------------------------- */
/*  Function :                                   */
/* --------------------------------------------- */
/*************************************************/
/* */
ScrPrCT *cl_mk_lk_make(scrct)
ScrPrCT  *scrct;
{
	ScrPrCT  *Dummy;

	if (scrct) Dummy = scrct;
	else {
		Dummy = cl_mk_scr_pr_ct();
		if (Dummy == NULL) return NULL;
	}
	if (!Dummy->Vary) {
		Dummy->Vary = (VarTBL *)ver_set();
/*
printf("cl_mk_lk_make: Dummy->Vary=%08x\n",Dummy->Vary);
*/
		if (Dummy->Vary == NULL) {
			Free(Dummy);
			return NULL;
		}
	}
	return Dummy;
}

/*************************************************/
/*  Program name                                 */
/*       int        cl_mk_lk_scr_pr_ct           */
/* --------------------------------------------- */
/*  (I/O)                                        */
/*       In         Leaf  *leaf                  */
/*                                               */
/*       Out        0   :Normal                  */
/*                 -1   :AbNormal                */
/* --------------------------------------------- */
/*  Function :                                   */
/*   nꂽXNvge[uP[W  */
/* --------------------------------------------- */
/*************************************************/
/* */
ScrPrCT *cl_mk_lk_scr_pr_ct(scrct)
ScrPrCT  *scrct;
{
	ScrPrCT  *Dummy;

	if (!(Dummy=cl_mk_lk_make(scrct))) return NULL;
	if (pCLprocTable->PrCTp == NULL) {
		pCLprocTable->PrCTp = Dummy;
	}
	else  {
		if (cl_mk_lk_push(Dummy)) return NULL;
	}

	Dummy->ScrGid = ++pCLprocTable->gid;
	akxs_xhasl(pCLprocTable->pha_gid,'S',Dummy->ScrGid,0);

	return pCLprocTable->CurScr = Dummy;
}

/*************************************************/
/*  Program name                                 */
/*       int        cl_mk_lk_push                */
/* --------------------------------------------- */
/*  (I/O)                                        */
/*       In         Leaf  *leaf                  */
/*                                               */
/*       Out        0   :Normal                  */
/*                 -1   :AbNormal                */
/* --------------------------------------------- */
/*  Function :                                   */
/*************************************************/
int cl_mk_lk_push(Scr)
ScrPrCT  *Scr;
{
	ScrPrCT  *Dummy;

	if (!Scr) return -1;
	Dummy = pCLprocTable->PrCTp;
	for(;;) {
		if (Dummy->nextScCT == (ScrPrCT *)NULL) {
			Scr->preScCT = Dummy;
			Dummy->nextScCT = Scr;
			break;
		}
		else Dummy = Dummy->nextScCT;
	}

	return 0;
}

#define D_VAR_SIZE_POS_PARM	8	/* 2020.2.24 6-->8 */
/********************************/
/*	cl_var_size_len				*/
/********************************/
int cl_var_size_len(opt)
int opt;
{
	return (sizeof(int)*D_VAR_SIZE_POS_PARM + sizeof(tdtInfoParm));
}

/********************************/
/*	cl_var_set_size				*/
/********************************/
int *cl_var_set_size(pSize, iMAX_VAR_IX, iMAX_VAR_IY, name)
int *pSize,iMAX_VAR_IX,iMAX_VAR_IY;
char *name;
{
	pSize[0] = iMAX_VAR_IX;
	pSize[1] = iMAX_VAR_IY;
	pSize[2] = iMAX_VAR_IX*iMAX_VAR_IY;
	strcpy((char *)&pSize[3],name);
	pSize[5] = 0;						/* max ix */
/*	pSize[4] = &pSize[D_VAR_SIZE_POS_PARM];	*/
#if 1	/* 2020.2.24 */
	pSize[6]= pSize[7] = 0;				/* 6:max ParmNo, 7:unused */
#endif
	pSize += D_VAR_SIZE_POS_PARM;
	cl_set_parm_bin(pSize,0);
	return (int *)((char *)pSize + sizeof(tdtInfoParm));
}

/********************************/
/*	cl_var_size_parm				*/
/********************************/
tdtInfoParm *cl_var_size_parm(pSize)
int *pSize;
{
	return (tdtInfoParm *)&pSize[D_VAR_SIZE_POS_PARM];
}

/********************************/
/*	ver_set						*/
/********************************/
VarTBL * ver_set ()
{
	VarTBL  *vDummy;
	int i,vlen,len,*pSize;
	tdtInfoParm ***pDummy ;
	char *cc;

	pSize = NULL;
	vDummy = (VarTBL *)Malloc(sizeof(VarTBL));
	if (!vDummy) return NULL;
	memset(vDummy,0,sizeof(VarTBL));

#ifdef HASH_FIXED_KEYL
	if (!(vDummy->pha_vnam=akxs_xhash_new(Var_NM_MAX,MAX_VAR_IY,0)))
#else
	if (!(vDummy->pha_vnam=akxs_xhash_new(0,MAX_VAR_IY,0)))
#endif
		goto Err;

	pSize = (int *)Malloc(cl_var_size_len(0)*4);
	if (!pSize) goto Err;

	len = sizeof(tdtInfoParm **)*((MAX_VAR_IX+1)*2+(MAX_IGE_IX+1)+(MAX_PAS_IX+1));
/*
printf("ver_set: len=%d\n",len);
*/
	pDummy = (tdtInfoParm ***)Malloc(len);
	if (!pDummy) goto Err;

	memset(pDummy,0,len);
	vDummy->pTBL_dolu    = pDummy;
	vDummy->pTBL_igeta   = vDummy->pTBL_dolu    + MAX_VAR_IX+1;
	vDummy->pTBL_pasento = vDummy->pTBL_igeta   + MAX_IGE_IX+1;
	vDummy->pTBL_vnam    = vDummy->pTBL_pasento + MAX_PAS_IX+1;

	vDummy->pTBL_dolu[0]    = (tdtInfoParm **)pSize;
	pSize = cl_var_set_size(pSize,MAX_VAR_IX,MAX_VAR_IY,"DOL");

	vDummy->pTBL_igeta[0]   = (tdtInfoParm **)pSize;
	pSize = cl_var_set_size(pSize,MAX_IGE_IX,MAX_IGE_IY,"IGE");

	vDummy->pTBL_pasento[0] = (tdtInfoParm **)pSize;
	pSize = cl_var_set_size(pSize,MAX_PAS_IX,MAX_PAS_IY,"PAS");

	vDummy->pTBL_vnam[0]    = (tdtInfoParm **)pSize;
	pSize = cl_var_set_size(pSize,MAX_VAR_IX,MAX_VAR_IY,"VNA");

	return vDummy;
 Err:
	if (vDummy->pha_vnam) akxs_xhash_free(vDummy->pha_vnam);
	if (vDummy) Free(vDummy);
	if (pSize) Free(pSize);
	return NULL;
}

/************************************************/
/******************  prm_list   ******************/

tdtInfoParm *parm_set0(pDummy)
tdtInfoParm *pDummy;
{
	cl_parm_set0(pDummy);
	return pDummy;
}

int cl_parm_set0(pDummy)
tdtInfoParm *pDummy;
{
	if (!pDummy) return -1;
	memset(pDummy,0,sizeof(tdtInfoParm));
	return 0;
}
/*
int prm_null(pDummy)
tdtInfoParm *pDummy;
{
	cl_null_data(pDummy);
	return 0;
}
*/
int cl_null_data(pDummy)
tdtInfoParm *pDummy;
{
	return cl_set_parm_char(pDummy,NULL,0);
}

int cl_null_parm(pDummy)
tdtInfoParm *pDummy;
{
	if (!pDummy) return 1;
	cl_null_data(pDummy);
	pDummy->pi_alen = D_AULN_NULL_PARM;
	return 0;
}

int cl_none_parm(pDummy)
tdtInfoParm *pDummy;
{
	if (!pDummy) return 1;
	cl_null_parm(pDummy);
	pDummy->pi_alen |= D_AULN_NONE_PARM;
	return 0;
}

int cl_is_null_parm(pDummy)
tdtInfoParm *pDummy;
{
	if (!pDummy) return 1;
	else if (cl_is_null_data(pDummy) && (pDummy->pi_alen & D_AULN_NULL_PARM)) return 1;
	else return 0;
}

int cl_is_none_parm(pDummy)
tdtInfoParm *pDummy;
{
	if (!pDummy) return 1;
	else if (cl_is_null_parm(pDummy) && (pDummy->pi_alen & D_AULN_NONE_PARM)) return 1;
	else return 0;
}

int cl_is_null_data(pDummy)
tdtInfoParm *pDummy;
{
	if (!pDummy) return 1;
	else if (pDummy->pi_id == ' ' &&
	         pDummy->pi_attr == DEF_ZOK_CHAR &&
	         pDummy->pi_dlen == 0
	        ) return 1;
	else return 0;
}

int cl_is_undef_parm(pDummy)
tdtInfoParm *pDummy;
{
	char c;

	if (!pDummy) return 1;
	else if ((c=pDummy->pi_id)=='U' || c=='\0') return 1;
	else return 0;
}
