static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************
*																		*
*	ړI	F Oo												*
*																		*
*	Tv	F 														*
*																		*
*************************************************************************/
#include <colmn.h>

extern CLCOMMON  CLcommon;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

/****************************************/
/*										*/
/* XV 2020.04.29 TRYłG[̓t@Cɏo͂ */
/****************************************/
int cl_log_out_l5(log_no,level,file,line,fmt,a1,a2,a3,a4,a5)
int log_no,level,line;
char *file,*fmt,*a1,*a2,*a3,*a4,*a5;
{
	int max_len,len,pos,iOUT,i,rc,log_flg;
	char *p,c,*a,buf[600],*b,*argv[5];
	int  (*logout)();
	ProcCT *proc;
/*
printf("cl_log_out_l5: log_no=%d level=%d file=[%s] line=%d\nfmt=[%s]\n",
log_no,level,file,line,fmt);
*/
	iOUT = 1;
	len = pos = 0;
	max_len = sizeof(pGlobTable->errmsg) - 1;
	if (log_no==0 && fmt) {
		if (pGlobTable->try_level > 0) {
			if ((proc=cl_search_proc_ct()) && proc->ucExcept<=D_EXCEPT_TRY) {
#if 1
				iOUT = -1;
#else
				p = pGlobTable->errmsg;
				pos = strlen(p);
				if (pos) {
					if (max_len-pos < 2) return 0;
#if 1
					pos += akxa_log_new_line_str(p+pos,pGlobTable->options[2]);
#else
					strcpy(p+pos,"\n");
					pos++;
#endif
				}
				max_len -= pos;
				if (max_len <= 0) return 0;
				iOUT = 0;
#endif
			}
		}
		if (LOGLEVEL(log_no,-1) < level) iOUT = 0;
	}
#if 1	/* 2020.4.29 */
	if (iOUT) {
		if (iOUT<0 && log_no==2) {
			log_flg = LOGFLG(log_no,-1);
			LOGFLG(log_no,(log_flg & ~D_LOG_FLG_STDOUT) | D_LOG_FLG_FILE);
			akb_error_out_level(level,file,line,fmt,a1,a2,a3,a4,a5);
			LOGFLG(log_no,log_flg);
		}
		else
#else
	if (iOUT > 0) {
#endif
		if (log_no>=0 && log_no<=2) {
			if      (log_no == 0) logout = akb_error_out_level;
			else if (log_no == 1) logout = akb_print_out_level;
			else if (log_no == 2) logout = akb_debug_out_level;
			logout(level,file,line,fmt,a1,a2,a3,a4,a5);
		}
		else akb_log_out_level_main(log_no,level,file,line,fmt,a1,a2,a3,a4,a5);
	}
#if 1	/* 2020.4.29 */
	if (iOUT <= 0) {
#else
	else {
#endif
		argv[0] = a1;
		argv[1] = a2;
		argv[2] = a3;
		argv[3] = a4;
		argv[4] = a5;
/*
printf("cl_log_out_l5: buf=[%s] len=%d pos=%d max_len=%d\n",buf,len,pos,max_len);
*/
		akxa_log_printf_len(buf,max_len,fmt,5,argv);
		sprintf(pGlobTable->errmsg+pos,buf,
		        argv[0],argv[1],argv[2],argv[3],argv[4]);
		if (iOUT < 0) {
			len = pGlobTable->err_msg_len;
			p = pGlobTable->errmsg;
			pos = strlen(p);
			if (pGlobTable->err_msg = a = MRealloc(pGlobTable->err_msg,len+pos+3)) {
				if (len > 0) len += akxa_log_new_line_str(a+len,pGlobTable->options[2]);
				memzcpy(a+len,p,pos);
				len += pos;
			}
			else len = 0;
		}
	}
	pGlobTable->err_msg_len = len;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _skip(buf,ptn,opt)
char *buf,*ptn;
int  opt;
{
	int i;
	char *p,c;

	p = buf;
	i = 0;
	while (c = *p++) {
		if (!strchr(ptn,c)) break;
		i++;
	}
	return i;
}

/****************************************/
/*										*/
/****************************************/
static int _per_check(fmt,buf)
char *buf,*fmt;
{
	int len,i;
	char *pf,*pb,c,cc;
/*
printf("_per_chack: fmt=[%s]\n",fmt);
*/
	len = 0;
	pf = fmt;
	pb = buf;
	while (c = *pf++) {
		*pb++ = c;
		len++;
		if (c == '%') {
#if 1
			*pb++ = c;
			len++;
#else
			if (*pf == c) {
				len++;
				*pb++ = c;
				pf++;
			}
			else {
				i = _skip(pf,".+-0123456789",0);
				cc = *(pf+i);
				if (cc<'a' || cc>'z') {
					*pb++ = c;
					len++;
				}
			}
#endif
		}
	}
	*pb++ = c;
/*
printf("_per_chack: buf=[%s]\n",buf);
*/
	return len;
}

/****************************************/
/*										*/
/****************************************/
static int _per_check_snprintf(buf,buf_size,fmt,argc,argv)
char *buf,*fmt,*argv[];
int buf_size,argc;
{
	int len,i,j,k,slen,bmax;
	char *pf,*pb,c,cc,wrk[256],*p;

printf("_per_chack_snprintf: buf_size=%d fmt=[%s]\n",buf_size,fmt);

	bmax = buf_size - 1;
	k=len = 0;
	pf = fmt;
	pb = buf;
	while ((c=*pf) && len<bmax) {
		if (c == '%') {
			if (k >= argc) break;
			if (*(pf+1) == c) {
				*pb++ = c;
				len++;
				if (len < bmax) {
					*pb++ = c;
					len++;
				}
				pf++;
			}
			else {
				i = _skip(pf+1,".+-0123456789",0);
				cc = *(pf+1+i);
				if (cc == 's') {
					p = argv[k++];
					slen = strlen(p);
					for (j=0;j<slen && len<bmax;j++) {
						cc = *p++;
						*pb++ = cc;
						len++;
						if (cc=='%' && len<bmax) {
							*pb++ = cc;
							len++;
						}
					}
				}
				else if (len+10<bmax) {
					memzcpy(wrk,pf,i+2);
					sprintf(pb,wrk,argv[k++]);
					pb += strlen(pb);
					len += strlen(pb);
				}
				pf += i+1;
			}
		}
		else {
			*pb++ = c;
			len++;
		}
		pf++;
	}
	strnzcpy(pb,pf,bmax-len);

printf("_per_chack_snprintf: len=%d buf=[%s]\n",len,buf);

	return len;
}

/****************************************/
/*										*/
/****************************************/
int cl_debug_array_info(fmt,len,pInfo)
char *fmt;
int  len;
tdtInfoParm *pInfo;
{
	tdtArrayIndex *pIndex;
/*	char *varnam;	*/
	ScrPrCT *pScCT;
	XHASHB *xhp;
	int i,ndim,*index;
	char *p;

	pIndex = (tdtArrayIndex *)pInfo->pi_data;
/*	varnam = (char *)pInfo->pi_pos;	*/
	pScCT = (ScrPrCT *)pInfo->pi_len;
	sprintf(&fmt[len]," pInfo=%08x id=%c attr=%d scale=0x%02x dlen=%d len(pScCT)=%08x hlen(gid)=%d aux=0x%02x 0x%02x auxlen=%04x %08x data=%08x",
	        pInfo,pInfo->pi_id,pInfo->pi_attr,pInfo->pi_scale,
	        pInfo->pi_dlen,pScCT,pInfo->pi_hlen,pInfo->pi_aux[0],pInfo->pi_aux[1],
	        pInfo->pi_alen,pInfo->pi_paux,pInfo->pi_data);
	len = strlen(fmt);
	if (pIndex) {
		sprintf(&fmt[len],
#if 1	/* 2017.7.30 koba */
			"(VarIndex=%08x Attr=%d %d %d %d size=%d xhp=%08x index=[",
			pIndex->pVarIndex,
			pIndex->uAttr[0],pIndex->uAttr[1],
			pIndex->uAttr[2],pIndex->uAttr[3],
			pIndex->size,
			pIndex->xhp);
			len = strlen(fmt);
		index = pIndex->index;
		ndim = index[0]*2 + 4;
		if (ndim > MAX_ARRAY_DIM) ndim = MAX_ARRAY_DIM;
		p = &fmt[len];
		for (i=0;i<ndim;i++) {
			if (i > 0 ) *p++ = ',';
			sprintf(p,"%d",index[i]);
			p += strlen(p);
		}
		strcpy(p,"]");
#else
			"(VarIndex=%08x Attr=%d %d %d %d size=%d index=%d[%d,%d,%d] xhp=%08x",
			pIndex->pVarIndex,
			pIndex->uAttr[0],pIndex->uAttr[1],
			pIndex->uAttr[2],pIndex->uAttr[3],
			pIndex->size,
			pIndex->index[0],pIndex->index[1],
			pIndex->index[2],pIndex->index[3],
			pIndex->xhp);
#endif
		if (xhp = pIndex->xhp) {
			len = strlen(fmt);
			sprintf(&fmt[len],"(_xhash Id=%c%c keylen=%d max=%d pre=%d ha=%08x next=%08x datlen=%d dreg=%08x)",
			        xhp->xha_id[0],xhp->xha_id[1],xhp->xha_keylen,
			        xhp->xha_maxreg,xhp->xha_prereg,
			        xhp->xha_hashb,xhp->xha_xhnext,
			        xhp->xha_datlen,xhp->xha_datreg);
		}
		len = strlen(fmt);
		strcpy(&fmt[len],")");
	}
	else strcpy(&fmt[len]," Index=NULL");
	len = strlen(fmt);
/*
	strcpy(&fmt[len]," varnam=[%s]");
	len = strlen(fmt);
*/
	return len;
}

/****************************************/
/*										*/
/****************************************/
void cl_debug_out_info_parm5(level,file,line,format,pInfo,a1,a2,a3,a4,a5)
int  level,line;
char *file,*format,*a1,*a2,*a3,*a4,*a5;
tdtInfoParm *pInfo;
{
	char   c,*p,buf[300],fmt[300],*argv[5],*varnam,*pdat,*fm;
	int    len,ix,attr,iRANGE,dlen,i;
	long   lVal;
	double dVal,dVal2;
	tdtArrayIndex *pIndex;
	ScrPrCT *pScCT;
	tdtInfoParm *pInfoParm;
	XHASHB *xhp;
	parmList  **parmName;
	tdtDefType *pDeftype;
	int ntype,ihx,nlen;
	tdtRbCtl *pRb;

	if (akb_log_out_check(D_LOG_NO_DEBUG,level,file,line) > 0) {

		argv[0] = a1;
		argv[1] = a2;
		argv[2] = a3;
		argv[3] = a4;
		argv[4] = a5;
#if 0
		akxa_log_printf_len(buf,sizeof(buf)-100,format,5,argv);
		_per_check_snprintf(fmt,sizeof(buf)-100,buf,5,argv);
#else
#if 1
		akxa_log_printf_len(buf,sizeof(buf)-100,format,5,argv);
		sprintf(fmt,buf,argv[0],argv[1],argv[2],argv[3],argv[4]);
#else
		akxa_log_printf_len(fmt,sizeof(buf)-100,format,5,argv);
		sprintf(buf,fmt,argv[0],argv[1],argv[2],argv[3],argv[4]);
		_per_check(buf,fmt);
#endif
#endif
		len = strlen(fmt);
		if (!pInfo) {
		/*	strcpy(&fmt[len]," pInfoParm is NULL");
			akb_debug_out_level(0,file,line,fmt,0);	*/
			akb_debug_out_level(0,file,line,"%s pInfoParm is NULL",fmt,0,0,0,0);
			return;
		}
		if ((c=pInfo->pi_id) == 'A' || c == 'R') {
			len = cl_debug_array_info(fmt,len,pInfo);
			varnam = (char *)pInfo->pi_pos;
		/*	strcpy(&fmt[len]," varnam=[%s]");
			akb_debug_out_level(0,file,line,fmt,varnam);	*/
			akb_debug_out_level(0,file,line,"%s varnam=[%s]",fmt,varnam,0,0,0);
		}
		else if (c=='S' || (c==D_DATA_ID_PNAME && pInfo->pi_attr==2)) {
			memcpy(&pInfoParm,pInfo->pi_data,pInfo->pi_dlen);
			sprintf(&fmt[len]," pInfo=%08x id=0x%02x[%c] attr=%d scale=0x%02x dlen=%d len(gid)=%d aux=0x%02x 0x%02x auxlen=%04x %08x data=%08x",
			        pInfo,pInfo->pi_id,c,pInfo->pi_attr,pInfo->pi_scale,
			        pInfo->pi_dlen,pInfo->pi_len,pInfo->pi_aux[0],pInfo->pi_aux[1],
			        pInfo->pi_alen,pInfo->pi_paux,pInfoParm);
		/*	akb_debug_out_level(0,file,line,fmt,0);	*/
			akb_debug_out_level(0,file,line,"%s",fmt,0,0,0,0);
			if (pInfo == pInfoParm) akb_debug_out_level(0,file,line,"pInfoParm==pInfoParm->pi_data",0,0,0,0,0);
			else {
				if (c==D_DATA_ID_PNAME && (p=pInfo->pi_paux)) {
					fm = "pi_paux=[%s]";
				}
				else fm = "";
				cl_debug_out_info_parm(level,file,line,fm,pInfoParm,p,0);
			}
		}
		else {
			if (!(c=pInfo->pi_id)) c = ' ';
			attr = pInfo->pi_attr;
			dlen = pInfo->pi_dlen;
			pdat = pInfo->pi_data;
			iRANGE = pInfo->pi_alen & D_AULN_RANGE_DATA;
			sprintf(&fmt[len]," pInfo=%08x id=0x%02x[%c] attr=%d scale=0x%02x code=%d dlen=%d len(gid)=%d hlen=%d pos=%d(%08x) aux=0x%02x 0x%02x auxlen=%04x %08x data=%08x ",
			        pInfo,pInfo->pi_id,c,attr,pInfo->pi_scale,
			        pInfo->pi_code,dlen,pInfo->pi_len,pInfo->pi_hlen,pInfo->pi_pos,pInfo->pi_pos,
			        pInfo->pi_aux[0],pInfo->pi_aux[1],pInfo->pi_alen,pInfo->pi_paux,pdat);
			len = strlen(fmt);
/*
printf("cl_debug_out_info_parm: len=%d fmt=[%s]\n",len,fmt);
*/
			if (c == 'P' || c == 'T') {
				varnam = (char *)pInfo->pi_pos;
				pDeftype = (tdtDefType *)pdat;
				sprintf(&fmt[len]," size=%d data=0x%08x ntype=%d vname=0x%08x pType=0x%08x",
				        pDeftype->size,pDeftype->data,pDeftype->ntype,pDeftype->vname,pDeftype->pType);
				akb_debug_out_level(0,file,line,"%s varnam=[%s]",fmt,varnam,0,0,0);
				if (c == 'T') {
					ihx = akxs_xhasl(pCLprocTable->pha_gid,'R',pInfo->pi_len,0);
/*
printf("cl_debug_out_info_parm: R gid=%ld ihx=%d\n",pInfo->pi_len,ihx);
*/
				}
				else ihx = 1;
				if (ihx) {
					parmName = pDeftype->vname;
				}
				else {
					nlen = 0;
					p = "***";
				}
				for (ix=0;ix<pDeftype->ntype;ix++) {
					if (ihx) {
						nlen = parmName[ix]->prmlen;
						p = parmName[ix]->prp;
					}
					cl_debug_out_info_parm(level,file,line," vnlen=%d %s:",pDeftype->pType[ix],nlen,p);
				}
			/*	return;	*/
			}
			else if (c=='L' || c=='N') {
				pRb = (tdtRbCtl *)pdat;
				sprintf(&fmt[len],"\n rb_bfsize=%d rb_max=%d rb_num=%d rb_used=%d rb_pos=%d rb_raddr=0x%08x rb_waddr=0x%08x rb_wpriv=0x%08x rb_cur=0x%08x",
				        pRb->rb_bfsz,pRb->rb_max,pRb->rb_num,pRb->rb_used,pRb->rb_pos,
						pRb->rb_raddr,pRb->rb_waddr,pRb->rb_wpriv,pRb->rb_cur);
				akb_debug_out_level(0,file,line,"%s",fmt,0,0,0,0);
			/*	return;	*/
			}
			else {
				if (!pdat) {
				/*	strcpy(&fmt[len],"NULL");
					akb_debug_out_level(0,file,line,fmt,0);	*/
					akb_debug_out_level(0,file,line,"%sNULL",fmt,0,0,0,0);
				}
				else if (attr == DEF_ZOK_CHAR) {
				/*	strcpy(&fmt[len],"[%s]");	*/
/*
printf("cl_debug_out_info_parm: fmt=[%s]\n",fmt);
*/
				/*	akb_debug_out_level(0,file,line,fmt,pInfo->pi_data);	*/
					if (iRANGE) fm = "%s[%s]..[%s]";
					else fm = "%s[%s]";
					akb_debug_out_level(0,file,line,fm,fmt,pdat,pdat+dlen,0,0);
				}
				else if (attr == DEF_ZOK_BINA) {
					lVal = cl_get_data_long(pInfo);
				/*	memcpy(&lVal,pInfo->pi_data,sizeof(long));	*/
				/*	strcpy(&fmt[len],"%d");
					akb_debug_out_level(0,file,line,fmt,lVal);	*/
					if (iRANGE) fm = "%s%d..%d";
					else fm = "%s%d";
					akb_debug_out_level(0,file,line,fm,fmt,lVal,pInfo->pi_hlen,0,0);
				}
				else if (attr == DEF_ZOK_FLOA) {
					memcpy(&dVal,pdat,sizeof(double));
				/*	strcpy(&fmt[len],"%e");
					akb_debug_out_level(0,file,line,fmt,dVal);	*/
					if (iRANGE) {
						fm = "%s%e..%e";
						memcpy(&dVal2,pdat+dlen,sizeof(double));
					}
					else fm = "%s%e";
					akb_debug_out_level(0,file,line,fm,fmt,dVal,dVal2,0,0);
				}
				else if (attr==DEF_ZOK_DECI || attr==DEF_ZOK_DATE) {
					m_mpa2an((MPA *)pdat,buf,sizeof(buf),pGlobTable->options[10]);
					ix = strlen(buf);
					p = buf + ix;
					if (iRANGE) {
						fm = "%s%s..%s";
						ix++;
						m_mpa2an((MPA *)(pdat+dlen),buf+ix,sizeof(buf)-ix,pGlobTable->options[10]);
						p += 1 + strlen(buf+ix);
					}
					else fm = "%s%s";
					*p++ = ' ';
					akxm_mem_sdump(pdat,32,p);
					akb_debug_out_level(0,file,line,fm,fmt,buf,buf+ix,0,0);
				}
				else if (attr==DEF_ZOK_BULK || c=='2') {
					if ((len=dlen) > 32) len = 32;
					len = akxcxtoc(pdat,len,buf);
					buf[len] = '\0';
				/*	strcpy(&fmt[len],"%s");
					akb_debug_out_level(0,file,line,fmt,buf);	*/
					akb_debug_out_level(0,file,line,"%s%s",fmt,buf,0,0,0);
				}
				else {
					akb_debug_out_level(0,file,line,"%s%s",fmt,"**INVALID**",0,0,0);
				}
			}
			if (/*c==' ' && */pInfo->pi_alen & D_AULN_PARMINFO2)
				cl_debug_out_info_parm(level,file,line,"PARMINFO2:",pInfo+1,0,0);
		}
	}
}

/****************************************/
/*										*/
/****************************************/
void cl_debug_out_info_parm(level,file,line,format,pInfo,a1,a2)
int  level,line;
char *file,*format,*a1,*a2;
tdtInfoParm *pInfo;
{
	cl_debug_out_info_parm5(level,file,line,format,pInfo,a1,a2,0,0,0);
	if (pInfo) {
		if (pInfo->pi_alen & D_AULN_PARMINFO2) {
			pInfo++;
			if (pInfo->pi_id == '2')
				cl_debug_out_info_parm5(level,file,line,"",pInfo,0,0,0,0,0);
		}
	}
}

/****************************************/
/*										*/
/****************************************/
int cl_debug_out_return(file,line,func,ret)
char *file,*func;
int  line,ret;
{
	if (((CLcommon.dbgopt[2] & 0x10) && ret<0) ||
	    ((CLcommon.dbgopt[2] & 0x20) && ret!=0))
		cl_log_out_l5(D_LOG_NO_DEBUG,0,file,line,"<---%s: return %d",func,ret,0,0,0);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int func_log(pAns,pOperator,nparm,ppParm,ope)
char *pAns;
char *pOperator;
tdtInfoParm **ppParm;
int nparm,ope;
{
	tdtInfoParm *pInfoParm;
	ScrPrCT *scrprct;
	int  line,logno,level,pri,syspri,iRc,len_f;
	char buf[256],*pWork,*format,*file,*p;

	if (iRc=cl_get_parm_bin(ppParm[0],&logno,"func_log:log_no/syspri:")) return -1;

	if (scrprct = cl_search_src_ct()) file = scrprct->pId;
	else file = AKX_NULL_PRINT;
	line = pGlobTable->script_line;

	pInfoParm = ppParm[1];
	len_f = pInfoParm->pi_dlen;
	if (len_f > 0) {
		if (pInfoParm->pi_attr != DEF_ZOK_CHAR) return -2;
		format = pInfoParm->pi_data;
		if ((iRc=cl_edit_sub(&pWork,format,nparm-2,&ppParm[2])) < 0) return iRc;
	}
	else pWork = "";

	if (ope==D_FUC_LOGOUT) {
		level = 0;
		pri = 0;
		akb_log_out_level_pri_main(logno,level,file,line,pri,pWork,0,0,0,0,0);
	}
	else if (ope==D_FUC_SYSLOG) {
		p = akb_log_get_proc_name();
		if (strlen(p)+strlen(file)+16 <= sizeof(buf)) {
			sprintf(buf,"%s/%s(%d): ",p,file,line);
		}
		else buf[0] = '\0';
		syspri = logno;
		syslog(syspri,"%s%s",buf,pWork);
	}
	iRc = 0;
	memcpy(pAns,&iRc,sizeof(int));
	return 0;
}

#define MAXLOGPARM	7

/****************************************/
/*										*/
/****************************************/
int func_get_log_parm(pAns,nparm,ppParm)
char *pAns;
int nparm;
tdtInfoParm **ppParm;
{
	int rc,iRc,i,maxargs,ix,*index;
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL;
	char *fn;
	tdtArrayIndex tIndex;
	long iParm[MAXLOGPARM];

	if (rc=cl_set_log_parmi(ppParm[0],NULL,iParm,0)) return rc;
	else if (iParm[0] < 0) iParm[0] = 0;

	if (iRc=cl_get_ITBL_maxargs(nparm-1,&ppParm[1],&tIndex,&pTBL,1,MAXLOGPARM,&maxargs,NULL)) return iRc;

	akb_log_set_parm2(1,NULL,maxargs,iParm);

	index = tIndex.index;
#if 1	/* 2017.07.23 koba */
	ix = index[3];
#else
	ix = index[0];
#endif
	for (i=0;i<maxargs;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		if (pInfoParm) {
			if (i == 6) {
				if (!(fn=(char *)iParm[i])) fn = AKX_NULL_PRINT;
				cl_set_parm_char(&rInfoParm,fn,strlen(fn));
			}
			else {
				cl_set_parm_long(&rInfoParm,iParm[i]);
			}
			if (iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) return iRc;
		}
		else {
			return -1;
		}
	}
	memcpy(pAns,&maxargs,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_log_parmi(pInfoParm,argv,iParm,ix)
tdtInfoParm *pInfoParm;
char *argv[];
long iParm[];
int ix;
{
	int i,rc;
	long logno;
	char c;

	i = ix;
	iParm[i] = -1;
	if (!pInfoParm) return -1;
	if (pInfoParm->pi_dlen > 0) {
		if (rc=cl_check_data_id(pInfoParm,0)) return rc+ECL_CHK_VAR_ERROR;
		c = pInfoParm->pi_attr;
		if (i==0 || i==6) {
			if (i == 0) {
				if (c == DEF_ZOK_CHAR) {
					if ((logno=akb_get_log_no(strname(pInfoParm->pi_data,pInfoParm->pi_dlen))) >= 0) {
						iParm[i] = logno;
						goto L_ix0;
					}
				}
			}
			else if (c == DEF_ZOK_CHAR) {
				if (argv) argv[i] = pInfoParm->pi_data;
				else iParm[i] = (long)pInfoParm->pi_data;
				return 0;
			}
			else {
				/* cl_set_logparmi: Ot@Č^(%d)Ă܂B */
				ERROROUT1(FORMAT(414),c);
 				return ECL_SCRIPT_ERROR;
			}
		}
		if (i>0 && c==DEF_ZOK_CHAR && argv) argv[ix] = pInfoParm->pi_data;
		else {
			if (rc=cl_get_parm_long(pInfoParm,&iParm[i],"cl_set_logparmi: ")) return rc;
			if (i == 0) goto L_ix0;
			if (argv) argv[i] = ".";
		}
	}
	else if (argv) argv[i] = ".";
	return 0;
L_ix0:
	if (!akb_get_log_name(iParm[i])) {
		/* cl_set_logparmi: Oԍ(%d)słB */
		ERROROUT1(FORMAT(415),logno);
		return -1;
	}
	if (argv) argv[i] = ".";
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int func_set_log_parm(pAns,nparm,ppParm)
char *pAns;
int nparm;
tdtInfoParm **ppParm;
{
	int i,rc,nm;
	long iParm[MAXLOGPARM];
	char *argv[MAXLOGPARM];

	nm = X_MIN(nparm,MAXLOGPARM);
	for (i=0;i<nm;i++) {
		if (rc=cl_set_log_parmi(ppParm[i],argv,iParm,i)) return rc;
/*
printf("func_set_log_parm: i=%d argv=[%s] iParm=%08x\n",i,argv[i],iParm[i]);
*/
	}
	akb_log_set_parm2(-nm,argv,nm,iParm);
	memcpy(pAns,&nm,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int func_res_log_parm(pAns,nparm,ppParm)
char *pAns;
int nparm;
tdtInfoParm **ppParm;
{
	int rc,i,maxargs,ix,*index;
	tdtInfoParm *pInfoParm;
	tdtInfoParm ***pTBL;
	char c;
	tdtArrayIndex tIndex;
	long iParm[MAXLOGPARM];

	if (rc=cl_get_ITBL_maxargs(nparm,ppParm,&tIndex,&pTBL,1,MAXLOGPARM,&maxargs,NULL)) return rc;
	index = tIndex.index;
#if 1	/* 2017.07.23 koba */
	ix = index[3];
#else
	ix = index[0];
#endif
	for (i=0;i<maxargs;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		if (pInfoParm) {
			c = pInfoParm->pi_attr;
			if ((i==6 && c!=DEF_ZOK_CHAR) || (i!=6 && c!=DEF_ZOK_BINA)) {
				/* let_log_parm: p[^̌^(%d)Ă܂B */
				ERROROUT2(FORMAT(285),"cl_res_logparm:",c);
				return -1;
			}
			if (i == 6) iParm[i] = (long)pInfoParm->pi_data;
			else iParm[i] = cl_get_data_long(pInfoParm);
		}
		else return -1;
	}
	akb_log_set_parm2(maxargs,NULL,maxargs,iParm);
	memcpy(pAns,&maxargs,sizeof(int));
	return 0;
}
