/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata;

import java.util.Enumeration;
import jdd.des.automata.Alphabet;
import jdd.des.automata.Automata;
import jdd.des.automata.Event;
import jdd.des.automata.EventManager;
import jdd.des.automata.State;
import jdd.des.automata.Transition;
import jdd.graph.Graph;
import jdd.util.Test;

public class Automaton
extends Graph {
    private String name;
    private String type;
    private Alphabet alphabet;
    private EventManager event_manager;
    public int extra1;
    public int extra2;
    public int extra3;
    boolean automaton_locked;

    public Automaton(String string, EventManager eventManager) {
        super(true);
        this.name = string;
        this.type = null;
        this.alphabet = new Alphabet();
        this.event_manager = eventManager;
        this.automaton_locked = false;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public int sharedEvents(Automaton automaton) {
        return this.alphabet.sharedEvents(automaton.alphabet);
    }

    public Event addEvent(String string) {
        return this.addEvent(string, true);
    }

    public Event addEvent(String string, boolean bl) {
        Event event = this.alphabet.add(string, bl);
        this.event_manager.registerEvent(event, this);
        return event;
    }

    public State addState(String string) {
        State state = this.findState(string);
        if (state == null) {
            state = new State(string, this.count_nodes++);
            this.nodes.add(state);
        }
        return state;
    }

    public State findState(String string) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            State state = (State)enumeration.nextElement();
            if (!state.label.equals(string)) continue;
            return state;
        }
        return null;
    }

    public void removeState(State state) {
        this.removeNode(state);
    }

    public Transition addTransition(State state, State state2, Event event) {
        Transition transition = this.findTransition(state, state2, event);
        if (transition == null) {
            transition = new Transition(state, state2, event);
            this.edges.add(transition);
            transition.next = state.firstOut;
            state.firstOut = transition;
            transition.prev = state2.firstIn;
            state2.firstIn = transition;
        }
        return transition;
    }

    public Transition findTransition(State state, State state2, Event event) {
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Transition transition = (Transition)enumeration.nextElement();
            if (transition.n1 != state || transition.n2 != state2 || transition.event != event) continue;
            return transition;
        }
        return null;
    }

    public void removeTransition(Transition transition) {
        this.removeEdge(transition);
    }

    public boolean isAutomatonLocked() {
        return this.automaton_locked;
    }

    public void lockAutomaton() {
        if (this.automaton_locked) {
            throw new IllegalArgumentException("Automaton " + this.getName() + " is already used in another object (BDDAutomata ?)!");
        }
        this.automaton_locked = true;
    }

    public void unlockAutomaton() {
        if (!this.automaton_locked) {
            throw new IllegalArgumentException("Automaton " + this.getName() + " was not locked piror to unlock!");
        }
        this.automaton_locked = false;
    }

    public static void internal_test() {
        Test.start("Automaton");
        Automata automata = new Automata();
        Automaton automaton = automata.add("test");
        Event event = automaton.addEvent("a");
        Event event2 = automaton.addEvent("b");
        Event event3 = automaton.addEvent("c");
        State state = automaton.addState("0");
        State state2 = automaton.addState("1");
        State state3 = automaton.addState("2");
        state.setInitial(true);
        state3.setMarked(true);
        Transition transition = automaton.addTransition(state, state2, event);
        Transition transition2 = automaton.addTransition(state2, state3, event2);
        Transition transition3 = automaton.addTransition(state3, state, event3);
        Test.check(state.isInitial(), "Initial");
        Test.check(state3.isMarked(), "Marked");
        Test.check(!state3.isForbidden(), "!Forbidden");
        Test.checkEquality(automaton.numOfNodes(), 3, "3 states (1)");
        Test.checkEquality(automaton.numOfEdges(), 3, "3 transitions (1)");
        automaton.addState("0");
        automaton.addTransition(state3, state, event3);
        automaton.addTransition(state3, state, event3);
        Test.checkEquality(automaton.numOfNodes(), 3, "3 states (2)");
        Test.checkEquality(automaton.numOfEdges(), 3, "3 transitions (2)");
        automaton.removeState(state);
        Test.checkEquality(automaton.numOfNodes(), 2, "2 states (3)");
        Test.checkEquality(automaton.numOfEdges(), 1, "1 transitions (3)");
        automaton.removeTransition(transition2);
        Test.checkEquality(automaton.numOfNodes(), 2, "2 states (4)");
        Test.checkEquality(automaton.numOfEdges(), 0, "0 transitions (4)");
        Test.end();
    }
}

