/* File: tex.h */

#ifndef __TEX_H_INCLUDED
#define __TEX_H_INCLUDED

#include "draw.h"

#define GRD_TRATTR_NONE		0x0000
#define GRD_TRATTR_GETSIZE	0x0001
#define GRD_TRATTR_ERROREXIT	0x0002

#define GRD_TEX_MAX_NAMELEN	32
#define GRD_TEX_MIPMAP_DEFAULT	-1
#define GRD_MAX_MIPMAP	7
#define GRD_MAX_CLUT	16

#define GRL_PS2_VRAM_START	0
#define GRL_PS2_VRAM_SIZE	16384
#define GRL_PS2_VRAM_MAX	(GRL_PS2_VRAM_SIZE-1)

typedef struct {
	void *free_p;
	void *freei_p;
	void *freec_p;
	void *image_p[GRD_MAX_MIPMAP];
	void *clut_p;

	int mipmap_max;
	int image_transferred[GRD_MAX_MIPMAP];
	u_long64 image_vram_adr[GRD_MAX_MIPMAP];
	u_long64 image_length[GRD_MAX_MIPMAP];
	u_long64 image_format;
	u_long64 image_size_w;
	u_long64 image_size_h;
	u_long64 image_bit_w;
	u_long64 image_bit_h;

	int clut_max;
	int clut_transferred[GRD_MAX_CLUT];
	u_long64 clut_vram_adr[GRD_MAX_CLUT];
	u_long64 clut_length[GRD_MAX_CLUT];
	u_long64 clut_format;
	u_long64 clut_size_w;
	u_long64 clut_size_h;
	u_long64 tex_0;

	char tex_name[GRD_TEX_MAX_NAMELEN];
} GRD_TEX_INFO;

typedef struct {
	int attr;
	int len;
	int n;
	GRD_TEX_INFO *p;
} __GRL_PS2_VRAMINFO;

typedef u_long64 GRD_TEX_ATTR;

extern int ps2_current_tex_force;
extern int ps2_current_clut_force;

int __grd_tex_init( void );
void __grl_tex_init( void );
int grd_ps2_tex_setvram( int clutsize );
int grd_tex_clear( void );
int grd_tex_readtex( GRD_TEX_INFO *tx_p, void *tex_p, char *ext );
void grd_tex_delete( GRD_TEX_INFO *tx_p );
void _gps2_tex_use_notag( GRD_TEX_INFO *tx_p, GRD_TEX_ATTR attr, int mipmap_max, int clut_select );
void grd_tex_use( GRD_TEX_INFO *tx_p, GRD_TEX_ATTR attr, int mipmap_max, int clut_select );
GRD_TEX_INFO *grd_tex_search( char *name_p );
int grd_tex_read( int attr, char *buf, GRD_TEX_INFO *tx_p, char *pathname );

#endif /* __TEX_H_INCLUDED */
