/* File: geometry.h */

#ifndef __GEOMETRY_H_INCLUDED
#define __GEOMETRY_H_INCLUDED

#include "matrix.h"

extern GRVector4	grg_hm_scale;
extern GRVector4	grg_hm_offset;
extern GRMatrix44	grg_hm_matrix;
extern GRVector4	grg_nhm_scale;
extern GRVector4	grg_nhm_offset;
extern GRMatrix44	grg_nhm_matrix;
extern GRVector3	grg_cam_angle, grg_cam_angle_old;
extern GRVector4	grg_cam_pos,   grg_cam_pos_old;
extern GRMatrix44	grg_cam_matrix;
extern GRMatrix44	grg_cam_matrix_angle;
extern GRMatrix44	grg_screen;

#define grg_rotperstrans_hm( target_v, vec, s_matrix ) { \
	grm_vector4_m_matrix44( (target_v), (vec), (s_matrix) ); \
	(target_v)->w = 1.0f / (target_v)->w; \
	(target_v)->x *= (target_v)->w; \
	(target_v)->y *= (target_v)->w; \
	(target_v)->z *= (target_v)->w; \
	grm_vector4_m_vector4( (target_v), (target_v), &grg_hm_scale ); \
	grm_vector4_a_vector4( (target_v), (target_v), &grg_hm_offset ); }

#define grg_rotperstrans_hm_wclip( target_v, vec, s_matrix, wclip ) { \
	grm_vector4_m_matrix44( (target_v), (vec), (s_matrix) ); \
	(target_v)->w = 1.0f / (target_v)->w; \
	(target_v)->x *= (target_v)->w; \
	(target_v)->y *= (target_v)->w; \
	(target_v)->z *= (target_v)->w; \
	if ((target_v)->x < -1.0f || (target_v)->x > 1.0f || \
	    (target_v)->y < -1.0f || (target_v)->y > 1.0f || \
	    (target_v)->z < -1.0f || (target_v)->z > 1.0f) \
		(wclip) = TRUE; \
	else { \
		(wclip) = FALSE; \
		grm_vector4_m_vector4( (target_v), (target_v), &grg_hm_scale ); \
		grm_vector4_a_vector4( (target_v), (target_v), &grg_hm_offset ); \
	}}

#define grg_rotperstrans_hm_wclip_q( target_v, vec, s_matrix, wclip, _Q ) { \
	grm_vector4_m_matrix44( (target_v), (vec), (s_matrix) ); \
	(_Q) = (target_v)->w = 1.0f / (target_v)->w; \
	(target_v)->x *= (target_v)->w; \
	(target_v)->y *= (target_v)->w; \
	(target_v)->z *= (target_v)->w; \
	if ((target_v)->x < -1.0f || (target_v)->x > 1.0f || \
	    (target_v)->y < -1.0f || (target_v)->y > 1.0f || \
	    (target_v)->z < -1.0f || (target_v)->z > 1.0f) \
		(wclip) = TRUE; \
	else { \
		(wclip) = FALSE; \
		grm_vector4_m_vector4( (target_v), (target_v), &grg_hm_scale ); \
		grm_vector4_a_vector4( (target_v), (target_v), &grg_hm_offset ); \
	}}

#define grg_rotperstrans_hm_tex( target_v, vec, target_t, tex, s_matrix ) { \
	grm_vector4_m_matrix44( (target_v), (vec), (s_matrix) ); \
	(target_v)->w = 1.0f / (target_v)->w; \
	(target_v)->x *= (target_v)->w; \
	(target_v)->y *= (target_v)->w; \
	(target_v)->z *= (target_v)->w; \
	(target_t)->x = (tex)->x * (target_v)->w; \
	(target_t)->y = (tex)->y * (target_v)->w; \
	(target_t)->z = (target_v)->w; \
	grm_vector4_m_vector4( (target_v), (target_v), &grg_hm_scale ); \
	grm_vector4_a_vector4( (target_v), (target_v), &grg_hm_offset ); }

#define grg_rotperstrans_hm_tex_wclip( target_v, vec, target_t, tex, s_matrix, wclip ) { \
	grm_vector4_m_matrix44( (target_v), (vec), (s_matrix) ); \
	(target_v)->w = 1.0f / (target_v)->w;  \
	(target_v)->x *= (target_v)->w; \
	(target_v)->y *= (target_v)->w; \
	(target_v)->z *= (target_v)->w; \
	if ((target_v)->x < -1.0f || (target_v)->x > 1.0f || \
	    (target_v)->y < -1.0f || (target_v)->y > 1.0f || \
	    (target_v)->z < -1.0f || (target_v)->z > 1.0f) \
		(wclip) = TRUE; \
	else { \
		(wclip) = FALSE; \
		(target_t)->x = (tex)->x * (target_v)->w; \
		(target_t)->y = (tex)->y * (target_v)->w; \
		(target_t)->z = (target_v)->w; \
		grm_vector4_m_vector4( (target_v), (target_v), &grg_hm_scale ); \
		grm_vector4_a_vector4( (target_v), (target_v), &grg_hm_offset ); \
	}}

extern void __grg_init( void );
extern void grg_set3Dmatrix( float dist, float far );
extern void grg_set3Dmatrix_camera( void );
extern void grg_setpos_hm( GRVector4 *vec, GRVector3 *angles );

#endif /* __GEOMETRY_H_INCLUDED */
