/* File: fileio.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "common.h"
#include "fileio.h"
#include "draw.h"

static int __grp_fd;
static int __grp_size;
static char __grp_fn[LNMAX];

int __grp_fileio_init( void )
{
	__grp_fd	= -1;
	__grp_size	= -1;
	__grp_fn[0]	= '\0';

	return TRUE;
}

int grp_fileio_getsize( char *filename )
{
	__grp_fd   = -1;
	__grp_size = -1;
	strcpy( __grp_fn, filename );
	if ((__grp_fd = open( __grp_fn, O_RDONLY )) < 0) {
		ERRMSG("grp_fileio_getsize() open error. \"%s\"\n", __grp_fn);
		return -1;
	}
	if ((__grp_size = lseek( __grp_fd, 0, SEEK_END )) < 0) {
		ERRMSG("grp_fileio_getsize() lseek error. \"%s\"\n", __grp_fn);
		return -1;
	}
	close(__grp_fd);
	__grp_fd = -1;
	return __grp_size;
}

int grp_fileio_open( char *filename )
{
	__grp_fd   = -1;
	__grp_size = -1;
	strcpy( __grp_fn, filename );
	if ((__grp_fd = open( __grp_fn, O_RDONLY )) < 0) {
		ERRMSG("grp_fileio_open() open error. \"%s\"\n", __grp_fn);
		EXIT(1);
	}
	if ((__grp_size = lseek( __grp_fd, 0, SEEK_END )) < 0) {
		ERRMSG("grp_fileio_open() lseek error. \"%s\"\n", __grp_fn);
		EXIT(1);
	}
	return __grp_size;
}

int grp_fileio_read( void *p )
{
	int retval = __grp_size;

	if (__grp_fd < 0 || __grp_size < 0) {
		ERRMSG("grp_fileio_read() error, (fd or size < 0).\n");
		close(__grp_fd);
		return -1;
	}
	if (lseek( __grp_fd, 0, SEEK_SET ) < 0) {
		ERRMSG("grp_fileio_read() lseek error. \"%s\"\n", __grp_fn);
		close(__grp_fd);
		return -1;
	}
	if (read( __grp_fd, p, __grp_size ) < __grp_size) {
		ERRMSG("grp_fileio_read() read error. \"%s\"\n", __grp_fn);
		return -1;
	}
	grp_fileio_close();
	return retval;
}

int grp_fileio_close()
{
	if (__grp_fd < 0 || __grp_size < 0)
		return FALSE;
	close(__grp_fd);

	__grp_fd    = -1;
	__grp_size  = -1;
	__grp_fn[0] = '\0';
	return TRUE;
}

int grp_fileio_openwrite( char *filename, void *p, long size )
{
	int fd;

	if ((fd = open( filename, O_CREAT | O_WRONLY | O_TRUNC, S_IREAD | S_IWRITE )) < 0) {
		ERRMSG("grp_fileio_openwrite() open error. \"%s\"\n", filename);
		return FALSE;
	}
	if (write( fd, p, size ) < size) {
		ERRMSG("grp_fileio_openwrite() write error. \"%s\"\n", filename);
		close(fd);
		return FALSE;
	}
	close(fd);
	return TRUE;
}
