/* File: draw.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <unistd.h>
#include <pthread.h>

#include "common.h"
#include "matrix.h"
#include "geometry.h"
#include "draw.h"
#include "prim.h"
#include "font.h"
#include "input.h"
#include "fileio.h"
#include "tex.h"
#include "context.h"
#include "debug.h"

/* variables */
int gri_resolution_mode = GRD_RESOLUTIONMODE_VESA;
int gri_resolution_x = 640;
int gri_resolution_y = 480;
int gri_grdrawpath1_dmabufsize;
int gri_grdrawpath2_dmabufsize;
int gri_dmalloc_mmapsize;
long gri_frame_ct;

#ifdef SCREEN_RES_FREE
int grd_screen_size_x;
int grd_screen_size_y;
int grd_screen_size_iy;
int grd_screen_center_x;
int grd_screen_center_y;
int grd_screen_center_iy;
int grd_screen_zbuf_min;
int grd_screen_zbuf_max;
int grd_screen_ratio;
float grd_screen_ratio_mfloat;
float grd_screen_x_div_y;
int grd_screen_interlace;
#endif

int __grl_ps2sm_screenx;
int __grl_ps2sm_screeny;
int __grl_ps2sm_bgcolor_r;
int __grl_ps2sm_bgcolor_g;
int __grl_ps2sm_bgcolor_b;
int __grl_ps2sm_bgcolor_a;

int __grl_ps2sm_interlace;
int __grl_ps2sm_outmode;
int __grl_ps2sm_framemode;
int __grl_ps2sm_resolution;
int __grl_ps2sm_refrate;
int __grl_ps2sm_refrate_n;

int __grl_ps2sm_psm;
int __grl_ps2sm_zpsm;
int __grl_ps2sm_zbits;

/* variables for graphic data strem DMA */
unsigned int *__grl_ps2gdma_bufdata[2][2] __attribute__ ((aligned(16))); /* DMA Buffer */
unsigned int *__grl_ps2gdma_buf[2]        __attribute__ ((aligned(16))); /* Current writable pointer (Path-1/3) */
unsigned int *__grl_ps2gdma_buf_p;		/* Selected path pointer */
int __grl_ps2gdma_bufid;			/* Current buffer ID */
int __grl_ps2gdma_sysbuf;			/* Current setting draw path is system dma buffer ? */
#ifdef USE_DRAWPATH_3
int __grl_ps2gdma_path;				/* Current draw path number */
#endif
int __grl_ps2draw_context;			/* Current draw context number */
#ifdef REDUCE_DMATAG
int __grl_dma_ct[2];
unsigned int *__grl_dma_ptr[2];
#endif

/* variables for GS controls */
int __grl_ps2_gsoddeven;
int __grl_ps2_gsframe;
ps2_gs_dbuffdc __grl_ps2_gdb;
ps2_gs_finish __grl_ps2_gfinish;
int __grl_ps2_fdgs;
ps2_vpu *__grl_ps2_vpu0, *__grl_ps2_vpu1;
int __grl_ps2_setdbuff_val = 0;

static int __grl_gs_lock_flag = FALSE;
static void __grl_draw_initgraph( void );
static void __grl_draw_initgraph_0( void );

static void gs_vc_unlock( void )
{
	if (!__grl_gs_lock_flag)
		return;
	ps2_gs_vc_unlock();
	__grl_gs_lock_flag = FALSE;
	return;
}

static void gs_vc_lock( void )
{
	if (__grl_gs_lock_flag)
		return;
	ps2_gs_vc_lock();
	__grl_gs_lock_flag = TRUE;
	return;
}

static void resinit( void )
{
#if defined(SCREEN_RES_VGA)
	__grl_ps2sm_screenx	= 640;
	__grl_ps2sm_screeny	= 480;
	__grl_ps2sm_interlace	= PS2_GS_NOINTERLACE;	/* PS2_GS_INTERLACE,NOINTERLACE */
	__grl_ps2sm_outmode	= PS2_GS_VESA;		/* PS2_GS_NTSC,PAL,DTV,VESA */
	__grl_ps2sm_framemode	= PS2_GS_FRAME;		/* PS2_GS_FRAME,PS2_GS_FIELD */
	__grl_ps2sm_resolution	= PS2_GS_640x480;	/* PS2_GS_xxx */
	__grl_ps2sm_refrate	= PS2_GS_60Hz;		/* PS2_GS_60Hz,75Hz */
	__grl_ps2sm_refrate_n	= 60;
#elif defined(SCREEN_RES_NTSC)
	__grl_ps2sm_screenx	= 640;
	__grl_ps2sm_screeny	= 448;
	__grl_ps2sm_interlace	= PS2_GS_INTERLACE;
	__grl_ps2sm_outmode	= PS2_GS_NTSC;
	__grl_ps2sm_framemode	= PS2_GS_FRAME;	
	__grl_ps2sm_resolution	= PS2_GS_640x448;
	__grl_ps2sm_refrate	= 0;
	__grl_ps2sm_refrate_n	= 60;
#elif defined(SCREEN_RES_PAL)
	__grl_ps2sm_screenx	= 640;
	__grl_ps2sm_screeny	= 512;
	__grl_ps2sm_interlace	= PS2_GS_INTERLACE;
	__grl_ps2sm_outmode	= PS2_GS_PAL;
	__grl_ps2sm_framemode	= PS2_GS_FRAME;
	__grl_ps2sm_resolution	= PS2_GS_640x512;
	__grl_ps2sm_refrate	= 0;
	__grl_ps2sm_refrate_n	= 50;
#endif
	__grl_ps2sm_psm		= PS2_GS_PSMCT32;
	__grl_ps2sm_zpsm	= PS2_GS_PSMZ24;
	__grl_ps2sm_zbits	= 24;
	__grl_ps2sm_bgcolor_r	= 0x00;
	__grl_ps2sm_bgcolor_g	= 0x00;
	__grl_ps2sm_bgcolor_b	= 0x00;
	__grl_ps2sm_bgcolor_a	= 0x80;

#ifdef SCREEN_RES_FREE
	grd_screen_size_x	= __grl_ps2sm_screenx;
	grd_screen_size_y	= __grl_ps2sm_screeny;
	grd_screen_size_iy	= grd_screen_size_y / (__grl_ps2sm_interlace == PS2_GS_INTERLACE ? 2 : 1);
	grd_screen_center_x	= grd_screen_size_x / 2;
	grd_screen_center_y	= grd_screen_size_y / 2;
	grd_screen_center_iy	= grd_screen_center_y / (__grl_ps2sm_interlace == PS2_GS_INTERLACE ? 2 : 1);
	grd_screen_zbuf_min	= 0x0000000UL;
	grd_screen_zbuf_max	= 0x00fffffUL;
	grd_screen_ratio	= __grl_ps2sm_interlace + 1;
	grd_screen_ratio_mfloat	= 1.0f / (__grl_ps2sm_interlace == PS2_GS_INTERLACE ? 2.0f : 1.0f);
	grd_screen_x_div_y	= 0.75f;
	grd_screen_interlace	= __grl_ps2sm_interlace;
#endif

	if (__grl_ps2sm_psm == PS2_GS_PSMCT16S && __grl_ps2sm_zpsm == PS2_GS_PSMZ16)
		__grl_ps2sm_psm = PS2_GS_PSMCT16;
	return;
}

int grd_draw_setresolution_0( void )
{
	int nointer_flag = FALSE;

	if (gri_resolution_mode < 0 || gri_resolution_mode >= GRD_RESOLUTIONMODE_MAX_NUM)
		return FALSE;
	switch (gri_resolution_mode) {
		case GRD_RESOLUTIONMODE_VESA :
			if (gri_resolution_x == 640 && gri_resolution_y == 480)
				__grl_ps2sm_resolution	= PS2_GS_640x480;
			else if (gri_resolution_x == 800 && gri_resolution_y == 600)
				__grl_ps2sm_resolution	= PS2_GS_800x600;
			else if (gri_resolution_x == 1024 && gri_resolution_y == 768)
				__grl_ps2sm_resolution	= PS2_GS_1024x768;
			else if (gri_resolution_x == 1280 && gri_resolution_y == 1024)
				__grl_ps2sm_resolution	= PS2_GS_1280x1024;
			else
				return -1;
			__grl_ps2sm_screenx	= gri_resolution_x;
			__grl_ps2sm_screeny	= gri_resolution_y;
			__grl_ps2sm_interlace	= PS2_GS_NOINTERLACE;
			__grl_ps2sm_outmode	= PS2_GS_VESA;
			__grl_ps2sm_framemode	= PS2_GS_FRAME;
			__grl_ps2sm_refrate	= PS2_GS_60Hz;
			__grl_ps2sm_refrate_n	= 60;
			break;
		case GRD_RESOLUTIONMODE_NTSC :
			if (gri_resolution_x < 256)
				return -1;
			if (gri_resolution_x > 640)
				return -1;
			if (gri_resolution_y < 224)
				return -1;
			if (gri_resolution_y > 480)
				return -1;
			if (gri_resolution_y <= 256)
				nointer_flag = TRUE;
			__grl_ps2sm_screenx	= gri_resolution_x;
			__grl_ps2sm_screeny	= gri_resolution_y;
			__grl_ps2sm_interlace	= nointer_flag ? PS2_GS_NOINTERLACE : PS2_GS_INTERLACE;
			__grl_ps2sm_outmode	= PS2_GS_NTSC;
			__grl_ps2sm_framemode	= PS2_GS_FRAME;
			__grl_ps2sm_resolution	= 0;
			__grl_ps2sm_refrate	= 0;
			__grl_ps2sm_refrate_n	= 60;
			break;
		case GRD_RESOLUTIONMODE_PAL :
			if (gri_resolution_x < 256)
				return -1;
			if (gri_resolution_x > 640)
				return -1;
			if (gri_resolution_y < 256)
				return -1;
			if (gri_resolution_y > 576)
				return -1;
			if (gri_resolution_y <= 256)
				nointer_flag = TRUE;
			__grl_ps2sm_screenx	= gri_resolution_x;
			__grl_ps2sm_screeny	= gri_resolution_y;
			__grl_ps2sm_interlace	= nointer_flag ? PS2_GS_NOINTERLACE : PS2_GS_INTERLACE;
			__grl_ps2sm_outmode	= PS2_GS_PAL;
			__grl_ps2sm_framemode	= PS2_GS_FRAME;
			__grl_ps2sm_resolution	= 0;
			__grl_ps2sm_refrate	= 0;
			__grl_ps2sm_refrate_n	= 50;
			break;
		default :
			  return FALSE;
	}
	resinit();
	__grl_draw_initgraph();
	return TRUE;
}

int grd_draw_setresolution( void )
{
#if !defined(USE_DIRECT_DMA_CONTROL) || !defined(USE_PHSYADR_DMA)
	ioctl( ps2_vpu_fd(__grl_ps2_vpu1), PS2IOC_SENDQCT, 1 );
#ifdef USE_DRAWPATH_3
	ioctl( __grl_ps2_fdgs,             PS2IOC_SENDQCT, 1 );
#endif
#else
	while (*(unsigned int *)(__grl_ps2_genio_p+0x10009000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#ifdef USE_DRAWPATH_3
	while (*(unsigned int *)(__grl_ps2_genio_p+0x1000a000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#endif
#endif
	__grl_ps2_gsoddeven = ps2_gs_sync_v(0);

	return grd_draw_setresolution();
}

void __grl_draw_init( void )
{
	ps2_gs_vc_graphicsmode();
	__grl_ps2_fdgs = ps2_gs_open(-1);
	__grl_ps2_vpu0 = ps2_vpu_open(0);
	__grl_ps2_vpu1 = ps2_vpu_open(1);

	/* Initialize DMA Buffer */
	__grl_ps2gdma_bufdata[0][GRDRAW_PATH1] = DMEMALIGN( 16, gri_grdrawpath1_dmabufsize );
	__grl_ps2gdma_bufdata[1][GRDRAW_PATH1] = DMEMALIGN( 16, gri_grdrawpath1_dmabufsize );
#ifdef USE_DRAWPATH_3
	__grl_ps2gdma_bufdata[0][GRDRAW_PATH2] = DMEMALIGN( 16, gri_grdrawpath2_dmabufsize );
	__grl_ps2gdma_bufdata[1][GRDRAW_PATH2] = DMEMALIGN( 16, gri_grdrawpath2_dmabufsize );
	if (!__grl_ps2gdma_bufdata[0][GRDRAW_PATH1] || !__grl_ps2gdma_bufdata[0][GRDRAW_PATH2]
			|| !__grl_ps2gdma_bufdata[1][GRDRAW_PATH1] || !__grl_ps2gdma_bufdata[1][GRDRAW_PATH2]) {
		ERRMSG("__grl_draw_init() dma buffer allocation error 1:%x 2:%x 3:%x 4:%x\n",
			(unsigned int)__grl_ps2gdma_bufdata[0][GRDRAW_PATH1], (unsigned int)__grl_ps2gdma_bufdata[0][GRDRAW_PATH2],
			(unsigned int)__grl_ps2gdma_bufdata[1][GRDRAW_PATH1], (unsigned int)__grl_ps2gdma_bufdata[1][GRDRAW_PATH2]);
		EXIT(1);
	}
#else
	__grl_ps2gdma_bufdata[0][1 /* GRDRAW_PATH2 */] = NULL;
	__grl_ps2gdma_bufdata[1][1 /* GRDRAW_PATH2 */] = NULL;
	if (!__grl_ps2gdma_bufdata[0][GRDRAW_PATH1] || !__grl_ps2gdma_bufdata[1][GRDRAW_PATH1]) {
		ERRMSG("__grl_draw_init() dma buffer allocation error 1:%x 3:%x\n",
			(unsigned int)__grl_ps2gdma_bufdata[0][GRDRAW_PATH1], (unsigned int)__grl_ps2gdma_bufdata[1][GRDRAW_PATH1]);
		EXIT(1);
	}
#endif
	/* Init graphic buffer */
	/* FREE mode default resolution */
	__grl_ps2_gsframe = 0;
	if (!grd_draw_setresolution_0()) {
		ERRMSG("__grl_draw_init() grd_draw_setresolution_0() error.\n");
		EXIT(1);
	}
	gri_frame_ct = 0;
	return;
}

static int release_0( void )
{
	if (__grl_ps2_fdgs >= 0) {
		ps2_gs_close();
		__grl_ps2_fdgs = -1;
	}
	if (__grl_ps2_vpu1) {
		ps2_vpu_close(__grl_ps2_vpu1);
		__grl_ps2_vpu1 = NULL;
	}
	if (__grl_ps2_vpu0) {
		ps2_vpu_close(__grl_ps2_vpu0);
		__grl_ps2_vpu0 = NULL;
	}
	gs_vc_unlock();
	return PS2_GS_VC_REL_SUCCESS;
}

static int release( void )
{
#if !defined(USE_DIRECT_DMA_CONTROL) || !defined(USE_PHSYADR_DMA)
	ioctl( ps2_vpu_fd(__grl_ps2_vpu1), PS2IOC_SENDQCT, 1 );
#ifdef USE_DRAWPATH_3
	ioctl( __grl_ps2_fdgs,             PS2IOC_SENDQCT, 1 );
#endif
#else
	while (*(unsigned int *)(__grl_ps2_genio_p+0x10009000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#ifdef USE_DRAWPATH_3
	while (*(unsigned int *)(__grl_ps2_genio_p+0x1000a000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#endif
#endif
	ps2_gs_sync_v(0);
	return release_0();
}

static int acquire( void )
{
	if (__grl_ps2_fdgs < 0)
		__grl_ps2_fdgs = ps2_gs_open(-1);
	if (!__grl_ps2_vpu0)
		__grl_ps2_vpu0 = ps2_vpu_open(0);
	if (!__grl_ps2_vpu1)
		__grl_ps2_vpu1 = ps2_vpu_open(1);
	if (__grl_ps2_fdgs < 0 || !__grl_ps2_vpu0 || !__grl_ps2_vpu1) {
		release_0();
		return PS2_GS_VC_ACQ_FAILURE;
	}
	ps2_gs_vc_graphicsmode();
	ps2_gs_vc_enablevcswitch( acquire, release );
	__grl_draw_initgraph_0();
	grd_tex_clear();
	return PS2_GS_VC_ACQ_SUCCESS;
}

static void __grl_draw_initgraph_0( void )
{
	ps2_gs_reset( 0, __grl_ps2sm_interlace, __grl_ps2sm_outmode,
		         __grl_ps2sm_framemode, __grl_ps2sm_resolution,
		         __grl_ps2sm_refrate );
	ps2_gs_set_dbuff_dc(&__grl_ps2_gdb, __grl_ps2sm_psm,
			__grl_ps2sm_screenx, __grl_ps2sm_screeny / (__grl_ps2sm_interlace == PS2_GS_INTERLACE ? 2 : 1),
			(__grl_ps2sm_zbits == 0) ? PS2_GS_TEST_ZTST_NEVER : PS2_GS_TEST_ZTST_GREATER,
			__grl_ps2sm_zpsm, 1 );
	__grl_ps2_setdbuff_val = (((SCREEN_SIZE_X*SCREEN_SIZE_IY*4 + VBYTE2048-1)
		& VMASK2048) * 3) / VBYTE2048;	/* 32bit only */
	*(__u64 *)&__grl_ps2_gdb.clear1.rgbaq =
	*(__u64 *)&__grl_ps2_gdb.clear0.rgbaq =
		PS2_GS_SETREG_RGBAQ(__grl_ps2sm_bgcolor_r, __grl_ps2sm_bgcolor_g,
			__grl_ps2sm_bgcolor_b, __grl_ps2sm_bgcolor_a, 0x3f800000);

	/* clear buffer and set environment */
	ps2_gs_swap_dbuff_dc( &__grl_ps2_gdb, __grl_ps2_gsframe + 1 );
	ps2_gs_swap_dbuff_dc( &__grl_ps2_gdb, __grl_ps2_gsframe );
	__grl_ps2_gsoddeven = ps2_gs_sync_v(0);
	ps2_gs_start_display(1);
	return;
}

static void __grl_draw_initgraph( void )
{
	ps2_gs_vc_graphicsmode();
	ps2_gs_vc_enablevcswitch( acquire, release );
	gs_vc_lock();
	__grl_draw_initgraph_0();

	/* set value for graphic data stream DMA */
	__grl_ps2gdma_bufid  = 0;
	__grl_ps2gdma_buf[GRDRAW_PATH1] = (unsigned int *)((int)__grl_ps2gdma_bufdata[__grl_ps2gdma_bufid][GRDRAW_PATH1]);
#ifdef USE_DRAWPATH_3
	__grl_ps2gdma_buf[GRDRAW_PATH2] = (unsigned int *)((int)__grl_ps2gdma_bufdata[__grl_ps2gdma_bufid][GRDRAW_PATH2]);
#else
	__grl_ps2gdma_buf[1 /* GRDRAW_PATH2 */] = NULL;
#endif
	__grl_ps2gdma_sysbuf = FALSE;

	grd_set_currentdrawpath( GRDRAW_PATH1 );
	__grl_debug_profframest();
	return;
}

void __grl_draw_shutdown( void )
{
#if !defined(USE_DIRECT_DMA_CONTROL) || !defined(USE_PHSYADR_DMA)
	ioctl( ps2_vpu_fd(__grl_ps2_vpu1), PS2IOC_SENDQCT, 1 );
#ifdef USE_DRAWPATH_3
	ioctl( __grl_ps2_fdgs,             PS2IOC_SENDQCT, 1 );
#endif
#else
	while (*(unsigned int *)(__grl_ps2_genio_p+0x10009000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#ifdef USE_DRAWPATH_3
	while (*(unsigned int *)(__grl_ps2_genio_p+0x1000a000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#endif
#endif
	ps2_gs_sync_v(0);
	gs_vc_unlock();
	ps2_gs_vc_disablevcswitch();
	ps2_gs_vc_textmode();
	if (__grl_ps2_fdgs >= 0) {
		ps2_gs_close();
		__grl_ps2_fdgs = -1;
	}
	if (__grl_ps2_vpu1) {
		ps2_vpu_close(__grl_ps2_vpu1);
		__grl_ps2_vpu1 = NULL;
	}
	if (__grl_ps2_vpu0) {
		ps2_vpu_close(__grl_ps2_vpu0);
		__grl_ps2_vpu0 = NULL;
	}
	return;
}

void grd_draw_framestart( void )
{
#ifdef REDUCE_DMATAG
	int i;
#endif

	/* set value for graphic data stream DMA */
	__grl_ps2gdma_buf[GRDRAW_PATH1] = (unsigned int *)((int)__grl_ps2gdma_bufdata[__grl_ps2gdma_bufid][GRDRAW_PATH1]);
#ifdef USE_DRAWPATH_3
	__grl_ps2gdma_buf[GRDRAW_PATH2] = (unsigned int *)((int)__grl_ps2gdma_bufdata[__grl_ps2gdma_bufid][GRDRAW_PATH2]);
#else
	__grl_ps2gdma_buf[1 /* GRDRAW_PATH2 */] = NULL;
#endif
#ifdef REDUCE_DMATAG
	for (i = 0; i < 2; i++) {
		__grl_dma_ct[i]  = 0;
		__grl_dma_ptr[i] = NULL;
	}
#endif
	__grl_ps2gdma_sysbuf = FALSE;

	/* set context-2 default value */
	grd_set_currentdrawpath( GRDRAW_PATH2 );
	_gps2_setdma_dmagif( 1, 8, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) );
	if (!(__grl_ps2_gsframe & 1)) {
		memcpy( __grl_ps2gdma_buf_p, &__grl_ps2_gdb.draw12, sizeof(ps2_gs_drawenv2) );
	} else
		memcpy( __grl_ps2gdma_buf_p, &__grl_ps2_gdb.draw02, sizeof(ps2_gs_drawenv2) );
	_gps2_setdma_skip_16(8);

	/* set context-1 default value */
	grd_set_currentdrawpath( GRDRAW_PATH1 );
	_gps2_setdma_dmagif( 1, 8, GIF_EOP | GIF_FLG_PACKED, GIF_REGS(GIF_REGS_A_D, 0) );
	if (!(__grl_ps2_gsframe & 1)) {
		memcpy( __grl_ps2gdma_buf_p, &__grl_ps2_gdb.draw11, sizeof(ps2_gs_drawenv1) );
	} else
		memcpy( __grl_ps2gdma_buf_p, &__grl_ps2_gdb.draw01, sizeof(ps2_gs_drawenv1) );
	_gps2_setdma_skip_16(8);

	grd_set_currentdrawpath( GRDRAW_PATH2 );
	grd_set_currentcontext( GRDRAW_CONTEXT2 );
	grd_set_drawmode_anormal_ztest_zupdate( grd_get_currentcontext() );
	grd_set_drawmode_texclamp( grd_get_currentcontext() );
	grd_set_currentdrawpath( GRDRAW_PATH1 );
	grd_set_currentcontext( GRDRAW_CONTEXT1 );
	grd_set_drawmode_anormal_ztest_zupdate( grd_get_currentcontext() );
	grd_set_drawmode_texclamp( grd_get_currentcontext() );

	__grd_font_framest();
	return;
}

static void __grl_draw_frameflip( int mode )
{
#if defined(USE_DIRECT_DMA_CONTROL) && defined(USE_PHSYADR_DMA)
	unsigned int tp1;
#ifdef USE_DRAWPATH_3
	unsigned int tp2;
#endif
	struct ps2_genio_ioctl_wback_inv flushparam;
#else
#ifdef USE_PHSYADR_DMA
	struct ps2_packet dma_vpu1;
#ifdef USE_DRAWPATH_3
	struct ps2_packet dma_gs;
#endif
#endif
#endif

	/* display messages */
	grd_wait_draw();
	__grl_debug_profframeend();

	/* dma end */
	grd_set_currentdrawpath( GRDRAW_PATH1 );
	_gps2_close_dma();
	_gps2_setdma_32323232( 0x70000000U, 0x0U, 0x0U, 0x0U );
#ifdef USE_DRAWPATH_3
	grd_set_currentdrawpath( GRDRAW_PATH2 );
	_gps2_close_dma();
	_gps2_setdma_32323232( 0x70000000U, 0x0U, 0x0U, 0x0U );
#endif

	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0xffffff );
#if !defined(USE_DIRECT_DMA_CONTROL) || !defined(USE_PHSYADR_DMA)
	grd_debug_profset( GRD_DEBUG_PROF_GS_ID, 0xffff00U );
	ioctl( ps2_vpu_fd(__grl_ps2_vpu1), PS2IOC_SENDQCT, 1 );
#ifdef USE_DRAWPATH_3
	ioctl( __grl_ps2_fdgs,             PS2IOC_SENDQCT, 1 );
#endif
#else
	while (*(unsigned int *)(__grl_ps2_genio_p+0x10009000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#ifdef USE_DRAWPATH_3
	while (*(unsigned int *)(__grl_ps2_genio_p+0x1000a000-PS2_DEV_GENIO_OFFSET) & 0x0100)
		usleep( 100 );
#endif
#endif
	grd_debug_profset( GRD_DEBUG_PROF_GS_ID, 0xffffffU );

	/* wait V-Sync and flip double buffer */
	__grl_ps2_gsframe++;
	__grl_ps2_gsoddeven = ps2_gs_sync_v(0);
	gs_vc_unlock();
	gs_vc_lock();
	ps2_gs_set_half_offset( (__grl_ps2_gsframe & 1) ? &__grl_ps2_gdb.draw11 : &__grl_ps2_gdb.draw01, !__grl_ps2_gsoddeven );
	ps2_gs_swap_dbuff_dc( &__grl_ps2_gdb, __grl_ps2_gsframe );
	__grl_ps2gdma_bufid = !__grl_ps2gdma_bufid;
	__grl_debug_profframest();

	/* DMA transfer start */
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0x00ff00U );
#if !defined(USE_DIRECT_DMA_CONTROL) || !defined(USE_PHSYADR_DMA)
#ifndef USE_VIF1DMA_TTE1
	ps2_dma_start( ps2_vpu_fd(__grl_ps2_vpu1), NULL, (ps2_dmatag *)__grl_ps2gdma_bufdata[!__grl_ps2gdma_bufid][GRDRAW_PATH1] );
#ifdef USE_DRAWPATH_3
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0x800000U );
	ps2_dma_start( __grl_ps2_fdgs,             NULL, (ps2_dmatag *)__grl_ps2gdma_bufdata[!__grl_ps2gdma_bufid][GRDRAW_PATH2] );
#endif
#else
	dma_vpu1.ptr = __grl_ps2gdma_bufdata[!__grl_ps2gdma_bufid][GRDRAW_PATH1];
	dma_vpu1.len = 16;
	ioctl( ps2_vpu_fd(__grl_ps2_vpu1), PS2IOC_SENDA_TTE1, &dma_vpu1 );
#ifdef USE_DRAWPATH_3
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0x800000U );
	dma_gs.ptr   = __grl_ps2gdma_bufdata[!__grl_ps2gdma_bufid][GRDRAW_PATH2];
	dma_gs.len   = 16;
	ioctl( __grl_ps2_fdgs, PS2IOC_SENDA_TTE1, &dma_gs );
#endif
#endif
#else
	flushparam.addr = PS2_RESERVE_MEMORY_START;
	flushparam.len  = PS2_RESERVE_MEMORY_SIZE;
#if 1
	if (ioctl( __grl_ps2_fdgenio, PS2IOC_DMA_CACHE_WBACK_INV, &flushparam ) < 0) {
		ERRMSG("__grl_draw_frameflip() ioctl( PS2IOC_DMA_CACHE_WBACK_INV ) error\n");
		EXIT(1);
	}
#else
	ioctl( __grl_ps2_fdgenio, PS2IOC_FLUSH_CACHE_ALL, 0 );
#endif

	tp1 = ((unsigned int)(__grl_ps2gdma_bufdata[!__grl_ps2gdma_bufid][GRDRAW_PATH1])) - (unsigned int)__grl_ps2_dmamem_p + PS2_RESERVE_MEMORY_START;
#ifdef USE_DRAWPATH_3
	tp2 = ((unsigned int)(__grl_ps2gdma_bufdata[!__grl_ps2gdma_bufid][GRDRAW_PATH2])) - (unsigned int)__grl_ps2_dmamem_p + PS2_RESERVE_MEMORY_START;
#endif

	/* VPU1 */
	*(unsigned int *)(__grl_ps2_genio_p+0x10009030 /* TADR */ -PS2_DEV_GENIO_OFFSET) = tp1;
	*(unsigned int *)(__grl_ps2_genio_p+0x10009020 /* QWC  */ -PS2_DEV_GENIO_OFFSET) = 0;
#ifdef USE_VIF1DMA_TTE1
	*(unsigned int *)(__grl_ps2_genio_p+0x10009000 /* CHCR */ -PS2_DEV_GENIO_OFFSET) = 0x0145;
#else
	*(unsigned int *)(__grl_ps2_genio_p+0x10009000 /* CHCR */ -PS2_DEV_GENIO_OFFSET) = 0x0105;
#endif

#ifdef USE_DRAWPATH_3
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0x800000U );
	/* GS */
	*(unsigned int *)(__grl_ps2_genio_p+0x1000a030 /* TADR */ -PS2_DEV_GENIO_OFFSET) = tp2;
	*(unsigned int *)(__grl_ps2_genio_p+0x1000a020 /* QWC  */ -PS2_DEV_GENIO_OFFSET) = 0;
	*(unsigned int *)(__grl_ps2_genio_p+0x1000a000 /* CHCR */ -PS2_DEV_GENIO_OFFSET) = 0x0105;
#endif
#endif
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0xff0000U );
	return;
}

void grd_draw_frameflip( void )
{
	int i, flag = FALSE;

	/* frame end routines */
	grd_font_locate( 0, 10, 10 );
	grd_font_setcolor( 0, 180, 255, 255, 128, 0 );
	grd_font_printf( 0, "Frame=%ld MM:%ldK/MD:%ldK\n", gri_frame_ct, gri_used_memory/1024, gri_used_dmemory/1024 );

	/* draw all */
	__grd_font_frameend();
	__grl_draw_frameflip( 0 );
	gri_frame_ct++;

	/* key input */
	grp_gameport_read();

	/* check debug input */
	for (i = 0; (i < GRP_GAMEDEV_MAX) && (gri_frame_ct > 5); i++) {
		if (grp_key_buttons[i] & GRP_KEYSELECT) {
			if (grp_key_triggers[i] & GRP_KEYSTART) {
				flag = TRUE;
				grp_key_buttons[i]  &= ~GRP_KEYSTART;
				grp_key_triggers[i] &= ~GRP_KEYSTART;
			}
			while (grp_key_buttons[i] & GRP_KEYR2) {
				__grl_ps2_gsoddeven = ps2_gs_sync_v(0);
				grp_gameport_read();
			}
			grp_key_buttons[i]  &= ~(GRP_KEYR2 | GRP_KEYSTART);
			grp_key_triggers[i] &= ~(GRP_KEYR2 | GRP_KEYSTART);
		}
	}
	if (flag)
		__grl_debug_framedump();
	return;
}
