/* File: common.h */

#ifndef __COMMON_H_INCLUDED
#define __COMMON_H_INCLUDED

#include "config.h"
#include "memory.h"

#include <stdio.h>
#include <stdarg.h>

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif
#define LNMAX	256

#define MEMALIGN(_A, _X) grp_memalign((_A), (_X))
#define MALLOC(_X) grp_malloc((_X))
#define FREE(_X) grp_free((_X))
#define DMEMALIGN(_A, _X) grp_dmemalign((_A), (_X))
#define DMALLOC(_X) grp_dmalloc((_X))
#define DFREE(_X) grp_dfree((_X))

#ifdef NDEBUG
#define TRACE(X)  {}
#define TRACE_LINE() {}
#else
inline static int TRACE( char *s, ... )
{
	char ___msg_buf[256];
	va_list arg_ptr;

	printf("cubedemo: ");
	va_start( arg_ptr, s );
	vsprintf(___msg_buf, s, arg_ptr);
	va_end( arg_ptr );
	printf("%s", ___msg_buf);
	return FALSE;
}

#define TRACE_LINE(_X) TRACE((_X) " : line=%d\n", __LINE__);
#endif

inline static int ERRMSG( char *s, ... )
{
	char ___msg_buf[256];
	va_list arg_ptr;

	fprintf(stderr, "cubedemo: ");
	va_start( arg_ptr, s );
	vsprintf(___msg_buf, s, arg_ptr);
	va_end( arg_ptr );
	fprintf(stderr, "%s", ___msg_buf);
	return FALSE;
}

#define EXIT(X) exit(X)

#endif /* __COMMON_H_INCLUDED */
