/* File: vpu1.h */

#ifndef __VPU1_H_INCLUDED
#define __VPU1_H_INCLUDED

#include "draw.h"

#define __PS2_VPU1_VPUFILE_MAX	10

#define grd_ps2_vpu1_setdma( _BASE, _OFFSET ) { \
	_gps2_setdma_vif1( PS2_VIF_SET_CODE( (_BASE),   0, PS2_VIF_BASE,   0 ) ); \
	_gps2_setdma_vif1( PS2_VIF_SET_CODE( (_OFFSET), 0, PS2_VIF_OFFSET, 0 ) ); }

#define grd_ps2_vpu1_exec( _ADDR ) \
	_gps2_setdma_vif1( PS2_VIF_SET_CODE( (_ADDR), 0, PS2_VIF_MSCAL, 0 ) );

#define grd_ps2_vpu1_cont() \
	_gps2_setdma_vif1( PS2_VIF_SET_CODE( 0, 0, PS2_VIF_MSCNT, 0 ) );

void __grl_ps2_vpu1_init( void );
void __grl_ps2_vpu1_shutdown( void );
int grd_ps2_vpu1_unload( int id );
int grd_ps2_vpu1_load( char *fn );
int grd_ps2_vpu1_use( int id, int auto_initialize, int force_transfer );

#endif /* __VPU1_H_INCLUDED */
