/* File: prim2d.h */

#ifndef __PRIM2D_H_INCLUDED
#define __PRIM2D_H_INCLUDED

#include "prim.h"

#define grd_2d_point( _X, _Y, _R, _G, _B, _A, _OPT ) \
	grd_draw_point( \
		SCREEN_2D_X((_X)), SCREEN_2D_Y((_Y)), \
		(_R), (_G), (_B), (_A), (_OPT) );

#define grd_2d_sprite( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _OPT ) \
	grd_draw_sprite( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		(_R), (_G), (_B), (_A), (_OPT) );

#define grd_2d_tsprite( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _S1, _T1, _Q1, _S2, _T2, _Q2, _OPT ) \
	grd_draw_tsprite( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		(_R), (_G), (_B), (_A), \
		(_S1), (_T1), (_Q1), (_S2), (_T2), (_Q2), (_OPT) );

#define grd_2d_usprite( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _U1, _V1, _U2, _V2, _OPT ) \
	grd_draw_usprite( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		(_R), (_G), (_B), (_A), \
		(_U1), (_V1), (_U2), (_V2), (_OPT) );

#define grd_2d_line( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _OPT ) \
	grd_draw_line( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		(_R), (_G), (_B), (_A), (_OPT) );

#define grd_2d_gline( _X1, _Y1, _X2, _Y2, _R1, _G1, _B1, _A1, _R2, _G2, _B2, _A2, _OPT ) \
	grd_draw_gline( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		(_R1), (_G1), (_B1), (_A1), \
		(_R2), (_G2), (_B2), (_A2), (_OPT) );

#define grd_2d_triangle( _X1, _Y1, _X2, _Y2, _X3, _Y3, _R, _G, _B, _A, _OPT ) \
	grd_draw_triangle( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		SCREEN_2D_X((_X3)), SCREEN_2D_Y((_Y3)), \
		(_R), (_G), (_B), (_A), (_OPT) );

#define grd_2d_gtriangle( _X1, _Y1, _X2, _Y2, _X3, _Y3, _R1, _G1, _B1, _A1, _R2, _G2, _B2, _A2, _R3, _G3, _B3, _A3, _OPT ) \
	grd_draw_gtriangle( \
		SCREEN_2D_X((_X1)), SCREEN_2D_Y((_Y1)), \
		SCREEN_2D_X((_X2)), SCREEN_2D_Y((_Y2)), \
		SCREEN_2D_X((_X3)), SCREEN_2D_Y((_Y3)), \
		(_R1), (_G1), (_B1), (_A1), \
		(_R2), (_G2), (_B2), (_A2), \
		(_R3), (_G3), (_B3), (_A3), (_OPT) );

#endif /* __PRIM2D_H_INCLUDED */
