/* File: prim.h */

#ifndef __PRIM_H_INCLUDED
#define __PRIM_H_INCLUDED

#include "def_gs.h"
#include "def_dma.h"

#define grd_draw_point( _X, _Y, _R, _G, _B, _A, _OPT ) { \
		_gps2_setdma_dmagif( 1, 2, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_POINT | (_OPT) ), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_xyzw( (_X), (_Y), 0, 0 ); \
	}

#define grd_draw_vpoint( _POS, _RGBA, _OPT ) { \
		_gps2_setdma_dmagif( 1, 2, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_POINT | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) ); \
		_gps2_setdma_rgba( (_RGBA)->x, (_RGBA)->y, (_RGBA)->z, (_RGBA)->w ); \
		_gps2_setdma_xyzw( (_POS)->x,  (_POS)->y,  (_POS)->z,  (_POS)->w  ); \
	}

#define grd_draw_sprite( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _OPT ) { \
		_gps2_setdma_dmagif( 1, 3, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_SPRITE | GS_PRIM_IIP | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
	}

#define grd_draw_vtsprite( _POS1, _POS2, _RGBA, _STQ1, _STQ2, _OPT ) { \
		_gps2_setdma_dmagif( 1, 6, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_SPRITE | GS_PRIM_IIP | GS_PRIM_TME | (_OPT)), \
			GIF_REGS(GIF_REGS_ST,    0) | \
			GIF_REGS(GIF_REGS_RGBAQ, 1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) | \
			GIF_REGS(GIF_REGS_ST,    3) | \
			GIF_REGS(GIF_REGS_RGBAQ, 4) | \
			GIF_REGS(GIF_REGS_XYZ2,  5) ); \
		_gps2_setdma_stq(  (_STQ1)->x, (_STQ1)->y, (_STQ1)->z ); \
		_gps2_setdma_rgba( (_RGBA)->x, (_RGBA)->y, (_RGBA)->z, (_RGBA)->w ); \
		_gps2_setdma_xyzw( (_POS1)->x, (_POS1)->y, (_POS1)->z, (_POS1)->w ); \
		_gps2_setdma_stq(  (_STQ2)->x, (_STQ2)->y, (_STQ2)->z ); \
		_gps2_setdma_rgba( (_RGBA)->x, (_RGBA)->y, (_RGBA)->z, (_RGBA)->w ); \
		_gps2_setdma_xyzw( (_POS2)->x, (_POS2)->y, (_POS2)->z, (_POS2)->w ); \
	}

#define grd_draw_tsprite( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _S1, _T1, _Q1, _S2, _T2, _Q2, _OPT ) { \
		_gps2_setdma_dmagif( 1, 6, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_SPRITE | GS_PRIM_IIP | GS_PRIM_TME | (_OPT)), \
			GIF_REGS(GIF_REGS_ST,    0) | \
			GIF_REGS(GIF_REGS_RGBAQ, 1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) | \
			GIF_REGS(GIF_REGS_ST,    3) | \
			GIF_REGS(GIF_REGS_RGBAQ, 4) | \
			GIF_REGS(GIF_REGS_XYZ2,  5) ); \
		_gps2_setdma_stq( (_S1), (_T1), (_Q1) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_stq( (_S2),  (_T2),  (_Q2) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
	}

#define grd_draw_usprite( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _U1, _V1, _U2, _V2, _OPT ) { \
		_gps2_setdma_dmagif( 1, 5, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_SPRITE | GS_PRIM_IIP | GS_PRIM_FST | GS_PRIM_TME | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_UV,    1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) | \
			GIF_REGS(GIF_REGS_UV,    3) | \
			GIF_REGS(GIF_REGS_XYZ2,  4) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_uv( (_U1),  (_V1) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_uv( (_U2),  (_V2) ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
	}

#define grd_draw_line( _X1, _Y1, _X2, _Y2, _R, _G, _B, _A, _OPT ) { \
		_gps2_setdma_dmagif( 1, 3, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_LINE | GS_PRIM_IIP | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
	}

#define grd_draw_gline( _X1, _Y1, _X2, _Y2, _R1, _G1, _B1, _A1, _R2, _G2, _B2, _A2, _R3, _G3, _B3, _A3, _OPT ) { \
		_gps2_setdma_dmagif( 1, 4, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_LINE | GS_PRIM_IIP  | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_RGBAQ, 2) | \
			GIF_REGS(GIF_REGS_XYZ2,  3) ); \
		_gps2_setdma_rgba( (_R1), (_G1), (_B1), (_A1) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_rgba( (_R2), (_G2), (_B2), (_A2) ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
	}

#define grd_draw_vline( _POS1, _POS2, _RGBA, _OPT ) { \
		_gps2_setdma_dmagif( 1, 3, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_LINE | GS_PRIM_IIP | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) ); \
		_gps2_setdma_rgba( (_RGBA1)->x, (_RGBA1)->y, (_RGBA1)->z, (_RGBA1)->w ); \
		_gps2_setdma_xyzw( (_POS1)->x,  (_POS1)->y,  (_POS1)->z,  (_POS1)->w  ); \
		_gps2_setdma_xyzw( (_POS2)->x,  (_POS2)->y,  (_POS2)->z,  (_POS2)->w  ); \
	}

#define grd_draw_vgline( _POS1, _POS2, _RGBA1, _RGBA2, _OPT ) { \
		_gps2_setdma_dmagif( 1, 4, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_LINE  | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_RGBAQ, 2) | \
			GIF_REGS(GIF_REGS_XYZ2,  3) ); \
		_gps2_setdma_rgba( (_RGBA1)->x, (_RGBA1)->y, (_RGBA1)->z, (_RGBA1)->w ); \
		_gps2_setdma_xyzw( (_POS1)->x,  (_POS1)->y,  (_POS1)->z,  (_POS1)->w  ); \
		_gps2_setdma_rgba( (_RGBA2)->x, (_RGBA2)->y, (_RGBA2)->z, (_RGBA2)->w ); \
		_gps2_setdma_xyzw( (_POS2)->x,  (_POS2)->y,  (_POS2)->z,  (_POS2)->w  ); \
	}

#define grd_draw_triangle( _X1, _Y1, _X2, _Y2, _X3, _Y3, _R, _G, _B, _A, _OPT ) { \
		_gps2_setdma_dmagif( 1, 4, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_TRIANGLE | GS_PRIM_IIP | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) | \
			GIF_REGS(GIF_REGS_XYZ2,  3) ); \
		_gps2_setdma_rgba( (_R), (_G), (_B), (_A) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
		_gps2_setdma_xyzw( (_X3), (_Y3), 0, 0 ); \
	}

#define grd_draw_gtriangle( _X1, _Y1, _X2, _Y2, _X3, _Y3, _R1, _G1, _B1, _A1, _R2, _G2, _B2, _A2, \
			    _R3, _G3, _B3, _A3, _OPT ) { \
		_gps2_setdma_dmagif( 1, 6, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_TRIANGLE  | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_RGBAQ, 2) | \
			GIF_REGS(GIF_REGS_XYZ2,  3) | \
			GIF_REGS(GIF_REGS_RGBAQ, 4) | \
			GIF_REGS(GIF_REGS_XYZ2,  5) ); \
		_gps2_setdma_rgba( (_R1), (_G1), (_B1), (_A1) ); \
		_gps2_setdma_xyzw( (_X1), (_Y1), 0, 0 ); \
		_gps2_setdma_rgba( (_R2), (_G2), (_B2), (_A2) ); \
		_gps2_setdma_xyzw( (_X2), (_Y2), 0, 0 ); \
		_gps2_setdma_rgba( (_R3), (_G3), (_B3), (_A3) ); \
		_gps2_setdma_xyzw( (_X3), (_Y3), 0, 0 ); \
	}

#define grd_draw_vtriangle( _POS1, _POS2, _POS3, _RGBA, _OPT ) { \
		_gps2_setdma_dmagif( 1, 4, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_TRIANGLE | GS_PRIM_IIP | (_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) | \
			GIF_REGS(GIF_REGS_XYZ2,  3) ); \
		_gps2_setdma_rgba( (_RGBA1)->x, (_RGBA1)->y, (_RGBA1)->z, (_RGBA1)->w ); \
		_gps2_setdma_xyzw( (_POS1)->x,  (_POS1)->y,  (_POS1)->z,  (_POS1)->w  ); \
		_gps2_setdma_xyzw( (_POS2)->x,  (_POS2)->y,  (_POS2)->z,  (_POS2)->w  ); \
		_gps2_setdma_xyzw( (_POS3)->x,  (_POS3)->y,  (_POS3)->z,  (_POS3)->w  ); \
	}

#define grd_draw_vgtriangle_s( _N, _OPT ) { \
		_gps2_setdma_dmagif( (_N), 2, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM((_OPT)), \
			GIF_REGS(GIF_REGS_RGBAQ, 0) | \
			GIF_REGS(GIF_REGS_XYZ2,  1) ); \
	}

#define grd_draw_vgtriangle_w( _POS, _RGBA, _WFLAG ) { \
		_gps2_setdma_rgba( (_RGBA)->x, (_RGBA)->y, (_RGBA)->z, (_RGBA)->w ); \
		_gps2_setdma_xyzwa( (_POS)->x,  (_POS)->y,  (_POS)->z,  (_POS)->w, (_WFLAG) ); \
	}

#define grd_draw_vgtriangle( _POS1, _POS2, _POS3, _RGBA1, _RGBA2, _RGBA3, _OPT ) { \
		grd_draw_vgtriangle_s( 3, GS_PRIM_TRIANGLE | (_OPT) ); \
		grd_draw_vgtriangle_w( (_POS1), (_RGBA1), 0 ); \
		grd_draw_vgtriangle_w( (_POS2), (_RGBA2), 0 ); \
		grd_draw_vgtriangle_w( (_POS3), (_RGBA3), 0 ); \
	}

#define grd_draw_vgttriangle_s( _N, _OPT ) { \
		_gps2_setdma_dmagif( (_N), 3, GIF_EOP | GIF_PRE | GIF_FLG_PACKED | \
			GIF_PRIM(GS_PRIM_TME | (_OPT)), \
			GIF_REGS(GIF_REGS_ST,    0) | \
			GIF_REGS(GIF_REGS_RGBAQ, 1) | \
			GIF_REGS(GIF_REGS_XYZ2,  2) ); \
	}

#define grd_draw_vgttriangle_w( _POS, _RGBA, _STQ, _WFLAG ) { \
		_gps2_setdma_stq(   (_STQ)->x,  (_STQ)->y,  (_STQ)->z ); \
		_gps2_setdma_rgba(  (_RGBA)->x, (_RGBA)->y, (_RGBA)->z, (_RGBA)->w ); \
		_gps2_setdma_xyzwa( (_POS)->x,  (_POS)->y,  (_POS)->z,  (_POS)->w, (_WFLAG) ); \
	}

#define grd_draw_vgttriangle( _POS1, _POS2, _POS3, _RGBA1, _RGBA2, _RGBA3, _STQ1, _STQ2, _STQ3, _OPT ) { \
		grd_draw_vgttriangle_s( 3, GS_PRIM_TRIANGLE | (_OPT) ); \
		grd_draw_vgttriangle_w( (_POS1), (_RGBA1), (_STQ1), 0 ); \
		grd_draw_vgttriangle_w( (_POS2), (_RGBA2), (_STQ2), 0 ); \
		grd_draw_vgttriangle_w( (_POS3), (_RGBA3), (_STQ3), 0 ); \
	}

#endif /* __PRIM_H_INCLUDED */
