/* File: main.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "common.h"
#include "main.h"
#include "cube.h"
#include "input.h"
#include "draw.h"
#include "tex.h"
#include "font.h"
#include "matrix.h"
#include "geometry.h"
#include "prim.h"
#include "prim2d.h"
#include "prim3d.h"
#include "debug.h"

#define BG_TEX_NUM		3
#define CUBE_TEX_NUM		4

#define CAMERA_MOVE_UNIT	100.0f
#define CUBE_MAX_NUM		2000
#define BG_VERTICIES_NUM	4
#define BG_SIZE			700.0f
#define BG_POS_Y		0.0f

static GRVector4 bg_vertices[BG_VERTICIES_NUM] = {
	{ -1.0f*BG_SIZE, 0.0f,  1.0f*BG_SIZE, 1.0f },
	{ -1.0f*BG_SIZE, 0.0f, -1.0f*BG_SIZE, 1.0f },
	{  1.0f*BG_SIZE, 0.0f,  1.0f*BG_SIZE, 1.0f },
	{  1.0f*BG_SIZE, 0.0f, -1.0f*BG_SIZE, 1.0f }
};

static GRVector4 bg_colors[BG_VERTICIES_NUM] = {
	{ 127.0f, 127.0f, 127.0f, 50.0f },
	{ 127.0f, 127.0f, 127.0f, 50.0f },
	{ 127.0f, 127.0f, 127.0f, 50.0f },
	{ 127.0f, 127.0f, 127.0f, 50.0f }
};

static GRVector4 bg_texs[BG_VERTICIES_NUM];

static GRVector4 bg_texs_o[BG_VERTICIES_NUM] = {
	{  0.0f, 1.0f, 1.0f, 0.0f },
	{  0.0f, 0.0f, 1.0f, 0.0f },
	{  1.0f, 1.0f, 1.0f, 0.0f },
	{  1.0f, 0.0f, 1.0f, 0.0f }
};

static int cubestat[CUBE_MAX_NUM];
static GRVector4 cubepos[CUBE_MAX_NUM];
static GRVector4 cubevecd[CUBE_MAX_NUM];
static GRVector4 cubevecdd[CUBE_MAX_NUM];
static GRVector4 cubeangle[CUBE_MAX_NUM];
static GRVector4 cubeavec[CUBE_MAX_NUM];

static GRVector4 cam_pos;
static GRVector3 cam_angle;
static GRD_TEX_INFO texinfo[CUBE_TEX_NUM];
static GRD_TEX_INFO texinfo_bg[BG_TEX_NUM];

static int cubes = 480;
static int global_ct = 0;
static int bg_tex_select = 0;

static void camera_init( void )
{
	cam_pos.x	=     0.0f;
	cam_pos.y	=  -600.0f;
	cam_pos.z	= -3000.0f;
	cam_pos.w	=     1.0f;
	cam_angle.x	=     0.0f;
	cam_angle.y	=     0.0f;
	cam_angle.z	=     0.0f;
	return;
}

static void cubepos_set( int i )
{
	/* status */
	cubestat[i] = FALSE;

	/* pos */
	cubepos[i].x = 50.0f*rand()/(RAND_MAX+1.0f) - 25.0f;
	cubepos[i].y = -2000.0f;
	cubepos[i].z = 50.0f*rand()/(RAND_MAX+1.0f) - 25.0f;
	cubepos[i].w = 0.0f;
	cubevecd[i].x = 6.0f*rand()/(RAND_MAX+1.0f) - 3.0f;
	cubevecd[i].y = 3.0f*rand()/(RAND_MAX+1.0f);
	cubevecd[i].z = 6.0f*rand()/(RAND_MAX+1.0f) - 3.0f;
	cubevecd[i].w = 0.0f;
	cubevecdd[i].x = 0.0f;
	cubevecdd[i].y = 0.4f*rand()/(RAND_MAX+1.0f) + 0.4f;
	cubevecdd[i].z = 0.0f;
	cubevecdd[i].w = 0.0f;

	/* angle */
	cubeangle[i].x = 0.0f;
	cubeangle[i].y = 0.0f;
	cubeangle[i].z = 0.0f;
	cubeangle[i].w = 0.0f;
	cubeavec[i].x = 0.1f*GRMFPI*rand()/(RAND_MAX+1.0f) - 0.05f*GRMFPI;
	cubeavec[i].y = 0.1f*GRMFPI*rand()/(RAND_MAX+1.0f) - 0.05f*GRMFPI;
	cubeavec[i].z = 0.1f*GRMFPI*rand()/(RAND_MAX+1.0f) - 0.05f*GRMFPI;
	cubeavec[i].w = 0.0f;
	return;
}

static void cubepos_init( void )
{
	int i;

	for (i = 0; i < CUBE_MAX_NUM; i++)
		cubepos_set( i );
	return;
}

static void select_bg( void )
{
	int i, l;

	l = (int)((float)5*rand()/(RAND_MAX+1.0f)) + 1;
	bg_tex_select = (int)((float)BG_TEX_NUM*rand()/(RAND_MAX+1.0f));
	for (i = 0; i < BG_VERTICIES_NUM; i++) {
		bg_texs[i] = bg_texs_o[i];
		bg_texs[i].x *= l;
		bg_texs[i].y *= l;
	}
	return;
}

int prog_init( void )
{
	camera_init();
	cube_init();
	cubepos_init();
	grg_cam_pos   = cam_pos;
	grg_cam_angle = cam_angle;
	grg_set3Dmatrix( 3.0f, 65535.0f );
	grg_set3Dmatrix_camera();
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo_bg[0], "texdata/purple_marble.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo_bg[1], "texdata/floral.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo_bg[2], "texdata/dark-gnome.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[0], "texdata/purple_marble.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[1], "texdata/blue_gray.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[2], "texdata/fibers.bmp" );
	grd_tex_read( GRD_TRATTR_ERROREXIT, NULL, &texinfo[3], "texdata/terracotta.bmp" );
	select_bg();
	return TRUE;
}

int prog_main( void )
{
	int i;
	int retflag = TRUE;
	int pause_flag = FALSE;
	static GRVector4 bg_pos = { 0.0f, BG_POS_Y, 0.0f, 0.0f };
	static GRVector3 bg_angle = { 0.0f, 0.0f, 0.0f };

	grd_draw_framestart();

	/* move and set camera */
	for (i = 0; i < GRP_GAMEDEV_MAX; i++) {
	  	if (grp_key_buttons[i] & GRP_KEYSELECT) {
			pause_flag = TRUE;
			break;
		}
		cam_pos.x = cam_pos.x + (float)grp_key_analog1_h[i];
		cam_pos.y = cam_pos.y + (float)grp_key_analog1_v[i];
		cam_pos.z = cam_pos.z + (float)grp_key_analog2_v[i];
		if (grp_key_buttons[i] & GRP_KEYLEFT)
			cam_angle.x = cam_angle.x - (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYRIGHT)
			cam_angle.x = cam_angle.x + (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYUP)
			cam_angle.y = cam_angle.y - (float)M_PI/180.0f;
		if (grp_key_buttons[i] & GRP_KEYDOWN)
			cam_angle.y = cam_angle.y + (float)M_PI/180.0f;
		if (grp_key_triggers[i] & GRP_KEYSTART)
			camera_init();
		if (grp_key_buttons[i] & GRP_KEYA) {
			if (cubes < CUBE_MAX_NUM)
				cubes++;
		}
		if (grp_key_buttons[i] & GRP_KEYB) {
			if (cubes > 0)
				--cubes;
		}
	}
	grg_cam_pos   = cam_pos;
	grg_cam_angle = cam_angle;
	grg_set3Dmatrix_camera();

	if (!pause_flag) {
		global_ct++;
		if (!(global_ct % 1000))
			select_bg();
	}

	/* message */
	grd_font_locate( 0, 10, 40 );
	grd_font_setsize( 0, 100 );
	grd_font_setcolor( 0, 128, 255, 128+64, 128, 0 );
	grd_font_printf( 0, "Cube Demo : N=%d %dx%d\n", cubes, gri_resolution_x, gri_resolution_y );
	grd_font_setcolor( 0, 255, 255, 255, 128, 0 );
	grd_font_printf( 0, "pX:%9.2f pY:%9.2f pZ:%9.2f\n", cam_pos.x,   cam_pos.y,   cam_pos.z );
	grd_font_printf( 0, "rX:%9.2f rY:%9.2f rZ:%9.2f\n", cam_angle.x, cam_angle.y, cam_angle.z );

	/* cube move */
	if (!pause_flag) {
		for (i = 0; i < cubes; i++) {
			grm_vector4_a_vector4( &cubevecd[i],  &cubevecd[i],  &cubevecdd[i] );
			grm_vector4_a_vector4( &cubepos[i],   &cubepos[i],   &cubevecd[i] );
			grm_vector4_a_vector4( &cubeangle[i], &cubeangle[i], &cubeavec[i] );
			if (cubepos[i].x < -(BG_SIZE+CUBE_SIZE) || cubepos[i].x > (BG_SIZE+CUBE_SIZE) ||
					cubepos[i].z < -(BG_SIZE+CUBE_SIZE) || cubepos[i].z > (BG_SIZE+CUBE_SIZE)) {
				cubestat[i] = TRUE;
			} else if (!cubestat[i] && (cubepos[i].y+cubevecd[i].y) >= BG_POS_Y-CUBE_SIZE && cubevecd[i].y > 0) {
				float d = -(0.2f*rand()/(RAND_MAX+1.0f) + 0.6f);

				if (cubevecd[i].y < 0.8f)
					cubestat[i] = TRUE;
				else {
					cubevecd[i].y = d*(cubevecd[i].y);
					cubeavec[i].x = d*(cubeavec[i].x);
					cubeavec[i].y = d*(cubeavec[i].y);
					cubeavec[i].z = d*(cubeavec[i].z);
				}
			}
			if (cubepos[i].y > 2000.0f)
				cubepos_set( i );
			if (!(i % 100))
				grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );
		}
	}

	/* cube draw */
	grd_set_currentdrawpath( GRDRAW_PATH1 );
	grd_set_currentcontext( GRDRAW_CONTEXT1 );
	grd_set_drawmode_anormal_ztest_zupdate( grd_get_currentcontext() );
	for (i = 0; i < cubes; i++) {
		if (!(i % 125))
			grd_tex_use( &texinfo[(i/100) % CUBE_TEX_NUM], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
		grg_setpos_hm( &cubepos[i], (GRVector3 *)&cubeangle[i] );
		cube_draw( GS_PRIM_CTXT_V(grd_get_currentcontext()) );
		if (!(i % 100))
			grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );
	}
	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0 );

	/* BG triangles */
	grd_tex_use( &texinfo_bg[bg_tex_select], GRTEX_OPT_LINEAR, GRD_TEX_MIPMAP_DEFAULT, 0 );
	grd_set_drawmode_texrepeat( grd_get_currentcontext() );
	grg_setpos_hm( &bg_pos, &bg_angle );
	grd_3d_vgttriangles( BG_VERTICIES_NUM, bg_vertices, bg_colors, bg_texs, GRDRAW_OPT_GOURAUD | GRDRAW_OPT_ALPHA | GS_PRIM_CTXT_V(grd_get_currentcontext()) );

	grd_debug_profset( GRD_DEBUG_PROF_EE_ID, 0xff0000 );
	grd_draw_frameflip();
	return retflag;
}
