/* File: geometry.c */

#include "config.h"

#include <stdio.h>
#include <math.h>

#include "common.h"
#include "draw.h"
#include "matrix.h"
#include "geometry.h"

GRVector4	grg_hm_scale;
GRVector4	grg_hm_offset;
GRMatrix44	grg_hm_matrix;
GRVector3	grg_cam_angle;
GRVector4	grg_cam_pos;
GRMatrix44	grg_cam_matrix;
GRMatrix44	grg_cam_matrix_angle;
GRMatrix44	grg_screen;

void __grg_init( void )
{
	grg_cam_pos.x	=     0.0f;
	grg_cam_pos.y	=     0.0f;
	grg_cam_pos.z	= -1000.0f;
	grg_cam_pos.w	=     1.0f;
	grg_cam_angle.x	=     0.0f;
	grg_cam_angle.y	=     0.0f;
	grg_cam_angle.z	=     0.0f;
	grg_set3Dmatrix( 1.0f, 65535.0f );
	grg_set3Dmatrix_camera();
	return;
}

void grg_set3Dmatrix_camera( void )
{
	GRVector4 tvec, l_camera_pos;
	GRMatrix44 rot_matrix;

	tvec.x = -grg_cam_pos.x;
	tvec.y = -grg_cam_pos.y;
	tvec.z = -grg_cam_pos.z;
	tvec.w = 0.0f;
	grm_rotmatrix44_vector3( &rot_matrix, &grg_cam_angle, GRM_ZYX );
	grg_cam_matrix_angle = rot_matrix;
	grm_vector4_m_matrix44( &l_camera_pos, &tvec, &rot_matrix );
	grm_translate_matrix44( &grg_cam_matrix, &rot_matrix, &l_camera_pos );
	return;
}

static void grg_set3Dmatrix_hm1( void )
{
	grg_hm_scale.x = (float)(SCREEN_SIZE_X >> 1)  * GRG_CLIPAREA;
	grg_hm_scale.y = (float)(SCREEN_SIZE_IY >> 1) * GRG_CLIPAREA;
	grg_hm_scale.z = -(float)SCREEN_ZBUF_MAX;
	grg_hm_scale.w = 1.0f;
	grg_hm_offset.x = (float)SCREEN_CENTER_POSX;
	grg_hm_offset.y = (float)SCREEN_CENTER_POSY;
	grg_hm_offset.z = (float)SCREEN_ZBUF_MAX;
	grg_hm_offset.w = 0.0f;
	return;
}

static void grg_set3Dmatrix_hm2( float dist, float far )
{
	grg_hm_matrix.m[0].x = (float)dist * SCREEN_X_DIV_Y * (1.0f/GRG_CLIPAREA);
	grg_hm_matrix.m[0].y = 0.0f;
	grg_hm_matrix.m[0].z = 0.0f;
	grg_hm_matrix.m[0].w = 0.0f;
	grg_hm_matrix.m[1].x = 0.0f;
	grg_hm_matrix.m[1].y = (float)dist * (1.0f/GRG_CLIPAREA);
	grg_hm_matrix.m[1].z = 0.0f;
	grg_hm_matrix.m[1].w = 0.0f;
	grg_hm_matrix.m[2].x = 0.0f;
	grg_hm_matrix.m[2].y = 0.0f;
	grg_hm_matrix.m[2].z = far / (far - dist);
	grg_hm_matrix.m[2].w = 1.0f;
	grg_hm_matrix.m[3].x = 0.0f;
	grg_hm_matrix.m[3].y = 0.0f;
	grg_hm_matrix.m[3].z = (-far * dist)/(far - dist);
	grg_hm_matrix.m[3].w = 0.0f;
	return;
}

void grg_set3Dmatrix( float dist, float far )
{      
	grg_set3Dmatrix_hm1();
	grg_set3Dmatrix_hm2( dist, far );
	return;
}

void grg_setpos_hm( GRVector4 *vec, GRVector3 *angles )
{
	GRVector3 angles2 = *angles;
	GRMatrix44 rot_matrix, object;

	angles2.x = -(angles -> x);
	angles2.y = -(angles -> y);
	angles2.z = -(angles -> z);
	grm_rotmatrix44_vector3( &rot_matrix, angles, GRM_XYZ );
	grm_translate_matrix44( &rot_matrix, &rot_matrix, vec );
	grm_matrix44_m_matrix44( &object, &rot_matrix, &grg_cam_matrix );
	grm_matrix44_m_matrix44( &grg_screen, &object, &grg_hm_matrix );
	return;
}
