/* File: def_gs.h */

#ifndef __DEF_GS_H_INCLUDED
#define __DEF_GS_H_INCLUDED

/* set draw primitive */
#define _gps2_setdma_rgba( _R, _G, _B, _A ) \
	_gps2_setdma_32323232( (_R), (_G), (_B), (_A) );

#define _gps2_setdma_stq( _S, _T, _Q ) \
	_gps2_setdma_f323232nd( (_S), (_T), (_Q) );

#define _gps2_setdma_uv( _U, _V ) \
	_gps2_setdma_3232ndnd( (unsigned int)(((_U)+0.5f)*16.0f), \
			       (unsigned int)(((_V)+0.5f)*16.0f) );

#define _gps2_setdma_xyz( _X, _Y, _Z ) \
		_gps2_setdma_323232nd( \
			(unsigned int)((_X)*16), \
			(unsigned int)((_Y)*16), \
			(unsigned int)((_Z)*16) );

#define _gps2_setdma_xyzw( _X, _Y, _Z, _W ) \
	_gps2_setdma_32323232( \
		(unsigned int)((_X)*16), \
		(unsigned int)((_Y)*16), \
		(unsigned int)((_Z)*16), \
		(unsigned int)((_W)) );

#define _gps2_setdma_xyza( _X, _Y, _Z, _ADC ) \
	_gps2_setdma_32323232( \
		(unsigned int)((_X)*16), \
		(unsigned int)((_Y)*16), \
		(unsigned int)((_Z)*16), \
		((unsigned int)(_ADC)) << 15 );

#define _gps2_setdma_xyzwa( _X, _Y, _Z, _W, _ADC ) \
	_gps2_setdma_32323232( \
		(unsigned int)((_X)*16), \
		(unsigned int)((_Y)*16), \
		(unsigned int)((_Z)*16), \
		((unsigned int)(_W)) | (((unsigned int)(_ADC)) << 15) );

/* ALPHA */
#define GS_ALPHA_A(X)	((u_long64)(X))
#define GS_ALPHA_B(X)	(((u_long64)(X)) << 2)
#define GS_ALPHA_C(X)	(((u_long64)(X)) << 4)
#define GS_ALPHA_D(X)	(((u_long64)(X)) << 6)
#define GS_ALPHA_FIX(X)	(((u_long64)(X)) << 32)

/* BITBLTBUF */
#define GS_BITBLTBUF_SBP(X)  ((u_long64)(X))
#define GS_BITBLTBUF_SBW(X)  (((u_long64)(X)) << 16)
#define GS_BITBLTBUF_SPSM(X) (((u_long64)(X)) << 24)
#define GS_BITBLTBUF_DBP(X)  (((u_long64)(X)) << 32)
#define GS_BITBLTBUF_DBW(X)  (((u_long64)(X)) << 48)
#define GS_BITBLTBUF_DPSM(X) (((u_long64)(X)) << 56)

/* CLAMP */
#define GS_CLAMP_WMS(X)  ((u_long64)(X))
#define GS_CLAMP_WMS_REPEAT        GS_CLAMP_WMS(0)
#define GS_CLAMP_WMS_CLAMP         GS_CLAMP_WMS(1)
#define GS_CLAMP_WMS_REGION_CLAMP  GS_CLAMP_WMS(2)
#define GS_CLAMP_WMS_REGION_REPEAT GS_CLAMP_WMS(3)
#define GS_CLAMP_WMT(X)  (((u_long64)(X)) <<  2)
#define GS_CLAMP_WMT_REPEAT        GS_CLAMP_WMT(0)
#define GS_CLAMP_WMT_CLAMP         GS_CLAMP_WMT(1)
#define GS_CLAMP_WMT_REGION_CLAMP  GS_CLAMP_WMT(2)
#define GS_CLAMP_WMT_REGION_REPEAT GS_CLAMP_WMT(3)
#define GS_CLAMP_MINU(X) (((u_long64)(X)) <<  4)
#define GS_CLAMP_MAXU(X) (((u_long64)(X)) << 14)
#define GS_CLAMP_MINV(X) (((u_long64)(X)) << 24)
#define GS_CLAMP_MAXV(X) (((u_long64)(X)) << 34)

/* FRAME */
#define GS_FRAME_FBP(X) 	((u_long64)(X))
#define GS_FRAME_FBW(X) 	(((u_long64)(X)) << 16)
#define GS_FRAME_PSM(X) 	(((u_long64)(X)) << 24)
#define GS_FRAME_FBMSK(X) 	(((u_long64)(X)) << 32)

/* SCISSOR */
#define GS_SCISSOR_SCAX0(X) 	((u_long64)(X))
#define GS_SCISSOR_SCAX1(X) 	(((u_long64)(X)) << 16)
#define GS_SCISSOR_SCAY0(X) 	(((u_long64)(X)) << 32)
#define GS_SCISSOR_SCAY1(X) 	(((u_long64)(X)) << 48)

/* TEST */
#define GS_TEST_ATE	1
#define GS_TEST_ATE_N	0
#define GS_TEST_ATST(X) (((u_long64)(X)) << 1)
#define GS_TEST_AREF(X) (((u_long64)(X)) << 4)
#define GS_TEST_AFAIL(X) (((u_long64)(X)) << 12)
#define GS_TEST_DATE	(1LL << 14)
#define GS_TEST_DATE_N	0
#define GS_TEST_DATM	(1LL << 15)
#define GS_TEST_DATM_N	0
#define GS_TEST_ZTE	(1LL << 16)
#define GS_TEST_ZTE_N	0
#define GS_TEST_ZTST(X) (((u_long64)(X)) << 17)

/* TEX0 */
#define GS_TEX0_TBP0(X) ((u_long64)(X))
#define GS_TEX0_TBW(X) (((u_long64)(X)) << 14)
#define GS_TEX0_PSM(X) (((u_long64)(X)) << 20)
#define GS_TEX0_TW(X) (((u_long64)(X)) << 26)
#define GS_TEX0_TH(X) (((u_long64)(X)) << 30)
#define GS_TEX0_TCC_RGBA (1ULL << 34)
#define GS_TEX0_TCC_RGB  0ULL
#define GS_TEX0_TFX(X) (((u_long64)(X)) << 35)
#define GS_TEX0_CBP(X)  (((u_long64)(X)) << 37)
#define GS_TEX0_CPSM(X) (((u_long64)(X)) << 51)
#define GS_TEX0_CSM	(1ULL << 55)
#define GS_TEX0_CSM_N	0ULL
#define GS_TEX0_CSA(X) (((u_long64)(X)) << 56)
#define GS_TEX0_CLD(X) (((u_long64)(X)) << 61)

/* TEX1 */
#define GS_TEX1_LCM(X) ((u_long64)(X))
#define GS_TEX1_MXL(X) (((u_long64)(X)) << 2)
#define GS_TEX1_MMAG(X) (((u_long64)(X)) << 5)
#define GS_TEX1_MMIN(X) (((u_long64)(X)) << 6)
#define GS_TEX1_MTBA(X) (((u_long64)(X)) << 9)
#define GS_TEX1_L(X) (((u_long64)(X)) << 19)
#define GS_TEX1_K(X) ((((u_long64)((X)*16.0f)) & 0x0fffUL) << 32)
#define GS_TEX1_K_DIRECT(X) ((((u_long64)(X)) & 0x0fffUL) << 32)

/* TRXDIR */
#define GS_TRXDIR_XDIR(X) ((u_long64)(X))

/* TRXPOS */
#define GS_TRXPOS_SSAX(X) ((u_long64)(X))
#define GS_TRXPOS_SSAY(X) (((u_long64)(X)) << 16)
#define GS_TRXPOS_DSAX(X) (((u_long64)(X)) << 32)
#define GS_TRXPOS_DSAY(X) (((u_long64)(X)) << 48)
#define GS_TRXPOS_DIR(X)  (((u_long64)(X)) << 59)

/* TRXREG */
#define GS_TRXREG_RRW(X) ((u_long64)(X))
#define GS_TRXREG_RRH(X) (((u_long64)(X)) << 32)

/* ZBUF */
#define GS_ZBUF_ZBP(X) ((u_long64)(X))
#define GS_ZBUF_PSM(X) (((u_long64)(X)) << 24)
#define GS_ZBUF_ZMSK	(1LL << 32)
#define GS_ZBUF_ZMSK_N	0

/* PRIM/GIFTAG */
enum GS_prim_type {
	GS_PRIM_POINT = 0,
	GS_PRIM_LINE,
	GS_PRIM_LINE_STRIP,
	GS_PRIM_TRIANGLE,
	GS_PRIM_TRIANGLE_STRIP,
	GS_PRIM_TRIANGLE_FAN,
	GS_PRIM_SPRITE,
	GS_PRIM_UNUSED,
	GS_PRIM_MAX_NUM
};

enum Gif_regs_addresses {
	GIF_REGS_PRIM	= 0,
	GIF_REGS_RGBAQ,
	GIF_REGS_ST,
	GIF_REGS_UV,
	GIF_REGS_XYZF2,
	GIF_REGS_XYZ2,
	GIF_REGS_TEX0_1,
	GIF_REGS_TEX0_2,
	GIF_REGS_CLAMP_1,
	GIF_REGS_CLAMP_2,
	GIF_REGS_FOG,
	GIF_REGS_RESERVED,
	GIF_REGS_XYZF3,
	GIF_REGS_XYZ3,
	GIF_REGS_A_D,
	GIF_REGS_NOP,
	GIF_REGS_MAX_NUM
};

#define GS_PRIM_IIP_V(_X)	((_X) << 3)
#define GS_PRIM_IIP		GS_PRIM_IIP_V(1)
#define GS_PRIM_IIP_N		0
#define GS_PRIM_TME_V(_X)	((_X) << 4)
#define GS_PRIM_TME		GS_PRIM_TME_V(1)
#define GS_PRIM_TME_N		0
#define GS_PRIM_FGE_V(_X)	((_X) << 5)
#define GS_PRIM_FGE		GS_PRIM_FGE_V(1)
#define GS_PRIM_FGE_N		0
#define GS_PRIM_ABE_V(_X)	((_X) << 6)
#define GS_PRIM_ABE		GS_PRIM_ABE_V(1)
#define GS_PRIM_ABE_N		0
#define GS_PRIM_AA1_V(_X)	((_X) << 7)
#define GS_PRIM_AA1		GS_PRIM_AA1_V(1)
#define GS_PRIM_AA1_N		0
#define GS_PRIM_FST_V(_X)	((_X) << 8)
#define GS_PRIM_FST		GS_PRIM_FST_V(1)
#define GS_PRIM_FST_N		0
#define GS_PRIM_CTXT_V(_X)	((_X) << 9)
#define GS_PRIM_CTXT_2		GS_PRIM_CTXT_V(1)
#define GS_PRIM_CTXT_1		0
#define GS_PRIM_FIX_V(_X)	((_X) << 10)
#define GS_PRIM_FIX		GS_PRIM_FIX_V(1)
#define GS_PRIM_FIX_N		0

#define GIF_REGS(REGS,N) (((u_long64)(REGS)) << ((N)*4))
#define GIF_NREG(X)	(((u_long64)(X)) << 60)
#define GIF_FLG_PACKED	0ULL
#define GIF_FLG_REGLIST	(1ULL << 58)
#define GIF_FLG_IMAGE	(2ULL << 58)
#define GIF_PRIM(X)	(((u_long64)(X)) << 47)
#define GIF_PRE		(1ULL << 46)
#define GIF_PRE_N	0ULL
#define GIF_EOP		(1ULL << 15)
#define GIF_NOT_EOP	0ULL
#define GIF_NLOOP(X)	(X)

/* GRDRAW options */
#define GRDRAW_OPT_CONTEXT1	GS_PRIM_CTXT_1
#define GRDRAW_OPT_CONTEXT2	GS_PRIM_CTXT_2
#define GRDRAW_OPT_FLAT		GS_PRIM_IIP_N
#define GRDRAW_OPT_GOURAUD	GS_PRIM_IIP
#define GRDRAW_OPT_FOG		GS_PRIM_FGE
#define GRDRAW_OPT_ALPHA	GS_PRIM_ABE
#define GRDRAW_OPT_ALPHABLEND	GS_PRIM_ABE
#define GRDRAW_OPT_ANTI		GS_PRIM_AA1
#define GRDRAW_OPT_ANTIALIAS	GS_PRIM_AA1

/* GRTEX options */
#define GRTEX_OPT_POINT			(GS_TEX1_MMAG(0) | GS_TEX1_MMIN(0))
#define GRTEX_OPT_LINEAR_MAX		(GS_TEX1_MMAG(1) | GS_TEX1_MMIN(0))
#define GRTEX_OPT_LINEAR		(GS_TEX1_MMAG(1) | GS_TEX1_MMIN(1))
#define GRTEX_OPT_MIPMAP_POINT		(GS_TEX1_MMAG(0) | GS_TEX1_MMIN(5))
#define GRTEX_OPT_MIPMAP_LINEAR_MAX	(GS_TEX1_MMAG(1) | GS_TEX1_MMIN(5))
#define GRTEX_OPT_MIPMAP_LINEAR		(GS_TEX1_MMAG(1) | GS_TEX1_MMIN(5))

#endif /* __DEF_GS_H_INCLUDED */
