/* File: cube.c */

#include "config.h"

#include <string.h>
#include <math.h>

#include "common.h"
#include "main.h"
#include "cube.h"
#include "draw.h"
#include "matrix.h"
#include "prim3d.h"

#define CUBE_VERTICIES_NUM	14

GRVector4 cube_vertices[CUBE_VERTICIES_NUM] = {
	{ -1.0f,  1.0f,  1.0f, 1.0f },	/* 0 */
	{ -1.0f, -1.0f,  1.0f, 1.0f },
	{  1.0f,  1.0f,  1.0f, 1.0f },
	{  1.0f, -1.0f,  1.0f, 1.0f },
	{  1.0f, -1.0f, -1.0f, 1.0f },	/* 4 */
	{ -1.0f, -1.0f,  1.0f, 1.0f },
	{ -1.0f, -1.0f, -1.0f, 1.0f },
	{ -1.0f,  1.0f,  1.0f, 1.0f },
	{ -1.0f,  1.0f, -1.0f, 1.0f },	/* 8 */
	{  1.0f,  1.0f,  1.0f, 1.0f },
	{  1.0f,  1.0f, -1.0f, 1.0f },
	{  1.0f, -1.0f, -1.0f, 1.0f },
	{ -1.0f,  1.0f, -1.0f, 1.0f },	/* 12 */
	{ -1.0f, -1.0f, -1.0f, 1.0f }
};

#if 1	/* graduation */
GRVector4 cube_colors[CUBE_VERTICIES_NUM] = {
	{ 1.0f, 1.0f, 1.0f, 1.0f },	/* 1 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },	/* 5 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },	/* 9 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },	/* 13 */
	{ 0.3f, 0.3f, 0.3f, 1.0f }
};
#else	/* colourful */
GRVector4 cube_colors[CUBE_VERTICIES_NUM] = {
	{ 0.3f, 1.0f, 1.0f, 1.0f },	/* 1 */
	{ 0.3f, 0.3f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 0.3f, 1.0f, 1.0f },
	{ 1.0f, 0.3f, 0.3f, 1.0f },	/* 5 */
	{ 0.3f, 0.3f, 1.0f, 1.0f },
	{ 0.3f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 1.0f, 1.0f, 1.0f },
	{ 0.3f, 1.0f, 0.3f, 1.0f },	/* 9 */
	{ 1.0f, 1.0f, 1.0f, 1.0f },
	{ 1.0f, 1.0f, 0.3f, 1.0f },
	{ 1.0f, 0.3f, 0.3f, 1.0f },
	{ 0.3f, 1.0f, 0.3f, 1.0f },	/* 13 */
	{ 0.3f, 0.3f, 0.3f, 1.0f }
};
#endif

GRVector4 cube_texstq[CUBE_VERTICIES_NUM] = {
	{ 0.0f, 0.0f, 1.0f, 0.0f },	/* 0 */
	{ 0.0f, 1.0f, 1.0f, 0.0f },
	{ 1.0f, 0.0f, 1.0f, 0.0f },
	{ 1.0f, 1.0f, 1.0f, 0.0f },
	{ 0.0f, 1.0f, 1.0f, 0.0f },	/* 4 */
	{ 1.0f, 0.0f, 1.0f, 0.0f },
	{ 0.0f, 0.0f, 1.0f, 0.0f },
	{ 1.0f, 1.0f, 1.0f, 0.0f },
	{ 0.0f, 1.0f, 1.0f, 0.0f },	/* 8 */
	{ 1.0f, 0.0f, 1.0f, 0.0f },
	{ 0.0f, 0.0f, 1.0f, 0.0f },
	{ 0.0f, 1.0f, 1.0f, 0.0f },
	{ 1.0f, 0.0f, 1.0f, 0.0f },	/* 12 */
	{ 1.0f, 1.0f, 1.0f, 0.0f }
};

int cube_init( void )
{
	int i;

	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		cube_vertices[i].x *= CUBE_SIZE;
		cube_vertices[i].y *= CUBE_SIZE;
		cube_vertices[i].z *= CUBE_SIZE;
	}
	for (i = 0; i < CUBE_VERTICIES_NUM; i++) {
		cube_colors[i].x *= 128.0f;
		cube_colors[i].y *= 128.0f;
		cube_colors[i].z *= 128.0f;
		cube_colors[i].w  = 128.0f;
	}
	return TRUE;
}

int cube_draw( int opt )
{
	grd_3d_vgttriangles( CUBE_VERTICIES_NUM, cube_vertices,
		cube_colors, cube_texstq,
		GRDRAW_OPT_GOURAUD | opt );
	return TRUE;
}
